/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.subform;

import alma.obsprep.bo.enumerations.Antenna;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import java.io.Serializable;

public class MosaicParameters
implements Serializable {
    public static final String TYPE_RECTANGLE = "Rectangle Grid";
    public static final String TYPE_TRIANGLE = "Triangle Grid";
    public static String[] knownTypeList = new String[]{"Rectangle Grid", "Triangle Grid"};
    private String type = "Triangle Grid";
    private Antenna antenna = Antenna.ANTENNA_12M;
    private final Frequency frequency = Frequency.createFrequency();
    private double overlap = 50.0;
    private double spacing = 0.0;

    public Angle getBeamsize() {
        return this.antenna.getBeamSize(this.getFrequency());
    }

    public void updateSpacing() {
        Angle angle = this.getAntenna().getBeamSize(this.getFrequency());
        this.setSpacing(angle.getContentInUnits(Angle.UNIT_ARCSEC) * (1.0 - this.getOverlap() / 100.0));
    }

    public double updateOverlap() {
        Angle angle = this.getAntenna().getBeamSize(this.getFrequency());
        double d = (1.0 - this.getSpacing() / angle.getContentInUnits(Angle.UNIT_ARCSEC)) * 100.0;
        this.setOverlap(d);
        return d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Antenna = " + this.antenna);
        stringBuffer.append(", Type = " + this.type);
        stringBuffer.append(", frequency = " + this.frequency);
        stringBuffer.append(", overlap = " + this.overlap);
        stringBuffer.append(", spacing = " + this.spacing);
        return stringBuffer.toString();
    }

    public String getType() {
        return this.type;
    }

    public Antenna getAntenna() {
        return this.antenna;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public double getOverlap() {
        return this.overlap;
    }

    public double getSpacing() {
        return this.spacing;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setAntenna(Antenna antenna) {
        this.antenna = antenna;
    }

    public void setOverlap(double d) {
        this.overlap = d;
    }

    public void setSpacing(double d) {
        this.spacing = d;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MosaicParameters)) {
            return false;
        }
        MosaicParameters mosaicParameters = (MosaicParameters)object;
        if (!mosaicParameters.canEqual(this)) {
            return false;
        }
        String string = this.getType();
        String string2 = mosaicParameters.getType();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        Antenna antenna = this.getAntenna();
        Antenna antenna2 = mosaicParameters.getAntenna();
        if (antenna == null ? antenna2 != null : !((Object)((Object)antenna)).equals((Object)antenna2)) {
            return false;
        }
        Frequency frequency = this.getFrequency();
        Frequency frequency2 = mosaicParameters.getFrequency();
        if (frequency == null ? frequency2 != null : !((Object)((Object)frequency)).equals((Object)frequency2)) {
            return false;
        }
        if (Double.compare(this.getOverlap(), mosaicParameters.getOverlap()) != 0) {
            return false;
        }
        return Double.compare(this.getSpacing(), mosaicParameters.getSpacing()) == 0;
    }

    protected boolean canEqual(Object object) {
        return object instanceof MosaicParameters;
    }

    public int hashCode() {
        int n = 1;
        String string = this.getType();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        Antenna antenna = this.getAntenna();
        n = n * 59 + (antenna == null ? 43 : ((Object)((Object)antenna)).hashCode());
        Frequency frequency = this.getFrequency();
        n = n * 59 + (frequency == null ? 43 : ((Object)((Object)frequency)).hashCode());
        long l = Double.doubleToLongBits(this.getOverlap());
        n = n * 59 + (int)(l >>> 32 ^ l);
        long l2 = Double.doubleToLongBits(this.getSpacing());
        n = n * 59 + (int)(l2 >>> 32 ^ l2);
        return n;
    }
}

