/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spectralvisual;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.AbstractTargetParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.boEditors.PanelUtilities;
import alma.obsprep.ot.editors.spectralvisual.ObservedAndTargetPanel;
import alma.obsprep.ot.gui.dnd.ConstrainedXDNDDescriptor;
import alma.obsprep.ot.gui.dnd.DNDDescriptor;
import alma.obsprep.ot.gui.dnd.DefaultDNDDescriptor;
import alma.obsprep.ot.gui.dnd.DomainPoint;
import alma.obsprep.ot.gui.dnd.MousePoint;
import alma.obsprep.ot.gui.resources.ColorPalette;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.BaseBandDeployer;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;

public class ScienceViewSpectralPanel
extends ObservedAndTargetPanel {
    private boolean isDrawReceiverBands;
    private boolean isDrawCentreFrequencies;
    private boolean isDrawBasebands;
    private boolean isDrawSideBands;
    private AbstractScienceSpectralWindow windowSelection = null;
    private final Set<Integer> spatialSelection = new HashSet<Integer>();
    private static final int DRAG_LINE = 1;
    private static final int DRAG_RANGE = 2;
    private static final int DRAG_LO = 3;
    private int lastDragX = 0;
    protected int chosenTargetIndex = 0;
    private boolean allowDragLO;
    private Frequency lo1PreDragFrequency = Frequency.createFrequencyGHZ(0.0);
    private String lastSpectralMode = null;
    private boolean draggingLo = false;

    @Override
    public DNDDescriptor createDescriptor(MousePoint mousePoint) {
        DefaultDNDDescriptor defaultDNDDescriptor = null;
        ScienceGoal scienceGoal = (ScienceGoal)this.model.getDocument();
        double d = this.unscaleObservedFrequency(mousePoint.getX());
        double d2 = -1000.0;
        int n = -1000;
        double d3 = -1000.0;
        int n2 = -1000;
        this.lastDragX = mousePoint.getX();
        if (scienceGoal != null) {
            d2 = scienceGoal.getRestFrequency().getContentInGHz();
            n = this.scaleRestFrequency(d2);
            if (this.isDrawSideBands) {
                d3 = scienceGoal.getLO1Frequency().getContentInGHz();
                n2 = this.scaleOF(d3);
            }
        }
        if (mousePoint.getY() <= this.yObservedAxis() || mousePoint.getY() >= this.yTargetAxis()) {
            DomainPoint domainPoint = new DomainPoint(d, 0.0);
            defaultDNDDescriptor = new DefaultDNDDescriptor(2, mousePoint, domainPoint);
        } else if (scienceGoal != null) {
            if ((double)Math.abs(mousePoint.getX() - n2) < 10.0 && this.isLODragAllowed()) {
                ReceiverBand receiverBand;
                MousePoint mousePoint2 = new MousePoint(n2, mousePoint.getY());
                DomainPoint domainPoint = new DomainPoint(d3, 0.0);
                try {
                    receiverBand = scienceGoal.getReceiverBand();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    receiverBand = ReceiverBand.ILLEGAL_RECEIVER;
                }
                defaultDNDDescriptor = new ConstrainedXDNDDescriptor(3, mousePoint2, domainPoint, new Range(receiverBand.getLOMin(), receiverBand.getLOMax()));
                defaultDNDDescriptor.setPublishesWhileDragging(false);
            } else if ((double)Math.abs(mousePoint.getX() - n) < 10.0) {
                MousePoint mousePoint3 = new MousePoint(n, mousePoint.getY());
                DomainPoint domainPoint = new DomainPoint(d2, 0.0);
                try {
                    scienceGoal.getReceiverBand();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                defaultDNDDescriptor = new ConstrainedXDNDDescriptor(1, mousePoint3, domainPoint, new Range(this.getAbsoluteMin(), this.getAbsoluteMax()));
            }
        }
        return defaultDNDDescriptor;
    }

    @Override
    public void drag(DNDDescriptor dNDDescriptor, MousePoint mousePoint) {
        ScienceGoal scienceGoal = (ScienceGoal)this.model.getDocument();
        DomainPoint domainPoint = new DomainPoint(this.unscaleObservedFrequency(mousePoint.getX()), 0.0);
        if (this.lastDragX == mousePoint.getX()) {
            return;
        }
        if (mousePoint.getX() <= 0) {
            double d = -1.0 * (double)mousePoint.getX() / (double)this.getWidth();
            this.panLeft(d);
        } else if (mousePoint.getX() > this.getWidth()) {
            double d = 1.0 * (double)(mousePoint.getX() - this.getWidth()) / (double)this.getWidth();
            this.panRight(d);
        }
        domainPoint = dNDDescriptor.getConstrained(domainPoint);
        switch (dNDDescriptor.getType()) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                Frequency frequency = scienceGoal.getLO1Frequency();
                String string = frequency.getUnit();
                frequency.setContentInGHz(domainPoint.getX());
                frequency.convertToUnit(string);
                break;
            }
        }
        this.lastDragX = mousePoint.getX();
    }

    @Override
    public void abandon(DNDDescriptor dNDDescriptor) {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        DomainPoint domainPoint = dNDDescriptor.getOriginalDomainPosition();
        switch (dNDDescriptor.getType()) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                Frequency frequency = spectralSpec.getLO1Frequency();
                String string = frequency.getUnit();
                frequency.setContentInGHz(domainPoint.getX());
                frequency.convertToUnit(string);
                break;
            }
        }
    }

    @Override
    public void drop(DNDDescriptor dNDDescriptor, MousePoint mousePoint) {
    }

    @Override
    public void destroyDescriptor(DNDDescriptor dNDDescriptor) {
    }

    public boolean isLODragAllowed() {
        return this.allowDragLO;
    }

    public void setAllowDragLO(boolean bl) {
        this.allowDragLO = bl;
    }

    @Override
    public void publish() {
        this.model.publish();
    }

    public void setModel(SingleFieldScienceGoalModel singleFieldScienceGoalModel) {
        ObservedAndTargetPanel.LocalDNDAdapter localDNDAdapter = new ObservedAndTargetPanel.LocalDNDAdapter(this);
        this.addMouseListener(localDNDAdapter);
        this.addMouseMotionListener(localDNDAdapter);
        super.setModel(singleFieldScienceGoalModel);
    }

    @Override
    public SingleFieldScienceGoalModel getModel() {
        return (SingleFieldScienceGoalModel)super.getModel();
    }

    public ScienceViewSpectralPanel(ColorPalette colorPalette, double d, double d2) {
        super(1.0, 1.0);
        this.palette = colorPalette;
        this.graphicsHelper = new PanelUtilities(this);
        this.isDrawReceiverBands = true;
        this.isDrawCentreFrequencies = false;
        this.isDrawBasebands = true;
        this.isDrawSideBands = true;
        this.isDrawDSBImageWindow = true;
        this.setDrawOtherLines(false);
        this.setDrawTransmission(true);
        this.setInitialFrequencyRange();
        this.setAllowDragLO(true);
    }

    public ScienceViewSpectralPanel(ColorPalette colorPalette) {
        this(colorPalette, 1.0, 1.0);
    }

    @Override
    public void resetFrequencyRange() {
        this.minOF = this.absoluteMinOF;
        this.maxOF = this.absoluteMaxOF;
        this.setFrequencyRangeNoRound(this.minOF, this.maxOF);
    }

    public void panToLine(Frequency frequency) {
        this.panTo(frequency.getContentInGHz());
    }

    public void panToLine() {
        if (this.windowSelection == null) {
            return;
        }
        Velocity velocity = this.getSourceVelocity();
        Frequency frequency = ((ScienceSpectralWindow)((Object)this.windowSelection)).getIsSkyFrequency() ? this.windowSelection.getCenterFrequency() : this.windowSelection.getCenterFrequency().dopplerShifted(velocity);
        this.panToLine(frequency);
    }

    public void zoomToBand(SpectralSetupParameters spectralSetupParameters) {
        try {
            ReceiverBand receiverBand = ReceiverBand.getReceiverBand(spectralSetupParameters);
            if (receiverBand != null) {
                this.setFrequencyRange(receiverBand.getRFMin(), receiverBand.getRFMax());
            }
        }
        catch (ReceiverBand.ReceiverNotFoundException | IllegalArgumentException exception) {
            return;
        }
    }

    public void zoomToBand() {
        SingleFieldScienceGoalModel singleFieldScienceGoalModel = this.getModel();
        SpectralSetupParameters spectralSetupParameters = singleFieldScienceGoalModel.getSpectralSetupParametersModel().getSpectralSetupParameters();
        this.zoomToBand(spectralSetupParameters);
    }

    @Override
    protected int yClearTarget() {
        return this.yTargetAxis();
    }

    @Override
    protected int yClearObserved() {
        return this.yObservedAxis() + 2 * this.textHeight;
    }

    private int observedLabelBase() {
        return this.yObservedAxis() + this.yRxBandHeight() + this.yLOBandHeight() + this.textHeight;
    }

    @Override
    protected int observedLabelHeight(int n) {
        return this.observedLabelBase() + n * this.textHeight;
    }

    public void paintObservedAxisAndBands(Graphics graphics) {
        this.paintSkyAxis(graphics);
        boolean bl = true;
        if (this.isDrawReceiverBands()) {
            Color color;
            Color color2 = color = COLOUR_BANDLINES;
            for (int i = 0; i < this.names.length; ++i) {
                ReceiverBand receiverBand = ReceiverBand.getReceiverBand(this.names[i]);
                if (bl) {
                    this.paintBand(graphics, receiverBand, color, bl);
                } else {
                    this.paintBand(graphics, receiverBand, color2, bl);
                }
                bl = !bl;
            }
        }
    }

    private ReceiverBand currentReceiverBand(ScienceGoal scienceGoal) {
        ReceiverBand receiverBand = null;
        if (scienceGoal != null && scienceGoal.getSpectralSetupParameters() != null && scienceGoal.getSpectralSetupParameters().getScienceSpectralWindowCount() > 0) {
            try {
                receiverBand = scienceGoal.getReceiverBand();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                receiverBand = null;
            }
        }
        return receiverBand;
    }

    private void paintSideBands(Graphics graphics, ScienceGoal scienceGoal) {
        Frequency frequency;
        Frequency frequency2;
        Object object;
        Object object2;
        Object object3;
        Range range = null;
        Range range2 = null;
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        if (spectralSetupParameters == null || spectralSetupParameters.isSpectralScan()) {
            return;
        }
        boolean bl = true;
        boolean bl2 = true;
        SpectralSpec spectralSpec = null;
        Frequency frequency3 = null;
        Frequency frequency4 = null;
        Frequency frequency5 = null;
        Frequency frequency6 = null;
        SBGenerationContext sBGenerationContext = new SBGenerationContext();
        try {
            sBGenerationContext.setArray(RequestedArray.TWELVE_M).setScienceGoal(spectralSetupParameters.getScienceGoal()).setSB(SchedBlock.createSchedBlock()).setSBType(SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION).setConfiguration(Configuration.getMostCompactConfiguration(RequestedArray.TWELVE_M)).setSBGenerationSchema(SBGeneratorTemplate.determineSBGenerationSchema(scienceGoal, RequestedArray.TWELVE_M, Optional.empty()));
        }
        catch (UnknownEntityException | Configuration.UnableToDetermineConfigurationException throwable) {
            throw new RuntimeException("Unable to determine 12-m configuration");
        }
        SpectralSpecFactory spectralSpecFactory = new SpectralSpecFactory(sBGenerationContext);
        int n = scienceGoal.getKeyTargetParametersPosition();
        scienceGoal.setKeyTargetParameters(this.chosenTargetIndex);
        if (spectralSetupParameters.getAbstractScienceSpectralWindowCount() > 0) {
            try {
                object3 = scienceGoal.getTargetParameters(this.chosenTargetIndex).getSourceVelocityInDefaultReferenceFrame(Optional.of(scienceGoal));
                object2 = scienceGoal.deepCopy();
                bl = object2.getSpectralSetupParameters().verifyBasebandSetting();
                spectralSpec = spectralSpecFactory.getSpectralSpec(spectralSetupParameters, (Velocity)((Object)object3), ObsType.SCIENCE);
            }
            catch (CopyException | BaseBandNotDeployableException | WizardSBGenerationException throwable) {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!bl) {
            scienceGoal.setKeyTargetParameters(n);
        }
        Frequency frequency7 = spectralSetupParameters.getLO1Frequency();
        if (this.lastSpectralMode == null || !spectralSetupParameters.getType().equals(this.lastSpectralMode)) {
            this.draggingLo = false;
            this.lastSpectralMode = spectralSetupParameters.getType();
        }
        object3 = Frequency.createFrequencyGHZ(0.0);
        if (this.lo1PreDragFrequency != null && !this.lo1PreDragFrequency.isZero() && this.draggingLo) {
            object3 = (Frequency)frequency7.minus((AbstractDoubleWithUnit)this.lo1PreDragFrequency);
            if (object3.isGreaterThan((AbstractDoubleWithUnit)Frequency.createFrequencyMHZ(10.0)) && this.draggingLo) {
                bl2 = false;
            }
        } else {
            this.lo1PreDragFrequency = frequency7.deepCopy();
        }
        if (bl) {
            object2 = spectralSpec.getBaseBand();
            int n2 = ((BaseBand[])object2).length;
            for (int i = 0; i < n2; ++i) {
                BaseBand baseBand = object2[i];
                object = (Frequency)baseBand.getCenterFrequencySky().minus((AbstractDoubleWithUnit)((Frequency)BaseBandDeployer.BASEBANDWIDTH.half()));
                frequency2 = (Frequency)baseBand.getCenterFrequencySky().plus((AbstractDoubleWithUnit)((Frequency)BaseBandDeployer.BASEBANDWIDTH.half()));
                if (baseBand.getCenterFrequencySky().isLessThan((AbstractDoubleWithUnit)this.lo1PreDragFrequency)) {
                    if (frequency3 == null || object.isLessThan((AbstractDoubleWithUnit)frequency3)) {
                        frequency3 = object.deepCopy();
                    }
                    if (frequency4 != null && !frequency2.isGreaterThan((AbstractDoubleWithUnit)frequency4)) continue;
                    frequency4 = frequency2.deepCopy();
                    continue;
                }
                if (frequency6 == null || object.isLessThan((AbstractDoubleWithUnit)frequency6)) {
                    frequency6 = object.deepCopy();
                }
                if (frequency5 != null && !frequency2.isGreaterThan((AbstractDoubleWithUnit)frequency5)) continue;
                frequency5 = frequency2.deepCopy();
            }
        }
        Object object4 = object2 = bl ? this.palette.getSidebandsColor() : this.palette.getUnconfiguredSidebandsColor();
        if (frequency7 == null || frequency7.isZero()) {
            return;
        }
        ReceiverBand receiverBand = this.currentReceiverBand(scienceGoal);
        if (receiverBand == null) {
            return;
        }
        double d = frequency7.getContentInGHz();
        object = Colors.transparentColor((Color)object2);
        if (receiverBand.hasLower()) {
            frequency2 = (Frequency)Frequency.createFrequencyGHZ(d - receiverBand.getIFMax()).minus((AbstractDoubleWithUnit)object3);
            frequency = (Frequency)Frequency.createFrequencyGHZ(d - receiverBand.getIFMin()).minus((AbstractDoubleWithUnit)object3);
            if (bl && bl2) {
                if (frequency3 != null && frequency3.isLessThan((AbstractDoubleWithUnit)frequency2)) {
                    frequency2 = frequency3.deepCopy();
                }
                if (frequency4 != null && frequency4.isGreaterThan((AbstractDoubleWithUnit)frequency)) {
                    frequency = frequency4.deepCopy();
                }
            }
            range2 = new Range(((Frequency)frequency2.plus((AbstractDoubleWithUnit)object3)).getContentInGHz(), ((Frequency)frequency.plus((AbstractDoubleWithUnit)object3)).getContentInGHz());
        }
        if (receiverBand.hasUpper()) {
            frequency2 = (Frequency)Frequency.createFrequencyGHZ(d + receiverBand.getIFMin()).minus((AbstractDoubleWithUnit)object3);
            frequency = (Frequency)Frequency.createFrequencyGHZ(d + receiverBand.getIFMax()).minus((AbstractDoubleWithUnit)object3);
            if (bl && bl2) {
                if (frequency5 != null && frequency5.isGreaterThan((AbstractDoubleWithUnit)frequency)) {
                    frequency = frequency5.deepCopy();
                }
                if (frequency6 != null && frequency6.isLessThan((AbstractDoubleWithUnit)frequency2)) {
                    frequency2 = frequency6.deepCopy();
                }
            }
            range = new Range(((Frequency)frequency2.plus((AbstractDoubleWithUnit)object3)).getContentInGHz(), ((Frequency)frequency.plus((AbstractDoubleWithUnit)object3)).getContentInGHz());
        }
        if (range != null && range2 != null) {
            if (range.range() > range2.range()) {
                double d2 = range.range() - range2.range();
                double d3 = range2.min() - d2 / 2.0;
                double d4 = range2.max() + d2 / 2.0;
                range2 = new Range(d3, d4);
            } else if (range2.range() > range.range()) {
                double d5 = range2.range() - range.range();
                double d6 = range.min() - d5 / 2.0;
                double d7 = range.max() + d5 / 2.0;
                range = new Range(d6, d7);
            }
        }
        if (receiverBand.hasLower()) {
            this.paintSideBand(graphics, range2, (Color)object, false);
        }
        if (receiverBand.hasUpper()) {
            this.paintSideBand(graphics, range, (Color)object, false);
        }
        this.paintObservedSpectralLine(graphics, d, "LO1", (Color)object2, 1, false);
    }

    private void paintSpectralElements(Graphics graphics, ScienceGoal scienceGoal) {
        Color color = this.palette.getSpectralWindowColor();
        double d = -1.0;
        if (scienceGoal == null) {
            return;
        }
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return;
        }
        int n = 0;
        if (this.spatialSelection.isEmpty()) {
            if (this.chosenTargetIndex > 0) {
                this.spatialSelection.add(this.chosenTargetIndex);
            } else {
                this.spatialSelection.add(0);
            }
        }
        for (int n2 : this.spatialSelection) {
            TargetParameters targetParameters = scienceGoal.getTargetParameters(n2);
            if (spectralSetupParameters.isSpectralScan()) {
                SpectralScan spectralScan = (SpectralScan)((Object)spectralSetupParameters.getAbstractScienceSpectralWindow()[0]);
                d = spectralScan.getCenterFrequency().getContentInGHz();
                this.paint(graphics, spectralSetupParameters.getAbstractScienceSpectralWindow()[0], (AbstractTargetParameters)((Object)targetParameters), color, n++);
            } else {
                for (AbstractScienceSpectralWindow abstractScienceSpectralWindow : spectralSetupParameters.getAbstractScienceSpectralWindow()) {
                    if (abstractScienceSpectralWindow == this.windowSelection) {
                        color = color.brighter();
                        Velocity velocity = Velocity.createVelocity();
                        velocity.setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
                        if (!((ScienceSpectralWindow)((Object)abstractScienceSpectralWindow)).getIsSkyFrequency()) {
                            velocity = this.getSourceVelocity();
                        }
                        Frequency frequency = abstractScienceSpectralWindow.getCenterFrequency().dopplerShifted(velocity);
                        d = frequency.getContentInGHz();
                    } else {
                        color = this.palette.getRestFrequencyColor();
                    }
                    this.paint(graphics, abstractScienceSpectralWindow, (AbstractTargetParameters)((Object)targetParameters), color, n++);
                }
            }
            if (n <= 5) continue;
            n = 0;
        }
        if (this.isDrawReceiverBands && d >= 0.0) {
            try {
                this.paintBand(graphics, ReceiverBand.getReceiverBand(spectralSetupParameters), this.palette.getRestFrequencyColor());
            }
            catch (ReceiverBand.ReceiverNotFoundException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    public void paintNoSpectralSpec(Graphics graphics) {
        this.textHeight = this.graphicsHelper.calculateTextHeight(graphics);
        this.paintBackground(graphics);
        if (this.getDrawOtherLines()) {
            this.paintKnownSpectralLinesLines(graphics, this.minTF, this.maxTF);
        }
    }

    private void paintSpectralSpec(Graphics graphics, ScienceGoal scienceGoal) {
        this.paintNoSpectralSpec(graphics);
        if (this.isDrawSideBands()) {
            this.paintSideBands(graphics, scienceGoal);
        }
        this.paintSpectralElements(graphics, scienceGoal);
    }

    @Override
    public void corePaintComponent(Graphics graphics) {
        ScienceGoal scienceGoal = (ScienceGoal)this.model.getDocument();
        if (scienceGoal != null) {
            this.paintSpectralSpec(graphics, scienceGoal);
        } else {
            this.resetFrequencyRange();
            this.paintNoSpectralSpec(graphics);
        }
    }

    private void paintBackground(Graphics graphics) {
        this.paintObservedAxisAndBands(graphics);
        this.paintRestAxis(graphics);
    }

    public void clearSpatialSelection() {
        this.spatialSelection.clear();
    }

    @Override
    protected SpectralSpecDocument getContext() {
        SpectralSpecDocument spectralSpecDocument = null;
        if (this.model != null) {
            SingleFieldScienceGoalModel singleFieldScienceGoalModel = (SingleFieldScienceGoalModel)this.model;
            spectralSpecDocument = singleFieldScienceGoalModel.getContext();
        }
        return spectralSpecDocument;
    }

    @Override
    protected Velocity getSourceVelocity() {
        Velocity velocity;
        ScienceGoal scienceGoal = (ScienceGoal)this.model.getDocument();
        if (scienceGoal == null || this.chosenTargetIndex < 0) {
            velocity = Velocity.createVelocity();
        } else {
            boolean bl = scienceGoal.getSpectralSetupParameters().isSpectralLine();
            try {
                TargetParameters targetParameters = scienceGoal.getTargetParameters(this.chosenTargetIndex);
                velocity = bl ? targetParameters.getSourceVelocityInDefaultReferenceFrame(Optional.of(scienceGoal)) : targetParameters.getSourceVelocity();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.clearSpatialSelection();
                if (scienceGoal.getTargetParametersCount() > 0) {
                    TargetParameters targetParameters = scienceGoal.getTargetParameters(0);
                    velocity = bl ? targetParameters.getSourceVelocityInDefaultReferenceFrame(Optional.of(scienceGoal)) : targetParameters.getSourceVelocity();
                    this.spatialSelection.add(0);
                    this.chosenTargetIndex = 0;
                }
                velocity = Velocity.createVelocity();
                this.chosenTargetIndex = -1;
            }
        }
        return velocity;
    }

    public void setSelectedLine(AbstractScienceSpectralWindow abstractScienceSpectralWindow) {
        this.windowSelection = abstractScienceSpectralWindow;
        this.repaint();
    }

    public void addSpatialListener(JTable jTable) {
        ListSelectionListener listSelectionListener = listSelectionEvent -> {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.getValueIsAdjusting()) {
                int[] nArray = jTable.getSelectedRows();
                this.spatialSelection.clear();
                for (int n : nArray) {
                    this.spatialSelection.add(n);
                }
                this.chosenTargetIndex = jTable.getSelectedRow();
                this.repaint();
            }
        };
        jTable.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public boolean mouseOnLo(MouseEvent mouseEvent) {
        ScienceGoal scienceGoal = (ScienceGoal)this.model.getDocument();
        double d = -1000.0;
        int n = -1000;
        if (scienceGoal != null) {
            d = scienceGoal.getLO1Frequency().getContentInGHz();
            n = this.scaleOF(d);
        }
        return (double)Math.abs(mouseEvent.getX() - n) < 10.0;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.pressedX = mouseEvent.getX();
        this.isDraggingLocally = this.mouseOnAxes(mouseEvent);
        this.draggingLo = this.mouseOnLo(mouseEvent) && this.isLODragAllowed();
        this.pressedMinOF = this.minOF;
        this.pressedMaxOF = this.maxOF;
        if (this.isDraggingLocally || this.draggingLo) {
            this.setCursor(this.moveCursor);
            ScienceGoal scienceGoal = (ScienceGoal)this.model.getDocument();
            if (scienceGoal != null) {
                this.lo1PreDragFrequency = scienceGoal.getLO1Frequency().deepCopy();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isDraggingLocally && !this.draggingLo) {
            if (mouseEvent.getButton() == 1) {
                this.zoomInAtCursor(3.0);
            } else if (mouseEvent.getButton() == 3) {
                this.zoomOutAtCursor(3.0);
            }
            this.repaint();
        }
        if (this.draggingLo) {
            this.lo1PreDragFrequency = null;
            this.springBackSidebands();
        }
        if (this.pressedX != mouseEvent.getX()) {
            return;
        }
        this.isDraggingLocally = false;
        this.draggingLo = false;
    }

    private void springBackSidebands() {
        ScienceGoal scienceGoal = (ScienceGoal)this.model.getDocument();
        try {
            scienceGoal.getSpectralSetupParameters().verifyBasebandSetting();
        }
        catch (BaseBandNotDeployableException baseBandNotDeployableException) {
            // empty catch block
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.mouseOnAxes(mouseEvent) || this.mouseOnLo(mouseEvent) && this.isLODragAllowed()) {
            this.setCursor(this.handCursor);
        } else {
            this.setCursor(this.zoomCursor);
        }
        this.repaint();
    }

    private Stroke setBrushStrokeDashed(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        float[] fArray = new float[]{2.0f, 0.0f, 2.0f};
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 1, 1.0f, fArray, 2.0f);
        graphics2D.setStroke(basicStroke);
        return stroke;
    }

    private void setBrushStroke(Graphics graphics, Stroke stroke) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(stroke);
    }

    @Override
    protected void paintSpectralWindow(Graphics graphics, ScienceSpectralWindow scienceSpectralWindow, AbstractTargetParameters abstractTargetParameters, Color color, int n) {
        ReceiverBand receiverBand;
        double d;
        Frequency frequency = scienceSpectralWindow.getCenterFrequency();
        double d2 = frequency.getContentInGHz();
        ScienceGoal scienceGoal = (ScienceGoal)this.model.getDocument();
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        double d3 = spectralSetupParameters.getLO1Frequency().getContentInGHz();
        boolean bl = false;
        if (spectralSetupParameters.getReceiverBand() != null && this.isDrawDSBImageWindow() && spectralSetupParameters.getReceiverBand().getType().equals(SpectralSpec.RECEIVERTYPE_DSB)) {
            bl = true;
        }
        if (scienceSpectralWindow.getIsSkyFrequency()) {
            d = d2;
            d2 = this.getSourceVelocity().reverseShift(frequency).getContentInGHz();
        } else {
            d = this.getSourceVelocity().dopplerShift(frequency).getContentInGHz();
        }
        double d4 = scienceSpectralWindow.getCorrConfigMode().getEffectiveBandwidth().getContentInGHz();
        double d5 = scienceSpectralWindow.getSpectralResolution().getContentInGHz();
        String string = this.transitionName(scienceSpectralWindow);
        this.paintTargetSpectralLine(graphics, d2, string, color, n + 1, false);
        this.paintObservedSpectralWindow(graphics, d - d4 / 2.0, d4, d5, color, n + 1);
        if (bl && (receiverBand = this.currentReceiverBand(scienceGoal)) != null) {
            Velocity velocity = spectralSetupParameters.isSpectralLine() ? abstractTargetParameters.getSourceVelocityInDefaultReferenceFrame(Optional.of(scienceGoal)) : abstractTargetParameters.getSourceVelocity();
            Frequency frequency2 = spectralSetupParameters.getLO1Frequency().inverseDopplerShifted(velocity);
            double d6 = frequency2.getContentInGHz();
            Frequency frequency3 = Frequency.createFrequencyGHZ(receiverBand.getIFMax()).inverseDopplerShifted(velocity);
            Frequency frequency4 = Frequency.createFrequencyGHZ(receiverBand.getIFMin()).inverseDopplerShifted(velocity);
            Range range = new Range(d6 - frequency3.getContentInGHz(), d6 - frequency4.getContentInGHz());
            Range range2 = new Range(d6 + frequency4.getContentInGHz(), d6 + frequency3.getContentInGHz());
            double d7 = 2.0 * d6 - d2;
            if (range.inRange(d7) || range2.inRange(d7)) {
                Color color2 = Colors.transparentColor(color);
                Stroke stroke = null;
                if (!scienceSpectralWindow.getAdvancedWindowSetup().getUseImage()) {
                    stroke = this.setBrushStrokeDashed(graphics);
                }
                this.paintTargetSpectralLine(graphics, d7, string, color2, n + 1, false);
                double d8 = 2.0 * d3 - d;
                this.paintObservedSpectralWindow(graphics, d8 - d4 / 2.0, d4, d5, color2, n + 1);
                if (!scienceSpectralWindow.getAdvancedWindowSetup().getUseImage()) {
                    this.setBrushStroke(graphics, stroke);
                }
            }
        }
    }

    public void setDrawReceiverBands(boolean bl) {
        this.isDrawReceiverBands = bl;
    }

    public boolean isDrawReceiverBands() {
        return this.isDrawReceiverBands;
    }

    public boolean isDrawCentreFrequencies() {
        return this.isDrawCentreFrequencies;
    }

    public boolean isDrawBasebands() {
        return this.isDrawBasebands;
    }

    public boolean isDrawSideBands() {
        return this.isDrawSideBands;
    }
}

