/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.valuetypes;

import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.verifiers.DecVerifier;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.guiutil.mvc.verifiers.RAVerifier;
import alma.obsprep.guiutil.mvc.verifiers.Verifier;
import alma.obsprep.ot.editors.valuetypes.CoordsEditor;
import alma.obsprep.ot.editors.valuetypes.SystemNotEditableSkyCoordsEditor;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.obsprep.util.Convert;
import alma.obsprep.util.Convert4dp;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SkyCoordsEditor
extends Editor {
    private static final long serialVersionUID = 57988961499841744L;
    private DialogId dialogId = new DialogId("SkyCoordsEditor.ReferenceSystem", "Display sky coordinates reference system change message");
    protected static final int DEFAULT_SYSTEM_INDEX = 1;
    protected static final int LAT_LON_FIELD_SIZE = 14;
    protected static final String LTAlt = "Alt (deg)";
    protected static final String LTAz = "Az (deg)";
    protected static final String LTDec = "Dec";
    protected static final String LTLat = "Lat (deg)";
    protected static final String LTLon = "Lon (deg)";
    protected static final String LTRA = "RA";
    protected static final String LTHA = "HA";
    protected static final String LTSexagDeg1 = "Sexagesimal";
    protected static final String LTSexagDeg2 = "display?";
    protected static final String LTSys = "System";
    protected static final int MAX_CHARS_AFTER = 8;
    protected static final int MIN_CHARS_BEFORE = 4;
    protected static final double RANGE_ALTITUDE_HIGH = 90.0;
    protected static final double RANGE_ALTITUDE_LOW = -90.0;
    protected static final double RANGE_AZIMUTH_HIGH = 180.0;
    protected static final double RANGE_AZIMUTH_LOW = -180.0;
    protected static final double RANGE_LATITUDE_HIGH = 90.0;
    protected static final double RANGE_LATITUDE_LOW = -90.0;
    protected static final double RANGE_LONGITUDE_HIGH = 360.0;
    protected static final double RANGE_LONGITUDE_LOW = 0.0;
    protected static final String[] SYSTEMS = new String[]{SkyCoordinates.SYSTEM_ICRS, "FK5 J2000", SkyCoordinates.SYSTEM_GALACTIC, SkyCoordinates.SYSTEM_ECLIPTIC, SkyCoordinates.SYSTEM_HORIZON, SkyCoordinates.SYSTEM_AZEL};
    private static final String TTTDec = "<html>Valid format is [+|-]DD:MM:SS.SSS,<br>with -90 &lt;= DD &lt;= 90</html>";
    protected static final String TTTLonLat = "A real number, ";
    private static final String TTTRA = "<html>Valid format is HH:MM:SS.SSS,<br>with 0 &lt;= HH &lt; 24</html>";
    private static final String TTTSexagDeg = "<html>If selected, display RA and Dec in<br>sexagesimal notation;<br>i.e. HH:MM:SS.SSS and DD:MM:SS.SSS</html>";
    protected static final String TTTSys = "Coordinate system type";
    protected JCheckBox cboxSexagDeg;
    protected JComboBox comboSys;
    protected JTextField fieldLat;
    protected JTextField fieldLon;
    protected JLabel labelLat;
    protected JLabel labelLon;
    protected JLabel labelNameserver;
    protected JLabel labelSexagDeg1;
    protected JLabel labelSexagDeg2;
    protected JLabel labelSys;
    protected boolean sexagesimal = true;
    protected String TTTAlt;
    protected String TTTAz;
    protected String TTTLat;
    protected String TTTLon;
    protected boolean updatePending = false;
    protected Verifier vAltDeg;
    protected Verifier vAzDeg;
    protected Verifier vDecSexag;
    protected Verifier vLatCurrent;
    protected Verifier vLatDeg;
    protected Verifier vLonCurrent;
    protected Verifier vLonDeg;
    protected Verifier vRASexag;
    private CoordSysItemListener coordSystemItemListener;

    public SkyCoordsEditor(SkyCoordsModel skyCoordsModel) {
        super(skyCoordsModel);
        SexagDegItemListener sexagDegItemListener = new SexagDegItemListener();
        this.cboxSexagDeg.addItemListener(sexagDegItemListener);
        CoordSysActionListener coordSysActionListener = new CoordSysActionListener();
        this.comboSys.addActionListener(coordSysActionListener);
        this.coordSystemItemListener = new CoordSysItemListener();
        this.comboSys.addItemListener(this.coordSystemItemListener);
        String string = TextUtils.range(0.0, 360.0, true, false);
        this.TTTLon = TTTLonLat + string;
        string = TextUtils.range(-90.0, 90.0, true, true);
        this.TTTLat = TTTLonLat + string;
        string = TextUtils.range(-90.0, 90.0, true, true);
        this.TTTAlt = TTTLonLat + string;
        string = TextUtils.range(-180.0, 180.0, true, true);
        this.TTTAz = TTTLonLat + string;
        this.reconfigureEditor();
    }

    @Override
    public SkyCoordsModel getModel() {
        return (SkyCoordsModel)super.getModel();
    }

    @Override
    protected void build() {
        this.buildCoordSysSelector();
        this.labelLon = new JLabel("");
        this.labelLon.setName("SkyCoordsEditor.LongitudeLabel");
        this.fieldLon = new JTextField();
        int n = this.fieldLon.getFont().getSize();
        Font font = new Font("Monospaced", 0, n);
        this.fieldLon.setFont(font);
        this.fieldLon.setColumns(14);
        this.initEvents(this.fieldLon, SkyCoordsModel.FID_LON);
        this.addLabeledWidget(this.labelLon, this.fieldLon);
        this.labelLat = new JLabel("");
        this.labelLat.setName("SkyCoordsEditor.LatitudeLabel");
        this.fieldLat = new JTextField();
        this.fieldLat.setFont(font);
        this.fieldLat.setColumns(14);
        this.initEvents(this.fieldLat, SkyCoordsModel.FID_LAT);
        this.addLabeledWidget(this.labelLat, this.fieldLat);
        this.labelNameserver = new JLabel();
        this.addLabeledWidget(new JLabel(""), this.labelNameserver);
        this.initEvents(this.labelNameserver, SkyCoordsModel.FID_RESOLVEDBY);
        this.comboSys.setToolTipText(TTTSys);
        this.cboxSexagDeg.setToolTipText(TTTSexagDeg);
        this.buildVerifiers();
        this.layoutLabeledWidgets();
    }

    private void buildCoordSysSelector() {
        boolean bl;
        this.labelSys = new JLabel(LTSys);
        this.labelSys.setName("SkyCoordsEditor.SystemLabel");
        this.comboSys = new JComboBox<String>(SYSTEMS);
        Box box = Box.createVerticalBox();
        this.createUILabelMapping(this.comboSys, SkyCoordinates.SYSTEM_J2000, "FK5 J2000");
        this.comboSys.setEditable(false);
        this.comboSys.setSelectedIndex(1);
        this.initEvents(this.comboSys, SkyCoordsModel.FID_SYS);
        boolean bl2 = bl = !SystemNotEditableSkyCoordsEditor.class.isAssignableFrom(this.getClass());
        if (bl) {
            box.add(this.comboSys);
            box.add(Box.createVerticalGlue());
        } else {
            this.labelSys.setText("");
        }
        this.labelSexagDeg1 = new JLabel(LTSexagDeg1);
        this.labelSexagDeg1.setName("SkyCoordsEditor.SexagesimalLabel1");
        this.labelSexagDeg2 = new JLabel(LTSexagDeg2);
        this.labelSexagDeg2.setName("SkyCoordsEditor.SexagesimalLabel2");
        this.cboxSexagDeg = new JCheckBox();
        this.cboxSexagDeg.setName("SkyCoordsEditor.SexagesimalBox");
        this.cboxSexagDeg.setSelected(true);
        Font font = this.labelSexagDeg1.getFont();
        float f = font.getSize();
        Font font2 = font.deriveFont(f - 2.0f);
        this.labelSexagDeg1.setFont(font2);
        this.labelSexagDeg2.setFont(font2);
        this.labelSexagDeg1.setVerticalTextPosition(3);
        this.labelSexagDeg2.setVerticalTextPosition(1);
        Box box2 = Box.createHorizontalBox();
        box2.add(this.labelSexagDeg1);
        box2.add(Box.createHorizontalGlue());
        Box box3 = Box.createHorizontalBox();
        box3.add(this.labelSexagDeg2);
        box3.add(this.cboxSexagDeg);
        box3.add(Box.createHorizontalGlue());
        Box box4 = Box.createVerticalBox();
        box4.add(box2);
        box4.add(box3);
        Box box5 = Box.createHorizontalBox();
        box5.add(box);
        box5.add(Box.createHorizontalStrut(10));
        box5.add(box4);
        this.addLabeledWidget(this.labelSys, box5);
    }

    private void buildVerifiers() {
        this.vAltDeg = new DoubleVerifier((Editor)this, this.fieldLat, -90.0, 90.0, true, true);
        this.vAzDeg = new DoubleVerifier((Editor)this, this.fieldLon, -180.0, 180.0, true, true);
        this.vLonDeg = new DoubleVerifier((Editor)this, this.fieldLon, 0.0, 360.0, true, false);
        this.vLatDeg = new DoubleVerifier((Editor)this, this.fieldLat, -90.0, 90.0, true, true);
        this.vRASexag = new RAVerifier(this, this.fieldLon);
        this.vDecSexag = new DecVerifier(this, this.fieldLat);
    }

    private void reconfigureEditor() {
        if (this.isEquatorial()) {
            this.configureEquatorial();
        } else if (this.isAltAz()) {
            this.configureAltAz();
        } else {
            this.configureNonEquatorial();
        }
        this.refresh();
        this.setVerifier(this.fieldLon, "FOCUSLOST_VERIFIER", this.vLonCurrent);
        this.setVerifier(this.fieldLat, "FOCUSLOST_VERIFIER", this.vLatCurrent);
        this.vLonCurrent.verify();
        this.vLatCurrent.verify();
        this.configureToolTips();
    }

    private void configureAltAz() {
        this.labelLon.setText(LTAz);
        this.labelLat.setText(LTAlt);
        this.setEnabled(this.labelSexagDeg1, false);
        this.setEnabled(this.labelSexagDeg2, false);
        this.setEnabled(this.cboxSexagDeg, false);
        this.vLonCurrent = this.vAzDeg;
        this.vLatCurrent = this.vAltDeg;
    }

    private void configureEquatorial() {
        String string = LTRA;
        this.labelLon.setText(string);
        this.labelLat.setText(LTDec);
        this.setEnabled(this.labelSexagDeg1, true);
        this.setEnabled(this.labelSexagDeg2, true);
        this.setEnabled(this.cboxSexagDeg, true & this.isEnabled());
        if (this.sexagesimal) {
            this.vLonCurrent = this.vRASexag;
            this.vLatCurrent = this.vDecSexag;
        } else {
            this.labelLon.setText(string + " (deg)");
            this.labelLat.setText("Dec (deg)");
            this.vLonCurrent = this.vLonDeg;
            this.vLatCurrent = this.vLatDeg;
        }
    }

    private void configureNonEquatorial() {
        this.labelLon.setText(LTLon);
        this.labelLat.setText(LTLat);
        this.setEnabled(this.labelSexagDeg1, false);
        this.setEnabled(this.labelSexagDeg2, false);
        this.setEnabled(this.cboxSexagDeg, false);
        this.vLonCurrent = this.vLonDeg;
        this.vLatCurrent = this.vLatDeg;
    }

    private void configureToolTips() {
        if (this.isEquatorial()) {
            if (this.sexagesimal) {
                this.fieldLon.setToolTipText(TTTRA);
                this.fieldLat.setToolTipText(TTTDec);
            } else {
                this.fieldLon.setToolTipText(this.TTTLon);
                this.fieldLat.setToolTipText(this.TTTLat);
            }
        } else if (this.isAltAz()) {
            this.fieldLon.setToolTipText(this.TTTAz);
            this.fieldLat.setToolTipText(this.TTTAlt);
        } else {
            this.fieldLon.setToolTipText(this.TTTLon);
            this.fieldLat.setToolTipText(this.TTTLat);
        }
    }

    private String getCurrentSystem() {
        return this.getUILabelToBOMapping(this.comboSys, this.comboSys.getSelectedItem().toString());
    }

    private boolean isAltAz() {
        String string = this.getCurrentSystem();
        return SkyCoordinates.isAltAz(string);
    }

    private boolean isEquatorial() {
        String string = this.getCurrentSystem();
        return SkyCoordinates.isEquatorial(string);
    }

    public boolean isSexagesimal() {
        return this.sexagesimal && this.isEquatorial();
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        Object object2;
        block15: {
            double d = -99.0;
            double d2 = -99.0;
            object2 = object;
            boolean bl = this.emptyCoordinates();
            if (fieldID.equals(SkyCoordsModel.FID_LON)) {
                d = Double.parseDouble(object.toString());
                object2 = bl ? "" : TextUtils.format(d, 4, 8);
            }
            if (fieldID.equals(CoordsEditor.FID_COORDS_SYSTEM)) {
                String string = (String)object;
                this.updatePending = true;
                this.coordSystemItemListener.updateCoordinateSystem(string);
                this.updatePending = false;
                this.reconfigureEditor();
            }
            if (fieldID.equals(SkyCoordsModel.FID_LAT)) {
                d2 = Double.parseDouble(object.toString());
                object2 = bl ? "" : TextUtils.format(d2, 4, 8);
            }
            if (fieldID.equals(SkyCoordsModel.FID_RESOLVEDBY)) {
                object2 = object == null ? "" : "Resolved by " + (String)object;
            }
            if (!this.isSexagesimal()) {
                this.updatePending = true;
                super.update(fieldID, object2);
                this.updatePending = false;
                return;
            }
            if (fieldID.equals(SkyCoordsModel.FID_LON)) {
                try {
                    if (bl) {
                        object2 = "";
                        break block15;
                    }
                    object2 = Convert4dp.degToHHMMSS(d);
                }
                catch (OutOfRangeException outOfRangeException) {
                }
                catch (InvalidCoordException invalidCoordException) {}
            } else if (fieldID.equals(SkyCoordsModel.FID_LAT)) {
                try {
                    object2 = bl ? "" : Convert.degToDDMMSS(d2);
                }
                catch (OutOfRangeException outOfRangeException) {
                }
                catch (InvalidCoordException invalidCoordException) {
                    // empty catch block
                }
            }
        }
        this.updatePending = true;
        super.update(fieldID, object2);
        this.updatePending = false;
    }

    private boolean emptyCoordinates() {
        SkyCoordsModel skyCoordsModel = this.getModel();
        SkyCoordinates skyCoordinates = (SkyCoordinates)skyCoordsModel.getDocument();
        Latitude latitude = skyCoordinates.getLatitude();
        Longitude longitude = skyCoordinates.getLongitude();
        return !latitude.hasContent() && !longitude.hasContent();
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (!this.isSexagesimal()) {
            return super.widgetUpdated(fieldID, object);
        }
        Object object2 = object;
        double d = -99.0;
        if (fieldID.equals(SkyCoordsModel.FID_LON)) {
            String string = (String)object;
            try {
                d = Convert4dp.HHMMSSToDeg(string);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (InvalidCoordException invalidCoordException) {
                // empty catch block
            }
            object2 = new Double(d);
        } else if (fieldID.equals(SkyCoordsModel.FID_LAT)) {
            String string = (String)object;
            try {
                d = Convert.DDMMSSToDeg(string);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (InvalidCoordException invalidCoordException) {
                // empty catch block
            }
            object2 = new Double(d);
        }
        return super.widgetUpdated(fieldID, object2);
    }

    public void setSystemEnabled(boolean bl) {
        this.comboSys.setEnabled(bl);
    }

    @Override
    public List<JComponent> getUserRestrictedEditableComponents() {
        return Arrays.asList(this.fieldLat, this.fieldLon, this.labelLat, this.labelLon, this.cboxSexagDeg, this.labelSexagDeg1, this.labelSexagDeg2);
    }

    class SexagDegItemListener
    implements ItemListener {
        SexagDegItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object.equals(SkyCoordsEditor.this.cboxSexagDeg)) {
                SkyCoordsEditor.this.sexagesimal = itemEvent.getStateChange() != 2;
                SkyCoordsEditor.this.reconfigureEditor();
            }
        }
    }

    class CoordSysItemListener
    implements ItemListener {
        private String previousValue = null;

        CoordSysItemListener() {
        }

        private boolean isSameCoordSysType(String string, String string2) {
            int n;
            int n2 = SkyCoordinates.getSystemType(SkyCoordsEditor.this.getUILabelToBOMapping(SkyCoordsEditor.this.comboSys, string));
            return n2 == (n = SkyCoordinates.getSystemType(SkyCoordsEditor.this.getUILabelToBOMapping(SkyCoordsEditor.this.comboSys, string2)));
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            String string = itemEvent.getItem().toString();
            string = SkyCoordsEditor.this.getUILabelToBOMapping((JComponent)itemEvent.getSource(), string);
            this.updateCoordinateSystem(string);
        }

        public void updateCoordinateSystem(String string) {
            if (string.equals(this.previousValue)) {
                return;
            }
            if (this.previousValue == null) {
                this.previousValue = string;
                return;
            }
            String string2 = this.previousValue;
            this.previousValue = string;
            if (SkyCoordsEditor.this.getModel().systemConvert(string)) {
                return;
            }
            if (SkyCoordsEditor.this.updatePending || this.isSameCoordSysType(string, string2) && !SkyCoordinates.isEquatorial(string)) {
                return;
            }
            String string3 = "Changed coordinate system type from \"" + string2 + "\" to \"" + string + "\",\nbut no coordinate conversion was performed";
            SwingUtilities.invokeLater(() -> GUIUtilities.infoWithDoNotShowAgain(SkyCoordsEditor.this.dialogId, string3));
        }
    }

    class CoordSysActionListener
    implements ActionListener {
        CoordSysActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SkyCoordsEditor.this.reconfigureEditor();
        }
    }
}

