/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Entity;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.OTActions;
import alma.obsprep.ot.gui.feedback.ProblemTableModel;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreePanels;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenu;

public class ObservingToolGuiProjectCompartment {
    protected ProjectTreePanels projectTreePanels;
    private final boolean readonly;
    JMenu menFile;
    JMenu menEdit;
    JMenu menView;
    JMenu menTool;
    JMenu menSearch;
    Action[] toolbarActions;
    OTActions.ProjectTiedActions projectTiedActions;
    File fileLocation = null;
    private ProblemTableModel problemModel;
    private final boolean dbg = false;
    protected StringBuilder initialXml = null;

    public ObservingToolGuiProjectCompartment(boolean bl) {
        this.readonly = bl;
    }

    void buildGui(ObservingToolGui observingToolGui, GuiFactory guiFactory) {
        this.projectTreePanels = guiFactory.giveTreePanels(observingToolGui, this.readonly);
    }

    void buildActions(GuiFactory guiFactory, ObservingToolController observingToolController, ObservingToolGui observingToolGui, ProjectRepository projectRepository) {
        this.projectTiedActions = new OTActions.ProjectTiedActions();
        this.projectTiedActions.initialize(observingToolController, observingToolGui, projectRepository, this.projectTreePanels);
        this.menFile = guiFactory.giveFileMenu(this.projectTiedActions);
        this.menEdit = guiFactory.giveEditMenu(this.projectTiedActions);
        this.menView = guiFactory.giveViewMenu(this.projectTiedActions);
        this.menTool = guiFactory.giveToolMenu(this.projectTiedActions);
        this.menSearch = guiFactory.giveSearchMenu();
        ArrayList<Action> arrayList = guiFactory.givePhase2TreePopupMenuItemList(this.projectTiedActions);
        this.getPhase2Tree().setPopupItemList(arrayList);
        arrayList = guiFactory.givePhase1TreePopupMenuItemList(this.projectTiedActions);
        this.getPhase1Tree().setPopupItemList(arrayList);
        this.toolbarActions = guiFactory.giveToolBarActions(this.projectTiedActions);
        for (ProjectTree projectTree : new ProjectTree[]{this.getPhase2Tree(), this.getPhase1Tree()}) {
            ActionMap actionMap = projectTree.getTree().getActionMap();
            actionMap.put("cut", this.projectTiedActions.cut);
            actionMap.put("copy", this.projectTiedActions.copy);
            actionMap.put("paste", this.projectTiedActions.paste);
        }
    }

    public OTActions.ProjectTiedActions getProjectTiedActions() {
        return this.projectTiedActions;
    }

    JMenu[] getMenus() {
        return new JMenu[]{this.menFile, this.menEdit, this.menView, this.menTool, this.menSearch};
    }

    ProjectTree getPhase2Tree() {
        return this.projectTreePanels.getPhase2Tree();
    }

    ProjectTree getPhase1Tree() {
        return this.projectTreePanels.getPhase1Tree();
    }

    ObsProject getObsProject() {
        return this.projectTreePanels.getObsProject();
    }

    public ProjectTreePanels getProjectTreePanels() {
        return this.projectTreePanels;
    }

    public File getFileLocation() {
        return this.fileLocation;
    }

    public void setFileLocation(File file) {
        this.fileLocation = file;
    }

    void buildData() {
        this.problemModel = new ProblemTableModel();
    }

    public ProblemTableModel getProblemModel() {
        return this.problemModel;
    }

    private StringBuilder dump(ObsProject obsProject) throws UnknownEntityException {
        long l = System.currentTimeMillis();
        StringBuilder stringBuilder = new StringBuilder(16384);
        Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.decompose(obsProject);
        for (Entity entity : boBundle.entities()) {
            stringBuilder.append(((BusinessObject)entity).toXml());
        }
        return stringBuilder;
    }

    public void resetInitialObsProject(ObsProject obsProject) {
        try {
            this.initialXml = this.dump(obsProject);
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
    }

    public boolean obsProjectModified() {
        if (this.initialXml == null || this.getObsProject() == null) {
            return false;
        }
        try {
            StringBuilder stringBuilder = this.dump(this.getObsProject());
            if (stringBuilder.length() != this.initialXml.length()) {
                return true;
            }
            int n = this.initialXml.length();
            for (int i = 0; i < n; ++i) {
                if (this.initialXml.charAt(i) == stringBuilder.charAt(i)) continue;
                return true;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            return false;
        }
        return false;
    }

    public boolean isReadonly() {
        return this.readonly;
    }
}

