/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrFraction;
import alma.obsprep.bo.obsproject.AdvancedWindowSetup;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.sciencegoals.SfiSpectralSetupEditor;
import alma.obsprep.ot.models.sciencegoals.SpectralScanTuningTableModel;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.ot.models.sciencegoals.WalshSwitchControllerInterface;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.Velocity;
import java.text.DecimalFormat;
import java.util.Set;
import lombok.NonNull;

public class SfiScanSetupModel
extends Model {
    private boolean isInhibitCalculationOfRepFreq = false;
    public static final FieldID SPECSCAN_SPECTRAL_AVERAGING = new FieldID("SpectralScanSetupParameters.SpectralAveraging");
    private int currentTargetSelected = -1;
    public static final FieldID FEEDBACK_AREA_FID = new FieldID("SpectralScanSetupParameters.FeedbackArea");
    public static final FieldID SPECSCAN_ACHIEVED_SCAN_RANGE_FID = new FieldID("SpectralScanSetupParameters.RealisedScanRange");
    public static final FieldID SPECSCAN_STARTFREQ_VALUE_VUP = new FieldID("SpectralScanSetupParameters.startFrequency.value");
    public static final FieldID SPECSCAN_STARTFREQ_UNIT_VUP = new FieldID("SpectralScanSetupParameters.startFrequency.unit");
    public static final FieldID SPECSCAN_SPECRESOLUTION_UNIT_VUP = new FieldID("SpectralScanSetupParameters.spectralResolution.unit");
    public static final FieldID SPECSCAN_SPECRESOLUTION_VALUE_VUP = new FieldID("SpectralScanSetupParameters.spectralResolution.value");
    public static final FieldID SPECSCAN_ENDFREQ_VALUE_VUP = new FieldID("SpectralScanSetupParameters.endFrequency.value");
    public static final FieldID SPECSCAN_ENDFREQ_UNIT_VUP = new FieldID("SpectralScanSetupParameters.endFrequency.unit");
    public static final FieldID SPECSCAN_BANDWIDTH = new FieldID("SpectralScanSetupParameters.bandwidth");
    public static final FieldID SPECSCAN_EFFECTIVEBANDWIDTH_UNIT_VUP = new FieldID("SpectralScanSetupParameters.effectiveBandwidth.unit");
    public static final FieldID SPECSCAN_EFFECTIVEBANDWIDTH_VALUE_VUP = new FieldID("SpectralScanSetupParameters.effectiveBandwidth.value");
    public static final FieldID AVERAGETUNINGOVERLAP = new FieldID("SpectralScanSetupParameters.averageTuningOverlap");
    private ValueUnitPairModel startFrequencyModel;
    private ValueUnitPairModel endFrequencyModel;
    private ValueUnitPairModel spectralResolutionModel;
    private ValueUnitPairModel bandwidthModel;
    private final SpectralScanTuningTableModel spectralScanTuningTableModel = new SpectralScanTuningTableModel(this);
    private CorrConfigMode correlatorMode;
    private Frequency averageTuningOverlapFreq;
    protected Double lastStartFreq = 0.0;
    protected Double lastEndFreq = 0.0;
    private Object lastCorrelatorMode;
    private WalshSwitchControllerInterface walshSwitchController = null;
    private boolean isAutoUpdateSpectralAveraging = true;

    public SfiScanSetupModel(SpectralScan spectralScan) {
        super((Object)spectralScan);
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> {
            SpectralScan spectralScan = (SpectralScan)((Object)((Object)this.getDocument()));
            SpectralScan.SpectralScanTunings spectralScanTunings = null;
            if (spectralScan != null) {
                try {
                    spectralScanTunings = spectralScan.getTunings();
                }
                catch (UnableToFindSolutionException unableToFindSolutionException) {
                    // empty catch block
                }
            }
            Object object2 = "Unknown";
            FrequencyRange frequencyRange = null;
            if (spectralScanTunings != null) {
                try {
                    frequencyRange = spectralScanTunings.getAchievedScanRange();
                    object2 = ((Frequency)((Object)((Object)frequencyRange.min()))).getContentInGHz() + " GHz - " + ((Frequency)((Object)((Object)frequencyRange.max()))).getContentInGHz() + " GHz";
                }
                catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
                    // empty catch block
                }
                this.publish(SPECSCAN_ACHIEVED_SCAN_RANGE_FID, object2);
            }
            if (frequencyRange != null) {
                double d;
                double d2;
                try {
                    d2 = this.endFrequencyModel.getVUP().getContent();
                    d = this.startFrequencyModel.getVUP().getContent();
                }
                catch (Exception exception) {
                    return;
                }
                double d3 = Math.abs(d2 - this.lastStartFreq);
                double d4 = Math.abs(d - this.lastEndFreq);
                if (d3 > 1.0E-5 || d4 > 1.0E-5 || fieldID.equals(SPECSCAN_EFFECTIVEBANDWIDTH_VALUE_VUP)) {
                    if (fieldID.equals(SPECSCAN_EFFECTIVEBANDWIDTH_VALUE_VUP) || fieldID.equals(SPECSCAN_ENDFREQ_UNIT_VUP) || fieldID.equals(SPECSCAN_ENDFREQ_VALUE_VUP) || fieldID.equals(SPECSCAN_STARTFREQ_UNIT_VUP) || fieldID.equals(SPECSCAN_STARTFREQ_VALUE_VUP)) {
                        this.calculateRepresentativeFrequency(model, fieldID, object);
                    }
                    this.lastStartFreq = d2;
                    this.lastEndFreq = d;
                }
            }
            this.walshSwitchController.setWalshSwitchingUserAvailability();
            this.getController().modelChanged(fieldID, object);
        };
        this.startFrequencyModel = new ValueUnitPairModel(null, SPECSCAN_STARTFREQ_VALUE_VUP, SPECSCAN_STARTFREQ_UNIT_VUP);
        this.endFrequencyModel = new ValueUnitPairModel(null, SPECSCAN_ENDFREQ_VALUE_VUP, SPECSCAN_ENDFREQ_UNIT_VUP);
        this.spectralResolutionModel = new ValueUnitPairModel(null, SPECSCAN_SPECRESOLUTION_VALUE_VUP, SPECSCAN_SPECRESOLUTION_UNIT_VUP);
        this.bandwidthModel = new ValueUnitPairModel(null, SPECSCAN_EFFECTIVEBANDWIDTH_VALUE_VUP, SPECSCAN_EFFECTIVEBANDWIDTH_UNIT_VUP);
        this.startFrequencyModel.subscribe(modelChangeSubscriber);
        this.startFrequencyModel.subscribe((Model model, FieldID fieldID, Object object) -> {
            if (this.walshSwitchController != null) {
                this.walshSwitchController.setWalshSwitchingUserAvailability();
            }
        });
        this.endFrequencyModel.subscribe((Model model, FieldID fieldID, Object object) -> {
            if (this.walshSwitchController != null) {
                this.walshSwitchController.setWalshSwitchingUserAvailability();
            }
        });
        this.endFrequencyModel.subscribe(modelChangeSubscriber);
        this.spectralResolutionModel.subscribe(modelChangeSubscriber);
        this.bandwidthModel.subscribe(modelChangeSubscriber);
        this.registerSubModel(this.startFrequencyModel, this.endFrequencyModel, this.spectralResolutionModel, this.bandwidthModel);
        this.setDocument((Object)spectralScan);
    }

    public SpectralScan getSpectralScan() {
        return (SpectralScan)((Object)this.getDocument());
    }

    @Override
    public void publish() {
        SpectralSetupParameters spectralSetupParameters;
        SpectralScan spectralScan = this.getSpectralScan();
        if (spectralScan != null && (spectralSetupParameters = (SpectralSetupParameters)this.getSpectralScan().getParent()) != null) {
            this.startFrequencyModel.publish();
            this.endFrequencyModel.publish();
            this.bandwidthModel.publish();
            this.spectralResolutionModel.publish();
            this.setCorrelatorMode(this.determineCorrelatorMode(spectralSetupParameters));
            this.publish(SPECSCAN_BANDWIDTH, this.getCorrelatorMode());
            this.publish(AVERAGETUNINGOVERLAP, (Object)this.averageTuningOverlapFreq);
            this.spectralScanTuningTableModel.fireTableDataChanged();
            this.publish(SPECSCAN_SPECTRAL_AVERAGING, spectralScan.getAdvancedWindowSetup().getSmoothingFactor());
        }
    }

    private CorrConfigMode determineCorrelatorMode(@NonNull SpectralSetupParameters spectralSetupParameters) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("spectralSetupParameters is marked non-null but is null");
        }
        CorrConfigMode corrConfigMode = null;
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        Set<CorrConfigMode> set = oTConfigModeDecoder.findMode(spectralSetupParameters.getCorrPolarization());
        Set<CorrConfigMode> set2 = oTConfigModeDecoder.findMode(CorrFraction.FULL, false, set);
        Set<CorrConfigMode> set3 = oTConfigModeDecoder.findModeInBandwidthRange(Frequency.createFrequencyGHZ(2.0), Frequency.createFrequencyGHZ(0.45), set2);
        for (CorrConfigMode corrConfigMode2 : set3) {
            if (!this.bandwidthModel.getVUP().isEqual((ValueUnitPair)corrConfigMode2.getNominalBandwidth(), 0.01) || !this.spectralResolutionModel.getVUP().isEqual((ValueUnitPair)corrConfigMode2.getResolution(), 1.0E-4)) continue;
            corrConfigMode = corrConfigMode2;
            break;
        }
        return corrConfigMode;
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        SpectralScan spectralScan = (SpectralScan)((Object)this.getDocument());
        if (spectralScan == null) {
            return object;
        }
        Integer n = spectralScan.getSpectralAverageFactor();
        if (fieldID.equals(SPECSCAN_STARTFREQ_VALUE_VUP)) {
            this.startFrequencyModel.update(editor, SPECSCAN_STARTFREQ_VALUE_VUP, object);
            this.startFrequencyModel.publish();
        } else if (fieldID.equals(SPECSCAN_ENDFREQ_VALUE_VUP)) {
            this.endFrequencyModel.update(editor, SPECSCAN_ENDFREQ_VALUE_VUP, object);
            this.endFrequencyModel.publish();
        } else if (fieldID.equals(SPECSCAN_SPECTRAL_AVERAGING)) {
            String string;
            if (object instanceof String && !(string = (String)object).equals(n.toString())) {
                spectralScan.setSpectralAveraging((String)object);
                this.publish(SPECSCAN_SPECTRAL_AVERAGING, object);
            }
        } else if (fieldID.equals(SPECSCAN_BANDWIDTH)) {
            if (this.lastCorrelatorMode != null && this.lastCorrelatorMode.equals(object)) {
                return object;
            }
            this.setCorrelatorMode(CorrConfigMode.fromString((String)object));
            CorrConfigMode corrConfigMode = this.getCorrelatorMode();
            if (corrConfigMode != null) {
                UserFrequency userFrequency = UserFrequency.createUserFrequency(corrConfigMode.getNominalBandwidth());
                ValueUnitPair valueUnitPair = this.bandwidthModel.getVUP();
                valueUnitPair.setContent(userFrequency.getContent());
                valueUnitPair.setUnit(userFrequency.getUnit());
                this.bandwidthModel.publish();
                Frequency frequency = this.correlatorMode.getResolution();
                valueUnitPair = this.spectralResolutionModel.getVUP();
                valueUnitPair.setContent(frequency.getContent());
                valueUnitPair.setUnit(frequency.getUnit());
                this.spectralResolutionModel.publish();
                boolean bl = corrConfigMode.getFilter().equals((Object)CorrFilter.TFB);
                if (this.isAutoUpdateSpectralAveraging && bl && n != 2) {
                    spectralScan.setSpectralAveraging(2);
                    this.publish(SPECSCAN_SPECTRAL_AVERAGING, 2);
                }
                if (!bl && n != 1) {
                    spectralScan.setSpectralAveraging(1);
                    this.publish(SPECSCAN_SPECTRAL_AVERAGING, 1);
                }
            }
        } else if (fieldID.equals(SfiSpectralSetupEditor.FID_WALSH_SWITCHING_USER_CONTROLLABLE)) {
            this.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING_USER_CONTROLLABLE, object);
        }
        return object;
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        if (object instanceof SpectralScan) {
            SpectralScan spectralScan = (SpectralScan)((Object)object);
            this.spectralResolutionModel.setDocument((Object)spectralScan.getSpectralResolution());
            this.bandwidthModel.setDocument(spectralScan.getBandWidth());
            this.setCorrelatorMode(this.determineCorrelatorMode((SpectralSetupParameters)spectralScan.getParent()));
            this.startFrequencyModel.setDocument((Object)spectralScan.getStartFrequency());
            this.endFrequencyModel.setDocument((Object)spectralScan.getEndFrequency());
            this.spectralScanTuningTableModel.setDocument(spectralScan);
        }
        this.publish();
    }

    public Frequency getSpectralScanCenterInSkyFrame() {
        SpectralScan spectralScan = (SpectralScan)((Object)this.getDocument());
        if (spectralScan == null) {
            return Frequency.createFrequencyGHZ(0.0);
        }
        return spectralScan.getCenterFrequency();
    }

    public FrequencyRange getSpectralScanInRestFrame() {
        FrequencyRange frequencyRange = null;
        SpectralScan spectralScan = (SpectralScan)((Object)this.getDocument());
        if (spectralScan != null) {
            Frequency frequency = spectralScan.getStartFrequency().deepCopy();
            Frequency frequency2 = spectralScan.getEndFrequency().deepCopy();
            if (frequency.isZero() || frequency2.isZero()) {
                return null;
            }
            Integer n = null;
            BusinessObject businessObject = spectralScan.getParent().getParent();
            if (businessObject instanceof ScienceGoal) {
                n = ((ScienceGoal)businessObject).getTargetParametersCount();
            } else if (businessObject instanceof ObservatoryGoal) {
                n = ((ObservatoryGoal)businessObject).getObservatoryGoalTargetParametersCount();
            } else {
                throw new RuntimeException("Unable to determine goal type");
            }
            if (n == null) {
                throw new RuntimeException("Unable to determine goal type");
            }
            if (n - 1 < this.currentTargetSelected) {
                this.currentTargetSelected = 0;
            }
            Velocity velocity = Velocity.createVelocity();
            if (n > 0) {
                if (businessObject instanceof ScienceGoal) {
                    velocity = ((ScienceGoal)businessObject).getTargetParameters(this.currentTargetSelected == -1 ? 0 : this.currentTargetSelected).getSourceVelocity().deepCopy();
                } else if (businessObject instanceof ObservatoryGoal) {
                    velocity = ((ObservatoryGoal)businessObject).getObservatoryGoalTargetParameters(this.currentTargetSelected == -1 ? 0 : this.currentTargetSelected).getSourceVelocity().deepCopy();
                } else {
                    throw new RuntimeException("Unable to determine goal type");
                }
            }
            assert (velocity != null);
            frequency = velocity.reverseShift(frequency);
            frequency2 = velocity.reverseShift(frequency2);
            frequencyRange = new FrequencyRange(frequency, frequency2);
        }
        return frequencyRange;
    }

    public void configureModelListeners() {
        SpectralSetupParametersModel spectralSetupParametersModel = (SpectralSetupParametersModel)this.getParentModel();
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> {
            SpectralSetupParameters spectralSetupParameters;
            SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice;
            if (fieldID.equals(SfiSpectralSetupEditor.FID_POLARIZATION)) {
                this.publish(SPECSCAN_BANDWIDTH, this.getCorrelatorMode());
            }
            if (fieldID.equals(SfiSpectralSetupEditor.FID_SPECTRALTYPE) && object instanceof SpectralSetupParameters.SpectralSetupTypeChoice && (spectralSetupTypeChoice = (SpectralSetupParameters.SpectralSetupTypeChoice)((Object)((Object)object))).equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALSCAN) && this.getParentModel().getDocument() instanceof SpectralSetupParameters && (spectralSetupParameters = (SpectralSetupParameters)((Object)((Object)this.getParentModel().getDocument()))) != null) {
                this.setDocument((Object)spectralSetupParameters.getAbstractScienceSpectralWindowSpectralScan()[0]);
            }
        };
        spectralSetupParametersModel.subscribe(modelChangeSubscriber);
    }

    private void calculateRepresentativeFrequency(Model model, FieldID fieldID, Object object) {
        SpectralScan spectralScan = (SpectralScan)((Object)this.getDocument());
        if (spectralScan == null) {
            return;
        }
        if (this.isInhibitCalculationOfRepFreq()) {
            return;
        }
        FrequencyRange frequencyRange = spectralScan.getRealisableScanRange();
        if (frequencyRange == null) {
            return;
        }
        Frequency frequency = (Frequency)((Object)frequencyRange.min());
        Frequency frequency2 = (Frequency)((Object)frequencyRange.max());
        Frequency frequency3 = Frequency.createFrequencyGHZ(0.0);
        if (!frequency.isZero() && !frequency2.isZero()) {
            frequency3 = Frequency.createFrequencyGHZ(frequency.getContentInGHz() + ((Frequency)frequency2.minus((AbstractDoubleWithUnit)frequency)).getContentInGHz() / 2.0);
            DecimalFormat decimalFormat = new DecimalFormat("####.###");
            ValueUnitPairModel valueUnitPairModel = ((SpectralSetupParametersModel)this.getParentModel()).getRepFreqModel();
            frequency3.setContentInGHz(Double.valueOf(decimalFormat.format(frequency3.getContentInGHz())));
            valueUnitPairModel.update(null, SpectralSetupParametersModel.REP_FREQ_VUP_VALUE, frequency3.getContentInGHz());
            valueUnitPairModel.update(null, SpectralSetupParametersModel.REP_FREQ_VUP_UNIT, Frequency.UNIT_GHZ);
            valueUnitPairModel.publish();
        }
    }

    public ValueUnitPairModel getRepresentativeFrequencyValueUnitPairModel() {
        return ((SpectralSetupParametersModel)this.getParentModel()).getRepFreqModel();
    }

    public void setAverageTuningOverlap(Frequency frequency) {
        this.averageTuningOverlapFreq = frequency.deepCopy();
        this.publish(AVERAGETUNINGOVERLAP, (Object)this.averageTuningOverlapFreq);
    }

    public void setTargetIndex(int n) {
        if (n == this.currentTargetSelected) {
            return;
        }
        this.currentTargetSelected = n;
        this.publish();
    }

    public SpectralScan.SpectralScanTunings getTunings() throws UnableToFindSolutionException {
        SpectralScan spectralScan = (SpectralScan)((Object)this.getDocument());
        if (spectralScan == null) {
            throw new UnableToFindSolutionException(SpectralScan.SpectralScanErrors.NULLDOCUMENT, "Null document found");
        }
        return spectralScan.getTunings();
    }

    public AdvancedWindowSetup getAdvancedWindowSetup() {
        SpectralScan spectralScan = (SpectralScan)((Object)this.getDocument());
        if (spectralScan == null) {
            return null;
        }
        return spectralScan.getAdvancedWindowSetup();
    }

    public void setInhibitCalculationOfRepFreq(boolean bl) {
        this.isInhibitCalculationOfRepFreq = bl;
    }

    public boolean isInhibitCalculationOfRepFreq() {
        return this.isInhibitCalculationOfRepFreq;
    }

    public ValueUnitPairModel getStartFrequencyModel() {
        return this.startFrequencyModel;
    }

    public ValueUnitPairModel getEndFrequencyModel() {
        return this.endFrequencyModel;
    }

    public ValueUnitPairModel getBandwidthModel() {
        return this.bandwidthModel;
    }

    public SpectralScanTuningTableModel getSpectralScanTuningTableModel() {
        return this.spectralScanTuningTableModel;
    }

    public void setCorrelatorMode(CorrConfigMode corrConfigMode) {
        this.correlatorMode = corrConfigMode;
    }

    public CorrConfigMode getCorrelatorMode() {
        return this.correlatorMode;
    }

    public void setWalshSwitchController(WalshSwitchControllerInterface walshSwitchControllerInterface) {
        this.walshSwitchController = walshSwitchControllerInterface;
    }

    public void setAutoUpdateSpectralAveraging(boolean bl) {
        this.isAutoUpdateSpectralAveraging = bl;
    }
}

