/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.persistence;

public class XPathQueries {
    public static final String Project = "ObsProject";
    public static final String Proposal = "ObsProposal";
    public static final String SchedBlock = "SchedBlock";
    public static final String Project_Name = "/ObsProject/projectName/text()";
    public static final String Project_PI = "/ObsProject/pI/text()";
    public static final String Project_Code = "/ObsProject/code/text()";
    public static final String Project_Status = "/ObsProject/@status";
    public static final String Schedblock_FSName = "/SchedBlock/FieldSource/sourceName/text()";
    public static final String Schedblock_Mode = "/SchedBlock/modeName/text()";
    public static final String Schedblock_Status = "/SchedBlock/@status";

    public static final String Contains(String string) {
        return "[ contains(.,'" + string + "') ]";
    }

    public static final String Equals(String string) {
        return "[ . = '" + string + "' ]";
    }

    public static class TestLogicalConjunction
    extends PredefinedQuery {
        public String varPI;
        public String varStatus;

        public TestLogicalConjunction() {
            this.prettyName = "by PI and Status";
            this.aotEntry = XPathQueries.Project;
        }

        @Override
        public String expression() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("self::node()");
            stringBuilder.append(" [ ");
            stringBuilder.append(XPathQueries.Project_PI + XPathQueries.Contains(this.varPI));
            stringBuilder.append(" and ");
            stringBuilder.append(XPathQueries.Project_Status + XPathQueries.Contains(this.varStatus));
            stringBuilder.append(" ]");
            return stringBuilder.toString();
        }
    }

    public static class SBFieldSource
    extends PredefinedQuery {
        public String varFsName;

        public SBFieldSource() {
            this.prettyName = "by FieldSource Name";
            this.aotEntry = XPathQueries.SchedBlock;
        }

        @Override
        public String expression() {
            return XPathQueries.Schedblock_FSName + XPathQueries.Contains(this.varFsName);
        }
    }

    public static class SchedblockMode
    extends PredefinedQuery {
        public String varSbMode;

        public SchedblockMode() {
            this.prettyName = "by SchedBlock Mode";
            this.aotEntry = XPathQueries.SchedBlock;
        }

        @Override
        public String expression() {
            return XPathQueries.Schedblock_Mode + XPathQueries.Contains(this.varSbMode);
        }
    }

    public static class ProjectName
    extends PredefinedQuery {
        public String varPrjName;

        public ProjectName() {
            this.prettyName = "by Project Name";
            this.aotEntry = XPathQueries.Project;
        }

        @Override
        public String expression() {
            return XPathQueries.Project_Name + XPathQueries.Contains(this.varPrjName);
        }
    }

    public static class ProjectCode
    extends PredefinedQuery {
        public String varPrjCode;

        public ProjectCode() {
            this.prettyName = "by Project Code";
            this.aotEntry = XPathQueries.Project;
        }

        @Override
        public String expression() {
            return XPathQueries.Project_Code + XPathQueries.Contains(this.varPrjCode);
        }
    }

    public static class ProjectAlmaPI
    extends PredefinedQuery {
        public String varPI;

        public ProjectAlmaPI() {
            this.prettyName = "by PI ALMA ID";
            this.aotEntry = XPathQueries.Project;
        }

        @Override
        public String expression() {
            return XPathQueries.Project_PI + XPathQueries.Equals(this.varPI);
        }
    }

    public static class AllProjects
    extends PredefinedQuery {
        public AllProjects() {
            this.prettyName = "all projects";
            this.aotEntry = XPathQueries.Project;
        }

        @Override
        public String expression() {
            return "/";
        }
    }

    public static abstract class PredefinedQuery {
        public String prettyName;
        public String aotEntry;

        public abstract String expression();
    }
}

