/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.valuetypes.Frequency;

public class ValFrequencyInBand
extends AbstractValidator {
    @Override
    public void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        FrequencySetup frequencySetup = (FrequencySetup)businessObject;
        String string = frequencySetup.getReceiverBand();
        ReceiverBand receiverBand = ReceiverBand.getReceiverBand(string);
        Frequency frequency = frequencySetup.getRestFrequency();
        if (!this.frequencyIsWithinBand(frequency.getContentInGHz(), receiverBand)) {
            stringBuffer.append("The target's Rest Frequency and Receiver Band are incompatible");
            bl = false;
        }
        if (!bl) {
            Problem problem = DefaultProblem.createError(stringBuffer.toString(), "Navigate to the Frequency Setup and correct the Receiver Band/Rest Frequency pairing", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private boolean frequencyIsWithinBand(double d, ReceiverBand receiverBand) {
        boolean bl = false;
        if (receiverBand == null) {
            bl = false;
        } else if (receiverBand.getRFMin() <= d && d <= receiverBand.getRFMax()) {
            bl = true;
        }
        return bl;
    }
}

