/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.ArrayRequested;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.DataRateCalculation;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.Phase1DataRateCalculatorInterface;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.DataRate;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class Phase1DataRateCalculator
implements Phase1DataRateCalculatorInterface {
    private final ScienceGoal scienceGoal;
    private final ObservingTimeCalculator otc;

    public Phase1DataRateCalculator(@NonNull ObservingTimeCalculator observingTimeCalculator, @NonNull ScienceGoal scienceGoal) {
        if (observingTimeCalculator == null) {
            throw new NullPointerException("otc is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        this.scienceGoal = scienceGoal;
        this.otc = observingTimeCalculator;
    }

    @Override
    public StorageVolume getDataVolume(@NonNull Array array) throws InvalidObsProgramParametersException {
        Object object;
        DataRate dataRate;
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        try {
            dataRate = this.getAverageDataRate(array);
        }
        catch (UnableToDetermineInstantaneousDataRateException unableToDetermineInstantaneousDataRateException) {
            throw new InvalidObsProgramParametersException(unableToDetermineInstantaneousDataRateException);
        }
        double d = 0.0;
        boolean bl = array.equals((Object)Array.ARRAY_12M);
        if (bl) {
            object = Configuration.getConfigurationsToBeScheduled(this.scienceGoal);
            assert (object != null);
            int n = ((ScienceGoalConfigurations)object).getCompactConfigurations().size();
            d = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, this.scienceGoal) * (double)n;
        }
        object = Time.createTime();
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl2 = ObsProposal.isVLBIRelated();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException("Unable to determine if the proposal is VLBI");
        }
        try {
            bl3 = this.scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException("Unable to determine if a solar science goal" + unknownEntityException.getMessage());
        }
        if (bl3) {
            dataRate = this.getPeakSBBasedDataRate(array);
            Log.logger(Phase1DataRateCalculator.class).fine("peak solar data rate from SB : " + dataRate);
            ((Time)object).aggregate(this.otc.getSolarExecutionTime(this.scienceGoal, true, array));
        } else if (bl2) {
            ((Time)object).aggregate(performanceParameters.getDesiredTime().deepCopy());
        } else {
            ((Time)object).aggregate(this.otc.getTotalRequestedTime(array, true, false, false));
        }
        if (bl) {
            ((Time)object).aggregate((Time)object.multiply(d));
        }
        StorageVolume storageVolume = dataRate.getStorageVolume((Time)object);
        Log.logger(ObservingTimeCalculator.class).fine(String.format("Estimated storage volume %s (based over %s using a data rate of %s)", new Object[]{storageVolume, object, dataRate}));
        return storageVolume;
    }

    private DataRate getPeakSBBasedDataRate(@NonNull Array array) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        DataRate dataRate = DataRate.createDataRate();
        try {
            Map<SpectralSpec, DataRate> map = this.otc.getInstantaneousSpectralSpecBasedDataRates(RequestedArray.valueOf(array));
            Optional<Map.Entry> optional = map.entrySet().stream().filter(entry -> Stream.of(((SpectralSpec)entry.getKey()).getTargetList()).filter(target -> target.hasScienceParameters()).findFirst().isPresent()).findFirst();
            dataRate = optional.map(entry -> (DataRate)((Object)((Object)entry.getValue()))).orElseGet(() -> DataRate.createDataRate());
        }
        catch (UnableToDetermineInstantaneousDataRateException unableToDetermineInstantaneousDataRateException) {
            throw new InvalidObsProgramParametersException("Unable to determine instantaneous data rates " + unableToDetermineInstantaneousDataRateException.getMessage());
        }
        assert (dataRate != null);
        return dataRate;
    }

    @Override
    public DataRate getPeakDataRate(@NonNull Array array, boolean bl) throws UnableToDetermineInstantaneousDataRateException {
        Object object;
        Time time;
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        DataRateCalculation dataRateCalculation = new DataRateCalculation(array);
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        String string = spectralSetupParameters.getType();
        boolean bl2 = spectralSetupParameters.isPureTDM();
        try {
            time = this.getCorrelatorIntegrationDuration(array);
        }
        catch (UnableToDetermineCorrelatorIntegrationTimeException unableToDetermineCorrelatorIntegrationTimeException) {
            Log.logger(ObservingTimeCalculator.class).warning("Unable to determine correlator integration time : " + unableToDetermineCorrelatorIntegrationTimeException.getMessage());
            return DataRate.createDataRate();
        }
        boolean bl3 = false;
        boolean bl4 = this.scienceGoal.isStandAloneACA();
        if (spectralSetupParameters.isWalshSwitching() && !bl4) {
            try {
                object = Configuration.getConfigurationsToBeScheduled(this.scienceGoal).getConfigurationRequiringMostTime(RequestedArray.TWELVE_M);
                bl3 = bl && ((ConfigurationSet)object).getTM1Configuration().map(configuration -> configuration.isLongBaselineConfiguration()).orElse(false) != false;
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                // empty catch block
            }
        }
        if (spectralSetupParameters.isSpectralScan()) {
            StorageVolume storageVolume;
            object = null;
            SpectralScan spectralScan = spectralSetupParameters.getAbstractScienceSpectralWindowSpectralScan()[0];
            CorrConfigMode corrConfigMode = spectralScan.getCorrConfigMode();
            if (corrConfigMode == CorrConfigMode.INVALID_CORRCONFIGMODE) {
                throw new RuntimeException("Unable to determine the correlator mode");
            }
            try {
                object = spectralScan.getTunings();
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                return DataRate.createDataRate();
            }
            if (object == null || ((SpectralScan.SpectralScanTunings)object).getNumberOfTunings() == 0) {
                return DataRate.createDataRate();
            }
            try {
                storageVolume = dataRateCalculation.getSpectralWindowDataVolumePerInteg(corrConfigMode, spectralScan.getAdvancedWindowSetup(), spectralSetupParameters);
            }
            catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
                throw new UnableToDetermineInstantaneousDataRateException(receiverNotFoundException);
            }
            int n = 0;
            try {
                n = ((SpectralScan.SpectralScanTunings)object).getNumberOfSPWs();
            }
            catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
                return DataRate.createDataRate();
            }
            StorageVolume storageVolume2 = storageVolume.times(n);
            Log.logger(Phase1DataRateCalculator.class).fine("Data rate = " + storageVolume2.divide(time).getContentInUnits(DataRate.UNIT_MB_S));
            Time time2 = time;
            if (bl3) {
                time2 = bl2 ? Time.createTimeSec(2.048) : Time.createTimeSec(4.096);
            }
            return storageVolume2.divide(time2);
        }
        if (string.equals(SpectralSetupParameters.TYPE_FULL) || string.equals(SpectralSetupParameters.TYPE_CONTINUUM)) {
            object = StorageVolume.createStorageVolume();
            Time time3 = time;
            if (bl3) {
                time3 = bl2 ? Time.createTimeSec(2.048) : Time.createTimeSec(4.096);
            }
            for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
                StorageVolume storageVolume;
                try {
                    storageVolume = dataRateCalculation.getSpectralWindowDataVolumePerInteg(scienceSpectralWindow.getCorrConfigMode(), scienceSpectralWindow.getAdvancedWindowSetup(), spectralSetupParameters);
                }
                catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
                    throw new UnableToDetermineInstantaneousDataRateException(receiverNotFoundException);
                }
                ((StorageVolume)((Object)object)).aggregate(storageVolume);
            }
            return ((StorageVolume)((Object)object)).divide(time3);
        }
        throw new RuntimeException("Unexpected SpectralSetupType : " + string);
    }

    @Override
    public DataRate getAverageDataRate(@NonNull Array array) throws UnableToDetermineInstantaneousDataRateException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        try {
            if (this.scienceGoal.isSolarScienceGoal()) {
                return this.getPeakSBBasedDataRate(array);
            }
        }
        catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
            throw new UnableToDetermineInstantaneousDataRateException((Exception)throwable);
        }
        try {
            boolean bl = array.equals((Object)Array.ARRAY_12M);
            Time time = this.otc.getTotalRequestedTime(array, true, false, false);
            Time time2 = this.otc.getTotalRequestedTime(array, true, false, true);
            if (bl) {
                time.aggregate(this.otc.getTotalRequestedTime(array, true, true, false));
                time2.aggregate(this.otc.getTotalRequestedTime(array, true, true, true));
            }
            DataRate dataRate = this.getPeakDataRate(array, false);
            DataRate dataRate2 = (DataRate)((DataRate)dataRate.multiply(time.getSecs())).divide(time2.getSecs());
            double d = dataRate2.getContentInUnits(DataRate.UNIT_MB_S);
            if (this.scienceGoal.getSpectralSetupParameters().isWalshSwitching() && d > AlmaPolicies.getInstance().getWarning12mDataRateMBPS()) {
                dataRate = this.getPeakDataRate(array, true);
                dataRate2 = (DataRate)((DataRate)dataRate.multiply(time.getSecs())).divide(time2.getSecs());
            }
            Log.logger(ObservingTimeCalculator.class).fine(String.format("Average data rate for %s is %s (peak %s). Data taking time %s (total requested time %s)", new Object[]{StringUtils.trim((String)array.toString()), dataRate2, dataRate, time, time2}));
            return dataRate2;
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            Log.logger(ObservingTimeCalculator.class).warning("Unable to calculate the average data rate " + invalidObsProgramParametersException.getMessage());
            return DataRate.createDataRate();
        }
    }

    @Override
    public Map<SpectralSpec, DataRate> getInstantaneousSpectralSpecBasedDataRates(@NonNull RequestedArray requestedArray) throws UnableToDetermineInstantaneousDataRateException {
        List list;
        ArrayRequested arrayRequested;
        ImmutableSet immutableSet;
        ObsUnitSet obsUnitSet;
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        HashMap<SpectralSpec, DataRate> hashMap = new HashMap<SpectralSpec, DataRate>();
        if (this.scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        try {
            obsUnitSet = this.otc.generateSBs(this.scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new UnableToDetermineInstantaneousDataRateException(invalidObsProgramParametersException);
        }
        switch (requestedArray) {
            case SEVEN_M: {
                immutableSet = ImmutableSet.of((Object)((Object)SBGeneratorTemplate.SchedBlockType.ACA7M));
                arrayRequested = RequestedArray.SEVEN_M.getControlBlockArray();
                break;
            }
            case TP: {
                immutableSet = ImmutableSet.of((Object)((Object)SBGeneratorTemplate.SchedBlockType.TPSCIENCE));
                arrayRequested = RequestedArray.TP.getControlBlockArray();
                break;
            }
            case TWELVE_M: {
                immutableSet = ImmutableSet.of((Object)((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION), (Object)((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION));
                arrayRequested = RequestedArray.TWELVE_M.getControlBlockArray();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected array type : " + requestedArray);
            }
        }
        assert (immutableSet != null);
        assert (arrayRequested != null);
        try {
            list = obsUnitSet.findSchedBlocks().stream().filter(arg_0 -> Phase1DataRateCalculator.lambda$getInstantaneousSpectralSpecBasedDataRates$5((Set)immutableSet, arg_0)).collect(Collectors.toList());
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new UnableToDetermineInstantaneousDataRateException((Exception)((Object)unknownEntityException));
        }
        for (SchedBlock schedBlock : list) {
            for (SpectralSpec spectralSpec : schedBlock.getSpectralSpec()) {
                AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
                abstractCorrelatorConfiguration.getDataRateCalculator().updateDataRateForConfig(abstractCorrelatorConfiguration, arrayRequested);
                hashMap.put(spectralSpec, spectralSpec.getInstantaneousDataRate());
            }
        }
        return hashMap;
    }

    @Override
    public List<SpectralSpecDataRate> getInstantaneousBaseBandBasedDataRates(@NonNull RequestedArray requestedArray) throws UnableToDetermineInstantaneousDataRateException {
        List list;
        ArrayRequested arrayRequested;
        ImmutableSet immutableSet;
        ObsUnitSet obsUnitSet;
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        ArrayList<SpectralSpecDataRate> arrayList = new ArrayList<SpectralSpecDataRate>();
        if (this.scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        try {
            obsUnitSet = this.otc.generateSBs(this.scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new UnableToDetermineInstantaneousDataRateException(invalidObsProgramParametersException);
        }
        switch (requestedArray) {
            case SEVEN_M: {
                immutableSet = ImmutableSet.of((Object)((Object)SBGeneratorTemplate.SchedBlockType.ACA7M));
                arrayRequested = RequestedArray.SEVEN_M.getControlBlockArray();
                break;
            }
            case TP: {
                immutableSet = ImmutableSet.of((Object)((Object)SBGeneratorTemplate.SchedBlockType.TPSCIENCE));
                arrayRequested = RequestedArray.TP.getControlBlockArray();
                break;
            }
            case TWELVE_M: {
                immutableSet = ImmutableSet.of((Object)((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION), (Object)((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION));
                arrayRequested = RequestedArray.TWELVE_M.getControlBlockArray();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected array type : " + requestedArray);
            }
        }
        assert (immutableSet != null);
        assert (arrayRequested != null);
        try {
            list = obsUnitSet.findSchedBlocks().stream().filter(arg_0 -> Phase1DataRateCalculator.lambda$getInstantaneousSpectralSpecBasedDataRates$5((Set)immutableSet, arg_0)).collect(Collectors.toList());
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new UnableToDetermineInstantaneousDataRateException((Exception)((Object)unknownEntityException));
        }
        for (SchedBlock schedBlock : list) {
            SpectralSpecDataRate spectralSpecDataRate = new SpectralSpecDataRate();
            for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
                SpectralSpec spectralSpec = target.getSpectralSpec();
                AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
                abstractCorrelatorConfiguration.getDataRateCalculator().updateDataRateForConfig(abstractCorrelatorConfiguration, arrayRequested);
                spectralSpec.getBaseBandConfig().stream().forEach(abstractBaseBandConfig -> spectralSpecDataRate.addBasebandDatarate((AbstractBaseBandConfig)abstractBaseBandConfig, abstractBaseBandConfig.getInstantaneousDataRate()));
            }
            arrayList.add(spectralSpecDataRate);
        }
        return arrayList;
    }

    private Time getCorrelatorIntegrationDuration(@NonNull Array array) throws UnableToDetermineCorrelatorIntegrationTimeException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        try {
            for (SchedBlock schedBlock : this.otc.generateSBs(this.scienceGoal).findSchedBlocks()) {
                if (!(array.equals((Object)Array.ARRAY_TP) && schedBlock.isTotalPowerScienceSB() || array.equals((Object)Array.ARRAY_12M) && schedBlock.is12mExtendedArraySB()) && (!array.equals((Object)Array.ARRAY_7M) || !schedBlock.isACA7mArraySB())) continue;
                for (Target target : schedBlock.getTarget()) {
                    if (!target.hasScienceParameters()) continue;
                    AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = target.getSpectralSpec().getAbstractCorrelatorConfiguration();
                    return abstractCorrelatorConfiguration.getIntegrationDuration().deepCopy();
                }
            }
        }
        catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
            throw new UnableToDetermineCorrelatorIntegrationTimeException("Unable to find SBs for array:" + array);
        }
        throw new UnableToDetermineCorrelatorIntegrationTimeException("Unable to find SBs for the array " + array);
    }

    public String toString() {
        return "Phase1DataRateCalculator(scienceGoal=" + this.scienceGoal + ", otc=" + this.otc + ")";
    }

    private static /* synthetic */ boolean lambda$getInstantaneousSpectralSpecBasedDataRates$5(Set set, SchedBlock schedBlock) {
        return set.contains((Object)schedBlock.getSbGenerationContext().getSBType());
    }

    public static class UnableToDetermineInstantaneousDataRateException
    extends Exception {
        public UnableToDetermineInstantaneousDataRateException(Exception exception) {
            super(exception);
        }
    }

    public static class UnableToDetermineCorrelatorIntegrationTimeException
    extends Exception {
        public UnableToDetermineCorrelatorIntegrationTimeException(String string) {
            super(string);
        }
    }

    public static final class SpectralSpecDataRate
    extends HashMap<AbstractBaseBandConfig, DataRate> {
        public void addBasebandDatarate(AbstractBaseBandConfig abstractBaseBandConfig, DataRate dataRate) {
            this.put(abstractBaseBandConfig, dataRate);
        }

        public DataRate getTotalDataRate() {
            DataRate dataRate = DataRate.createDataRate();
            for (AbstractBaseBandConfig abstractBaseBandConfig : this.keySet()) {
                dataRate.plus((AbstractDoubleWithUnit)abstractBaseBandConfig.getInstantaneousDataRate());
            }
            return dataRate;
        }

        @Override
        public String toString() {
            return "Phase1DataRateCalculator.SpectralSpecDataRate()";
        }
    }
}

