/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc.editor;

import alma.common.sensitivitycalculatorcore.calc.SensitivityCalculatorEngine;
import alma.common.sensitivitycalculatorcore.enumerations.Polarization;
import alma.common.sensitivitycalculatorcore.exceptions.BeamsizeNotSpecifiedException;
import alma.common.sensitivitycalculatorcore.exceptions.InvalidFrequencyException;
import alma.common.sensitivitycalculatorcore.exceptions.SourceNeverVisibleException;
import alma.common.sensitivitycalculatorcore.lookup.BasicReceiverBand;
import alma.entity.xmlbinding.valuetypes.TimeT;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.UnitMap;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.models.valuetypes.SensitivityFeedbackCalculatorInterface;
import alma.obsprep.ot.models.valuetypes.SensitivityFormModel;
import alma.obsprep.ot.models.valuetypes.UserUnitValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.etc.editor.SensitivityCalculatorEditor;
import alma.obsprep.util.Convert;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Temperature;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import alma.valuetypes.data.UserFrequencyData;
import java.text.DecimalFormat;

public class SensitivityCalculatorModel
extends Model {
    private static final String[] selectableUnitsForResolution = new String[]{UserAngle.UNIT_ARCSEC, UserAngle.UNIT_MAS};
    private static final FieldID observingFrequencyFID = new FieldID("Observing Frequency");
    private static final FieldID bandwidthFID = new FieldID("Bandwidth");
    private static final FieldID fieldsize12mFID = new FieldID("Beamsize of 12m array");
    private static final FieldID fieldsize7mFID = new FieldID("Beamsize of 7m array");
    private static final FieldID fieldsizeTPFID = new FieldID("FieldSize TP");
    private static final FieldID _12mIntTimeFID = new FieldID("12M Integration Time");
    private static final FieldID _7IntTimeFID = new FieldID("7M Integration Time");
    private static final FieldID TPIntTimeFID = new FieldID("TP Integration Time");
    static final UserUnitValueUnitPairModel bandwidthModel = new UserUnitValueUnitPairModel(null, bandwidthFID);
    static final ValueUnitPairModel obsFrequencyModel = new ValueUnitPairModel(null, observingFrequencyFID);
    static final UserUnitValueUnitPairModel beamsize12mModel = new UserUnitValueUnitPairModel(null, fieldsize12mFID);
    static final UserUnitValueUnitPairModel beamsize7mModel = new UserUnitValueUnitPairModel(null, fieldsize7mFID);
    static final UserUnitValueUnitPairModel beamsizeTPModel = new UserUnitValueUnitPairModel(null, fieldsizeTPFID);
    public static final SensitivityFormModel sensitivity12mModel = new SensitivityFormModel(null, new FieldID("12M Sensitivity"));
    static final SensitivityFormModel sensitivity7mModel = new SensitivityFormModel(null, new FieldID("7M Sensitivity"));
    static final SensitivityFormModel sensitivityTPModel = new SensitivityFormModel(null, new FieldID("TP Sensitivity"));
    final TimeModel intTime12mModel = new TimeModel(null, _12mIntTimeFID, new FieldID());
    final TimeModel intTime7mModel = new TimeModel(null, _7IntTimeFID, new FieldID());
    final TimeModel intTimeTPModel = new TimeModel(null, TPIntTimeFID, new FieldID());
    private SensitivityCalculatorEditor.TimeDisplayOption timeDisplayOption = SensitivityCalculatorEditor.TimeDisplayOption.AUTOMATIC;

    public SensitivityCalculatorModel(SensitivityCalculatorEngine sensitivityCalculatorEngine) {
        super(sensitivityCalculatorEngine);
        this.setDocument(sensitivityCalculatorEngine);
        beamsizeTPModel.setNumberFormat(new DecimalFormat("0.0"));
        sensitivity12mModel.getFeedbackModel().setSensitivityFeedbackCalculator(new AscSpecificSensitivityFeedbackCalculator());
        sensitivity7mModel.getFeedbackModel().setSensitivityFeedbackCalculator(new AscSpecificSensitivityFeedbackCalculator());
        sensitivityTPModel.getFeedbackModel().setSensitivityFeedbackCalculator(new AscSpecificSensitivityFeedbackCalculator());
        sensitivity12mModel.getFineResolutionFeedbackModel().setSensitivityFeedbackCalculator(new AscSpecificSensitivityFeedbackCalculator());
        sensitivity7mModel.getFineResolutionFeedbackModel().setSensitivityFeedbackCalculator(new AscSpecificSensitivityFeedbackCalculator());
        sensitivityTPModel.getFineResolutionFeedbackModel().setSensitivityFeedbackCalculator(new AscSpecificSensitivityFeedbackCalculator());
        this.registerSubModel(bandwidthModel);
        this.registerSubModel(obsFrequencyModel);
        this.registerSubModel(beamsize12mModel);
        this.registerSubModel(beamsize7mModel);
        this.registerSubModel(beamsizeTPModel);
        this.registerSubModel(sensitivity12mModel);
        this.registerSubModel(sensitivity7mModel);
        this.registerSubModel(sensitivityTPModel);
        this.registerSubModel(this.intTime12mModel);
        this.registerSubModel(this.intTime7mModel);
        this.registerSubModel(this.intTimeTPModel);
        obsFrequencyModel.subscribe(this.sensitivityEngineDataUpdater());
        bandwidthModel.subscribe(this.sensitivityEngineDataUpdater());
        beamsize12mModel.subscribe(this.sensitivityEngineDataUpdater());
        beamsize7mModel.subscribe(this.sensitivityEngineDataUpdater());
        beamsizeTPModel.subscribe(this.sensitivityEngineDataUpdater());
        sensitivity12mModel.subscribe(this.sensitivityEngineDataUpdater());
        sensitivity7mModel.subscribe(this.sensitivityEngineDataUpdater());
        sensitivityTPModel.subscribe(this.sensitivityEngineDataUpdater());
        this.intTime12mModel.subscribe(this.sensitivityEngineDataUpdater());
        this.intTime7mModel.subscribe(this.sensitivityEngineDataUpdater());
        this.intTimeTPModel.subscribe(this.sensitivityEngineDataUpdater());
        this.subscribe(this.sensitivityEngineDataUpdater());
        ModelChangeSubscriber modelChangeSubscriber = this.atmDataUpdater();
        this.subscribe(modelChangeSubscriber);
        obsFrequencyModel.subscribe(modelChangeSubscriber);
        if (sensitivityCalculatorEngine != null) {
            sensitivityCalculatorEngine.set12MBeamsizeInArcsecs(0.0);
            sensitivityCalculatorEngine.set7MBeamsizeInArcsecs(0.0);
        }
    }

    public SensitivityCalculatorEngine getSC() {
        return (SensitivityCalculatorEngine)this.getDocument();
    }

    private ModelChangeSubscriber atmDataUpdater() {
        return new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (model == SensitivityCalculatorModel.this) {
                    if (fieldID.equals(SensitivityCalculatorEditor.decFID)) {
                        SensitivityCalculatorModel.this.refreshAtmData();
                    }
                    return;
                }
                SensitivityCalculatorModel.this.refreshAtmData();
            }
        };
    }

    private void refreshSCValues() {
        SensitivityCalculatorEngine sensitivityCalculatorEngine = this.getSC();
        if (sensitivityCalculatorEngine != null) {
            double d = sensitivity12mModel.getVUP().getContentInUnits(Sensitivity.UNIT_JY);
            sensitivityCalculatorEngine.set12MSensitivityInJ(d);
            d = sensitivity7mModel.getVUP().getContentInUnits(Sensitivity.UNIT_JY);
            sensitivityCalculatorEngine.set7MSensitivityInJ(d);
            d = sensitivityTPModel.getVUP().getContentInUnits(Sensitivity.UNIT_JY);
            sensitivityCalculatorEngine.setTPSensitivityInJ(d);
            double d2 = this.intTime12mModel.getVUP().getContentInUnits(Time.UNIT_S);
            sensitivityCalculatorEngine.set12MIntegrationTimeInSec(d2);
            d2 = this.intTime7mModel.getVUP().getContentInUnits(Time.UNIT_S);
            sensitivityCalculatorEngine.set7MIntegrationTimeInSec(d2);
            d2 = this.intTimeTPModel.getVUP().getContentInUnits(Time.UNIT_S);
            sensitivityCalculatorEngine.setTPIntegrationTimeInSec(d2);
            double d3 = obsFrequencyModel.getVUP().getContentInUnits(UserFrequencyData.UNIT_GHZ);
            sensitivityCalculatorEngine.setObservingFrequencyInGHZ(d3);
            UserFrequency userFrequency = (UserFrequency)bandwidthModel.getDocument();
            userFrequency.setObservingFrequency(Frequency.createFrequencyGHZ(d3));
            bandwidthModel.publish();
            double d4 = bandwidthModel.getVUP().getContentInUnits(UserFrequencyData.UNIT_GHZ);
            sensitivityCalculatorEngine.setBandwidth(d4);
            double d5 = beamsize12mModel.getVUP().getContentInUnits(Angle.UNIT_ARCSEC);
            sensitivity12mModel.setBeamsize((Angle)beamsize12mModel.getVUP());
            sensitivityCalculatorEngine.set12MBeamsizeInArcsecs(d5);
            double d6 = beamsize7mModel.getVUP().getContentInUnits(Angle.UNIT_ARCSEC);
            sensitivity7mModel.setBeamsize((Angle)beamsize7mModel.getVUP());
            sensitivityCalculatorEngine.set7MBeamsizeInArcsecs(d6);
            double d7 = beamsizeTPModel.getVUP().getContentInUnits(Angle.UNIT_ARCSEC);
            sensitivityTPModel.setBeamsize((Angle)beamsizeTPModel.getVUP());
            sensitivityCalculatorEngine.setTPBeamsizeInArcsecs(d7);
        }
    }

    private ModelChangeSubscriber sensitivityEngineDataUpdater() {
        return new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                SensitivityCalculatorEngine sensitivityCalculatorEngine = SensitivityCalculatorModel.this.getSC();
                if (sensitivityCalculatorEngine != null) {
                    if (model.equals(sensitivity12mModel)) {
                        boolean bl = object.equals(UserSensitivity.USERUNIT_K) || object.equals(UserSensitivity.USERUNIT_MK);
                        UserSensitivity userSensitivity = (UserSensitivity)sensitivity12mModel.getVUP();
                        double d = userSensitivity.getContentInUnits(Sensitivity.UNIT_JY);
                        sensitivityCalculatorEngine.set12MSensitivityInJ(d);
                        if (bl) {
                            boolean bl2 = beamsize12mModel.getVUP().isZero();
                            if (bl2) {
                                SensitivityCalculatorModel.this.publish(SensitivityCalculatorEditor.sensitivity12InTempFID, "Beamsize must be greater than 0.0 to specify sensitivity in one of the Temperature units.");
                            }
                        } else {
                            SensitivityCalculatorModel.this.publish(SensitivityCalculatorEditor.sensitivity12InTempFID, null);
                        }
                    } else if (model.equals(sensitivity7mModel)) {
                        boolean bl = object.equals(UserSensitivity.USERUNIT_K) || object.equals(UserSensitivity.USERUNIT_MK);
                        double d = sensitivity7mModel.getVUP().getContentInUnits(Sensitivity.UNIT_JY);
                        sensitivityCalculatorEngine.set7MSensitivityInJ(d);
                        if (bl) {
                            boolean bl3 = beamsize7mModel.getVUP().isZero();
                            if (bl3) {
                                SensitivityCalculatorModel.this.publish(SensitivityCalculatorEditor.sensitivity7InTempFID, "Beamsize must be greater than 0.0 to specify sensitivity in one of the Temperature units.");
                            }
                        } else {
                            SensitivityCalculatorModel.this.publish(SensitivityCalculatorEditor.sensitivity7InTempFID, null);
                        }
                    } else if (model.equals(sensitivityTPModel)) {
                        double d = sensitivityTPModel.getVUP().getContentInUnits(Sensitivity.UNIT_JY);
                        boolean bl = object.equals(UserSensitivity.USERUNIT_K) || object.equals(UserSensitivity.USERUNIT_MK);
                        sensitivityCalculatorEngine.setTPSensitivityInJ(d);
                        if (bl) {
                            boolean bl4 = beamsizeTPModel.getVUP().isZero();
                            if (bl4) {
                                SensitivityCalculatorModel.this.publish(SensitivityCalculatorEditor.sensitivityTPInTempFID, "Beamsize must be greater than 0.0 to specify sensitivity in one of the Temperature units.");
                            }
                        } else {
                            SensitivityCalculatorModel.this.publish(SensitivityCalculatorEditor.sensitivityTPInTempFID, null);
                        }
                    } else if (model.equals(SensitivityCalculatorModel.this.intTime12mModel)) {
                        double d = SensitivityCalculatorModel.this.intTime12mModel.getVUP().getContentInUnits(Time.UNIT_S);
                        sensitivityCalculatorEngine.set12MIntegrationTimeInSec(d);
                    } else if (model.equals(SensitivityCalculatorModel.this.intTime7mModel)) {
                        double d = SensitivityCalculatorModel.this.intTime7mModel.getVUP().getContentInUnits(Time.UNIT_S);
                        sensitivityCalculatorEngine.set7MIntegrationTimeInSec(d);
                    } else if (model.equals(SensitivityCalculatorModel.this.intTimeTPModel)) {
                        double d = SensitivityCalculatorModel.this.intTimeTPModel.getVUP().getContentInUnits(Time.UNIT_S);
                        sensitivityCalculatorEngine.setTPIntegrationTimeInSec(d);
                    } else if (model.equals(obsFrequencyModel)) {
                        double d = obsFrequencyModel.getVUP().getContentInUnits(UserFrequencyData.UNIT_GHZ);
                        sensitivityCalculatorEngine.setObservingFrequencyInGHZ(d);
                        beamsizeTPModel.setDocument(SensitivityCalculatorModel.this.createBeamsizeAngle(sensitivityCalculatorEngine.getTPBeamsizeInArcsecs(), Frequency.createFrequencyGHZ(sensitivityCalculatorEngine.getObservingFrequencyInGHZ())));
                    } else if (model.equals(beamsize12mModel)) {
                        double d = beamsize12mModel.getVUP().getContentInUnits(Angle.UNIT_ARCSEC);
                        sensitivity12mModel.setBeamsize((Angle)beamsize12mModel.getVUP());
                        sensitivityCalculatorEngine.set12MBeamsizeInArcsecs(d);
                    } else if (model.equals(beamsize7mModel)) {
                        double d = beamsize7mModel.getVUP().getContentInUnits(Angle.UNIT_ARCSEC);
                        sensitivity7mModel.setBeamsize((Angle)beamsize7mModel.getVUP());
                        sensitivityCalculatorEngine.set7MBeamsizeInArcsecs(d);
                    } else if (model.equals(beamsizeTPModel)) {
                        double d = beamsizeTPModel.getVUP().getContentInUnits(Angle.UNIT_ARCSEC);
                        sensitivityTPModel.setBeamsize((Angle)beamsizeTPModel.getVUP());
                        sensitivityCalculatorEngine.setTPBeamsizeInArcsecs(d);
                    } else if (model.equals(bandwidthModel)) {
                        double d = bandwidthModel.getVUP().getContentInUnits(UserFrequencyData.UNIT_GHZ);
                        sensitivityCalculatorEngine.setBandwidth(d);
                    }
                }
            }
        };
    }

    private void refreshAtmData() {
        SensitivityCalculatorEngine sensitivityCalculatorEngine = this.getSC();
        if (sensitivityCalculatorEngine != null) {
            double d = obsFrequencyModel.getVUP().getContentInUnits(Frequency.UNIT_GHZ);
            sensitivityCalculatorEngine.setObservingFrequencyInGHZ(d);
            Double d2 = sensitivityCalculatorEngine.getTskyEl();
            if (null != d2) {
                if (null != sensitivityCalculatorEngine.getTsysInKelvin()) {
                    double d3 = sensitivityCalculatorEngine.getTsysInKelvin();
                    double d4 = sensitivityCalculatorEngine.getTrx();
                    String string = String.format("%.3f K", d3);
                    String string2 = sensitivityCalculatorEngine.gettrueWaterVapourColumnDensity();
                    this.publish(SensitivityCalculatorEditor.waterVapourChooserFID, string2);
                    this.publish(SensitivityCalculatorEditor.waterVapourFeedbackFID, string2);
                    this.publish(SensitivityCalculatorEditor.tsysFID, string);
                    String string3 = String.format("%.0f K, %.3f, %.3f K", d4, sensitivityCalculatorEngine.getAtmData().getTau(), d2);
                    this.publish(SensitivityCalculatorEditor.ttauFID, string3.toString());
                } else {
                    String string = "Target is not visible";
                    this.publish(SensitivityCalculatorEditor.waterVapourChooserFID, string);
                    this.publish(SensitivityCalculatorEditor.waterVapourFeedbackFID, string);
                    this.publish(SensitivityCalculatorEditor.tsysFID, string);
                    this.publish(SensitivityCalculatorEditor.ttauFID, string);
                }
            } else {
                String string = "Obs Frequency out of Range";
                this.publish(SensitivityCalculatorEditor.waterVapourChooserFID, string);
                this.publish(SensitivityCalculatorEditor.waterVapourFeedbackFID, string);
                this.publish(SensitivityCalculatorEditor.tsysFID, string);
                this.publish(SensitivityCalculatorEditor.ttauFID, string);
            }
        }
    }

    public void setTimeDisplayOption(SensitivityCalculatorEditor.TimeDisplayOption timeDisplayOption) {
        this.timeDisplayOption = timeDisplayOption;
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        SensitivityCalculatorEngine sensitivityCalculatorEngine = this.getSC();
        if (sensitivityCalculatorEngine != null) {
            Frequency frequency = Frequency.createFrequencyGHZ(sensitivityCalculatorEngine.getObservingFrequencyInGHZ());
            obsFrequencyModel.setDocument((Object)frequency);
            UserFrequency userFrequency = UserFrequency.createUserFrequency();
            userFrequency.setContent(sensitivityCalculatorEngine.getBandwidth());
            userFrequency.setObservingFrequency(frequency);
            userFrequency.setUnit(UserFrequency.UNIT_GHZ);
            bandwidthModel.setDocument(userFrequency);
            beamsize12mModel.setDocument(this.createBeamsizeAngle(sensitivityCalculatorEngine.get12MBeamsizeInArcsecs(), frequency));
            beamsize7mModel.setDocument(this.createBeamsizeAngle(sensitivityCalculatorEngine.get7MBeamsizeInArcsecs(), frequency));
            beamsizeTPModel.setDocument(this.createBeamsizeAngle(sensitivityCalculatorEngine.getTPBeamsizeInArcsecs(), frequency));
            beamsizeTPModel.setNumberFormat(new DecimalFormat("0.0"));
            this.createNewSensitivityDocument(sensitivity12mModel, frequency, sensitivityCalculatorEngine.get12MBeamsizeInArcsecs(), sensitivityCalculatorEngine.get12MSensitivityInJ(), Antenna.ANTENNA_12M);
            this.createNewSensitivityDocument(sensitivity7mModel, frequency, sensitivityCalculatorEngine.get7MBeamsizeInArcsecs(), sensitivityCalculatorEngine.get7MSensitivityInJ(), Antenna.ANTENNA_7M);
            this.createNewSensitivityDocument(sensitivityTPModel, frequency, sensitivityCalculatorEngine.getTPBeamsizeInArcsecs(), sensitivityCalculatorEngine.getTPSensitivityInJ(), Antenna.ANTENNA_12M);
            this.intTime12mModel.setDocument(sensitivityCalculatorEngine.get12MIntegrationTimeInSecs());
            this.intTime7mModel.setDocument(sensitivityCalculatorEngine.get7MIntegrationTimeInSecs());
            this.intTimeTPModel.setDocument(sensitivityCalculatorEngine.getTPIntegrationTimeInSecs());
        }
        this.publish();
    }

    private UserAngle createBeamsizeAngle(double d, Frequency frequency) {
        UserAngle userAngle = UserAngle.createUserAngle(d, UserAngle.UNIT_ARCSEC);
        userAngle.setUserUnitList(selectableUnitsForResolution);
        userAngle.setObservingFrequency(frequency);
        userAngle.convertToDefaultUnit();
        return userAngle;
    }

    private UserSensitivity createUserSensitivity(double d, double d2, Frequency frequency, Antenna antenna, String string) {
        UserSensitivity userSensitivity = UserSensitivity.createUserSensitivity(d, UserSensitivity.UNIT_JY);
        userSensitivity.setBeamsize((Angle)((Object)UserAngle.createUserAngle(d2, UserAngle.UNIT_ARCSEC, frequency, antenna)));
        userSensitivity.setObservingFrequency(frequency);
        userSensitivity.convertToUserUnit(string);
        return userSensitivity;
    }

    @Override
    public void publish() {
        if (this.document != null) {
            SensitivityCalculatorEngine sensitivityCalculatorEngine = this.getSC();
            Latitude latitude = Latitude.createLatitude();
            latitude.setContentAndUnit(sensitivityCalculatorEngine.getRaDec(), Latitude.UNIT_DEG);
            this.publish(SensitivityCalculatorEditor.decFID, (Object)latitude);
            this.publish(SensitivityCalculatorEditor.polarizationFID, sensitivityCalculatorEngine.getPolarization());
            this.publish(SensitivityCalculatorEditor.waterVapourChoiceTypeFID, sensitivityCalculatorEngine.getWaterVapourChoiceType());
            this.refreshAtmData();
            this.publish(SensitivityCalculatorEditor.numberAntennasBFID, sensitivityCalculatorEngine.getNum12MAntennas());
            this.publish(SensitivityCalculatorEditor.numberAntennasAFID, sensitivityCalculatorEngine.getNum7MAntennas());
            this.publish(SensitivityCalculatorEditor.numberAntennasSFID, sensitivityCalculatorEngine.getNumTPAntennas());
        }
        this.publishSubmodels();
    }

    private String invalidFrequencyErrorMessage(double d) {
        String string = "Frequency " + d + " GHZ is <strong>outside</strong> bands supported by ALMA.";
        return string;
    }

    private String sourceNeverVisibleErrorMessage(double d) {
        String string = null;
        string = "Source at declination " + d + " degrees is not visible to ALMA.";
        return string;
    }

    void calcIntegrationTime() {
        SensitivityCalculatorEngine sensitivityCalculatorEngine = this.getSC();
        String string = null;
        this.refreshSCValues();
        BasicReceiverBand basicReceiverBand = sensitivityCalculatorEngine.getReceiverBand();
        try {
            UserSensitivity userSensitivity;
            Frequency frequency = Frequency.createFrequencyGHZ(sensitivityCalculatorEngine.getObservingFrequencyInGHZ());
            frequency.convertToDefaultUnit();
            boolean bl = false;
            boolean bl2 = false;
            if (sensitivity12mModel != null) {
                userSensitivity = (UserSensitivity)sensitivity12mModel.getDocument();
                boolean bl3 = bl = !userSensitivity.inTemperatureUnit() || !beamsize12mModel.getVUP().isZero();
            }
            if (sensitivity7mModel != null) {
                userSensitivity = (UserSensitivity)sensitivity7mModel.getDocument();
                bl2 = !userSensitivity.inTemperatureUnit() || !beamsize7mModel.getVUP().isZero();
            }
            sensitivityCalculatorEngine.calcIntegration();
            if (bl) {
                this.intTime12mModel.setDocument(sensitivityCalculatorEngine.get12MIntegrationTimeInSecs());
                this.intTime12mModel.publish();
                this.createNewSensitivityDocument(sensitivity12mModel, frequency, sensitivityCalculatorEngine.get12MBeamsizeInArcsecs(), sensitivityCalculatorEngine.get12MSensitivityInJ(), Antenna.ANTENNA_12M);
            } else {
                sensitivityCalculatorEngine.set12MSensitivityInJ(0.0);
            }
            if (bl2) {
                this.intTime7mModel.setDocument(sensitivityCalculatorEngine.get7MIntegrationTimeInSecs());
                this.intTime7mModel.publish();
                this.createNewSensitivityDocument(sensitivity7mModel, frequency, sensitivityCalculatorEngine.get7MBeamsizeInArcsecs(), sensitivityCalculatorEngine.get7MSensitivityInJ(), Antenna.ANTENNA_7M);
            } else {
                sensitivityCalculatorEngine.set12MSensitivityInJ(0.0);
            }
            this.intTimeTPModel.setDocument(sensitivityCalculatorEngine.getTPIntegrationTimeInSecs());
            this.intTimeTPModel.publish();
            this.createNewSensitivityDocument(sensitivityTPModel, frequency, sensitivityCalculatorEngine.getTPBeamsizeInArcsecs(), sensitivityCalculatorEngine.getTPSensitivityInJ(), Antenna.ANTENNA_12M);
            obsFrequencyModel.setDocument((Object)frequency);
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            string = this.invalidFrequencyErrorMessage(sensitivityCalculatorEngine.getObservingFrequencyInGHZ());
        }
        catch (SourceNeverVisibleException sourceNeverVisibleException) {
            string = this.sourceNeverVisibleErrorMessage(sensitivityCalculatorEngine.getRaDec());
        }
        catch (BeamsizeNotSpecifiedException beamsizeNotSpecifiedException) {
            string = beamsizeNotSpecifiedException.getMessage();
        }
        this.publishErrorMessage(string);
        sensitivityCalculatorEngine.setReceiverBand(basicReceiverBand);
        this.publish(SensitivityCalculatorEditor.observingBandFID, basicReceiverBand.getName());
    }

    private void publishErrorMessage(String string) {
        this.publish(SensitivityCalculatorEditor.errorMessageFID, string);
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        int n;
        String string;
        String string2 = object.toString();
        SensitivityCalculatorEngine sensitivityCalculatorEngine = this.getSC();
        if (fieldID.equals(SensitivityCalculatorEditor.polarizationFID)) {
            String string3 = (String)object;
            Polarization polarization = Polarization.getPolarization((String)string3);
            sensitivityCalculatorEngine.setPolarization(polarization);
            return polarization;
        }
        if (fieldID.equals(SensitivityCalculatorEditor.observingBandFID)) {
            string = object.toString();
            sensitivityCalculatorEngine.setReceiverBand(BasicReceiverBand.getReceiverBand((String)string));
            if (sensitivityCalculatorEngine.isWaterVapourAutoChoice()) {
                sensitivityCalculatorEngine.setWaterVapourColumnDensity(null);
            }
            this.refreshAtmData();
        }
        if (fieldID.equals(SensitivityCalculatorEditor.waterVapourChoiceTypeFID)) {
            string = object.toString();
            sensitivityCalculatorEngine.setWaterVapourChoiceType(string);
            if (sensitivityCalculatorEngine.isWaterVapourAutoChoice()) {
                sensitivityCalculatorEngine.setWaterVapourColumnDensity(null);
            }
            this.refreshAtmData();
        }
        if (fieldID.equals(SensitivityCalculatorEditor.waterVapourChooserFID)) {
            string = object.toString();
            sensitivityCalculatorEngine.setWaterVapourColumnDensity(string);
            this.refreshAtmData();
        }
        if (fieldID.equals(SensitivityCalculatorEditor.decFID)) {
            try {
                double d = Convert.DDMMSSToDeg(string2);
                sensitivityCalculatorEngine.setRaDec(d);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            catch (InvalidCoordException invalidCoordException) {
                invalidCoordException.printStackTrace();
            }
        }
        if (fieldID.equals(SensitivityCalculatorEditor.numberAntennasBFID)) {
            String string4 = object.toString();
            n = Integer.parseInt(string4);
            sensitivityCalculatorEngine.setNum12MAntennas(n);
        }
        if (fieldID.equals(SensitivityCalculatorEditor.numberAntennasAFID)) {
            String string5 = object.toString();
            n = Integer.parseInt(string5);
            sensitivityCalculatorEngine.setNum7MAntennas(n);
        }
        if (fieldID.equals(SensitivityCalculatorEditor.numberAntennasSFID)) {
            String string6 = object.toString();
            n = Integer.parseInt(string6);
            sensitivityCalculatorEngine.setNumTPAntennas(n);
        }
        if (fieldID.equals(SensitivityCalculatorEditor.calculateExpTimeFID)) {
            this.refreshAtmData();
        }
        if (fieldID.equals(fieldsize12mFID)) {
            double d = Double.parseDouble(string2);
            sensitivityCalculatorEngine.set12MBeamsizeInArcsecs(d);
            if (beamsize12mModel.getVUP().getContent() != d) {
                beamsize12mModel.getVUP().setContent(d);
                beamsize12mModel.publish();
            }
        }
        if (fieldID.equals(fieldsize7mFID)) {
            double d = Double.parseDouble(string2);
            if (beamsize7mModel.getVUP().getContent() != d) {
                beamsize7mModel.getVUP().setContent(d);
                beamsize7mModel.publish();
            }
        }
        return string2;
    }

    void calcSensitivity() {
        String string = null;
        SensitivityCalculatorEngine sensitivityCalculatorEngine = this.getSC();
        BasicReceiverBand basicReceiverBand = sensitivityCalculatorEngine.getReceiverBand();
        try {
            try {
                Object object;
                this.refreshSCValues();
                boolean bl = false;
                boolean bl2 = false;
                if (sensitivity12mModel != null) {
                    object = (UserSensitivity)sensitivity12mModel.getDocument();
                    boolean bl3 = bl = !object.inTemperatureUnit() || !beamsize12mModel.getVUP().isZero();
                }
                if (sensitivity7mModel != null) {
                    object = (UserSensitivity)sensitivity7mModel.getDocument();
                    bl2 = !object.inTemperatureUnit() || !beamsize7mModel.getVUP().isZero();
                }
                sensitivityCalculatorEngine.calcSensitivity();
                object = Frequency.createFrequencyGHZ(sensitivityCalculatorEngine.getObservingFrequencyInGHZ());
                object.convertToDefaultUnit();
                if (bl) {
                    this.createNewSensitivityDocument(sensitivity12mModel, (Frequency)((Object)object), sensitivityCalculatorEngine.get12MBeamsizeInArcsecs(), sensitivityCalculatorEngine.get12MSensitivityInJ(), Antenna.ANTENNA_12M);
                } else {
                    this.createNewSensitivityDocument(sensitivity12mModel, (Frequency)((Object)object), sensitivityCalculatorEngine.get12MBeamsizeInArcsecs(), sensitivityCalculatorEngine.get12MSensitivityInJ(), Antenna.ANTENNA_12M);
                }
                if (bl2) {
                    this.createNewSensitivityDocument(sensitivity7mModel, (Frequency)((Object)object), sensitivityCalculatorEngine.get7MBeamsizeInArcsecs(), sensitivityCalculatorEngine.get7MSensitivityInJ(), Antenna.ANTENNA_7M);
                } else {
                    sensitivityCalculatorEngine.set7MSensitivityInJ(0.0);
                }
                this.createNewSensitivityDocument(sensitivityTPModel, (Frequency)((Object)object), sensitivityCalculatorEngine.getTPBeamsizeInArcsecs(), sensitivityCalculatorEngine.getTPSensitivityInJ(), Antenna.ANTENNA_12M);
                obsFrequencyModel.setDocument(object);
            }
            catch (BeamsizeNotSpecifiedException beamsizeNotSpecifiedException) {
                string = beamsizeNotSpecifiedException.getMessage();
            }
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            string = this.invalidFrequencyErrorMessage(sensitivityCalculatorEngine.getObservingFrequencyInGHZ());
            return;
        }
        catch (SourceNeverVisibleException sourceNeverVisibleException) {
            string = this.sourceNeverVisibleErrorMessage(sensitivityCalculatorEngine.getRaDec());
            return;
        }
        this.publishErrorMessage(string);
        sensitivityCalculatorEngine.setReceiverBand(basicReceiverBand);
        this.publish(SensitivityCalculatorEditor.observingBandFID, basicReceiverBand.getName());
    }

    private void createNewSensitivityDocument(SensitivityFormModel sensitivityFormModel, Frequency frequency, double d, double d2, Antenna antenna) {
        if (sensitivityFormModel != null) {
            UserSensitivity userSensitivity;
            String string = UserSensitivity.UNIT_JY;
            if (sensitivityFormModel.getDocument() != null) {
                userSensitivity = (UserSensitivity)sensitivityFormModel.getDocument();
                string = userSensitivity.getUserUnit();
            }
            userSensitivity = this.createUserSensitivity(d2, d, frequency, antenna, string);
            userSensitivity.convertToUserUnit(string);
            sensitivityFormModel.setDocument(userSensitivity);
            sensitivityFormModel.publish();
        }
    }

    class IntegrationTime
    extends Time {
        public static final double COMPARISON_TOLERANCE = 1.0E-12;

        public IntegrationTime(TimeT timeT) {
            super(timeT);
        }

        @Override
        public String getFriendlyUnit() {
            if (this.isZero(1.0E-12)) {
                return this.getUnit();
            }
            Object[] objectArray = this.unitMap().getUnitsSorted();
            String string = null;
            for (int i = objectArray.length - 1; i >= 0; --i) {
                string = (String)objectArray[i];
                if (!(this.getContentInUnits(string) > 1.0)) continue;
                return string;
            }
            return string;
        }

        @Override
        public IntegrationTime convertToFriendlyUnit() {
            if (this.isZero(1.0E-12)) {
                return this;
            }
            this.convertToUnit(this.getFriendlyUnit());
            return this;
        }
    }

    class AscSpecificSensitivityFeedbackCalculator
    implements SensitivityFeedbackCalculatorInterface {
        AscSpecificSensitivityFeedbackCalculator() {
        }

        private String stringifyArray(String[] stringArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(stringArray[i]);
            }
            return stringBuilder.toString();
        }

        @Override
        public ValueUnitPair<?> getSensitivityFeedback(UserSensitivity userSensitivity) {
            Object object = null;
            if (userSensitivity.inFluxUnit()) {
                object = Temperature.createTemperature((double)userSensitivity.getContentInUnits(UserSensitivity.USERUNIT_K), (String)UserSensitivity.USERUNIT_K);
                if (userSensitivity.getBeamsize().getContent() <= 0.0) {
                    object.setContent(Double.POSITIVE_INFINITY);
                }
            } else {
                object = UserSensitivity.createUserSensitivity(userSensitivity.getContentInUnits(UserSensitivity.UNIT_JY), UserSensitivity.UNIT_JY);
                if (userSensitivity.getBeamsize().getContent() == 0.0) {
                    object.setContent(Double.POSITIVE_INFINITY);
                }
            }
            return object;
        }
    }

    private class TimeModel
    extends ValueUnitPairModel {
        private String unitRequested;

        private TimeModel(Time time) {
            super((ValueUnitPair<?>)time, new FieldID());
        }

        private TimeModel(Time time, FieldID fieldID, FieldID fieldID2) {
            super((ValueUnitPair<?>)time, fieldID, fieldID2);
        }

        public void setDocument(double d) {
            TimeT timeT = new TimeT();
            timeT.setContent(d);
            timeT.setUnit(Time.UNIT_S);
            this.document = new IntegrationTime(timeT);
            this.publish();
        }

        @Override
        public void publish() {
            if (this.document != null) {
                String string;
                IntegrationTime integrationTime = (IntegrationTime)this.getDocument();
                switch (SensitivityCalculatorModel.this.timeDisplayOption) {
                    case AUTOMATIC: {
                        string = integrationTime.getFriendlyUnit();
                        UnitMap unitMap = integrationTime.unitMap();
                        if (!((Double)unitMap.get((Object)string) < (Double)unitMap.get((Object)Time.UNIT_NS))) break;
                        string = Time.UNIT_NS;
                        break;
                    }
                    case CURRENT: {
                        string = this.unitRequested;
                        break;
                    }
                    case TIME_HOUR: 
                    case TIME_MIN: 
                    case TIME_SEC: 
                    case TIME_DAY: {
                        string = SensitivityCalculatorModel.this.timeDisplayOption.getUnit();
                        break;
                    }
                    default: {
                        string = integrationTime.defaultUnit();
                    }
                }
                if (!integrationTime.getUnit().equals(string)) {
                    integrationTime.convertToUnit(string);
                }
                this.unitRequested = string;
            }
            super.publish();
        }

        @Override
        public Object update(Editor editor, FieldID fieldID, Object object) {
            if (fieldID.equals(this.getUnitFID())) {
                this.unitRequested = (String)object;
            }
            return super.update(editor, fieldID, object);
        }
    }
}

