/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserAngle;
import java.io.Serializable;
import lombok.NonNull;

public class DeclinationData
implements Comparable<DeclinationData>,
Serializable {
    private Angle dec = null;
    private Angle resolution = null;
    private Angle LAS = null;
    private UserAngle minorAxis = null;
    private UserAngle majorAxis = null;

    public DeclinationData(double d, double d2, double d3, Double d4, Double d5) {
        this.dec = UserAngle.createUserAngle(d, Angle.UNIT_DEG);
        this.resolution = UserAngle.createUserAngle(d2, Angle.UNIT_ARCSEC);
        this.LAS = UserAngle.createUserAngle(d3, Angle.UNIT_ARCSEC);
        this.minorAxis = UserAngle.createUserAngle(d4, Angle.UNIT_ARCSEC);
        this.majorAxis = UserAngle.createUserAngle(d5, Angle.UNIT_ARCSEC);
    }

    public Angle getScaledMinorAxis(@NonNull Frequency frequency) {
        if (frequency == null) {
            throw new NullPointerException("rfSky is marked non-null but is null");
        }
        return (Angle)this.minorAxis.multiply(100.0 / frequency.getContentInGHz());
    }

    public Angle getScaledMajorAxis(@NonNull Frequency frequency) {
        if (frequency == null) {
            throw new NullPointerException("rfSky is marked non-null but is null");
        }
        return (Angle)this.majorAxis.multiply(100.0 / frequency.getContentInGHz());
    }

    @Override
    public int compareTo(DeclinationData declinationData) {
        if (this.getDec().isGreaterThan((AbstractDoubleWithUnit)declinationData.getDec())) {
            return 1;
        }
        if (this.getDec().isLessThan((AbstractDoubleWithUnit)declinationData.getDec())) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "DeclinationData(dec=" + this.getDec() + ", resolution=" + this.getResolution() + ", LAS=" + this.getLAS() + ", minorAxis=" + this.getMinorAxis() + ", majorAxis=" + this.getMajorAxis() + ")";
    }

    public Angle getDec() {
        return this.dec;
    }

    public Angle getResolution() {
        return this.resolution;
    }

    public Angle getLAS() {
        return this.LAS;
    }

    public UserAngle getMinorAxis() {
        return this.minorAxis;
    }

    public UserAngle getMajorAxis() {
        return this.majorAxis;
    }
}

