/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.services.experts.Line;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.util.MinimumBoundingRectangle;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class MinBoundingBoxExpert {
    private MinBoundingBoxExpert() {
    }

    public static Rectangle getBoundingRectangle(@NonNull TargetParameters targetParameters) {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        TargetParameters targetParameters2 = TargetParameters.getPointingSourceInICRS(targetParameters);
        Rectangle rectangle = MinBoundingBoxExpert.getBoundingRectangle(targetParameters2.getFieldCenterCoordinates(), targetParameters2.getPointingPattern().getPhaseCenterCoordinates());
        rectangle.setTargetParameters(targetParameters2);
        return rectangle;
    }

    private static Rectangle getBoundingRectangle(@NonNull SkyCoordinates skyCoordinates, @NonNull SkyCoordinates[] skyCoordinatesArray) throws IllegalArgumentException {
        if (skyCoordinates == null) {
            throw new NullPointerException("fieldCentre is marked non-null but is null");
        }
        if (skyCoordinatesArray == null) {
            throw new NullPointerException("phaseCentreCoords is marked non-null but is null");
        }
        ArrayList<SkyCoordinates> arrayList = new ArrayList<SkyCoordinates>();
        Rectangle rectangle = Rectangle.createRectangle();
        try {
            Log.logger(SchedBlockExpert.class).fine(String.format("Rectangle origin: RA %s Dec %s ", skyCoordinates.getLongitude().toHHMMSS(), skyCoordinates.getLatitude().toDDMMSS()));
        }
        catch (InvalidCoordException | OutOfRangeException exception) {
            // empty catch block
        }
        for (SkyCoordinates object : skyCoordinatesArray) {
            SkyCoordinates skyCoordinates2 = object.isOffsetCoordinates() ? object.deepCopy() : object.getOffsetCoordinates(skyCoordinates);
            boolean bl = false;
            for (SkyCoordinates skyCoordinates3 : arrayList) {
                if (!skyCoordinates3.getLongitude().isEqual((AbstractDoubleWithUnit)skyCoordinates2.getLongitude()) || !skyCoordinates3.getLatitude().isEqual((AbstractDoubleWithUnit)skyCoordinates2.getLatitude())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(skyCoordinates2);
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("Illegal argument: offsetSkyCoords.size() (" + arrayList.size() + ") did not pass the test: offsetSkyCoords.size() == 0");
        }
        Line line = MinBoundingBoxExpert.determineMaximumSeparationBetweenPointings(arrayList);
        assert (line != null);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            MinimumBoundingRectangle minimumBoundingRectangle = new MinimumBoundingRectangle();
            MinimumBoundingRectangle.BoundedRectangle boundedRectangle = minimumBoundingRectangle.determineMinimumBoundRectangleForCoordinates(arrayList);
            assert (boundedRectangle != null);
            Log.logger(SchedBlockExpert.class).fine("boundedRectangle (without 7m beam width included) : " + boundedRectangle);
            rectangle.setLong(Angle.createAngle((double)boundedRectangle.getSide(MinimumBoundingRectangle.BoundedRectangle.SideType.LONGEST).getSideLength(), (String)Angle.UNIT_ARCSEC));
            rectangle.setShort(Angle.createAngle((double)boundedRectangle.getSide(MinimumBoundingRectangle.BoundedRectangle.SideType.SHORTEST).getSideLength(), (String)Angle.UNIT_ARCSEC));
            double d = boundedRectangle.getRotationAngle();
            Log.logger(SchedBlockExpert.class).fine("Adjusted rotation angle (degs) : " + d);
            rectangle.setRotationAngle(Angle.createAngle((double)d, (String)Angle.UNIT_DEG));
            rectangle.clearTPVertices();
            stringBuilder.setLength(0);
            for (Point2D.Double double_ : boundedRectangle.getRectangle()) {
                Angle angle = Angle.createAngle((double)double_.getX(), (String)Angle.UNIT_ARCSEC);
                Angle angle2 = Angle.createAngle((double)double_.getY(), (String)Angle.UNIT_ARCSEC);
                rectangle.addTPVertex(angle, angle2);
                stringBuilder.append(angle.getContentInUnits(Angle.UNIT_ARCSEC) + "," + angle2.getContentInUnits(Angle.UNIT_ARCSEC) + ",");
            }
            try {
                rectangle.setCentre(rectangle.getTPRectangleCentralCoordinate().getAbsoluteCoordinates(skyCoordinates));
            }
            catch (Rectangle.UnableToDetermineCentralCoordinateException unableToDetermineCentralCoordinateException) {
                throw new IllegalArgumentException("Unable to determine TP rectangle central coordinate");
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            double_.setRect(rectangle.getLongitudeLength().getContentInUnits(Angle.UNIT_ARCSEC), rectangle.getLatitudeLength().getContentInUnits(Angle.UNIT_ARCSEC), boundedRectangle.getSide(MinimumBoundingRectangle.BoundedRectangle.SideType.LONGEST).getSideLength(), boundedRectangle.getSide(MinimumBoundingRectangle.BoundedRectangle.SideType.SHORTEST).getSideLength());
        }
        catch (MinimumBoundingRectangle.PointsAreAllCollinearException | MinimumBoundingRectangle.UnableToDetermineMinimumBoundingBoxException exception) {
            Log.logger(SchedBlockExpert.class).fine("Points are collinear or there are less than 3 pointings");
            if (arrayList.size() < 2) {
                rectangle.setRotationAngle(Angle.createAngle((double)0.0, (String)Angle.UNIT_DEG));
            } else {
                rectangle.setRotationAngle(Angle.createAngle((double)line.getAngleOfLine(), (String)Angle.UNIT_DEG));
            }
            if (arrayList.size() == 1) {
                rectangle.setCentre(arrayList.get(0).getAbsoluteCoordinates(skyCoordinates));
            } else {
                rectangle.setCentre(line.getRectangleCentre().getAbsoluteCoordinates(skyCoordinates));
            }
            rectangle.setLong(Angle.createAngle((double)line.getLength(), (String)Angle.UNIT_ARCSEC));
            rectangle.setShort(Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC));
        }
        if (Log.logger(SchedBlockExpert.class).fine()) {
            stringBuilder.setLength(0);
            for (SkyCoordinates skyCoordinates4 : arrayList) {
                stringBuilder.append(skyCoordinates4.getLongitude().getContentInUnits(Angle.UNIT_ARCSEC) + "," + skyCoordinates4.getLatitude().getContentInUnits(Angle.UNIT_ARCSEC) + ",");
            }
        }
        Log.logger(SchedBlockExpert.class).fine(String.format("Sky offset pointing coords (arcsec) : %s", stringBuilder.toString()));
        Log.logger(SchedBlockExpert.class).fine("Rectangle dimensions (arcsec) : Long " + rectangle.getLong().getContentInUnits(Angle.UNIT_ARCSEC) + " short " + rectangle.getShort().getContentInUnits(Angle.UNIT_ARCSEC));
        assert (rectangle != null);
        return rectangle;
    }

    private static Line determineMaximumSeparationBetweenPointings(@NonNull List<SkyCoordinates> list) throws IllegalArgumentException {
        if (list == null) {
            throw new NullPointerException("offsetSkyCoords is marked non-null but is null");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Illegal argument: offsetCoords.size (" + list.size() + ")  did not pass the test: offsetCoords.size < 1");
        }
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        if (list.size() == 1) {
            return new Line(0.0, double_, double_2);
        }
        double d = 0.0;
        boolean bl = false;
        for (SkyCoordinates skyCoordinates : list) {
            for (SkyCoordinates skyCoordinates2 : list) {
                if (skyCoordinates2 == skyCoordinates) continue;
                double d2 = skyCoordinates.getLongitude().getContentInUnits(Angle.UNIT_ARCSEC);
                double d3 = skyCoordinates.getLatitude().getContentInUnits(Angle.UNIT_ARCSEC);
                double d4 = skyCoordinates2.getLongitude().getContentInUnits(Angle.UNIT_ARCSEC);
                double d5 = skyCoordinates2.getLatitude().getContentInUnits(Angle.UNIT_ARCSEC);
                double d6 = d2 - d4;
                double d7 = d3 - d5;
                double d8 = Math.abs(Math.sqrt(d6 * d6 + d7 * d7));
                if (!bl) {
                    bl = true;
                    d = d8;
                    double_.setLocation(d2, d3);
                    double_2.setLocation(d4, d5);
                    continue;
                }
                if (!(d8 > d)) continue;
                double_.setLocation(d2, d3);
                double_2.setLocation(d4, d5);
                d = d8;
            }
        }
        Log.logger(SchedBlockExpert.class).fine("maxDistance: " + d);
        return new Line(d, double_, double_2);
    }
}

