/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.util.Range;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;

public class SingleContinuumExpert {
    private static final double DELTA = 1.0E-10;
    private final Frequency f;
    private final Velocity v;
    private final ObservingFrequency.FrequencyType ftype;

    public SingleContinuumExpert(Frequency frequency) {
        this(frequency, Velocity.createVelocity(), ObservingFrequency.FrequencyType.SKY_FREQUENCY);
    }

    public SingleContinuumExpert(Frequency frequency, Velocity velocity, ObservingFrequency.FrequencyType frequencyType) {
        this(frequency, velocity, frequencyType, CorrPolarization.DOUBLE);
    }

    public SingleContinuumExpert(Frequency frequency, CorrPolarization corrPolarization) {
        this(frequency, Velocity.createVelocity(), ObservingFrequency.FrequencyType.SKY_FREQUENCY, corrPolarization);
    }

    public SingleContinuumExpert(Frequency frequency, Velocity velocity, ObservingFrequency.FrequencyType frequencyType, CorrPolarization corrPolarization) {
        this.f = frequency;
        this.v = velocity;
        this.ftype = frequencyType;
    }

    protected Frequency getSkyFrequency() {
        if (this.ftype == ObservingFrequency.FrequencyType.SKY_FREQUENCY) {
            return this.f;
        }
        return this.v.dopplerShift(this.f);
    }

    public Frequency[] singleContinuumBasebandCenters(boolean bl) {
        Range<Frequency>[] rangeArray = this.singleContinuumBasebands(bl);
        Frequency[] frequencyArray = new Frequency[rangeArray.length];
        for (int i = 0; i < rangeArray.length; ++i) {
            frequencyArray[i] = rangeArray[i].mid();
        }
        return frequencyArray;
    }

    public Range<Frequency>[] singleContinuumBasebands(boolean bl) throws IllegalArgumentException {
        int n;
        Object object;
        VupRange[] vupRangeArray = new VupRange[4];
        Frequency frequency = this.getSkyFrequency();
        ReceiverBand receiverBand = ReceiverBand.getReceiverBand(frequency);
        Frequency[] frequencyArray = new Frequency[4];
        if (receiverBand.getType() == SpectralSpec.RECEIVERTYPE_SSB || receiverBand.getType() == SpectralSpec.RECEIVERTYPE_DSB) {
            object = new double[]{1.0E-10, 0.0, 0.0, -1.0E-10};
            for (n = 0; n < 4; ++n) {
                frequencyArray[n] = Frequency.createFrequencyGHZ((double)n * 2.0 - 3.0 + object[n]);
            }
        } else if (receiverBand.getType() == SpectralSpec.RECEIVERTYPE_TSB) {
            frequencyArray[0] = Frequency.createFrequencyGHZ(-receiverBand.getIFMax() + 1.0 + 1.0E-10);
            frequencyArray[1] = Frequency.createFrequencyGHZ(-receiverBand.getIFMax() + 3.0 - 1.0E-10);
            frequencyArray[2] = Frequency.createFrequencyGHZ(receiverBand.getIFMax() - 3.0 + 1.0E-10);
            frequencyArray[3] = Frequency.createFrequencyGHZ(receiverBand.getIFMax() - 1.0 - 1.0E-10);
        } else {
            throw new IllegalArgumentException("Unknown ReceiverType : " + receiverBand.getType());
        }
        object = (Object)Frequency.createFrequencyGHZ(1.0);
        for (n = 0; n < 4; ++n) {
            Frequency frequency2 = (Frequency)frequency.plus((AbstractDoubleWithUnit)frequencyArray[n]);
            Frequency frequency3 = (Frequency)frequency2.minus((AbstractDoubleWithUnit)object);
            Frequency frequency4 = (Frequency)frequency2.plus((AbstractDoubleWithUnit)object);
            if (bl) {
                frequency3 = this.v.reverseShift(frequency3);
                frequency4 = this.v.reverseShift(frequency4);
            }
            vupRangeArray[n] = new VupRange<Frequency>(frequency3, frequency4);
        }
        return vupRangeArray;
    }

    public static String printCentreFreq(Frequency[] frequencyArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        for (Frequency frequency : frequencyArray) {
            stringBuffer.append(frequency.toBasicString());
            stringBuffer.append(", ");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        Frequency frequency = Frequency.createFrequencyGHZ(230.0);
        Velocity velocity = Velocity.createVelocity();
        SingleContinuumExpert singleContinuumExpert = new SingleContinuumExpert(frequency, velocity, ObservingFrequency.FrequencyType.REST_FREQUENCY, CorrPolarization.DOUBLE);
        String string = frequency.toBasicString();
        String string2 = velocity.getCenterVelocity().toBasicString();
        Frequency[] frequencyArray = singleContinuumExpert.singleContinuumBasebandCenters(true);
        String string3 = SingleContinuumExpert.printCentreFreq(frequencyArray);
        System.out.println("Rest centre frequencies (frequency " + string + ", velocity " + string2 + "): " + string3);
        singleContinuumExpert = new SingleContinuumExpert(frequency, velocity, ObservingFrequency.FrequencyType.SKY_FREQUENCY, CorrPolarization.DOUBLE);
        string = frequency.toBasicString();
        string2 = velocity.getCenterVelocity().toBasicString();
        frequencyArray = singleContinuumExpert.singleContinuumBasebandCenters(false);
        string3 = SingleContinuumExpert.printCentreFreq(frequencyArray);
        System.out.println("Sky centre frequencies (frequency " + string + ", velocity " + string2 + "): " + string3);
        velocity.setCenterVelocity(Speed.createSpeed((double)3000.0, (String)Speed.UNIT_KM_S));
        singleContinuumExpert = new SingleContinuumExpert(frequency, velocity, ObservingFrequency.FrequencyType.REST_FREQUENCY, CorrPolarization.DOUBLE);
        string = frequency.toBasicString();
        string2 = velocity.getCenterVelocity().toBasicString();
        frequencyArray = singleContinuumExpert.singleContinuumBasebandCenters(true);
        string3 = SingleContinuumExpert.printCentreFreq(frequencyArray);
        System.out.println("Rest centre frequencies (frequency " + string + ", velocity " + string2 + "): " + string3);
        singleContinuumExpert = new SingleContinuumExpert(frequency, velocity, ObservingFrequency.FrequencyType.SKY_FREQUENCY, CorrPolarization.DOUBLE);
        string = frequency.toBasicString();
        string2 = velocity.getCenterVelocity().toBasicString();
        frequencyArray = singleContinuumExpert.singleContinuumBasebandCenters(false);
        string3 = SingleContinuumExpert.printCentreFreq(frequencyArray);
        System.out.println("Sky centre frequencies (frequency " + string + ", velocity " + string2 + "): " + string3);
        frequency = velocity.reverseShift(frequency);
        singleContinuumExpert = new SingleContinuumExpert(frequency, velocity, ObservingFrequency.FrequencyType.REST_FREQUENCY, CorrPolarization.DOUBLE);
        string = frequency.toBasicString();
        string2 = velocity.getCenterVelocity().toBasicString();
        frequencyArray = singleContinuumExpert.singleContinuumBasebandCenters(false);
        string3 = SingleContinuumExpert.printCentreFreq(frequencyArray);
        System.out.println("Rest centre frequencies (frequency " + string + ", velocity " + string2 + "): " + string3);
    }
}

