/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline;

import alma.obsprep.services.experts.spectralline.SpectralLine;
import java.util.Comparator;

public class SpectralLineComparators {
    public static final Comparator<SpectralLine> FREQUENCY_COMPARATOR = new Comparator<SpectralLine>(){

        @Override
        public int compare(SpectralLine spectralLine, SpectralLine spectralLine2) {
            Double d = spectralLine.getFrequencyInGHz();
            Double d2 = spectralLine2.getFrequencyInGHz();
            Double d3 = d - d2;
            if (d3 == 0.0) {
                return 0;
            }
            if (d3 < 0.0) {
                return -1;
            }
            return 1;
        }
    };
    public static final Comparator<SpectralLine> DESCRIPTION_COMPARATOR = new Comparator<SpectralLine>(){

        @Override
        public int compare(SpectralLine spectralLine, SpectralLine spectralLine2) {
            String string = spectralLine.getDescription();
            String string2 = spectralLine2.getDescription();
            return string.compareToIgnoreCase(string2);
        }
    };
    public static final Comparator<SpectralLine> TITLE_COMPARATOR = new Comparator<SpectralLine>(){

        @Override
        public int compare(SpectralLine spectralLine, SpectralLine spectralLine2) {
            String string = spectralLine.getTitle();
            String string2 = spectralLine2.getTitle();
            return string.compareToIgnoreCase(string2);
        }
    };
    public static final Comparator<SpectralLine> SPECIES_COMPARATOR = new Comparator<SpectralLine>(){

        @Override
        public int compare(SpectralLine spectralLine, SpectralLine spectralLine2) {
            String string = spectralLine.getSpecies();
            String string2 = spectralLine2.getSpecies();
            return string.compareToIgnoreCase(string2);
        }
    };
    public static final Comparator<SpectralLine> UPPER_STATE_ENERGY_COMPARATOR = new Comparator<SpectralLine>(){

        @Override
        public int compare(SpectralLine spectralLine, SpectralLine spectralLine2) {
            Double d = spectralLine.getUpperStateEnergy();
            Double d2 = spectralLine2.getUpperStateEnergy();
            Double d3 = d - d2;
            if (d3 == 0.0) {
                return 0;
            }
            if (d3 < 0.0) {
                return -1;
            }
            return 1;
        }
    };
}

