/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui.filters;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.experts.spectralline.gui.filters.MergeMatcherInterface;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BasebandMatcher
implements Matcher<SpectralLine>,
MergeMatcherInterface {
    private final List<FrequencyRange> basebandList = new ArrayList<FrequencyRange>();

    public BasebandMatcher(Frequency frequency, Velocity velocity, Frequency frequency2) {
        Frequency frequency3 = (Frequency)Frequency.createFrequencyGHZ(2.0).minus((AbstractDoubleWithUnit)frequency2);
        Frequency frequency4 = (Frequency)frequency3.multiply(2.0);
        FrequencyRange frequencyRange = FrequencyRange.centredOn(frequency, frequency4);
        frequencyRange.setMin(velocity.reverseShift((Frequency)((Object)frequencyRange.min())));
        frequencyRange.setMax(velocity.reverseShift((Frequency)((Object)frequencyRange.max())));
        this.getBasebandList().add(frequencyRange);
    }

    public boolean matches(SpectralLine spectralLine) {
        Frequency frequency = spectralLine.getFrequency();
        for (FrequencyRange frequencyRange : this.getBasebandList()) {
            if (!frequencyRange.contains(frequency)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mergeMatcher(MergeMatcherInterface mergeMatcherInterface) throws MergeMatcherInterface.CannotBeMergedException {
        mergeMatcherInterface.getFrequencyRanges().stream().forEach(frequencyRange -> this.basebandList.add((FrequencyRange)frequencyRange));
    }

    public List<FrequencyRange> getBasebandList() {
        return this.basebandList;
    }

    @Override
    public Collection<FrequencyRange> getFrequencyRanges() {
        return this.getBasebandList();
    }
}

