/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.schedblock.ACACorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ACAPhaseSwitchingConfiguration;
import alma.obsprep.bo.schedblock.ACASpectrometerCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.DGCScienceCalParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.DGCB2BReferenceSpectralSpecBuilderBase;
import alma.valuetypes.Time;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.NonNull;

public class DGCPostProcessor {
    @NonNull
    private final SchedBlock sb;

    public void postProcessDGCTargets() {
        this.configureDGCTargets(this.sb);
        this.reassignCalibratorSpectralSpecToDGCReferenceSpectralSpec(BandpassCalParameters.bandpassParametersFilter);
        CalibrationSetupParameters calibrationSetupParameters = this.sb.getSbGenerationContext().getGoal().getCalibrationSetupParameters();
        if (calibrationSetupParameters.isAmplitudeSpecificSystemDefinedCalibration()) {
            this.reassignCalibratorSpectralSpecToDGCReferenceSpectralSpec(AmplitudeCalParameters.ampCalParametersFilter);
            this.reassignAmpCalSpectralSpecToScienceSpectralSpec();
        }
        this.reassignPhaseCalCalibratorSpectralSpec();
        this.correctCalibratorConfigurations();
        this.configureInternalCycleCount();
    }

    private void configureInternalCycleCount() {
        SpectralSpec spectralSpec;
        boolean bl;
        List<Target> list = this.sb.getAllTargets(DGCScienceCalParameters.DGCScienceCalParametersFilter);
        if (list.isEmpty()) {
            return;
        }
        SBGenerationContext sBGenerationContext = this.sb.getSbGenerationContext();
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = sBGenerationContext.getSchemaToUseForSBGeneration();
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            throw new UnsupportedOperationException("We cannot handle the DGC multiple tuning scenario yet");
        }
        int n = enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_BWSW) ? 3 : ((bl = DGCB2BReferenceSpectralSpecBuilderBase.lookUpDGCB2BRefData((spectralSpec = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter).get(0).getSpectralSpec()).getReceiverBand(), spectralSpec.getLO1Frequency()).isHarmonic()) ? 5 : 3);
        list.forEach(target -> target.getFirstDGCScienceParameters().ifPresent(dGCScienceCalParameters -> dGCScienceCalParameters.setInternalCycleCount(n)));
    }

    private void reassignAmpCalSpectralSpecToScienceSpectralSpec() {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sb.getSbGenerationContext().getSchemaToUseForSBGeneration();
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            throw new UnsupportedOperationException("We cannot handle the DGC multiple tuning scenario yet");
        }
        List<Target> list = this.sb.getAllTargets(AmplitudeCalParameters.ampCalParametersFilter);
        List<Target> list2 = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter);
        if (list2.size() > 1) {
            throw new IllegalArgumentException("Expecting only a single science target for a single tuning");
        }
        Optional<Target> optional = list.stream().filter(target -> target.getSpectralSpec().getName().contains("TDM")).findFirst();
        if (optional.isEmpty()) {
            return;
        }
        optional.get().setSpectralSpec(list2.get(0).getSpectralSpec());
    }

    private void correctCalibratorConfigurations() {
        List<Target> list = this.sb.getAllTargets(DGCReferenceCalParameters.DGCReferenceCalParametersFilter);
        List<Target> list2 = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter);
        if (list2.isEmpty() || list.isEmpty()) {
            throw new WizardSBGenerationException("Unable to find any science/DGC reference targets");
        }
        Target target3 = list2.get(0);
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = target3.getSpectralSpec().getCorrelatorConfiguration();
        list.stream().forEach(target2 -> {
            SpectralSpec spectralSpec = target2.getSpectralSpec();
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration2 = spectralSpec.getCorrelatorConfiguration();
            abstractCorrelatorConfiguration2.setIntegrationDuration(abstractCorrelatorConfiguration.getIntegrationDuration().deepCopy());
            abstractCorrelatorConfiguration2.setChannelAverageDuration(abstractCorrelatorConfiguration.getChannelAverageDuration().deepCopy());
            abstractCorrelatorConfiguration2.setEnable180DegreeWalshFunction(abstractCorrelatorConfiguration.getEnable180DegreeWalshFunction());
            abstractCorrelatorConfiguration2.setAPCDataSets(abstractCorrelatorConfiguration.getAPCDataSets());
            abstractCorrelatorConfiguration2.setCAM(abstractCorrelatorConfiguration.getCAM());
            if (!spectralSpec.getReceiverBand().is90DegWalshSwitchingCapable()) {
                abstractCorrelatorConfiguration2.setEnable90DegreeWalshFunction(false);
            }
            if (target3.getSpectralSpec().isACASpectralSpec()) {
                AbstractCorrelatorConfiguration abstractCorrelatorConfiguration3 = target3.getSpectralSpec().getCorrelatorConfiguration();
                if (abstractCorrelatorConfiguration3 instanceof ACACorrelatorConfiguration) {
                    ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration = ((ACACorrelatorConfiguration)((Object)((Object)abstractCorrelatorConfiguration2))).getACAPhaseSwitchingConfiguration();
                    ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration2 = ((ACACorrelatorConfiguration)((Object)((Object)abstractCorrelatorConfiguration))).getACAPhaseSwitchingConfiguration();
                    aCAPhaseSwitchingConfiguration.setDoD180demodulation(aCAPhaseSwitchingConfiguration2.getDoD180demodulation());
                    aCAPhaseSwitchingConfiguration.setDoD180modulation(aCAPhaseSwitchingConfiguration2.getDoD180modulation());
                } else if (abstractCorrelatorConfiguration3 instanceof ACASpectrometerCorrelatorConfiguration) {
                    ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration = ((ACASpectrometerCorrelatorConfiguration)((Object)((Object)abstractCorrelatorConfiguration2))).getACAPhaseSwitchingConfiguration();
                    ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration3 = ((ACASpectrometerCorrelatorConfiguration)((Object)((Object)abstractCorrelatorConfiguration))).getACAPhaseSwitchingConfiguration();
                    aCAPhaseSwitchingConfiguration.setDoD180demodulation(aCAPhaseSwitchingConfiguration3.getDoD180demodulation());
                    aCAPhaseSwitchingConfiguration.setDoD180modulation(aCAPhaseSwitchingConfiguration3.getDoD180modulation());
                }
            } else if (target3.getSpectralSpec().isBLSpectralSpec()) {
                BLCorrelatorConfiguration bLCorrelatorConfiguration = (BLCorrelatorConfiguration)((Object)((Object)abstractCorrelatorConfiguration2));
                BLCorrelatorConfiguration bLCorrelatorConfiguration2 = (BLCorrelatorConfiguration)((Object)((Object)abstractCorrelatorConfiguration));
                bLCorrelatorConfiguration.setDumpDuration(bLCorrelatorConfiguration2.getDumpDuration().deepCopy());
            } else {
                throw new WizardSBGenerationException("Unknown correlator found");
            }
        });
        list.stream().forEach(target -> {
            Time time = SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(12.0), target);
            Stream.of(target.getDGCReferenceCalParametersList()).forEach(dGCReferenceCalParameters -> dGCReferenceCalParameters.setSubScanDuration(time.deepCopy()));
        });
        this.alignCalibratorSubscanDurations();
    }

    private void configureDGCTargets(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        @NonNull SpectralSpec spectralSpec = schedBlock.getScienceTargets().get(0).getSpectralSpec();
        @NonNull List<Target> list = schedBlock.getAllUnorderedTargets(DGCScienceCalParameters.DGCScienceCalParametersFilter.get());
        if (list.isEmpty()) {
            throw new WizardSBGenerationException("No DGC science targets have been found");
        }
        list.stream().forEach(target -> target.setSpectralSpec(spectralSpec));
        @NonNull List<Target> list2 = schedBlock.getAllUnorderedTargets(DGCReferenceCalParameters.DGCReferenceCalParametersFilter.get());
        if (list2.isEmpty()) {
            throw new WizardSBGenerationException("No DGC reference targets have been found");
        }
        FieldSource fieldSource = list.get(0).getFieldSource();
        list2.forEach(target -> {
            schedBlock.removeFieldSource(target.getFieldSource());
            target.setFieldSource(fieldSource);
        });
        fieldSource.setName("DGC");
    }

    private void reassignPhaseCalCalibratorSpectralSpec() {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sb.getSbGenerationContext().getSchemaToUseForSBGeneration();
        if (!enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC)) {
            return;
        }
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            throw new UnsupportedOperationException("We cannot handle the multiple tuning scenario yet");
        }
        List<Target> list = this.sb.getAllTargets(PhaseCalParameters.phaseCalParametersFilter);
        SpectralSpec spectralSpec = this.sb.getAllUnorderedTargets(DGCReferenceCalParameters.DGCReferenceCalParametersFilter.get()).get(0).getSpectralSpec();
        list.stream().forEach(target -> target.setSpectralSpec(spectralSpec));
    }

    private void alignCalibratorSubscanDurations() {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sb.getSbGenerationContext().getSchemaToUseForSBGeneration();
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            throw new UnsupportedOperationException("We cannot handle the multiple tuning scenario yet");
        }
        List<Target> list = this.sb.getAllTargets(PhaseCalParameters.phaseCalParametersFilter);
        list.stream().forEach(target -> Stream.of(target.getFieldSource().getReference()).forEach(reference -> reference.setSubScanDuration(target.getSpectralSpec().getAbstractCorrelatorConfiguration().getIntegrationDuration().deepCopy())));
        for (Optional optional : ImmutableList.of(BandpassCalParameters.bandpassParametersFilter, AmplitudeCalParameters.ampCalParametersFilter, PhaseCalParameters.phaseCalParametersFilter)) {
            List<Target> list2 = this.sb.getAllTargets(optional);
            list2.stream().forEach(target -> Stream.of(target.getFieldSource().getReference()).forEach(reference -> reference.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(reference.getSubScanDuration(), target))));
        }
    }

    private void reassignCalibratorSpectralSpecToDGCReferenceSpectralSpec(@NonNull Optional<Predicate<Target>> optional) {
        if (optional == null) {
            throw new NullPointerException("calibratorParametersfilter is marked non-null but is null");
        }
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sb.getSbGenerationContext().getSchemaToUseForSBGeneration();
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            throw new UnsupportedOperationException("We cannot handle the DGC multiple tuning scenario yet");
        }
        List<Target> list = this.sb.getAllTargets(optional);
        List<Target> list2 = this.sb.getAllTargets(ScienceParameters.scienceParametersFilter);
        List<Target> list3 = this.sb.getAllUnorderedTargets(DGCReferenceCalParameters.DGCReferenceCalParametersFilter.get());
        long l = list.stream().filter(target -> list2.stream().filter(target2 -> target.getSpectralSpec().equals(target2.getSpectralSpec())).findFirst().isPresent()).count();
        boolean bl = false;
        for (Target target2 : list) {
            SpectralSpec spectralSpec = target2.getSpectralSpec();
            boolean bl2 = l > 1L && !bl;
            boolean bl3 = list2.stream().map(target -> target.getSpectralSpec()).filter(spectralSpec2 -> spectralSpec.equals(spectralSpec2)).findFirst().isPresent();
            if (bl3) {
                if (!bl2) continue;
                bl = true;
            }
            SpectralSpec spectralSpec3 = list3.get(0).getSpectralSpec();
            target2.setSpectralSpec(spectralSpec3);
            ObservingParameters observingParameters = target2.getObservingParameters()[0];
            observingParameters.setName(observingParameters.getClass().getSimpleName() + "(" + spectralSpec3.getName() + ")");
            break;
        }
    }

    public DGCPostProcessor(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        this.sb = schedBlock;
    }
}

