/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.entity.xmlbinding.obsproject.types.ControlBlockTArrayRequestedType;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.ArrayRequested;
import java.util.EnumSet;
import lombok.NonNull;

public enum RequestedArray {
    ACA(ControlBlockTArrayRequestedType.ACA, Antenna.ANTENNA_7M, Array.ARRAY_7M, ArrayRequested.ACA),
    TP(ControlBlockTArrayRequestedType.TP_ARRAY, Antenna.ANTENNA_12M, Array.ARRAY_TP, ArrayRequested.TP_ARRAY),
    TWELVE_M(ControlBlockTArrayRequestedType.TWELVE_M, Antenna.ANTENNA_12M, Array.ARRAY_12M, ArrayRequested.TWELVE_M),
    SEVEN_M(ControlBlockTArrayRequestedType.SEVEN_M, Antenna.ANTENNA_7M, Array.ARRAY_7M, ArrayRequested.SEVEN_M);

    @NonNull
    private final ControlBlockTArrayRequestedType controlBlockType;
    @NonNull
    private final Antenna antenna;
    @NonNull
    private final Array array;
    @NonNull
    private ArrayRequested controlBlockArray;

    public String getType() {
        return this.controlBlockType.toString();
    }

    public boolean isInterferometeric() {
        return EnumSet.of(ACA, TWELVE_M, SEVEN_M).contains((Object)RequestedArray.valueOf(this.controlBlockType));
    }

    public boolean isTM() {
        return this.equals((Object)TWELVE_M);
    }

    public boolean isTP() {
        return this.equals((Object)TP);
    }

    public boolean isACA7M() {
        return this.equals((Object)SEVEN_M);
    }

    public static RequestedArray valueOf(@NonNull ControlBlockTArrayRequestedType controlBlockTArrayRequestedType) {
        if (controlBlockTArrayRequestedType == null) {
            throw new NullPointerException("arrayRequestedType is marked non-null but is null");
        }
        for (RequestedArray requestedArray : RequestedArray.values()) {
            if (!requestedArray.controlBlockType.equals(controlBlockTArrayRequestedType)) continue;
            return requestedArray;
        }
        throw new IllegalArgumentException("Unknown array type " + controlBlockTArrayRequestedType + " found ");
    }

    public static RequestedArray valueOf(@NonNull Array array) {
        if (array == null) {
            throw new NullPointerException("arrayRequestedType is marked non-null but is null");
        }
        ControlBlockTArrayRequestedType controlBlockTArrayRequestedType = ControlBlockTArrayRequestedType.valueOf((String)array.name);
        for (RequestedArray requestedArray : RequestedArray.values()) {
            if (!requestedArray.controlBlockType.equals(controlBlockTArrayRequestedType)) continue;
            return requestedArray;
        }
        throw new IllegalArgumentException("Unknown array type " + array + " found ");
    }

    private RequestedArray(@NonNull ControlBlockTArrayRequestedType controlBlockTArrayRequestedType, @NonNull Antenna antenna, Array array, ArrayRequested arrayRequested) {
        if (controlBlockTArrayRequestedType == null) {
            throw new NullPointerException("controlBlockType is marked non-null but is null");
        }
        if (antenna == null) {
            throw new NullPointerException("antenna is marked non-null but is null");
        }
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (arrayRequested == null) {
            throw new NullPointerException("controlBlockArray is marked non-null but is null");
        }
        this.controlBlockType = controlBlockTArrayRequestedType;
        this.antenna = antenna;
        this.array = array;
        this.controlBlockArray = arrayRequested;
    }

    @NonNull
    public Antenna getAntenna() {
        return this.antenna;
    }

    @NonNull
    public Array getArray() {
        return this.array;
    }

    @NonNull
    public ArrayRequested getControlBlockArray() {
        return this.controlBlockArray;
    }
}

