/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.services.generator.refactored.ArraySBGroupPostProcessorInterface;
import alma.valuetypes.Time;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;

public class TotalPowerScienceSBGroupPostProcessor
implements ArraySBGroupPostProcessorInterface {
    @Override
    public void postProcessSBArrayGroup(@NonNull Collection<SchedBlock> collection, ScienceGoal scienceGoal) {
        if (collection == null) {
            throw new NullPointerException("schedBlockGroup is marked non-null but is null");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Illegal argument: schedBlockGroup.size() (" + collection.size() + ") did not pass the test: schedBlockGroup.size() == 0");
        }
        if (collection.size() > 1) {
            this.setSBExecutionTime(collection);
        }
    }

    private void setSBExecutionTime(Collection<SchedBlock> collection) {
        Map<SchedBlock, Double> map = collection.stream().collect(Collectors.toMap(schedBlock -> schedBlock, this::calculateTimeOnSource));
        for (SchedBlock schedBlock2 : collection) {
            Time time = schedBlock2.getObsUnitControl().getEstimatedExecutionTime();
            time.setContentAndUnit(map.get(schedBlock2), Time.UNIT_S);
            time.convertToFriendlyUnit();
        }
    }

    private double calculateTimeOnSource(SchedBlock schedBlock) {
        double d = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter).stream().mapToDouble(target -> target.getFirstScienceParameters().get().getIntegrationTime().getSecs()).sum();
        return d * (double)schedBlock.getSchedBlockControl().getExecutionCount();
    }
}

