/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.IntegerMosaicEnforcer;
import alma.obsprep.services.generator.refactored.IntegerMosaicEnforcerInterface;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.RevisedIntegrationParameters;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import lombok.NonNull;

public class VaryingSubscanIntegerMosaicEnforcer
extends IntegerMosaicEnforcer
implements IntegerMosaicEnforcerInterface {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean enforceCompleteMosaicScansPerSBExec(@NonNull SchedBlock schedBlock, @NonNull RequestedArray requestedArray, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws UnknownEntityException, InvalidObsProgramParametersException {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("requestedArray is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        boolean bl = false;
        if (RequestedArray.TP.equals((Object)requestedArray)) {
            return false;
        }
        Array array = requestedArray.getArray();
        ArrayList<RevisedIntegrationParameters> arrayList = new ArrayList<RevisedIntegrationParameters>();
        HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>();
        SchedBlock schedBlock2 = schedBlock;
        synchronized (schedBlock2) {
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                    ScienceParameters scienceParameters;
                    Target target = orderedTarget.getTarget();
                    int n = target.getFieldSource().getFieldPattern().getNumberOfPointings();
                    if (!target.hasScienceParameters() || hashSet.contains((Object)(scienceParameters = target.getScienceParametersList()[0]))) continue;
                    if (!target.getFieldSource().getFieldPattern().isPointingPattern()) {
                        Log.logger(SchedBlockWorker.class).fine("Unable to apply integer mosaic scan algorithm: not a pointing pattern");
                        return false;
                    }
                    Time time = (Time)scienceParameters.getIntegrationTime().getTime().multiply(schedBlock.getSchedBlockControl().getExecutionCount());
                    RevisedIntegrationParameters revisedIntegrationParameters = this.adjustSubscanDurationForMosaicBasedSources(target, n, time.getContentInDefaultUnits(), enumSet, array, schedBlock, false);
                    if (revisedIntegrationParameters == null) {
                        return false;
                    }
                    if (revisedIntegrationParameters.getSubScanDuration().isLessThan((AbstractDoubleWithUnit)Time.createTimeSec(3.0)) && (revisedIntegrationParameters = this.adjustSubscanDurationForMosaicBasedSources(target, n, time.getContentInDefaultUnits(), enumSet, array, schedBlock, true)) == null) {
                        return false;
                    }
                    arrayList.add(revisedIntegrationParameters);
                    hashSet.add(scienceParameters);
                }
            }
            int n = 0;
            double d = 0.0;
            for (RevisedIntegrationParameters revisedIntegrationParameters : arrayList) {
                Log.logger(SchedBlockWorker.class).fine("revisedIntegrationParameters: " + revisedIntegrationParameters);
                ScienceParameters scienceParameters = revisedIntegrationParameters.getScienceTarget().getScienceParametersList()[0];
                assert (scienceParameters != null);
                bl = true;
                assert (revisedIntegrationParameters.getNoOfSBExecs() > 0);
                if (revisedIntegrationParameters.getNoOfSBExecs() > n) {
                    n = revisedIntegrationParameters.getNoOfSBExecs();
                    schedBlock.getSchedBlockControl().setExecutionCount(n);
                }
                scienceParameters.setSubScanDuration(revisedIntegrationParameters.getSubScanDuration());
                scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)revisedIntegrationParameters.getScienceIntegrationTime().getContentInDefaultUnits(), (String)IntTimeSource.UNIT_S));
                scienceParameters.setIntegrationTimeChangeable(false);
                d += scienceParameters.getIntegrationTime().getContentInUnits(IntTimeSource.UNIT_S);
                assert (n > 0);
                assert (d < SchedBlockWorker.getMaxTimeOnSourcePerSBExec(enumSet));
            }
        }
        return bl;
    }

    private RevisedIntegrationParameters adjustSubscanDurationForMosaicBasedSources(@NonNull Target target, int n, double d, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, @NonNull Array array, @NonNull SchedBlock schedBlock, boolean bl) {
        double d2;
        double d3;
        double d4;
        double d5;
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        RevisedIntegrationParameters.RevisedIntegrationParametersBuilder revisedIntegrationParametersBuilder = RevisedIntegrationParameters.builder();
        double d6 = 0.0;
        if (n == 0 || d == 0.0) {
            throw new IllegalArgumentException("totalOnSourceTimeForTarget and noOfPointings should be greater than zero");
        }
        if (!target.hasScienceParameters()) {
            throw new IllegalArgumentException("target should be a science target");
        }
        ScienceParameters scienceParameters = target.getScienceParametersList()[0];
        assert (scienceParameters != null);
        if (Array.ARRAY_TP.equals((Object)array)) {
            return null;
        }
        double d7 = this.getProportionOfTOSForScienceTarget(enumSet, target, schedBlock.getScienceTargets());
        double d8 = SchedBlockWorker.getMaxTimeOnSourcePerSBExec(enumSet) * d7;
        if (bl) {
            Time time = this.getActualTOSRequiredForSingleSBExec(schedBlock.getScienceTargets());
            d8 = time.getContentInUnits(Time.UNIT_S) * d7;
        }
        double d9 = d / (double)n;
        assert (d9 > 0.0);
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = target.getSpectralSpec().getCorrelatorConfiguration();
        int n2 = Array.ARRAY_7M.equals((Object)array) ? 11 : (abstractCorrelatorConfiguration.isTDM() ? 2 : 1);
        assert (n2 == 11 || n2 == 2 || n2 == 1);
        double d10 = scienceParameters.getSubScanDuration().getContentInUnits(Time.UNIT_S);
        if (CorrelatorType.BL.equals((Object)abstractCorrelatorConfiguration.getCorrelatorType())) {
            BLCorrelatorConfiguration bLCorrelatorConfiguration = (BLCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            d5 = bLCorrelatorConfiguration.getDumpDuration().getContentInUnits(Time.UNIT_S);
        } else {
            d5 = CorrelatorExpert.getInstance(CorrelatorType.ACA).calcDumpDurationInmsecs() / 1000.0;
        }
        double d11 = (double)n2 * d5;
        int n3 = (int)Math.ceil(d9 * (double)n / d8);
        if (n3 == 0) {
            return null;
        }
        if (n3 == Integer.MAX_VALUE) {
            throw new WizardSBGenerationException("The calculated required number of SB executions is too high, is the desired sensitivity too high?");
        }
        if (n3 > 5000) {
            Log.logger(SchedBlockWorker.class).info("SB execution count exceeds limits: not running algorithm");
            return null;
        }
        double d12 = (double)n * d10;
        boolean bl2 = false;
        double d13 = 0.0;
        while (!bl2) {
            d4 = d9 * (double)n / (double)n3;
            if (d4 <= 0.0) {
                throw new WizardSBGenerationException("Unable to calculate integer mosaic scan: requested TOS per SB execution is zero or less");
            }
            while (d12 > d8) {
                if ((d10 -= d11) < 1.0) {
                    throw new WizardSBGenerationException("Unable to determine integer number of mosaic scans per SB execution: too many pointings?");
                }
                d3 = SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(d10), target).getContentInUnits(Time.UNIT_S);
                d12 = (double)n * d3;
                assert (d12 > 0.0);
            }
            assert (d10 > 0.0);
            d10 = SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(d10), target).getContentInUnits(Time.UNIT_S);
            d6 = Math.ceil(d4 / d12);
            assert (d6 > 0.0);
            d13 = d12 * d6;
            assert (d13 > 0.0);
            if (d13 > d8) {
                d3 = d10;
                d2 = d12;
                double d14 = d13;
                double d15 = d6;
                boolean bl3 = false;
                do {
                    if ((d10 -= d11) < 1.0) {
                        bl3 = true;
                        break;
                    }
                    double d16 = SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(d10), target).getContentInUnits(Time.UNIT_S);
                    d12 = (double)n * d16;
                    d6 = Math.ceil(d4 / d12);
                    if (d6 < 1.0) {
                        bl3 = true;
                        break;
                    }
                    d13 = d12 * d6;
                    assert (d13 > 0.0);
                } while (d13 > d8 && !bl3);
                if (d13 > d8 || bl3) {
                    d10 = d3;
                    d12 = d2;
                    d13 = d14;
                    d6 = d15;
                    ++n3;
                    continue;
                }
                d10 = SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(d10), target).getContentInUnits(Time.UNIT_S);
                bl2 = true;
                break;
            }
            bl2 = true;
            break;
        }
        assert (d6 > 0.0 && d10 > 0.0 && n3 > 0 && d13 > 0.0);
        revisedIntegrationParametersBuilder.subScanDuration(Time.createTimeSec(d10)).noOfSBExecs(n3).scienceIntegrationTime(Time.createTimeSec(d13 - 0.1));
        d4 = (double)n3 * d13;
        d3 = d13 * (double)n3;
        d2 = AlmaPolicies.getInstance().getMinimumTimeOnSrc().getSecs();
        while (d3 > d && !((d10 -= d11) <= 0.0)) {
            Time time = SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(d10), target);
            d12 = (double)n * time.getContentInUnits(Time.UNIT_S);
            assert (d12 >= 0.0);
            d3 = d6 * d12 * (double)n3;
            if (!(d3 > d)) continue;
            assert (d12 * d6 > 0.0);
            double d17 = d12 * d6 - 0.1;
            if (d17 / (double)n < d2) break;
            revisedIntegrationParametersBuilder.scienceIntegrationTime(Time.createTimeSec(d17));
            revisedIntegrationParametersBuilder.subScanDuration(time);
            d4 = d3;
        }
        revisedIntegrationParametersBuilder.scienceTarget(target);
        RevisedIntegrationParameters revisedIntegrationParameters = revisedIntegrationParametersBuilder.build();
        Log.logger(SchedBlockWorker.class).fine("No of required SB execs : " + n3 + " On-source time per SB : " + revisedIntegrationParameters.getScienceIntegrationTime() + " Total on-source time actually required : " + d4 + " Total time initially requested : " + d + " No Of Mosaics per SB : " + d6 + " Initial time per pointing : " + d / (double)n + " Recalculated time per pointing : " + revisedIntegrationParameters.getSubScanDuration().getContentInUnits(Time.UNIT_S) * d6 * (double)n3 + " Subscan duration : " + revisedIntegrationParameters.getSubScanDuration() + " No of Pointings : " + n + " target : " + revisedIntegrationParameters.getScienceTarget().getName());
        Log.logger(SchedBlockWorker.class).fine("Ratio of requested to required time : " + d4 / d);
        return revisedIntegrationParameters;
    }
}

