/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.AtmosphericWindow;
import alma.obsprep.services.generator.refactored.intermediatetarget.AtmosphericWindowNotFoundException;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntegrationTimeResolverInterface;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.StandardCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.obsparams.ScienceGoalObservingParametersFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.AngularResolutionLimitsExpertFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.AngularResolutionLimitsExpertInterface;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreator;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import lombok.NonNull;

public class PhaseCalIntermediateTarget
extends StandardCalIntermediateTarget
implements IntegrationTimeResolverInterface {
    public static final Collection<ReceiverBand> HIGHBANDS = ImmutableList.of((Object)ReceiverBand.getReceiverBand(8), (Object)ReceiverBand.getReceiverBand(9), (Object)ReceiverBand.getReceiverBand(10));
    private static final double CHECKSOURCE_AR_THRESHOLD_ARCSEC = 0.25;

    @Override
    protected void determineAdditionalTargetsRequiredForSpectralScans(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray) {
        block8: {
            EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sbContext.getSchemaToUseForSBGeneration();
            try {
                SpectralScan.SpectralScanTunings spectralScanTunings = spectralSetupParameters.getSpectralScan().getTunings();
                if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
                    int n = 1;
                    for (ArrayList<Frequency> arrayList : spectralScanTunings.getTunings()) {
                        SpectralSetupParameters spectralSetupParameters2 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, arrayList);
                        this.sspsDerivedFromSpectralScanTuning.add(spectralSetupParameters2);
                        Integer n2 = this.getObservingGroupManager().getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, n);
                        Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n2, this.sbContext);
                        this.completeTargetConstruction(target, spectralSetupParameters2, requestedArray);
                        if (this.isCheckSourceNeeded(spectralSetupParameters2, requestedArray, this.sbContext)) {
                            this.createCheckSource(targetWithIntent, spectralSetupParameters2, requestedArray, n2, this.sbContext);
                        }
                        ++n;
                    }
                    break block8;
                }
                if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN_MULTIPLE_SB)) {
                    Integer n = this.sbContext.getSpectralScanTuningIndex();
                    assert (n != null) : "The tuning index for which we should generate an SB should be specified";
                    SpectralSetupParameters spectralSetupParameters3 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, (List<Frequency>)spectralScanTunings.getTunings().get(n));
                    this.sspsDerivedFromSpectralScanTuning.add(spectralSetupParameters3);
                    Integer n3 = this.getObservingGroupManager().getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, 1);
                    Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters3, n3, this.sbContext);
                    this.completeTargetConstruction(target, spectralSetupParameters3, requestedArray);
                    if (this.isCheckSourceNeeded(spectralSetupParameters3, requestedArray, this.sbContext)) {
                        this.createCheckSource(targetWithIntent, spectralSetupParameters3, requestedArray, n3, this.sbContext);
                    }
                    break block8;
                }
                throw new RuntimeException("Unexpected spectral scan generation mode detected " + enumSet);
            }
            catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
                Log.Logger logger = Log.logger((Object)this);
                logger.log(Level.WARNING, "Failed to add spectral scan tunings ", (Throwable)exception);
            }
        }
    }

    public PhaseCalIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGeneratorTemplate.SchedBlockType schedBlockType, SBGenerationContext sBGenerationContext) {
        this(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext);
    }

    public PhaseCalIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext) {
        super(targetWithIntent, spectralSetupParameters, requestedArray, ObsType.PHASE, observingGroupManager, n, ObservingGroupManager.ObservingGroupType.SCIENCE, enumSet, sBGenerationContext);
        boolean bl;
        boolean bl2;
        this.setTargetPriority(2);
        boolean bl3 = sBGenerationContext.getArray().equals((Object)RequestedArray.TWELVE_M);
        boolean bl4 = bl2 = sBGenerationContext.getConfiguration() != null && sBGenerationContext.getConfiguration().isLongBaselineConfiguration();
        if (bl3 && bl2) {
            this.getTargets().stream().filter(target -> targetWithIntent.getObsType().equals((Object)ObsType.PHASE)).forEach(target -> {
                for (PhaseCalParameters phaseCalParameters : target.getPhaseCalParametersList()) {
                    phaseCalParameters.setSubScanDuration(Time.createTimeSec(18.144));
                }
            });
        }
        boolean bl5 = HIGHBANDS.contains(spectralSetupParameters.getReceiverBand());
        if ((sBGenerationContext.getArray().equals((Object)RequestedArray.TWELVE_M) || sBGenerationContext.getArray().equals((Object)RequestedArray.SEVEN_M)) && !bl2 && bl5) {
            this.getTargets().stream().filter(target -> targetWithIntent.getObsType().equals((Object)ObsType.PHASE)).forEach(target -> {
                for (PhaseCalParameters phaseCalParameters : target.getPhaseCalParametersList()) {
                    phaseCalParameters.setSubScanDuration(Time.createTimeSec(60.48));
                    phaseCalParameters.setDefaultIntegrationTime(Time.createTimeSec(60.0));
                }
            });
        }
        if (sBGenerationContext.isSolar() && (sBGenerationContext.isTM1SB() || sBGenerationContext.isTM2SB())) {
            this.getTargets().stream().filter(target -> targetWithIntent.getObsType().equals((Object)ObsType.PHASE)).forEach(target -> {
                for (PhaseCalParameters phaseCalParameters : target.getPhaseCalParametersList()) {
                    phaseCalParameters.setSubScanDuration(Time.createTimeSec(60.48));
                    phaseCalParameters.setDefaultIntegrationTime(Time.createTimeSec(60.0));
                }
            });
        }
        if (bl = VLBIExpert.isPassivePhasingEnabled(sBGenerationContext.getGoal())) {
            this.getTargets().stream().filter(target -> !(targetWithIntent instanceof QuerySource) && targetWithIntent.getObsType().equals((Object)ObsType.PHASE)).forEach(target -> {
                for (PhaseCalParameters phaseCalParameters : target.getPhaseCalParametersList()) {
                    phaseCalParameters.setSubScanDuration(Time.createTimeSec(16.128));
                    phaseCalParameters.setDefaultIntegrationTime(Time.createTimeSec(4.0));
                }
                target.getFieldSource().setName("VLBI Phasor");
            });
        }
        if (!enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN) && !enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN_MULTIPLE_SB) && this.isCheckSourceNeeded(spectralSetupParameters, requestedArray, sBGenerationContext)) {
            if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
                this.createCheckSource(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, n), sBGenerationContext);
            } else if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.STANDARD)) {
                this.createCheckSource(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, 1), sBGenerationContext);
            } else {
                throw new RuntimeException("Unknown SB generation schema type detected " + enumSet);
            }
        }
    }

    private void createCheckSource(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, Integer n, SBGenerationContext sBGenerationContext) {
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_CHECKSOURCE);
        querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
        if (targetWithIntent instanceof QuerySource) {
            querySource.setQueryCenter(((QuerySource)targetWithIntent).getQueryCenter().deepCopy());
        } else if (targetWithIntent instanceof CalibrationTargetParameters) {
            querySource.setQueryCenter(((CalibrationTargetParameters)targetWithIntent).getSourceCoordinates().deepCopy());
        }
        Target target = TargetCreator.createTarget(querySource, spectralSetupParameters, n, sBGenerationContext);
        target.getFieldSource().setName("Check source");
        SpectralSpecFactory spectralSpecFactory = new SpectralSpecFactory(sBGenerationContext);
        SpectralSpec spectralSpec = spectralSpecFactory.getSpectralSpec(spectralSetupParameters, spectralSetupParameters.getSourceVelocity(), ObsType.SCIENCE);
        target.setSpectralSpec(spectralSpec);
        for (Target target2 : this.targets) {
            Object object;
            HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(target2.getIntendedObservingGroupList()));
            if (!target2.hasPhaseCalParameters() || !hashSet.contains(n)) continue;
            PhaseCalParameters phaseCalParameters = target2.getPhaseCalParametersList()[0];
            for (Object object2 : target.getCheckSourceCalParametersList()) {
                object2.setName("Check source parameters");
                object2.setDataOrigin(phaseCalParameters.getDataOrigin());
                ScienceGoalObservingParametersFactory scienceGoalObservingParametersFactory = new ScienceGoalObservingParametersFactory(sBGenerationContext.getGoal(), spectralSpec, targetWithIntent, requestedArray, sBGenerationContext);
                object2.setSubScanDuration(scienceGoalObservingParametersFactory.getAlignedSubscanDuration(60.0));
                if (HIGHBANDS.contains(spectralSetupParameters.getReceiverBand())) {
                    Time time = (Time)((Time)phaseCalParameters.getCycleTime().plus((AbstractDoubleWithUnit)Time.createTimeSec(7.0))).plus((AbstractDoubleWithUnit)phaseCalParameters.getSubScanDuration());
                    object2.setCycleTime((Time)time.multiply(2.0));
                }
                if (sBGenerationContext.getConfiguration() == null || !sBGenerationContext.getConfiguration().isLongBaselineConfiguration()) continue;
                int n2 = sBGenerationContext.getConfiguration().getNumber();
                ScienceGoal scienceGoal = sBGenerationContext.getGoal();
                boolean bl = n2 == 7 && HIGHBANDS.contains(spectralSetupParameters.getReceiverBand()) && !scienceGoal.getSpectralSetupParameters().isWalshSwitching();
                Time time = Time.createTimeSec(bl ? 36.0 : 18.0);
                Time time2 = scienceGoalObservingParametersFactory.getAlignedSubscanDuration(bl ? 36.288 : 18.144);
                object2.setSubScanDuration(time2);
                object2.setDefaultIntegrationTime(time);
            }
            if (sBGenerationContext.isTM1SB()) {
                try {
                    object = Configuration.getConfigurationsToBeScheduled(sBGenerationContext.getGoal()).getMostExtendedTM1Configuration();
                }
                catch (Configuration.UnableToDetermineConfigurationException | InvalidObsProgramParametersException exception) {
                    throw new WizardSBGenerationException("Unable to determine most extended 12-m configuration for setup: " + exception.getMessage());
                }
            } else {
                object = sBGenerationContext.getConfiguration();
            }
            int n3 = object != null && ((Configuration)object).isLongBaselineConfiguration() ? 1 : 0;
            int n4 = HIGHBANDS.contains(spectralSetupParameters.getReceiverBand()) ? 1 : 0;
            if (n3 != 0 || n4 != 0) {
                Object object2;
                object2 = target2.getFieldSource().deepCopy();
                object2.setName("Check");
                target.setFieldSource((FieldSource)object2);
                break;
            }
            target.setFieldSource(target2.getFieldSource());
            break;
        }
        this.targets.add(target);
        Object object = OrderedTarget.createOrderedTarget();
        object.setTarget(target);
        this.orderedTargets.add(object);
    }

    boolean isCheckSourceNeeded(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull RequestedArray requestedArray, @NonNull SBGenerationContext sBGenerationContext) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        if (requestedArray.isTP()) {
            return false;
        }
        if (sBGenerationContext.isVLBI()) {
            return false;
        }
        if (HIGHBANDS.contains(spectralSetupParameters.getReceiverBand())) {
            return true;
        }
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        if (SingleFieldScienceGoalModel.isNarrowBWScienceGoal(scienceGoal)) {
            return true;
        }
        if (requestedArray.isACA7M()) {
            return false;
        }
        assert (RequestedArray.TWELVE_M.equals((Object)requestedArray));
        SBGeneratorTemplate.SchedBlockType schedBlockType = sBGenerationContext.getSBType();
        assert (EnumSet.of(SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION, SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION).contains((Object)schedBlockType)) : "Should only be 12-m SBs at this point";
        boolean bl = scienceGoal.getCalibrationSetupParameters().isEnhancedAstrometry();
        if (schedBlockType.equals((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION) && bl) {
            return true;
        }
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        schedBlock.setSbGenerationContext(sBGenerationContext);
        AngularResolutionLimitsExpertInterface angularResolutionLimitsExpertInterface = AngularResolutionLimitsExpertFactory.getARLimitsExpert(schedBlockType);
        angularResolutionLimitsExpertInterface.setARLimitsInSBConstraints(scienceGoal, (Collection<Collection<SchedBlock>>)ImmutableList.of((Object)ImmutableList.of((Object)schedBlock)));
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        return schedulingConstraints.getMinAcceptableAngResolution().getArcsec() < 0.25 || schedulingConstraints.getMaxAcceptableAngResolution().getArcsec() < 0.25;
    }

    @Override
    public Time getTPFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("TP FDM calibration times are as yet unknown");
    }

    @Override
    public Time get7mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = null;
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        int n = spectralSetupParameters.getReceiverBand().getNumber();
        if (n == 1 || n == 3 || n == 4 || n == 6) {
            time = Time.createTime((double)1.0, (String)Time.UNIT_MIN);
        } else if (n == 9 || n == 8) {
            time = Time.createTime((double)2.0, (String)Time.UNIT_MIN);
        } else if (n == 5) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ175));
                if (atmosphericWindow.equals((Object)AtmosphericWindow.GHZ175)) {
                    time = Time.createTime((double)2.0, (String)Time.UNIT_MIN);
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)1.0, (String)Time.UNIT_MIN);
            }
        } else if (n == 7) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ321, AtmosphericWindow.GHZ365));
                switch (atmosphericWindow) {
                    case GHZ321: {
                        time = Time.createTime((double)2.0, (String)Time.UNIT_MIN);
                        break;
                    }
                    case GHZ365: {
                        time = Time.createTime((double)2.0, (String)Time.UNIT_MIN);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown atmospheric window detected " + atmosphericWindow);
                    }
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)1.0, (String)Time.UNIT_MIN);
            }
        }
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for 7m FDM and receiver band " + n);
        }
        return time;
    }

    @Override
    public Time getTPTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("TP calibration times are as yet undetermined");
    }

    @Override
    public Time get7mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        return this.get7mFDMIntegrationTimes(spectralSetupParameters);
    }
}

