/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.valuetypes.Time;

public class TPRasterData {
    private Time t_osmax = Time.createTime();
    private Time t_rect = Time.createTime();
    private boolean isSolarTPSB = false;
    private Time t_expectedTotalITOS = Time.createTime();
    private int n_rowcount = 1;

    private TPRasterData(Builder builder) {
        this.t_osmax = builder.t_osmax;
        this.t_rect = builder.t_rect;
        this.isSolarTPSB = builder.isSolarTPSB;
        this.t_expectedTotalITOS = builder.t_expectedTotalITOS;
        this.n_rowcount = builder.n_rowcount;
    }

    public void setT_osmax(Time time) {
        this.t_osmax = time;
    }

    public void setT_rect(Time time) {
        this.t_rect = time;
    }

    public void setSolarTPSB(boolean bl) {
        this.isSolarTPSB = bl;
    }

    public boolean isSolarTPSB() {
        return this.isSolarTPSB;
    }

    public Time getT_osmax() {
        return this.t_osmax;
    }

    public Time getT_rect() {
        return this.t_rect;
    }

    public Time getT_expectedTotalITOS() {
        return this.t_expectedTotalITOS;
    }

    public void setT_expectedTotalITOS(Time time) {
        this.t_expectedTotalITOS = time;
    }

    public int getN_rows() {
        return this.n_rowcount;
    }

    public void setN_rows(int n) {
        this.n_rowcount = n;
    }

    public TPRasterData deepCopy() {
        Builder builder = new Builder();
        builder.n_rowcount(this.getN_rows()).isSolarTPSB(this.isSolarTPSB()).t_osmax(this.getT_osmax().deepCopy()).t_rect(this.getT_rect().deepCopy()).t_expectedTotalITOS(this.getT_expectedTotalITOS().deepCopy());
        return builder.build();
    }

    public static class Builder {
        private Time t_osmax;
        private Time t_rect;
        private boolean isSolarTPSB;
        public Time t_expectedTotalITOS;
        private int n_rowcount;

        public Builder t_expectedTotalITOS(Time time) {
            this.t_expectedTotalITOS = time;
            return this;
        }

        public Builder isSolarTPSB(boolean bl) {
            this.isSolarTPSB = bl;
            return this;
        }

        public Builder t_osmax(Time time) {
            this.t_osmax = time;
            return this;
        }

        public Builder t_rect(Time time) {
            this.t_rect = time;
            return this;
        }

        public TPRasterData build() {
            return new TPRasterData(this);
        }

        public Builder n_rowcount(int n) {
            this.n_rowcount = n;
            return this;
        }
    }
}

