/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.InterferometrySchedBlockGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

public class ACASBGenerator
extends InterferometrySchedBlockGenerator {
    public ACASBGenerator() {
        super(RequestedArray.SEVEN_M);
        this.sbContext.setArray(this.array).setSBType(SBGeneratorTemplate.SchedBlockType.ACA7M);
    }

    @Override
    protected void addDGCCalibrators(@NonNull ScienceGoal scienceGoal, @NonNull Integer n, @NonNull List<IntermediateTarget> list, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (n == null) {
            throw new NullPointerException("tuningIndex is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("intermediateTargets is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        if (scienceGoal.getCalibrationSetupParameters().getIsDGCOverride()) {
            return;
        }
        Set<DGCExpert.DGCTypeEnum> set = DGCExpert.dgcObservingStrategiesRequired(scienceGoal, true);
        if (set.containsAll(DGCExpert.allDGCStrategies) || set.equals(EnumSet.of(DGCExpert.DGCTypeEnum.DGCBandwidthSwitching))) {
            enumSet.add(SBGeneratorTemplate.SBGenerationSchema.DGC_BWSW);
            super.addDGCCalibrators(scienceGoal, n, list, enumSet);
        } else if (set.contains((Object)DGCExpert.DGCTypeEnum.DGCBandToBand)) {
            enumSet.remove((Object)SBGeneratorTemplate.SBGenerationSchema.DGC);
        }
    }

    @Override
    public double getAntennaMultiplier(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        return Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACA7M, scienceGoal);
    }

    @Override
    public Collection<Collection<SchedBlock>> getSchedBlocks(ScienceGoal scienceGoal) {
        Collection<Collection<SchedBlock>> collection = super.getSchedBlocks(scienceGoal);
        for (Collection<SchedBlock> collection2 : collection) {
            for (SchedBlock schedBlock : collection2) {
                schedBlock.getSbGenerationContext().setSBType(this.sbContext.getSBType());
            }
        }
        return collection;
    }
}

