/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.valuetypes.Velocity;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class RepresentativeTargetCalculator {
    public Target getRepresentativeScienceTargetInObservingGroup(@NonNull ObservingGroup observingGroup, @NonNull SchedBlock schedBlock, @NonNull SBGenerationContext sBGenerationContext) throws SchedBlock.UnableToFindParentScienceGoalException, UnableToDetermineRepTargetForObservingGroupException {
        if (observingGroup == null) {
            throw new NullPointerException("observingGroup is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        if (scienceGoal == null) {
            throw new UnableToDetermineRepTargetForObservingGroupException("No science goal found when expected");
        }
        SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice = scienceGoal.getSpectralSetupParameters().getSpectralType();
        Target target = null;
        switch (spectralSetupTypeChoice) {
            case SPECTRALLINE: {
                target = this.getRepTargetForSpectralLineSetup(observingGroup, schedBlock, scienceGoal);
                break;
            }
            case SPECTRALSCAN: {
                target = this.getRepTargetForSpectralScanSetup(observingGroup, schedBlock);
                break;
            }
            case SINGLECONTINUUM: {
                target = this.findRepresentativeTarget(schedBlock);
                break;
            }
            default: {
                throw new UnableToDetermineRepTargetForObservingGroupException("Unknown spectral type: " + spectralSetupTypeChoice);
            }
        }
        if (target == null) {
            throw new UnableToDetermineRepTargetForObservingGroupException("Unable to determine rep. target for observing group " + observingGroup.getName());
        }
        return target;
    }

    private Target getRepTargetForSpectralScanSetup(@NonNull ObservingGroup observingGroup, @NonNull SchedBlock schedBlock) throws UnableToDetermineRepTargetForObservingGroupException {
        if (observingGroup == null) {
            throw new NullPointerException("observingGroup is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        Target target = this.findRepresentativeTarget(schedBlock);
        Target target2 = null;
        for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
            Target target3 = orderedTarget.getTarget();
            if (!target3.hasScienceParameters() || !target3.getSourceVelocity().getCenterVelocity().isEqual((AbstractDoubleWithUnit)target.getSourceVelocity().getCenterVelocity(), 1.0E-7) || !target3.getFieldSource().getSourceName().equalsIgnoreCase(target.getFieldSource().getSourceName())) continue;
            target2 = target3;
            break;
        }
        if (target2 == null) {
            throw new UnableToDetermineRepTargetForObservingGroupException(String.format("Unable to find observing group specific copy of the rep. target %s in the observing group %s", target.getFieldSource().getSourceName(), observingGroup.getName()));
        }
        return target2;
    }

    /*
     * WARNING - void declaration
     */
    private Target getRepTargetForSpectralLineSetup(@NonNull ObservingGroup observingGroup, @NonNull SchedBlock schedBlock, @NonNull ScienceGoal scienceGoal) throws UnableToDetermineRepTargetForObservingGroupException {
        void var9_17;
        Object object2;
        if (observingGroup == null) {
            throw new NullPointerException("observingGroup is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        List<MinTuningsCalculator.TuningResult> list = null;
        if (schedBlock.isTotalPowerAmpcalSB()) {
            for (Object object2 : observingGroup.getOrderedTarget()) {
                Target target2 = object2.getTarget();
                if (!target2.hasScienceParameters()) continue;
                return target2;
            }
        }
        try {
            list = MinTuningsCalculator.removeDuplicateTargets(MinTuningsCalculator.getLO1Tunings(scienceGoal));
        }
        catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings unableToCalculateMinNumberOfTunings) {
            Log.logger(SpectralSpec.class).warning("Unable to determine min tunings: " + unableToCalculateMinNumberOfTunings.getMessage());
            throw new UnableToDetermineRepTargetForObservingGroupException(unableToCalculateMinNumberOfTunings.getMessage());
        }
        assert (list != null && !list.isEmpty());
        MinTuningsCalculator.TuningResult[] tuningResultArray = new MinTuningsCalculator.TuningResult[list.size()];
        list.toArray(tuningResultArray);
        if (list.size() == 1) {
            return this.findRepresentativeTarget(schedBlock);
        }
        String string = null;
        Velocity velocity = null;
        object2 = null;
        for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
            FieldSource fieldSource;
            Target target3 = orderedTarget.getTarget();
            assert (target3 != null);
            if (!target3.hasScienceParameters() || (fieldSource = target3.getFieldSource()) == null) continue;
            velocity = fieldSource.getSourceVelocity().deepCopy();
            string = fieldSource.getSourceName();
            object2 = target3;
            break;
        }
        if (velocity == null || string == null || object2 == null) {
            throw new UnableToDetermineRepTargetForObservingGroupException("Unable to determine source velocity or name when establishing key target parameters");
        }
        Object var9_15 = null;
        block4: for (MinTuningsCalculator.TuningResult tuningResult : list) {
            for (TargetParameters targetParameters : tuningResult.getTargets()) {
                if (!targetParameters.getSourceVelocity().getCenterVelocity().isEqual((AbstractDoubleWithUnit)velocity.getCenterVelocity())) continue;
                TargetParameters targetParameters2 = tuningResult.getKeyTarget();
                break block4;
            }
        }
        assert (var9_17 != null);
        Object object3 = null;
        List<Target> list2 = observingGroup.getAllOrderedTargets(Optional.of(target -> target.hasScienceParameters()));
        if (list2.size() == 1) {
            return list2.get(0);
        }
        for (Target target4 : list2) {
            if (!target4.getSourceVelocity().getCenterVelocity().isEqual((AbstractDoubleWithUnit)var9_17.getSourceVelocity().getCenterVelocity()) || !target4.getFieldSource().getSourceName().trim().equalsIgnoreCase(var9_17.getSourceName())) continue;
            object3 = target4;
            break;
        }
        if (object3 == null) {
            throw new UnableToDetermineRepTargetForObservingGroupException("Could not match target to target parameters");
        }
        return object3;
    }

    private Target findRepresentativeTarget(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        Target target = null;
        for (Target target2 : schedBlock.getTarget()) {
            if (!target2.isRepresentativeTarget()) continue;
            target = target2;
        }
        if (target == null) {
            throw new WizardSBGenerationException("Unable to determine the representative target");
        }
        return target;
    }

    public class UnableToDetermineRepTargetForObservingGroupException
    extends Exception {
        public UnableToDetermineRepTargetForObservingGroupException(String string) {
            super(string);
        }
    }
}

