/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.spectralspec;

import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import java.util.List;

public class DGCB2BFrequencySetup {
    private FrequencyRange lo1Range;
    private List<Frequency> spwCentres;
    private HarmonicEnum frequencySwitchingMode;
    private ReceiverBand scienceReceiverBand;
    private ReceiverBand referenceReceiverBand;
    private Frequency singleContinuumFrequency;

    public boolean isHarmonic() {
        return this.frequencySwitchingMode.equals((Object)HarmonicEnum.HARMONIC);
    }

    DGCB2BFrequencySetup(FrequencyRange frequencyRange, List<Frequency> list, HarmonicEnum harmonicEnum, ReceiverBand receiverBand, ReceiverBand receiverBand2, Frequency frequency) {
        this.lo1Range = frequencyRange;
        this.spwCentres = list;
        this.frequencySwitchingMode = harmonicEnum;
        this.scienceReceiverBand = receiverBand;
        this.referenceReceiverBand = receiverBand2;
        this.singleContinuumFrequency = frequency;
    }

    public static DGCB2BFrequencySetupBuilder builder() {
        return new DGCB2BFrequencySetupBuilder();
    }

    public FrequencyRange getLo1Range() {
        return this.lo1Range;
    }

    public List<Frequency> getSpwCentres() {
        return this.spwCentres;
    }

    public HarmonicEnum getFrequencySwitchingMode() {
        return this.frequencySwitchingMode;
    }

    public ReceiverBand getScienceReceiverBand() {
        return this.scienceReceiverBand;
    }

    public ReceiverBand getReferenceReceiverBand() {
        return this.referenceReceiverBand;
    }

    public Frequency getSingleContinuumFrequency() {
        return this.singleContinuumFrequency;
    }

    public void setLo1Range(FrequencyRange frequencyRange) {
        this.lo1Range = frequencyRange;
    }

    public void setSpwCentres(List<Frequency> list) {
        this.spwCentres = list;
    }

    public void setFrequencySwitchingMode(HarmonicEnum harmonicEnum) {
        this.frequencySwitchingMode = harmonicEnum;
    }

    public void setScienceReceiverBand(ReceiverBand receiverBand) {
        this.scienceReceiverBand = receiverBand;
    }

    public void setReferenceReceiverBand(ReceiverBand receiverBand) {
        this.referenceReceiverBand = receiverBand;
    }

    public void setSingleContinuumFrequency(Frequency frequency) {
        this.singleContinuumFrequency = frequency;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DGCB2BFrequencySetup)) {
            return false;
        }
        DGCB2BFrequencySetup dGCB2BFrequencySetup = (DGCB2BFrequencySetup)object;
        if (!dGCB2BFrequencySetup.canEqual(this)) {
            return false;
        }
        FrequencyRange frequencyRange = this.getLo1Range();
        FrequencyRange frequencyRange2 = dGCB2BFrequencySetup.getLo1Range();
        if (frequencyRange == null ? frequencyRange2 != null : !frequencyRange.equals(frequencyRange2)) {
            return false;
        }
        List<Frequency> list = this.getSpwCentres();
        List<Frequency> list2 = dGCB2BFrequencySetup.getSpwCentres();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        HarmonicEnum harmonicEnum = this.getFrequencySwitchingMode();
        HarmonicEnum harmonicEnum2 = dGCB2BFrequencySetup.getFrequencySwitchingMode();
        if (harmonicEnum == null ? harmonicEnum2 != null : !((Object)((Object)harmonicEnum)).equals((Object)harmonicEnum2)) {
            return false;
        }
        ReceiverBand receiverBand = this.getScienceReceiverBand();
        ReceiverBand receiverBand2 = dGCB2BFrequencySetup.getScienceReceiverBand();
        if (receiverBand == null ? receiverBand2 != null : !receiverBand.equals(receiverBand2)) {
            return false;
        }
        ReceiverBand receiverBand3 = this.getReferenceReceiverBand();
        ReceiverBand receiverBand4 = dGCB2BFrequencySetup.getReferenceReceiverBand();
        if (receiverBand3 == null ? receiverBand4 != null : !receiverBand3.equals(receiverBand4)) {
            return false;
        }
        Frequency frequency = this.getSingleContinuumFrequency();
        Frequency frequency2 = dGCB2BFrequencySetup.getSingleContinuumFrequency();
        return !(frequency == null ? frequency2 != null : !((Object)((Object)frequency)).equals((Object)frequency2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof DGCB2BFrequencySetup;
    }

    public int hashCode() {
        int n = 1;
        FrequencyRange frequencyRange = this.getLo1Range();
        n = n * 59 + (frequencyRange == null ? 43 : frequencyRange.hashCode());
        List<Frequency> list = this.getSpwCentres();
        n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
        HarmonicEnum harmonicEnum = this.getFrequencySwitchingMode();
        n = n * 59 + (harmonicEnum == null ? 43 : ((Object)((Object)harmonicEnum)).hashCode());
        ReceiverBand receiverBand = this.getScienceReceiverBand();
        n = n * 59 + (receiverBand == null ? 43 : receiverBand.hashCode());
        ReceiverBand receiverBand2 = this.getReferenceReceiverBand();
        n = n * 59 + (receiverBand2 == null ? 43 : receiverBand2.hashCode());
        Frequency frequency = this.getSingleContinuumFrequency();
        n = n * 59 + (frequency == null ? 43 : ((Object)((Object)frequency)).hashCode());
        return n;
    }

    public String toString() {
        return "DGCB2BFrequencySetup(lo1Range=" + this.getLo1Range() + ", spwCentres=" + this.getSpwCentres() + ", frequencySwitchingMode=" + this.getFrequencySwitchingMode() + ", scienceReceiverBand=" + this.getScienceReceiverBand() + ", referenceReceiverBand=" + this.getReferenceReceiverBand() + ", singleContinuumFrequency=" + this.getSingleContinuumFrequency() + ")";
    }

    public static class DGCB2BFrequencySetupBuilder {
        private FrequencyRange lo1Range;
        private List<Frequency> spwCentres;
        private HarmonicEnum frequencySwitchingMode;
        private ReceiverBand scienceReceiverBand;
        private ReceiverBand referenceReceiverBand;
        private Frequency singleContinuumFrequency;

        DGCB2BFrequencySetupBuilder() {
        }

        public DGCB2BFrequencySetupBuilder lo1Range(FrequencyRange frequencyRange) {
            this.lo1Range = frequencyRange;
            return this;
        }

        public DGCB2BFrequencySetupBuilder spwCentres(List<Frequency> list) {
            this.spwCentres = list;
            return this;
        }

        public DGCB2BFrequencySetupBuilder frequencySwitchingMode(HarmonicEnum harmonicEnum) {
            this.frequencySwitchingMode = harmonicEnum;
            return this;
        }

        public DGCB2BFrequencySetupBuilder scienceReceiverBand(ReceiverBand receiverBand) {
            this.scienceReceiverBand = receiverBand;
            return this;
        }

        public DGCB2BFrequencySetupBuilder referenceReceiverBand(ReceiverBand receiverBand) {
            this.referenceReceiverBand = receiverBand;
            return this;
        }

        public DGCB2BFrequencySetupBuilder singleContinuumFrequency(Frequency frequency) {
            this.singleContinuumFrequency = frequency;
            return this;
        }

        public DGCB2BFrequencySetup build() {
            return new DGCB2BFrequencySetup(this.lo1Range, this.spwCentres, this.frequencySwitchingMode, this.scienceReceiverBand, this.referenceReceiverBand, this.singleContinuumFrequency);
        }

        public String toString() {
            return "DGCB2BFrequencySetup.DGCB2BFrequencySetupBuilder(lo1Range=" + this.lo1Range + ", spwCentres=" + this.spwCentres + ", frequencySwitchingMode=" + this.frequencySwitchingMode + ", scienceReceiverBand=" + this.scienceReceiverBand + ", referenceReceiverBand=" + this.referenceReceiverBand + ", singleContinuumFrequency=" + this.singleContinuumFrequency + ")";
        }
    }

    public static enum HarmonicEnum {
        HARMONIC,
        NONHARMONIC;

    }
}

