/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.network.versioncheck;

import alma.obsprep.services.network.versioncheck.ws.Status;
import java.util.EnumSet;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="status")
@XmlEnum
public enum UpdateStatus {
    CRITICAL("A critical ALMA OT update has been released.", "Please update immediately to the latest release"),
    RECOMMENDED("A new version of the OT has been released.", "We recommend you update to the latest release"),
    MINOR("A new version of the OT has been released.", "We recommend you update to the latest release"),
    CURRENT("You are running a current version of the OT"),
    LATEST("You are running the latest version of the OT");

    protected static final EnumSet<UpdateStatus> ACTION_REQUIRED;
    private final String notice;
    private final String action;
    private String url;

    private UpdateStatus(String string2, String string3) {
        this.notice = string2;
        this.action = string3;
    }

    private UpdateStatus(String string2) {
        this(string2, null);
    }

    public String getAction() {
        if (ACTION_REQUIRED.contains((Object)this) && this.url != null) {
            return this.action + " available at " + this.url;
        }
        return this.action;
    }

    public boolean isActionable() {
        return ACTION_REQUIRED.contains((Object)this);
    }

    public static UpdateStatus toPojo(Status status) {
        if (Status.CRITICAL.equals((Object)status)) {
            return CRITICAL;
        }
        if (Status.RECOMMENDED.equals((Object)status)) {
            return RECOMMENDED;
        }
        if (Status.MINOR.equals((Object)status)) {
            return MINOR;
        }
        if (Status.CURRENT.equals((Object)status)) {
            return CURRENT;
        }
        if (Status.LATEST.equals((Object)status)) {
            return LATEST;
        }
        throw new UnsupportedOperationException("Web service stubs need updating!");
    }

    public String getNotice() {
        return this.notice;
    }

    public String getUrl() {
        return this.url;
    }

    static {
        ACTION_REQUIRED = EnumSet.of(CRITICAL, RECOMMENDED, MINOR);
    }
}

