/*
 * Decompiled with CFR 0.152.
 */
package alma.valuetypes;

import alma.entity.xmlbinding.valuetypes.UserSensitivityT;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.ArrayType;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.util.FrequencyDependentUnitMap;
import alma.obsprep.util.UserSensitivityUnitMap;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Temperature;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserUnitHelper;
import alma.valuetypes.UserUnitValueUnitPair;
import alma.valuetypes.data.UserSensitivityData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;

public class UserSensitivity
extends UserSensitivityData
implements UserUnitValueUnitPair<Sensitivity> {
    private final UserUnitHelper uuhelper;
    private static Set<String> temperatureUnits = new HashSet<String>();
    private static Set<String> fluxUnits = new HashSet<String>();
    private ArrayType arrayType = ArrayType.INTERFEROMETRY;
    private Antenna antenna = Antenna.ANTENNA_12M;
    private Angle beamsize;
    private UserSensitivityUnitMap unitMap;
    private static final String[] sortedUserUnitList = new String[]{USERUNIT_UJY, USERUNIT_MJY, USERUNIT_JY, USERUNIT_MK, USERUNIT_K};
    private static final String[] sortedFluxUserUnitList = new String[]{USERUNIT_UJY, USERUNIT_MJY, USERUNIT_JY};
    private static final String[] sortedTemperatureUserUnitList = new String[]{USERUNIT_MK, USERUNIT_K};
    private Frequency observingFrequency;
    private Temperature temperature;

    public UserSensitivity(UserSensitivityT userSensitivityT) {
        super(userSensitivityT);
        this.unitMap().acceptNonModelUnits();
        this.uuhelper = new UserUnitHelper(this);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setUserUnit(this.defaultUnit());
    }

    public static UserSensitivity createUserSensitivity(double d, String string) {
        UserSensitivity userSensitivity = UserSensitivity.createUserSensitivity();
        userSensitivity.setContent(d);
        userSensitivity.setUnit(string);
        return userSensitivity;
    }

    public static boolean isModelSupportUnit(String string) {
        for (String string2 : UserSensitivity.getKnownUnitList()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getKnownModelUnits() {
        return knownUnitList;
    }

    @Override
    public String[] getKnownUserUnits() {
        return sortedUserUnitList;
    }

    public Frequency getObservingFrequency() {
        if (this.observingFrequency == null) {
            this.observingFrequency = Frequency.createFrequency();
        }
        return this.observingFrequency;
    }

    public Frequency gettrueObservingFrequency() {
        return this.observingFrequency;
    }

    public void setObservingFrequency(Frequency frequency) {
        this.observingFrequency = frequency;
        UserSensitivityUnitMap userSensitivityUnitMap = this.unitMap();
        if (userSensitivityUnitMap.gettrueObservingFrequency() == null) {
            userSensitivityUnitMap.setObservingFrequency(frequency);
        } else {
            userSensitivityUnitMap.gettrueObservingFrequency().setContentAndUnit((ValueUnitPair)frequency);
            ((FrequencyDependentUnitMap)userSensitivityUnitMap).updateUnitMap();
        }
    }

    public UserSensitivityUnitMap unitMap() {
        if (this.unitMap == null) {
            this.unitMap = new UserSensitivityUnitMap(this);
        }
        return this.unitMap;
    }

    public String getFriendlyUnit() {
        return this.uuhelper.getFriendlyUnit();
    }

    public Temperature asTemperature() {
        String string = Temperature.UNIT_K;
        double d = this.getContentInUnits(string);
        if (this.temperature == null) {
            this.temperature = Temperature.createTemperature();
        }
        this.temperature.setContentAndUnit(d, string);
        return this.temperature;
    }

    public UserSensitivity deepCopy() {
        return super.deepCopy();
    }

    protected void initAttribsAndPartsFrom(IBusinessObject iBusinessObject, Copier copier) throws CopyException {
        super.initAttribsAndPartsFrom(iBusinessObject, copier);
        UserSensitivity userSensitivity = (UserSensitivity)iBusinessObject;
        String[] stringArray = userSensitivity.gettrueUserUnitList();
        if (stringArray != null) {
            this.setUserUnitList(Arrays.copyOf(stringArray, stringArray.length));
        }
        if (userSensitivity.observingFrequency != null) {
            this.unitMap().suspendUnitMapUpdater();
            this.setObservingFrequency(userSensitivity.getObservingFrequency().deepCopy());
            this.unitMap().resumeUnitMapUpdater();
        } else {
            this.setObservingFrequency(null);
        }
        if (userSensitivity.beamsize != null) {
            this.unitMap().suspendUnitMapUpdater();
            this.setBeamsize(userSensitivity.beamsize.deepCopy());
            this.unitMap().resumeUnitMapUpdater();
        } else {
            this.setBeamsize(null);
        }
        this.antenna = userSensitivity.antenna;
        this.arrayType = userSensitivity.arrayType;
    }

    public Angle getBeamsize() {
        if (this.beamsize == null) {
            this.beamsize = UserAngle.createUserAngle();
        }
        return this.beamsize;
    }

    public Angle gettrueBeamsize() {
        return this.beamsize;
    }

    public void setBeamsize(Angle angle) {
        this.beamsize = angle;
        this.unitMap().setBeamsize(angle);
    }

    public void setArrayType(ArrayType arrayType) {
        this.arrayType = arrayType;
        this.unitMap().setArrayType(arrayType);
    }

    public void setAntenna(Antenna antenna) {
        this.antenna = antenna;
        this.unitMap().setAntenna(antenna);
    }

    public void setArrayTypeAndAntenna(Array array) {
        this.setArrayType(array.type);
        this.setAntenna(array.antenna);
    }

    public double getContentInUnits(String string) {
        return this.uuhelper.getContentInUnits(string);
    }

    @Override
    public void setUserContent(double d) {
        this.uuhelper.setUserContent(d);
    }

    @Override
    public void setUserContent(double d, String string) {
        this.uuhelper.setUserContent(d, string);
    }

    protected void updateContentAndUnit(double d, String string) {
        this.uuhelper.updateContentAndUnit(d, string);
    }

    public void setUserContentAndUserUnit(double d, String string) {
        this.uuhelper.setUserContentAndUserUnit(d, string);
    }

    public void setUserContentAndUserUnit(ValueUnitPair valueUnitPair) {
        this.uuhelper.setUserContentAndUserUnit(valueUnitPair);
    }

    @Override
    public double getUserContent() {
        return this.uuhelper.getUserContent();
    }

    @Override
    public String gettrueUserUnit() {
        return this.uuhelper.gettrueUserUnit();
    }

    public String[] gettrueUserUnitList() {
        return this.uuhelper.gettrueUserUnitList();
    }

    @Override
    public String[] getUserUnitList() {
        return this.uuhelper.getUserUnitList();
    }

    @Override
    public void setUserUnitList(String[] stringArray) {
        this.uuhelper.setUserUnitList(stringArray);
    }

    @Override
    public void convertToUserUnit(String string) {
        this.uuhelper.convertToUserUnit(string);
    }

    @Override
    public boolean isModelUnit(String string) {
        return this.uuhelper.isModelUnit(string);
    }

    @Override
    public void dependeeChanged() {
        if (this.uuhelper != null) {
            this.uuhelper.dependeeChanged();
        }
    }

    @Override
    public void unitMapUpdated() {
        if (this.uuhelper != null) {
            this.uuhelper.unitMapUpdated();
        }
    }

    @Override
    public boolean inModelUnit() {
        return this.isModelUnit(this.getUserUnit());
    }

    public boolean inFluxUnit() {
        return fluxUnits.contains(this.getUserUnit());
    }

    public static boolean inFluxUnit(String string) {
        return fluxUnits.contains(string);
    }

    public boolean inTemperatureUnit() {
        return temperatureUnits.contains(this.getUserUnit());
    }

    public static String[] getFluxUnits() {
        return sortedFluxUserUnitList;
    }

    public static String[] getTemperatureUnits() {
        return sortedTemperatureUserUnitList;
    }

    public UserSensitivity getF1FluxSensitivity(@NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        Angle angle;
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        if (this.inFluxUnit() || !performanceParameters.isAngularResolutionModeRange()) {
            return this;
        }
        UserSensitivity userSensitivity = this.deepCopy();
        try {
            angle = (Angle)((Object)ConfigurationHelper.getARsForConfigsInARRange(scienceGoal).min());
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            throw new InvalidObsProgramParametersException(invalidConfigurationParametersException);
        }
        userSensitivity.setBeamsize(angle);
        return userSensitivity;
    }

    public ArrayType getArrayType() {
        return this.arrayType;
    }

    public Antenna getAntenna() {
        return this.antenna;
    }

    static {
        temperatureUnits.add(USERUNIT_K);
        temperatureUnits.add(USERUNIT_MK);
        fluxUnits.add(USERUNIT_JY);
        fluxUnits.add(USERUNIT_MJY);
        fluxUnits.add(USERUNIT_UJY);
    }
}

