/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.exceptions;

import alma.ACSErr.ACSException;
import alma.ACSErr.ErrorTrace;
import alma.acs.exceptions.AcsJException;
import alma.acs.exceptions.ErrorTraceManipulator;
import org.omg.CORBA.UserException;

public class DefaultAcsJException
extends AcsJException {
    private int errType;
    private int errCode;
    private String shortDescription;
    private String javaNativeExName;

    public DefaultAcsJException(String message, int errType, int errCode, String shortDescription) {
        this(message, errType, errCode, shortDescription, null);
    }

    public DefaultAcsJException(String message, int errType, int errCode, String shortDescription, String javaNativeExName) {
        super(message);
        this.errType = errType;
        this.errCode = errCode;
        this.shortDescription = shortDescription != null && shortDescription.trim().length() > 0 ? shortDescription.trim() : "";
        this.javaNativeExName = javaNativeExName;
    }

    DefaultAcsJException(ErrorTrace etCause) {
        super(etCause);
    }

    @Override
    public UserException toCorbaException() {
        ErrorTrace et = this.getErrorTrace();
        ACSException acsEx = new ACSException(et);
        return acsEx;
    }

    @Override
    protected int getErrorType() {
        return this.errType;
    }

    @Override
    protected int getErrorCode() {
        return this.errCode;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    protected ErrorTrace createSingleErrorTrace() {
        ErrorTrace et = super.createSingleErrorTrace();
        if (this.javaNativeExName != null && !this.javaNativeExName.isEmpty()) {
            ErrorTraceManipulator.setProperty(et, "javaex.class", this.javaNativeExName);
        }
        return et;
    }

    @Override
    public String toString() {
        String message;
        Object s = this.getClass().getName();
        if (this.javaNativeExName != null) {
            s = (String)s + " (" + this.javaNativeExName + ")";
        }
        return (message = this.getLocalizedMessage()) != null && message.length() > 0 ? (String)s + ": " + message : s;
    }
}

