/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.arch.io.hcompress;

import ca.nrc.cadc.arch.io.BulkDataOutput;
import ca.nrc.cadc.arch.io.hcompress.HCompressEncoder;
import ca.nrc.cadc.arch.io.hcompress.HCompressProcessor;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HCompressOutputStream
implements BulkDataOutput {
    private static final int HCOMPRESS_MAGIC = 56729;
    private boolean waitingForHeader = true;
    private boolean headerWritten = false;
    private int nx = -1;
    private int ny = -1;
    private int scale = 0;
    private int encoded_bytes = 0;
    private int header_bytes = 0;
    private byte[] byte_singleton = new byte[1];
    private short[] short_singleton = new short[1];
    private int[] singleton = new int[1];
    private int[] ibuf;
    private int ibuf_data_len;
    private int ipos;
    private DataOutputStream datastream;
    private OutputStream ostream;

    public HCompressOutputStream(DataOutputStream dataOutputStream, OutputStream outputStream) {
        this.datastream = dataOutputStream;
        this.ostream = outputStream;
        this.waitingForHeader = true;
    }

    public HCompressOutputStream(OutputStream outputStream) {
        this.datastream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        this.ostream = outputStream;
        this.waitingForHeader = true;
    }

    public void cleanup() {
        this.ibuf = null;
        System.gc();
    }

    public void close() throws IOException {
        this.flush();
        this.datastream.close();
        this.cleanup();
    }

    private int compress() throws IOException {
        HCompressProcessor.htrans(this.ibuf, this.nx, this.ny);
        HCompressProcessor.digitize(this.ibuf, this.nx, this.ny, this.scale);
        HCompressEncoder hCompressEncoder = new HCompressEncoder();
        this.datastream.writeInt(this.ibuf[0]);
        this.ibuf[0] = 0;
        int n = hCompressEncoder.encode(this.ostream, this.ibuf, this.nx, this.ny);
        return n;
    }

    public void flush() throws IOException {
        this.datastream.flush();
    }

    public int getByteCount() {
        return this.encoded_bytes + this.header_bytes;
    }

    public boolean markSupported() {
        return false;
    }

    public void setDimensions(int n, int n2, int n3) throws IOException {
        this.nx = n;
        this.ny = n2;
        this.scale = n3;
        this.waitingForHeader = false;
        this.headerWritten = false;
    }

    public void writeByte(byte by) throws IOException {
        this.byte_singleton[0] = by;
        this.writeByte(this.byte_singleton, 0, 1);
    }

    public void writeByte(byte[] byArray) throws IOException {
        this.writeByte(byArray, 0, byArray.length);
    }

    public void writeByte(byte[] byArray, int n, int n2) throws IOException {
        if (this.waitingForHeader) {
            throw new IOException("no image dimensions");
        }
        if (!this.headerWritten) {
            this.writeHeader();
        }
        this.ipos = this.ibuf_data_len;
        if (this.ibuf == null) {
            this.ibuf = new int[this.nx * this.ny];
        }
        int n3 = 0;
        while (n3 < n2) {
            this.ibuf[n3 + this.ipos] = byArray[n3 + n];
            ++n3;
        }
        this.ibuf_data_len += n2;
        if (this.ibuf_data_len == this.ibuf.length) {
            this.encoded_bytes = this.compress();
        }
    }

    public void writeChar(char[] cArray) {
        this.writeChar(cArray, 0, cArray.length);
    }

    public void writeChar(char[] cArray, int n, int n2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void writeDouble(double[] dArray) {
        this.writeDouble(dArray, 0, dArray.length);
    }

    public void writeDouble(double[] dArray, int n, int n2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void writeFloat(float[] fArray) {
        this.writeFloat(fArray, 0, fArray.length);
    }

    public void writeFloat(float[] fArray, int n, int n2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private void writeHeader() throws IOException {
        if (!this.headerWritten) {
            this.datastream.writeShort(56729);
            this.datastream.writeInt(this.nx);
            this.datastream.writeInt(this.ny);
            this.datastream.writeInt(this.scale);
            this.header_bytes = 14;
            this.ibuf = null;
            this.ibuf_data_len = 0;
            this.ipos = 0;
            this.waitingForHeader = false;
            this.headerWritten = true;
        }
    }

    public void writeInt(int n) throws IOException {
        this.singleton[0] = n;
        this.writeInt(this.singleton, 0, 1);
    }

    public void writeInt(int[] nArray) throws IOException {
        this.writeInt(nArray, 0, nArray.length);
    }

    public void writeInt(int[] nArray, int n, int n2) throws IOException {
        if (this.waitingForHeader) {
            throw new IOException("no image dimensions");
        }
        if (!this.headerWritten) {
            this.writeHeader();
        }
        this.ipos = this.ibuf_data_len;
        if (n2 == this.nx * this.ny) {
            this.ibuf = nArray;
            this.ibuf_data_len = n2;
        } else {
            if (this.ibuf == null) {
                this.ibuf = new int[this.nx * this.ny];
            }
            System.arraycopy(this.ibuf, this.ipos, nArray, n, n2);
            this.ibuf_data_len += n2;
        }
        if (this.ibuf_data_len == this.ibuf.length) {
            this.encoded_bytes = this.compress();
        }
    }

    public void writeLong(long[] lArray) {
        this.writeLong(lArray, 0, lArray.length);
    }

    public void writeLong(long[] lArray, int n, int n2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void writeShort(short s) throws IOException {
        this.short_singleton[0] = s;
        this.writeShort(this.short_singleton, 0, 1);
    }

    public void writeShort(short[] sArray) throws IOException {
        this.writeShort(sArray, 0, sArray.length);
    }

    public void writeShort(short[] sArray, int n, int n2) throws IOException {
        if (this.waitingForHeader) {
            throw new IOException("no image dimensions");
        }
        if (!this.headerWritten) {
            this.writeHeader();
        }
        this.ipos = this.ibuf_data_len;
        if (this.ibuf == null) {
            this.ibuf = new int[this.nx * this.ny];
        }
        int n3 = 0;
        while (n3 < n2) {
            this.ibuf[n3 + this.ipos] = sArray[n3 + n];
            ++n3;
        }
        this.ibuf_data_len += n2;
        if (this.ibuf_data_len == this.ibuf.length) {
            this.encoded_bytes = this.compress();
        }
    }

    public void writeUnsignedByte(short[] sArray) {
        this.writeUnsignedByte(sArray, 0, sArray.length);
    }

    public void writeUnsignedByte(short[] sArray, int n, int n2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void writeUnsignedShort(int[] nArray) {
        this.writeUnsignedShort(nArray, 0, nArray.length);
    }

    public void writeUnsignedShort(int[] nArray, int n, int n2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

