/*
 * Decompiled with CFR 0.152.
 */
package alma.entity.xmlbinding.obsproject;

import alma.entity.xmlbinding.obsattachment.ObsAttachmentRefT;
import alma.entity.xmlbinding.obsproject.ExpectedPropertiesT;
import alma.entity.xmlbinding.obsproject.types.AbstractTargetParametersTSolarSystemObjectType;
import alma.entity.xmlbinding.valuetypes.AngleT;
import alma.entity.xmlbinding.valuetypes.AngularVelocityT;
import alma.entity.xmlbinding.valuetypes.SkyCoordinatesT;
import alma.entity.xmlbinding.valuetypes.VelocityT;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;

public abstract class AbstractTargetParametersT
implements Serializable {
    private AbstractTargetParametersTSolarSystemObjectType solarSystemObject;
    private String sourceName;
    private SkyCoordinatesT sourceCoordinates;
    private AngularVelocityT pmRA;
    private AngularVelocityT pmDec;
    private AngleT parallax;
    private boolean nonSiderealMotion = false;
    private boolean _hasnonSiderealMotion;
    private String sourceEphemeris;
    private VelocityT sourceVelocity;
    private String ephemerisFileName;
    private int index = 0;
    private boolean _hasindex;
    private List<SkyCoordinatesT> sdReferencePositionList = new ArrayList<SkyCoordinatesT>();
    private ExpectedPropertiesT expectedProperties;
    private ObsAttachmentRefT imageRef;

    public void addSdReferencePosition(SkyCoordinatesT vSdReferencePosition) throws IndexOutOfBoundsException {
        if (this.sdReferencePositionList.size() >= 2) {
            throw new IndexOutOfBoundsException("addSdReferencePosition has a maximum of 2");
        }
        this.sdReferencePositionList.add(vSdReferencePosition);
    }

    public void addSdReferencePosition(int index, SkyCoordinatesT vSdReferencePosition) throws IndexOutOfBoundsException {
        if (this.sdReferencePositionList.size() >= 2) {
            throw new IndexOutOfBoundsException("addSdReferencePosition has a maximum of 2");
        }
        this.sdReferencePositionList.add(index, vSdReferencePosition);
    }

    public void deleteIndex() {
        this._hasindex = false;
    }

    public void deleteNonSiderealMotion() {
        this._hasnonSiderealMotion = false;
    }

    public Enumeration<? extends SkyCoordinatesT> enumerateSdReferencePosition() {
        return Collections.enumeration(this.sdReferencePositionList);
    }

    public String getEphemerisFileName() {
        return this.ephemerisFileName;
    }

    public ExpectedPropertiesT getExpectedProperties() {
        return this.expectedProperties;
    }

    public ObsAttachmentRefT getImageRef() {
        return this.imageRef;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean getNonSiderealMotion() {
        return this.nonSiderealMotion;
    }

    public AngleT getParallax() {
        return this.parallax;
    }

    public AngularVelocityT getPmDec() {
        return this.pmDec;
    }

    public AngularVelocityT getPmRA() {
        return this.pmRA;
    }

    public SkyCoordinatesT getSdReferencePosition(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.sdReferencePositionList.size()) {
            throw new IndexOutOfBoundsException("getSdReferencePosition: Index value '" + index + "' not in range [0.." + (this.sdReferencePositionList.size() - 1) + "]");
        }
        return this.sdReferencePositionList.get(index);
    }

    public SkyCoordinatesT[] getSdReferencePosition() {
        SkyCoordinatesT[] array = new SkyCoordinatesT[]{};
        return this.sdReferencePositionList.toArray(array);
    }

    public int getSdReferencePositionCount() {
        return this.sdReferencePositionList.size();
    }

    public AbstractTargetParametersTSolarSystemObjectType getSolarSystemObject() {
        return this.solarSystemObject;
    }

    public SkyCoordinatesT getSourceCoordinates() {
        return this.sourceCoordinates;
    }

    public String getSourceEphemeris() {
        return this.sourceEphemeris;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public VelocityT getSourceVelocity() {
        return this.sourceVelocity;
    }

    public boolean hasIndex() {
        return this._hasindex;
    }

    public boolean hasNonSiderealMotion() {
        return this._hasnonSiderealMotion;
    }

    public boolean isNonSiderealMotion() {
        return this.nonSiderealMotion;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends SkyCoordinatesT> iterateSdReferencePosition() {
        return this.sdReferencePositionList.iterator();
    }

    public void removeAllSdReferencePosition() {
        this.sdReferencePositionList.clear();
    }

    public boolean removeSdReferencePosition(SkyCoordinatesT vSdReferencePosition) {
        boolean removed = this.sdReferencePositionList.remove(vSdReferencePosition);
        return removed;
    }

    public SkyCoordinatesT removeSdReferencePositionAt(int index) {
        SkyCoordinatesT obj = this.sdReferencePositionList.remove(index);
        return obj;
    }

    public void setEphemerisFileName(String ephemerisFileName) {
        this.ephemerisFileName = ephemerisFileName;
    }

    public void setExpectedProperties(ExpectedPropertiesT expectedProperties) {
        this.expectedProperties = expectedProperties;
    }

    public void setImageRef(ObsAttachmentRefT imageRef) {
        this.imageRef = imageRef;
    }

    public void setIndex(int index) {
        this.index = index;
        this._hasindex = true;
    }

    public void setNonSiderealMotion(boolean nonSiderealMotion) {
        this.nonSiderealMotion = nonSiderealMotion;
        this._hasnonSiderealMotion = true;
    }

    public void setParallax(AngleT parallax) {
        this.parallax = parallax;
    }

    public void setPmDec(AngularVelocityT pmDec) {
        this.pmDec = pmDec;
    }

    public void setPmRA(AngularVelocityT pmRA) {
        this.pmRA = pmRA;
    }

    public void setSdReferencePosition(int index, SkyCoordinatesT vSdReferencePosition) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.sdReferencePositionList.size()) {
            throw new IndexOutOfBoundsException("setSdReferencePosition: Index value '" + index + "' not in range [0.." + (this.sdReferencePositionList.size() - 1) + "]");
        }
        this.sdReferencePositionList.set(index, vSdReferencePosition);
    }

    public void setSdReferencePosition(SkyCoordinatesT[] vSdReferencePositionArray) {
        this.sdReferencePositionList.clear();
        for (int i = 0; i < vSdReferencePositionArray.length; ++i) {
            this.sdReferencePositionList.add(vSdReferencePositionArray[i]);
        }
    }

    public void setSolarSystemObject(AbstractTargetParametersTSolarSystemObjectType solarSystemObject) {
        this.solarSystemObject = solarSystemObject;
    }

    public void setSourceCoordinates(SkyCoordinatesT sourceCoordinates) {
        this.sourceCoordinates = sourceCoordinates;
    }

    public void setSourceEphemeris(String sourceEphemeris) {
        this.sourceEphemeris = sourceEphemeris;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setSourceVelocity(VelocityT sourceVelocity) {
        this.sourceVelocity = sourceVelocity;
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

