#!/bin/bash
#
# 
# This installer creates various launcher-scripts for running from the commandline.
# msc 2005-11-18

if [ `dirname $0` != "." ] ; then
   echo "Please run this script from the setup directory"
   exit 1;
fi


# locate java and check java version (msc 2015-02, ICT-4570)
# -----------------------------------------------------------

## note: with Java 1.6, the java executable supports a cli option to enforce
## a certain version. this option performs automagic discovery of additional
## java installations, and will autonomously pick one. useful, but obscure.
## java installations, and will autonomously pick one. useful, but obscure.
## also, the option will produce an error when used on a 1.5 java executable.

function java_release {
   local JAVA_MAJOR_VERSION=$(java -version 2>&1 | sed -E -n 's/.* version "([^.-]*).*"/\1/p' | cut -d' ' -f1)
   echo $JAVA_MAJOR_VERSION
}

# this runs the connection check, but only for learning if the jvm
# on this host is tool old for our byte code (msc 2015-10, ICT-5924)

function java_version_probe {
   java -cp . ConnectionCheck 2>&1 1>/dev/null | grep java.lang.UnsupportedClassVersionError
}

javacmd=

for jreDir in "../jre/bin/java" "../../jre/Contents/Home/jre/bin/java"  "jre/bin/java" "../../jre/Contents/Home/bin/java" "../jre/Contents/Home/bin/java" "../../jre/bin/java"
do 
  if [ -e $jreDir ]; then 
      javacmd=$jreDir
      echo "Using Java runtime environment found in ${jreDir}"
      break
  fi
done

# If we cannot find a bundled JRE, we need to check the system installed JRE - it needs to be at least J11 

if [ -z "$javacmd" ] ; then 

   echo -en "\nVerifying that you have an acceptable version of Java installed... "

   JavaFound=`which java 2>/dev/null`

   if [ ! "$JavaFound" ] ; then
      echo "failed"
      echo "Problem: Could not locate any \"java\" executable in your \$PATH. Is Java installed?"
      echo " Please install a recent version of Java (http://java.com), or correct your \$PATH."
      exit 1;
   fi

   version=`java_release java`
   echo Java version "$version" found 

   if [ "$version" -lt "11" ]; then
      echo "failed"
      echo "Problem: The \"java\" executable in your \$PATH (at $JavaFound) is too old: Java ${version}"
      echo " Please install a more recent version of Java (http://java.com), or correct your \$PATH."
      exit 1;
   fi

   echo "System installed Java OT compatible"

   javacmd=java
fi


# help users configure their proxy settings (msc 2014-12, ICT-3035)
# ------------------------------------------------------------------

function ask { # interactive prompt with default reply
   local question=$1 ; local default=$2
   read -p "${question/\{\}/$default}"
   if [ -z "$REPLY" ] ; then REPLY=$default; fi
}

function connection_check { # run a java program that connects to the web
   local protocol=$1
   echo -en "\nProbing your $protocol internet connection... "
   $javacmd $proxysettings -cp . ConnectionCheck  $protocol://www.wikipedia.org/  7000
   if [ $? == 5 ]
   	then connection_check_failed=true ; echo "failed"
   	else connection_check_failed=     ; echo "ok"
   fi
}

proxysettings=""
connection_check https

if [ $connection_check_failed ] ; then
   ask "Are you (a) simply just offline, or are you (b) behind a proxy server [{}]? " b
   if [ $REPLY == b ] ; then

   	proxysettings="-Djava.net.useSystemProxies=true"
   	connection_check https

   	if [ $connection_check_failed ] ; then
      	echo "Your operating system does not support automatic discovery of proxy server"
      	echo "settings. Please enter them manually."

      	while [ $connection_check_failed ] ; do
      		ask "HTTPS Proxy Host: "           ; httpsHost=$REPLY
      		ask "HTTPS Proxy Port [{}]: " 443  ; httpsPort=$REPLY
      		proxysettings="-Dhttps.proxyHost=$httpsHost -Dhttps.proxyPort=$httpsPort"
      		connection_check https
      	done

			while [ $connection_check_failed ] ; do
      		ask "HTTP Proxy Host [same as for HTTPS]: " $httpsHost ; httpHost=$REPLY
      		ask "HTTP Proxy Port [{}]: "                8080       ; httpPort=$REPLY
      		proxysettings="$proxysettings -Dhttp.proxyHost=$httpHost -Dhttp.proxyPort=$httpPort"
      		connection_check http
      	done
      fi
   fi
fi



# create the launcher scripts
# -------------------------------------------------------------

cd ..
installdir=$PWD

echo ""
echo "Your install dir is $installdir"

# Inserts the cwd into the launcher-scripts
function create {
   local create=$1
   local template=setup/$3

   {
    echo "#! /bin/bash"
    echo "INSTALLDIR=$installdir"
    echo "PROXYSETTINGS=$proxysettings"
    echo "HEAPSPACE=$4"
    cat $template
   } > $create

   chmod 775 $create
   echo "  created $create"
}

# create launcher-scripts
echo "Creating scripts in install dir:"

# If the heap space has been set from the installanywhere script then we use that otherwise 
# we default to 4GB of Java heap space 

if [ -z $1 ] 
then 
    HEAPSPACE=4
else 
    HEAPSPACE=`echo $1 | sed -e 's/,//g'`
fi 

echo "Default heap space set to ${HEAPSPACE}G" 

# The name of the script is different on Linux/MacOS

platform="$(uname -s)"
destinationScript=ALMA-OT.sh

if [ $platform = "Darwin" ]; then    
    destinationScript=ALMA-OT.app
fi
  
create $destinationScript from ALMA-OT.sh.tpl $HEAPSPACE

# Create the launcher on the desktop using apple magic if we are being installed using IA 

if [[ $platform = "Darwin" && ! -z $1 ]]
then 

   echo "Setting up Desktop launcher" 
   
   cd setup

   launcher=$HOME/Desktop/ALMAOT-C8-2021

   if [ -f $launcher ]
   then
       rm $launcher
   fi 

   # Create a desktop launcher in the case that we are installing via IA 
   
   ./createAlias.sh
   ./setIcon.sh alma.icns $launcher
fi 

