/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import [Ljava.lang.String;;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.logging.Logger;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import uk.ac.starlink.fits.ArrayWriter;
import uk.ac.starlink.fits.ColumnWriter;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.ScalarColumnWriter;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;

public class StandardFitsTableSerializer
implements FitsTableSerializer {
    private static Logger logger;
    private final boolean allowSignedByte;
    private StarTable table;
    private ColumnWriter[] colWriters;
    private ColumnInfo[] colInfos;
    private long rowCount;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;

    StandardFitsTableSerializer(boolean allowSignedByte) {
        this.allowSignedByte = allowSignedByte;
    }

    public StandardFitsTableSerializer(StarTable table, boolean allowSignedByte) throws IOException {
        this(allowSignedByte);
        this.init(table);
    }

    public StandardFitsTableSerializer(StarTable table) throws IOException {
        this(table, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void init(StarTable table) throws IOException {
        if (this.table != null) {
            throw new IllegalStateException("Table already initialised");
        }
        this.table = table;
        int ncol = table.getColumnCount();
        long nrow = table.getRowCount();
        this.colInfos = Tables.getColumnInfos(table);
        boolean hasVarShapes = false;
        boolean hasNullableInts = false;
        int[][] shapes = new int[ncol][];
        int[] maxChars = new int[ncol];
        int[] maxElements = new int[ncol];
        long[] totalElements = new long[ncol];
        boolean[] useCols = new boolean[ncol];
        boolean[] varShapes = new boolean[ncol];
        boolean[] varChars = new boolean[ncol];
        boolean[] varElementChars = new boolean[ncol];
        boolean[] nullableInts = new boolean[ncol];
        Arrays.fill(useCols, true);
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo colinfo = this.colInfos[icol];
            Class clazz = colinfo.getContentClass();
            if (clazz.isArray()) {
                shapes[icol] = (int[])colinfo.getShape().clone();
                int[] shape = shapes[icol];
                if (shape[shape.length - 1] < 0) {
                    varShapes[icol] = true;
                    hasVarShapes = true;
                } else {
                    int nel = shape.length > 0 ? 1 : 0;
                    for (int id = 0; id < shape.length; ++id) {
                        nel *= shape[id];
                    }
                    if (!$assertionsDisabled && nel < 0) {
                        throw new AssertionError();
                    }
                    maxElements[icol] = nel;
                }
                if (!clazz.getComponentType().equals(class$java$lang$String == null ? StandardFitsTableSerializer.class$("java.lang.String") : class$java$lang$String)) continue;
                maxChars[icol] = colinfo.getElementSize();
                if (maxChars[icol] > 0) continue;
                varElementChars[icol] = true;
                hasVarShapes = true;
                continue;
            }
            if (clazz.equals(class$java$lang$String == null ? StandardFitsTableSerializer.class$("java.lang.String") : class$java$lang$String)) {
                maxChars[icol] = colinfo.getElementSize();
                if (maxChars[icol] > 0) continue;
                varChars[icol] = true;
                hasVarShapes = true;
                continue;
            }
            if (!colinfo.isNullable() || clazz != (class$java$lang$Byte == null ? StandardFitsTableSerializer.class$("java.lang.Byte") : class$java$lang$Byte) && clazz != (class$java$lang$Short == null ? StandardFitsTableSerializer.class$("java.lang.Short") : class$java$lang$Short) && clazz != (class$java$lang$Integer == null ? StandardFitsTableSerializer.class$("java.lang.Integer") : class$java$lang$Integer) && clazz != (class$java$lang$Long == null ? StandardFitsTableSerializer.class$("java.lang.Long") : class$java$lang$Long)) continue;
            nullableInts[icol] = true;
            hasNullableInts = true;
        }
        boolean[] hasNulls = new boolean[ncol];
        if (hasVarShapes || hasNullableInts || nrow < 0L) {
            int icol;
            StringBuffer sbuf = new StringBuffer("First pass needed: ");
            if (hasVarShapes) {
                sbuf.append("(variable array shapes) ");
            }
            if (hasNullableInts) {
                sbuf.append("(nullable ints) ");
            }
            if (nrow < 0L) {
                sbuf.append("(unknown row count) ");
            }
            logger.config(sbuf.toString());
            nrow = 0L;
            RowSequence rseq = table.getRowSequence();
            try {
                while (rseq.next()) {
                    ++nrow;
                    for (int icol2 = 0; icol2 < ncol; ++icol2) {
                        if (!useCols[icol2] || !varShapes[icol2] && !varChars[icol2] && !varElementChars[icol2] && (!nullableInts[icol2] || hasNulls[icol2])) continue;
                        Object cell = rseq.getCell(icol2);
                        if (cell == null) {
                            if (!nullableInts[icol2]) continue;
                            hasNulls[icol2] = true;
                            continue;
                        }
                        if (varChars[icol2]) {
                            int leng = ((String)cell).length();
                            maxChars[icol2] = Math.max(maxChars[icol2], leng);
                        } else if (varElementChars[icol2]) {
                            String[] svals = (String[])cell;
                            for (int i = 0; i < svals.length; ++i) {
                                maxChars[icol2] = Math.max(maxChars[icol2], svals[i].length());
                            }
                        }
                        if (!varShapes[icol2]) continue;
                        int nel = Array.getLength(cell);
                        maxElements[icol2] = Math.max(maxElements[icol2], nel);
                        int n = icol2;
                        totalElements[n] = totalElements[n] + (long)nel;
                    }
                }
            }
            finally {
                rseq.close();
            }
            for (icol = 0; icol < ncol; ++icol) {
                if (maxChars[icol] >= 0) continue;
                maxChars[icol] = 0;
            }
            for (icol = 0; icol < ncol; ++icol) {
                if (maxChars[icol] != 0) continue;
                maxChars[icol] = 1;
            }
            if (hasVarShapes) {
                for (icol = 0; icol < ncol; ++icol) {
                    if (!useCols[icol] || !varShapes[icol]) continue;
                    int[] shape = shapes[icol];
                    int ndim = shape.length;
                    if (!$assertionsDisabled && shape[ndim - 1] > 0) {
                        throw new AssertionError();
                    }
                    int nel = 1;
                    for (int i = 0; i < ndim - 1; ++i) {
                        nel *= shape[i];
                    }
                    shape[ndim - 1] = Math.max(1, (maxElements[icol] + nel - 1) / nel);
                }
            }
        }
        if (!$assertionsDisabled && nrow < 0L) {
            throw new AssertionError();
        }
        this.rowCount = nrow;
        this.colWriters = new ColumnWriter[ncol];
        boolean rbytes = false;
        for (int icol = 0; icol < ncol; ++icol) {
            if (!useCols[icol]) continue;
            ColumnInfo cinfo = this.colInfos[icol];
            ColumnWriter writer = this.createColumnWriter(cinfo, shapes[icol], varShapes[icol], maxChars[icol], maxElements[icol], totalElements[icol], nullableInts[icol] && hasNulls[icol]);
            if (writer == null) {
                logger.warning("Ignoring column " + cinfo.getName() + " - don't know how to write to FITS");
            }
            this.colWriters[icol] = writer;
        }
    }

    ColumnWriter[] getColumnWriters() {
        return this.colWriters;
    }

    public Header getHeader() throws HeaderCardException {
        int rowLength = 0;
        int nUseCol = 0;
        int ncol = this.table.getColumnCount();
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnWriter writer = this.colWriters[icol];
            if (writer == null) continue;
            ++nUseCol;
            rowLength += writer.getLength();
        }
        Header hdr = new Header();
        hdr.addValue("XTENSION", "BINTABLE", "binary table extension");
        hdr.addValue("BITPIX", 8L, "8-bit bytes");
        hdr.addValue("NAXIS", 2L, "2-dimensional table");
        hdr.addValue("NAXIS1", rowLength, "width of table in bytes");
        hdr.addValue("NAXIS2", this.rowCount, "number of rows in table");
        hdr.addValue("PCOUNT", 0L, "size of special data area");
        hdr.addValue("GCOUNT", 1L, "one data group");
        hdr.addValue("TFIELDS", nUseCol, "number of columns");
        int jcol = 0;
        for (int icol = 0; icol < ncol; ++icol) {
            String utype;
            String ucd;
            String comm;
            int[] dims;
            Number bad;
            ColumnWriter colwriter = this.colWriters[icol];
            if (colwriter == null) continue;
            String forcol = " for column " + ++jcol;
            ColumnInfo colinfo = this.colInfos[icol];
            String name = colinfo.getName();
            if (name != null && name.trim().length() > 0) {
                hdr.addValue("TTYPE" + jcol, name, "label" + forcol);
            }
            String form = colwriter.getFormat();
            hdr.addValue("TFORM" + jcol, form, "format" + forcol);
            String unit = colinfo.getUnitString();
            if (unit != null && unit.trim().length() > 0) {
                hdr.addValue("TUNIT" + jcol, unit, "units" + forcol);
            }
            if ((bad = colwriter.getBadNumber()) != null) {
                hdr.addValue("TNULL" + jcol, bad.longValue(), "blank value" + forcol);
            }
            if ((dims = colwriter.getDims()) != null && dims.length > 1) {
                StringBuffer sbuf = new StringBuffer();
                for (int i = 0; i < dims.length; ++i) {
                    sbuf.append(i == 0 ? (char)'(' : ',');
                    sbuf.append(dims[i]);
                }
                sbuf.append(')');
                hdr.addValue("TDIM" + jcol, sbuf.toString(), "dimensions" + forcol);
            }
            double zero = colwriter.getZero();
            double scale = colwriter.getScale();
            if (zero != 0.0) {
                hdr.addValue("TZERO" + jcol, zero, "base" + forcol);
            }
            if (scale != 1.0) {
                hdr.addValue("TSCALE" + jcol, scale, "factor" + forcol);
            }
            if ((comm = colinfo.getDescription()) != null && comm.trim().length() > 0) {
                if (comm.length() > 67) {
                    comm = comm.substring(0, 68);
                }
                try {
                    hdr.addValue("TCOMM" + jcol, comm, null);
                }
                catch (HeaderCardException e) {
                    // empty catch block
                }
            }
            if ((ucd = colinfo.getUCD()) != null && ucd.trim().length() > 0 && ucd.length() < 68) {
                try {
                    hdr.addValue("TUCD" + jcol, ucd, null);
                }
                catch (HeaderCardException e) {
                    // empty catch block
                }
            }
            if ((utype = Tables.getUtype(colinfo)) == null || utype.trim().length() <= 0 || utype.trim().length() >= 68) continue;
            try {
                hdr.addValue("TUTYP" + jcol, utype, null);
                continue;
            }
            catch (HeaderCardException e) {
                // empty catch block
            }
        }
        return hdr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(DataOutput strm) throws IOException {
        int rowBytes = 0;
        int ncol = this.table.getColumnCount();
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnWriter writer = this.colWriters[icol];
            if (writer == null) continue;
            rowBytes += writer.getLength();
        }
        long nWritten = 0L;
        RowSequence rseq = this.table.getRowSequence();
        try {
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                for (int icol = 0; icol < ncol; ++icol) {
                    ColumnWriter writer = this.colWriters[icol];
                    if (writer == null) continue;
                    writer.writeValue(strm, row[icol]);
                }
                nWritten += (long)rowBytes;
            }
        }
        finally {
            rseq.close();
        }
        int extra = (int)(nWritten % 2880L);
        if (extra > 0) {
            strm.write(new byte[2880 - extra]);
        }
    }

    public char getFormatChar(int icol) {
        if (this.colWriters[icol] == null) {
            return '\u0000';
        }
        return this.colWriters[icol].getFormatChar();
    }

    public int[] getDimensions(int icol) {
        if (this.colWriters[icol] == null) {
            return null;
        }
        int[] dims = this.colWriters[icol].getDims();
        return dims == null ? new int[]{} : dims;
    }

    public String getBadValue(int icol) {
        if (this.colWriters[icol] == null) {
            return null;
        }
        Number badnum = this.colWriters[icol].getBadNumber();
        return badnum == null ? null : badnum.toString();
    }

    public long getRowCount() {
        return this.rowCount;
    }

    ColumnWriter createColumnWriter(ColumnInfo cinfo, int[] shape, boolean varShape, int eSize, final int maxEls, long totalEls, boolean nullableInt) {
        Class clazz = cinfo.getContentClass();
        if (clazz == String.class) {
            final int maxChars = eSize;
            final int[] dims = new int[]{maxChars};
            final byte[] buf = new byte[maxChars];
            final byte[] blankBuf = new byte[maxChars];
            int padByte = 32;
            Arrays.fill(blankBuf, (byte)32);
            return new ColumnWriter(){

                public void writeValue(DataOutput out, Object value) throws IOException {
                    byte[] bytes;
                    if (value == null) {
                        bytes = blankBuf;
                    } else {
                        int i;
                        bytes = buf;
                        String sval = (String)value;
                        int leng = Math.min(sval.length(), maxChars);
                        for (i = 0; i < leng; ++i) {
                            bytes[i] = (byte)sval.charAt(i);
                        }
                        for (i = leng; i < maxChars; ++i) {
                            bytes[i] = 32;
                        }
                    }
                    out.write(bytes);
                }

                public String getFormat() {
                    return Integer.toString(maxChars) + 'A';
                }

                public char getFormatChar() {
                    return 'A';
                }

                public int getLength() {
                    return maxChars;
                }

                public int[] getDims() {
                    return dims;
                }

                public double getZero() {
                    return 0.0;
                }

                public double getScale() {
                    return 1.0;
                }

                public Number getBadNumber() {
                    return null;
                }
            };
        }
        if (clazz == String;.class) {
            final int maxChars = eSize;
            final int[] charDims = new int[shape.length + 1];
            charDims[0] = maxChars;
            System.arraycopy(shape, 0, charDims, 1, shape.length);
            final byte[] buf = new byte[maxChars];
            int padByte = 32;
            return new ColumnWriter(){

                public void writeValue(DataOutput out, Object value) throws IOException {
                    int is;
                    if (value != null) {
                        String[] svals = (String[])value;
                        int leng = Math.min(svals.length, maxEls);
                        for (is = 0; is < leng; ++is) {
                            int ic;
                            String str = svals[is];
                            if (str != null) {
                                int sleng = Math.min(str.length(), maxChars);
                                for (ic = 0; ic < sleng; ++ic) {
                                    buf[ic] = (byte)str.charAt(ic);
                                }
                            }
                            Arrays.fill(buf, ic, maxChars, (byte)32);
                            out.write(buf);
                        }
                    }
                    if (is < maxEls) {
                        Arrays.fill(buf, (byte)32);
                        while (is < maxEls) {
                            out.write(buf);
                            ++is;
                        }
                    }
                }

                public String getFormat() {
                    return Integer.toString(maxChars * maxEls) + 'A';
                }

                public char getFormatChar() {
                    return 'A';
                }

                public int getLength() {
                    return maxChars * maxEls;
                }

                public int[] getDims() {
                    return charDims;
                }

                public double getZero() {
                    return 0.0;
                }

                public double getScale() {
                    return 1.0;
                }

                public Number getBadNumber() {
                    return null;
                }
            };
        }
        ScalarColumnWriter cw = ScalarColumnWriter.createColumnWriter(cinfo, nullableInt, this.allowSignedByte);
        if (cw != null) {
            return cw;
        }
        ArrayWriter aw = ArrayWriter.createArrayWriter(cinfo.getContentClass(), this.allowSignedByte);
        if (aw != null) {
            return new FixedArrayColumnWriter(aw, shape);
        }
        return null;
    }

    static {
        $assertionsDisabled = !StandardFitsTableSerializer.class.desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.fits");
    }

    static class FixedArrayColumnWriter
    implements ColumnWriter {
        private final ArrayWriter arrayWriter_;
        private final int[] shape_;
        private final int nel_;

        FixedArrayColumnWriter(ArrayWriter arrayWriter, int[] shape) {
            this.arrayWriter_ = arrayWriter;
            this.shape_ = shape;
            int nel = 1;
            if (shape != null) {
                for (int i = 0; i < shape.length; ++i) {
                    nel *= shape[i];
                }
            }
            this.nel_ = nel;
        }

        public void writeValue(DataOutput out, Object value) throws IOException {
            int i;
            int leng = Math.min(value == null ? 0 : Array.getLength(value), this.nel_);
            for (i = 0; i < leng; ++i) {
                this.arrayWriter_.writeElement(out, value, i);
            }
            for (i = leng; i < this.nel_; ++i) {
                this.arrayWriter_.writePad(out);
            }
        }

        public char getFormatChar() {
            return this.arrayWriter_.getFormatChar();
        }

        public String getFormat() {
            String fc = new String(new char[]{this.getFormatChar()});
            return this.nel_ == 1 ? fc : Integer.toString(this.nel_) + fc;
        }

        public int getLength() {
            return this.nel_ * this.arrayWriter_.getByteCount();
        }

        public int[] getDims() {
            return this.shape_;
        }

        public double getZero() {
            return this.arrayWriter_.getZero();
        }

        public double getScale() {
            return 1.0;
        }

        public Number getBadNumber() {
            return null;
        }
    }
}

