/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.DataProcessingParametersT;
import alma.obsprep.bo.obsproject.data.DataProcessingParametersData;
import alma.valuetypes.Angle;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Temperature;
import alma.valuetypes.UserAngle;
import alma.valuetypes.Velocity;

public class DataProcessingParameters
extends DataProcessingParametersData {
    public DataProcessingParameters(DataProcessingParametersT dataProcessingParametersT) {
        super(dataProcessingParametersT);
    }

    public void setAngularResolution(UserAngle userAngle) {
        Angle angle = Angle.createAngle((double)userAngle.getContentInUnits(UserAngle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC);
        this.setAngularResolution(angle);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setProjectType(PROJECTTYPE_CONTINUUM);
        this.getAngularResolution().setUnit(Angle.UNIT_ARCSEC);
        this.setVelocityResolution(Velocity.createVelocity());
        this.setTBSensitivityGoal(Temperature.createTemperature((double)0.0, (String)Temperature.UNIT_K));
        this.setRMSGoal(Sensitivity.createSensitivity((double)0.0, (String)Sensitivity.UNIT_JY));
    }

    public static enum AQUADataProcessingFlags {
        B2B("B2B"),
        BWSW("BWSW"),
        ASTROMETRY("Astrometry");

        private String label;

        private AQUADataProcessingFlags(String string2) {
            this.label = string2;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

