/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.PointingPatternI;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.util.astro.CoordsSystemConversionHelper;
import alma.obsprep.util.astro.PointingCoordsConverter;
import alma.valuetypes.SkyCoordinates;

public class PointingPatternAdapter
implements PointingPatternI {
    private TargetParameters targetParameters;
    private Boolean isOffsetPointingPattern = null;
    private String offsetAngleUnit;

    @Override
    public boolean isMosaic() {
        return this.targetParameters.getIsMosaic();
    }

    @Override
    public void setIsMosaic(boolean bl) {
        this.targetParameters.setIsMosaic(bl);
    }

    public PointingPatternAdapter() {
    }

    public PointingPatternAdapter(TargetParameters targetParameters) {
        this();
        this.setTargetParameters(targetParameters);
    }

    public void setTargetParameters(TargetParameters targetParameters) {
        if (targetParameters == null) {
            throw new IllegalArgumentException("targetParameters must not be null");
        }
        this.targetParameters = targetParameters;
    }

    @Override
    public SkyCoordinates getSourceCoordinates() {
        return this.targetParameters.getSourceCoordinates();
    }

    @Override
    public void originCoordinatesSystemUpdated() {
        this.matchSystemToOrigin();
    }

    @Override
    public boolean isPointingPattern() {
        return TargetParameters.TYPE_F_MULTIPLEPOINTS.equals(this.targetParameters.getType());
    }

    @Override
    public boolean isOffsetPointingPattern() {
        if (this.isOffsetPointingPattern != null) {
            return this.isOffsetPointingPattern;
        }
        if (!this.isPointingPattern()) {
            return false;
        }
        if (this.targetParameters.getFieldSinglePointCount() == 0) {
            return true;
        }
        return this.targetParameters.getFieldSinglePoint()[0].isOffsetPointingPattern();
    }

    @Override
    public void setOffsetPointingPattern(boolean bl) {
        this.isOffsetPointingPattern = bl;
    }

    @Override
    public String getOffsetAngleUnit() {
        if (this.offsetAngleUnit == null && this.isOffsetPointingPattern() && this.getPhaseCenterCoordinatesCount() > 0) {
            SkyCoordinates skyCoordinates = this.getPhaseCenterCoordinates(0);
            this.offsetAngleUnit = skyCoordinates.getLatitude().getUnit();
        }
        return this.offsetAngleUnit != null ? this.offsetAngleUnit : DEFAULT_OFFSETANGLE_UNIT;
    }

    @Override
    public void setOffsetAngleUnit(String string) {
        this.offsetAngleUnit = string;
    }

    @Override
    public void addPhaseCenterCoordinates(SkyCoordinates skyCoordinates) {
        SinglePoint singlePoint = SinglePoint.createSinglePoint(skyCoordinates);
        this.targetParameters.addField((Field)((Object)singlePoint));
    }

    @Override
    public void addPhaseCenterCoordinates(int n, SkyCoordinates skyCoordinates) {
        int n2;
        SinglePoint singlePoint = SinglePoint.createSinglePoint(skyCoordinates);
        if (n == 0) {
            n2 = 0;
        } else {
            n2 = 0;
            for (Field field : this.targetParameters.getField()) {
                if (n2 == n) break;
                if (!field.isPointingPattern()) continue;
                ++n2;
            }
        }
        if (n >= 0) {
            this.targetParameters.addField(n2, (Field)((Object)singlePoint));
        }
    }

    @Override
    public SkyCoordinates[] getPhaseCenterCoordinates() {
        SinglePoint[] singlePointArray = this.targetParameters.getFieldSinglePoint();
        SkyCoordinates[] skyCoordinatesArray = new SkyCoordinates[singlePointArray.length];
        for (int i = 0; i < singlePointArray.length; ++i) {
            skyCoordinatesArray[i] = singlePointArray[i].getCentre();
        }
        return skyCoordinatesArray;
    }

    @Override
    public SkyCoordinates getPhaseCenterCoordinates(int n) {
        SinglePoint[] singlePointArray = this.targetParameters.getFieldSinglePoint();
        return singlePointArray[n].getCentre();
    }

    @Override
    public int getPhaseCenterCoordinatesCount() {
        return this.targetParameters.getFieldSinglePointCount();
    }

    @Override
    public void removePhaseCenterCoordinates(SkyCoordinates skyCoordinates) {
        for (SinglePoint singlePoint : this.targetParameters.getFieldSinglePoint()) {
            if (singlePoint.getCentre() != skyCoordinates) continue;
            this.targetParameters.removeField((Field)((Object)singlePoint));
            return;
        }
    }

    @Override
    public int indexOf(SkyCoordinates skyCoordinates) {
        return this.indexWithinSinglePointArray(skyCoordinates);
    }

    private int indexWithinSinglePointArray(SkyCoordinates skyCoordinates) {
        int n = 0;
        for (SinglePoint singlePoint : this.targetParameters.getFieldSinglePoint()) {
            if (singlePoint.getCentre() == skyCoordinates) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public boolean isAbsolutePointingPattern() {
        return this.isPointingPattern() ? !this.isOffsetPointingPattern() : false;
    }

    public boolean isCirclePattern() {
        return false;
    }

    @Override
    public boolean isCrossPattern() {
        return false;
    }

    @Override
    public boolean isRectanglePattern() {
        return false;
    }

    @Override
    public boolean isFillPattern() {
        return false;
    }

    @Override
    public FieldPattern.FieldPatternType getFieldPatternType() {
        return FieldPattern.FieldPatternType.POINT;
    }

    @Override
    public SkyCoordinates getFieldCenterCoordinates() {
        if (this.targetParameters == null) {
            return null;
        }
        return this.targetParameters.getFieldCenterCoordinates();
    }

    @Override
    public SkyCoordinates getOrigin() {
        if (this.targetParameters == null) {
            return null;
        }
        return this.targetParameters.getOrigin();
    }

    public void matchSystemToOrigin() {
        SkyCoordinates skyCoordinates = this.getOrigin();
        if (skyCoordinates == null) {
            Log.logger((Object)this).warning("Can not determine the origin of the offset coordinates");
            return;
        }
        String string = skyCoordinates.getSystem();
        if (!CoordsSystemConversionHelper.isSupportedSystem(string)) {
            for (SkyCoordinates skyCoordinates2 : this.getPhaseCenterCoordinates()) {
                skyCoordinates2.setSystem(string);
            }
            return;
        }
        PointingCoordsConverter pointingCoordsConverter = new PointingCoordsConverter(skyCoordinates);
        if (this.isOffsetPointingPattern()) {
            for (SkyCoordinates skyCoordinates3 : this.getPhaseCenterCoordinates()) {
                if (CoordsSystemConversionHelper.isSupportedTransform(string, skyCoordinates3.getSystem())) {
                    pointingCoordsConverter.matchSystemToOrigin(skyCoordinates3);
                    continue;
                }
                skyCoordinates3.setSystem(string);
            }
        } else {
            for (SkyCoordinates skyCoordinates4 : this.getPhaseCenterCoordinates()) {
                if (CoordsSystemConversionHelper.isSupportedTransform(string, skyCoordinates4.getSystem())) {
                    skyCoordinates4.convertToSystem(string);
                    continue;
                }
                skyCoordinates4.setSystem(string);
            }
        }
    }

    public TargetParameters getTargetParameters() {
        return this.targetParameters;
    }

    @Override
    public void setPhaseCenterCoordinates(SkyCoordinates[] skyCoordinatesArray) {
        this.targetParameters.clearField();
        for (SkyCoordinates skyCoordinates : skyCoordinatesArray) {
            SinglePoint singlePoint = SinglePoint.createSinglePoint(skyCoordinates);
            this.targetParameters.addField((Field)((Object)singlePoint));
        }
    }

    @Override
    public boolean isPhase2PointingPattern() {
        return false;
    }
}

