/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproposal;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsproposal.TimeAllocationBreakdown;

public abstract class AbstractTimeAllocationStrategy {
    private final TimeAllocationBreakdown breakdown;

    public AbstractTimeAllocationStrategy(TimeAllocationBreakdown timeAllocationBreakdown) {
        this.breakdown = timeAllocationBreakdown;
        timeAllocationBreakdown.clearTimeFraction();
    }

    protected ObsProposal getProposal() {
        return this.breakdown.getProposalFeedback().getObsProposal();
    }

    protected TimeAllocationBreakdown getBreakdown() {
        return this.breakdown;
    }

    protected void allocateObservingTimeToExecutives() {
        this.allocate();
        this.testResult();
    }

    protected abstract void allocate();

    protected void testResult() {
        TimeAllocationBreakdown timeAllocationBreakdown = this.getBreakdown();
        if (!timeAllocationBreakdown.testExecutives()) {
            Log.logger((Object)this).warning("Not all executives are listed in the TimeAllocationBreakdown instance.:" + timeAllocationBreakdown.toString());
        }
        if (!timeAllocationBreakdown.testTotal()) {
            Log.logger((Object)this).warning("The total number of time fractions is not equal to 1.0.:" + timeAllocationBreakdown.toString());
        }
    }
}

