/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.events.examples;

import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventType;

public class Example2 {
    public static final EventType MSG = new EventType("MSG");
    public static final EventType START = new EventType("START");
    public static final EventType STOP = new EventType("STOP");

    public void run() {
        Controller controller = new Controller();
        Observer observer = new Observer();
        Actor actor = new Actor();
        Actor actor2 = new Actor();
        Actor actor3 = new Actor();
        Actress actress = new Actress();
        Actress actress2 = new Actress();
        EventManager.subscribeBySrc(controller, observer);
        EventManager.subscribeByType(MSG, observer);
        actor.send(1);
        actress2.send(2);
        actor3.send(41);
        controller.startObserver();
        actor.send(1);
        actress.send(1);
        actor2.send(2);
        actress2.send(2);
        actor3.send(3);
        controller.stopObserver();
        actor.send(1);
        actress2.send(2);
        actor3.send(41);
        EventManager.finish();
    }

    public static void main(String[] stringArray) {
        Example2 example2 = new Example2();
        example2.run();
    }

    private class Observer
    implements EventReceiver {
        boolean started = false;
        int total = 0;

        private Observer() {
        }

        @Override
        public void receiveEvent(Event event) {
            if (event.getType().equals(MSG)) {
                if (!this.started) {
                    return;
                }
                Integer n = (Integer)event.getData();
                this.total += n.intValue();
                System.out.println("got: " + event);
            }
            if (event.getType().equals(START)) {
                this.started = true;
            }
            if (event.getType().equals(STOP)) {
                this.started = false;
                System.out.println("Total: " + this.total);
            }
        }
    }

    private class Controller {
        private Controller() {
        }

        public void startObserver() {
            Event event = new Event(START, this, null);
            EventManager.publish(event);
        }

        public void stopObserver() {
            Event event = new Event(STOP, this, null);
            EventManager.publish(event);
        }
    }

    private class Actress
    extends Actor {
        private Actress() {
        }

        @Override
        public void send(int n) {
            super.send(-n);
        }
    }

    private class Actor {
        private Actor() {
        }

        public void send(int n) {
            Integer n2 = new Integer(n);
            Event event = new Event(MSG, this, n2);
            EventManager.publish(event);
        }
    }
}

