/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.NewProposalInteractor;
import alma.obsprep.ot.actions.NewProposalPerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.util.GUIUtilities;
import javax.swing.tree.TreePath;

public class NewProposal
extends OTAction
implements NewProposalInteractor,
RoleDirectoryService.UserAuthenticatesListener,
EventReceiver {
    private static DialogId DIALOG_SAVE_CURRENT_PROJECT = new DialogId("NewProposal.SaveCurrentProject", "Save current project before creating new proposal");
    private final ObservingToolGui gui;

    public NewProposal(ObservingToolGui observingToolGui) {
        this.gui = observingToolGui;
        NewProposalPerformer newProposalPerformer = new NewProposalPerformer(this);
        this.setPerformer(newProposalPerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
        RoleDirectoryService.addUserAuthenticatesListener(this);
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
    }

    @Override
    public void display(ObsProject obsProject) {
        this.gui.setPrimaryProject(obsProject, null, false);
        ProjectTree projectTree = this.gui.activeProjectCompartment().getProjectTreePanels().getPhase1Tree();
        ProjectTreeNode projectTreeNode = projectTree.findNodeBelow(projectTree.getTop(), ObsProposal.class);
        projectTree.select(new TreePath(projectTreeNode.getPath()));
    }

    @Override
    public boolean confirmOverwrite() {
        if (this.gui.isProjectModified(this.gui.getPrimaryProject())) {
            switch (GUIUtilities.offer(DIALOG_SAVE_CURRENT_PROJECT, "The current project has unsaved changes.\nDo you want to save it now, or discard the changes?", "Save", "Discard", "Cancel")) {
                case 2: {
                    return false;
                }
                case 0: {
                    this.gui.primaryProjectCompartment().getProjectTiedActions().save.actionPerformed(null);
                }
            }
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        return !AlmaPolicies.getInstance().isSupplementalCallEnabled() || RoleDirectoryServiceHelper.isUserP2G();
    }

    @Override
    public void userHasAuthenticated() {
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void receiveEvent(Event event) {
        this.setEnabled(this.isEnabled());
    }
}

