/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetProperties;
import alma.obsprep.ot.editors.obsproject.CalibrationTargetParametersEditor;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.obsproject.CalibrationTargetParametersModel;
import alma.obsprep.util.UnitMapConfigurator;
import alma.valuetypes.Velocity;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import lombok.NonNull;

public class CalibrationTargetParametersDialog
extends GuiFactory.Dialog {
    private boolean isCancelled = false;
    private final CalibrationTargetParametersEditor calibrationTargetParametersEditor;
    private final CalibrationTargetParametersModel calibrationTargetParametersModel;
    private CalibrationTargetParameters originalCalibrationTargetParameters;
    private static volatile CalibrationTargetParametersDialog calibrationTargetParametersDialogInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CalibrationTargetParametersDialog getInstance() {
        if (calibrationTargetParametersDialogInstance != null) return calibrationTargetParametersDialogInstance;
        Class<CalibrationTargetParametersDialog> clazz = CalibrationTargetParametersDialog.class;
        synchronized (CalibrationTargetParametersDialog.class) {
            if (calibrationTargetParametersDialogInstance != null) return calibrationTargetParametersDialogInstance;
            calibrationTargetParametersDialogInstance = new CalibrationTargetParametersDialog();
            // ** MonitorExit[var0] (shouldn't be in output)
            return calibrationTargetParametersDialogInstance;
        }
    }

    private CalibrationTargetParametersDialog() {
        this.setModal(true);
        this.calibrationTargetParametersModel = new CalibrationTargetParametersModel(null);
        this.calibrationTargetParametersEditor = new CalibrationTargetParametersEditor(this.calibrationTargetParametersModel);
        this.calibrationTargetParametersEditor.getOkButton().addActionListener(actionEvent -> this.okButtonActionPerformed());
        this.calibrationTargetParametersEditor.getCancelButton().addActionListener(actionEvent -> this.cancelButtonActionPerformed());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CalibrationTargetParametersDialog.this.okButtonActionPerformed();
            }
        });
        this.initComponents();
    }

    private void cancelButtonActionPerformed() {
        CalibrationTargetParameters calibrationTargetParameters = (CalibrationTargetParameters)this.calibrationTargetParametersModel.getDocument();
        calibrationTargetParameters.setSolarSystemObject(this.originalCalibrationTargetParameters.getSolarSystemObject());
        calibrationTargetParameters.setSourceCoordinates(this.originalCalibrationTargetParameters.getSourceCoordinates());
        calibrationTargetParameters.setSourceVelocity((Velocity)this.originalCalibrationTargetParameters.getSourceVelocity());
        calibrationTargetParameters.setSourceName(this.originalCalibrationTargetParameters.getSourceName());
        calibrationTargetParameters.setNonSiderealMotion(this.originalCalibrationTargetParameters.getNonSiderealMotion());
        calibrationTargetParameters.clearCalibrationTargetProperties();
        Stream.of(this.originalCalibrationTargetParameters.getCalibrationTargetProperties()).forEach(calibrationTargetProperties -> calibrationTargetParameters.addCalibrationTargetProperties((CalibrationTargetProperties)((Object)calibrationTargetProperties)));
        this.isCancelled = true;
        this.setVisible(false);
        this.dispose();
    }

    public void setDocument(@NonNull CalibrationTargetParameters calibrationTargetParameters) {
        if (calibrationTargetParameters == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        this.originalCalibrationTargetParameters = calibrationTargetParameters.deepCopy();
        this.calibrationTargetParametersModel.setDocument(calibrationTargetParameters);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.pack();
            this.rescaleToMonitor(0.75);
        }
        super.setVisible(bl);
    }

    private void okButtonActionPerformed() {
        this.setVisible(false);
        this.isCancelled = false;
        this.dispose();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Calibrator Target Editor");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.calibrationTargetParametersEditor, gridBagConstraints);
        this.pack();
        this.getRootPane().setDefaultButton(this.calibrationTargetParametersEditor.getOkButton());
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        CalibrationTargetParameters calibrationTargetParameters = CalibrationTargetParameters.createCalibrationTargetParameters();
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, exception);
            }
            CalibrationTargetParametersDialog calibrationTargetParametersDialog = CalibrationTargetParametersDialog.getInstance();
            calibrationTargetParametersDialog.setDocument(calibrationTargetParameters);
            calibrationTargetParametersDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            calibrationTargetParametersDialog.setVisible(true);
        });
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }
}

