/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.FieldTypeInfo;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.guiutil.mvc.widgets.OTComboBox;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.NonNegativeVerifier;
import alma.obsprep.ot.boEditors.NonResettingNegativeVerifier;
import alma.obsprep.ot.editors.sciencegoals.EstimatedTimeInfoBuilder;
import alma.obsprep.ot.editors.sciencegoals.MonitoringConstraintListEditor;
import alma.obsprep.ot.editors.sciencegoals.TargetParametersEditor;
import alma.obsprep.ot.editors.sciencegoals.TimeEstimateInterface;
import alma.obsprep.ot.editors.sciencegoals.TimingConstraintsListEditor;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintListEditor;
import alma.obsprep.ot.editors.valuetypes.UserUnitValueUnitPairEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairView;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.models.sciencegoals.MonitoringConstraintsListModel;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.ot.models.sciencegoals.TimingConstraintsListModel;
import alma.obsprep.ot.models.sciencegoals.VisitConstraintsListModel;
import alma.obsprep.ot.models.valuetypes.AbstractValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.UserUnitValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.sfi.ScienceGoalEditorViewEnum;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Length;
import alma.valuetypes.Time;
import alma.valuetypes.UserUnitValueUnitPair;
import alma.valuetypes.data.UserSensitivityData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.help.CSH;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import lombok.NonNull;

public class SfiControlParameterEditor
extends EditorWithGridBagLayout {
    private static final String ENTER_TOTAL_TIME_ESTIMATE = "Enter total time estimate";
    private static final long serialVersionUID = 7560875029910062299L;
    private static boolean isUseACA = false;
    public static final FieldID FID_ANGULARRESOLUTION_VUP = new FieldID("SfiControl.angularResolution.vup");
    public static final FieldID FID_ANGULARRESOLUTIONDELIMITER_VUP = new FieldID("SfiControl.angularResolutionDelimiter.vup");
    public static final FieldID FID_AR_FOR_SENS_EQUIV_FIELD_ONE_VUP = new FieldID("SfiControl.arForSensEquivalenceFieldOne.vup");
    public static final FieldID FID_AR_FOR_SENS_EQUIV_FIELD_TWO_VUP = new FieldID("SfiControl.arForSensEquivalenceFieldTwoi.vup");
    public static final FieldID FID_ANGULARRESOLUTIONMODE = new FieldID("SfiControl.angularResolutionMode");
    public static final FieldID FID_ISPOINTSOURCE = new FieldID("SfiControl.isPointSource");
    public static final FieldID FID_EXTENDEDSOURCE = new FieldID("SfiControl.extendedSource");
    public static final FieldID FID_LARGESTSCALE_VUP = new FieldID("SfiControl.largestScale");
    public static final FieldID FID_SENSITIVITY_VUP = new FieldID("SfiControl.sensitivity.vup");
    public static final FieldID FID_SENSITIVITY_FB_FIELD_ONE_RESOLUTION_VUP = new FieldID("SfiControl.sensitivityFBcoarseResolution.vup");
    public static final FieldID FID_SENSITIVITY_FB_FIELD_TWO_RESOLUTION_VUP = new FieldID("SfiControl.sensitivityFBfineResolution.vup");
    public static final FieldID FID_FREQUENCY_MEASURES_SPECLINE = new FieldID("SfiControl.frequencyMeasures");
    public static final FieldID FID_FREQUENCY_MEASURES_CONT = new FieldID("SfiControl.frequencyMeasuresCont");
    public static final FieldID FID_FREQUENCY_MEASURES_SPECSCAN = new FieldID("SfiControl.frequencyMeasuresSpectralScan");
    public static final FieldID FID_DESIRED_SENSITIVITY_EQUIVALENCE_LABEL = new FieldID("SfiControl.desiredSensitivityEquivlanceLabel");
    public static final FieldID FID_FREQUENCY_WIDTH_LABEL = new FieldID("SfiControl.frequencyWidthLabel");
    public static final FieldID FID_BANDWIDTH_USED_FOR_SENSITIVITY_LABEL = new FieldID("SfiControl.bandwidthUsedForSensitivityLabel");
    public static final FieldID FID_DESIRED_ANGULAR_RESOLUTION_LABEL = new FieldID("SfiControl.desiredAngularResolution");
    public static final FieldID FID_LARGEST_ANGULAR_STRUCTURE_LABEL = new FieldID("SfiControl.largestAngularStructureLabel");
    public static final FieldID FID_FREQUENCYWIDTH = new FieldID("SfiControl.frequencyWidth");
    public static final FieldID FID_FREQUENCYWIDTH_VUP = new FieldID("SfiControl.frequencyWidth.vup");
    public static final FieldID FID_DYNAMICRANGE = new FieldID("SfiControl.dynamicRange");
    public static final FieldID FID_TIMEESTIMATEBUTTON = new FieldID("SfiControl.btnTimeEstimate");
    public static final FieldID FID_TIMEESTIMATELABEL = new FieldID("SfiControl.timeEstimateLabel");
    public static final FieldID FID_NEEDSMORETIME = new FieldID("SfiControl.needsMoreTime");
    public static final FieldID FID_DESIREDTIME_VUP = new FieldID("SfiControl.desiredTime");
    public static final FieldID FID_DESIREDTIME_VALUE = new FieldID("SfiControl.desiredTime.value");
    public static final FieldID FID_DESIREDTIME_UNIT = new FieldID("SfiControl.desiredTime.unit");
    public static final FieldID FID_DESIREDTIME_LABEL = new FieldID("SfiControl.desiredTimeLabel");
    public static final FieldID FID_ACAOBSERVATION = new FieldID("SfiControl.ACAObservation");
    public static final FieldID FID_ISTIMECONST = new FieldID("SfiControl.isTimeConst");
    public static final FieldID FID_TYPE_OF_TIME_CONSTRAINT = new FieldID("SfiControl.typeOfTimeConstraint");
    public static final FieldID FID_TIME_CONSTRAINED_OBSERVING_LABEL = new FieldID("SfiControl.timeConstrainedObservingLabel");
    public static final FieldID FID_START_TIME = new FieldID("SfiControl.startTime");
    public static final FieldID FID_END_TIME = new FieldID("SfiControl.endTime");
    public static final FieldID FID_ALLOWED_MARGIN_VALUE = new FieldID("SfiControl.allowedMargin.value");
    public static final FieldID FID_ALLOWED_MARGIN_UNIT = new FieldID("SfiControl.allowedMargin.unit");
    public static final FieldID FID_TEMPORAL_NOTE = new FieldID("SfiControl.temporalNote");
    public static final FieldID FID_TEMPORAL_NOTE_ENABLED = new FieldID("SfiControl.temporalNoteEnabled");
    public static final FieldID FID_BEAMSIZE_12M = new FieldID("SfiControl.beamSize12m");
    public static final FieldID FID_BEAMSIZE_7M = new FieldID("SfiControl.beamSize7m");
    public static final FieldID FID_MAXBASELINE_LENGTH = new FieldID("SfiControl.maxBaselineLength");
    public static final FieldID FID_MOSTEXTENDEDBASELINE_BEAMSIZE = new FieldID("SfiControl.maxBaselineBeamsize");
    public static final FieldID FID_COMPACTMAXBASELINE_LENGTH = new FieldID("SfiControl.compactMaxBaselineLength");
    public static final FieldID FID_COMPACTMAXBASELINE_BEAMSIZE = new FieldID("SfiControl.compactMaxBaselineBeamsize");
    public static final FieldID FID_MINBASELINE_LENGTH = new FieldID("SfiControl.minBaselineLength");
    public static final FieldID FID_MINBASELINE_SCALE = new FieldID("SfiControl.minBaselineScale");
    public static final FieldID FID_COMPACTMINBASELINE_LENGTH = new FieldID("SfiControl.compactMinBaselineLength");
    public static final FieldID FID_COMPACTMINBASELINE_SCALE = new FieldID("SfiControl.compactMinBaselineScale");
    public static final FieldID FID_ACA7MMAXBASELINE_LENGTH = new FieldID("SfiControl.aca7mMinBaselineScale");
    public static final FieldID FID_ACA7MMAXBASELINE_BEAMSIZE = new FieldID("SfiControl.aca7mMinBaselineScale");
    public static final FieldID FID_ACA7MMINBASELINE_LENGTH = new FieldID("SfiControl.aca7mMinBaselineScale");
    public static final FieldID FID_ACA7MMINBASELINE_SCALE = new FieldID("SfiControl.aca7mMinBaselineScale");
    public static final FieldID FID_ACA_SENSITIVITY_VUP = new FieldID("SfiControl.ACASensitivity.vup");
    public static final FieldID FID_ACA_SENSITIVITY_FB_VUP = new FieldID("SfiControl.ACASensitivityFB.vup");
    public static final FieldID FID_TP_SENSITIVITY_VUP = new FieldID("SfiControl.TPSensitivity.vup");
    public static final FieldID FID_TP_SENSITIVITY_FB_VUP = new FieldID("SfiControl.TPSensitivityFB.vup");
    private static final FieldID FID_CONFIGURATION_PANEL = new FieldID("SfiControl.ConfigurationPanel");
    private static final FieldID FID_OVERRIDE_LABEL = new FieldID("SfiControl.overrideLabel.label");
    public static final FieldID FID_IS_SIMULTANEOUS_12_AND_7 = new FieldID("IsSimultaneous12and7");
    public static final FieldID FID_IS_SIMULTANEOUS_12_AND_7_POSSIBLE = new FieldID("IsSimultaneous12and7Possible");
    public static final FieldID FID_SOLARINTEGRATION_DURATION = new FieldID("SolarIntegrationDuration");
    public static final FieldID FID_SOLARINTEGRATION_DURATION_LABEL = new FieldID("SolarIntegrationDurationLabel");
    private static final FieldID FID_SENSITIVITY_CONTAINER = new FieldID("SfiControl.sensitivityContainer");
    private static final FieldID FID_BW_FOR_SENSITIVITY_CONTAINER = new FieldID("SfiControl.bwForSensitivityContainer");
    public static final FieldID FID_NO_ANTENNA_12M = new FieldID("SfiControl.noOfAntennas12M");
    public static final FieldID FID_NO_ANTENNA_7M = new FieldID("SfiControl.noOfAntennas7M");
    public static final FieldID FID_NO_ANTENNA_TP = new FieldID("SfiControl.noOfAntennasTP");
    public static final FieldID FID_EDITORVIEW = new FieldID("SfiControl.editorView");
    public static final FieldID FID_SPECTRALTYPE = new FieldID("SfiControl.SpectralType");
    static final Map<FieldID, String> tooltips = new HashMap<FieldID, String>();
    private final boolean isCollapsed;
    public static final String CHOICE_YES = "Yes";
    public static final String CHOICE_NO = "No";
    private static final String LABEL_SENSITIVITY_SINGLEPOINT = "Desired sensitivity per pointing";
    private static final String LABEL_SENSITIVITY_MOSAIC = "Desired mosaic sensitivity";
    private OTButtonGroup typeOfTimeConstraintGroup;
    private OTButtonGroup isSimultaneous12AndACA;
    public static final String TIMECONST_YES = "Yes";
    public static final String TIMECONST_NO = "No";
    public final String[] isTimeConstrainedOptions = new String[]{"Yes", "No"};
    public static final String TIMECONST_VISIT;
    public static final String TIMECONST_TIME;
    public static final String TIMECONST_NONE;
    private static final String[] typeOfTimeConstraintOptions;
    private static final String[] typeOfTimeConstraintTooltips;
    private Set<JComponent> tempConstrainedComps = new HashSet<JComponent>();
    private Set<JComponent> visitConstrainedComps = new HashSet<JComponent>();
    private Set<JComponent> monitoringConstrainedComps = new HashSet<JComponent>();
    private final Set<JComponent> anyTimeConstrainedComps = new HashSet<JComponent>();
    private final Set<JComponent> desiredSensitivityComps = new HashSet<JComponent>();
    public static final String NEEDSMORETIME_YES = "Yes";
    public static final String NEEDSMORETIME_NO = "No";
    public final String[] needsMoreTimeOptions = new String[]{"Yes", "No"};
    private JLabel sensitivityTypeLabel;
    private boolean isSensitivityWidgetsVisible = true;
    private ScienceGoalEditorViewEnum currentView = ScienceGoalEditorViewEnum.DEFAULTVIEW;
    private static final String OVERRIDE_LABEL_TEXT = "<html>Override OT's sensitivity-based <BR>time estimate (must be justified)</html>";
    public static final FieldID FID_DESIRED_SENSITIVITY_EQUIVALENCE_SEPARATOR_LABEL;
    private static final FieldID FID_SENSITIVITY_FINE_CONTAINER;
    private OTButtonGroup angularResolutionModeButtonGroup;
    private JPanel angularResolutionRangeSpecificationContainer;
    private ValueUnitPairEditor angularResolutionDelimiterEditor;
    private JLabel angularResolutionRangeDelimiterLabel;
    private final String[] angularResolutionAnyRestrictedUnits = new String[]{UserSensitivityData.USERUNIT_JY, UserSensitivityData.USERUNIT_MJY, UserSensitivityData.USERUNIT_UJY};
    private Boolean isAngularResolutionSpecifiersEqual = false;
    private Boolean isMultipleEquivalanceFieldsDisplayed = false;

    public SfiControlParameterEditor(Model model, boolean bl) {
        this.setModel(model);
        this.isCollapsed = bl;
        this.build();
        model.publish();
    }

    public SfiControlParameterEditor(Model model) {
        this(model, true);
    }

    private SfiControlParameterModel getMyModel() {
        return (SfiControlParameterModel)this.getModel();
    }

    @Override
    protected JPanel addGroup(JComponent jComponent, String string) {
        if (this.isCollapsed) {
            return super.addGroup(jComponent, string);
        }
        return (JPanel)this.addNonCollapsingGroup(jComponent, string);
    }

    @Override
    protected void build() {
        super.build("Control and Performance");
    }

    private JPanel myCreateLineContainer() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 10, 5));
        return jPanel;
    }

    private JPanel createConfigurationInformationPanel() {
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 11;
        JPanel jPanel = new JPanel();
        this.register(jPanel, FID_CONFIGURATION_PANEL);
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        JPanel jPanel2 = this.myCreateLineContainer();
        JLabel jLabel = this.makeLabel("12m");
        jPanel2.add(jLabel);
        jLabel.setHorizontalAlignment(4);
        jPanel2.add(this.makeTextField(FID_BEAMSIZE_12M, 15, false, tooltips.get(FID_BEAMSIZE_12M)));
        if (this.displaysUseACAChoice()) {
            jPanel2.add(this.makeLabel("7m"));
            jPanel2.add(this.makeTextField(FID_BEAMSIZE_7M, 15, false, tooltips.get(FID_BEAMSIZE_7M)));
        }
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.makeLabel("<html>Antenna Beamsize ( " + Antenna.BEAMSIZE_TIP_STRING + " )</html>"), (JComponent)jPanel2);
        jPanel2 = this.myCreateLineContainer();
        jPanel2.add(this.makeLabel("12m"));
        jPanel2.add(this.makeTextField(FID_NO_ANTENNA_12M, 15, false, tooltips.get(FID_NO_ANTENNA_12M)));
        jPanel2.add(this.makeLabel("7m"));
        jPanel2.add(this.makeTextField(FID_NO_ANTENNA_7M, 15, false, tooltips.get(FID_NO_ANTENNA_7M)));
        jPanel2.add(this.makeLabel("TP"));
        jPanel2.add(this.makeTextField(FID_NO_ANTENNA_TP, 15, false, tooltips.get(FID_NO_ANTENNA_TP)));
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.makeLabel("<html>Number of Antennas</html>"), (JComponent)jPanel2);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel(""));
        jPanel2 = this.myCreateLineContainer();
        jLabel = this.makeLabel("ACA 7m configuration      ");
        jPanel2.add(jLabel);
        jLabel.setHorizontalAlignment(0);
        jLabel = this.makeLabel("<html>&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; &nbsp;Most compact 12m configuration</html>");
        jPanel2.add(jLabel);
        jLabel.setHorizontalAlignment(0);
        jLabel = this.makeLabel("<HTML>&nbsp;Most extended 12m configuration</html>");
        jPanel2.add(jLabel);
        jLabel.setHorizontalAlignment(0);
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.makeLabel("<html>&nbsp;</html>"), (JComponent)jPanel2);
        jPanel2 = this.myCreateLineContainer();
        jPanel2.add(this.makeTextField(FID_ACA7MMAXBASELINE_LENGTH, 15, false, tooltips.get(FID_ACA7MMAXBASELINE_LENGTH)));
        jPanel2.add(this.makeTextField(FID_COMPACTMAXBASELINE_LENGTH, 15, false, tooltips.get(FID_COMPACTMAXBASELINE_LENGTH)));
        jPanel2.add(this.makeTextField(FID_MAXBASELINE_LENGTH, 15, false, tooltips.get(FID_MAXBASELINE_LENGTH)));
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.makeLabel("<html>Longest baseline</html>"), (JComponent)jPanel2);
        jPanel2 = this.myCreateLineContainer();
        jPanel2.add(this.makeTextField(FID_ACA7MMAXBASELINE_BEAMSIZE, 15, false, true, tooltips.get(FID_ACA7MMAXBASELINE_BEAMSIZE)));
        jPanel2.add(this.makeTextField(FID_COMPACTMAXBASELINE_BEAMSIZE, 15, false, true, tooltips.get(FID_COMPACTMAXBASELINE_BEAMSIZE)));
        jPanel2.add(this.makeTextField(FID_MOSTEXTENDEDBASELINE_BEAMSIZE, 15, false, true, tooltips.get(FID_MOSTEXTENDEDBASELINE_BEAMSIZE)));
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.makeLabel("<html>Synthesized beamsize</html>"), (JComponent)jPanel2);
        jPanel2 = this.myCreateLineContainer();
        jPanel2.add(this.makeTextField(FID_ACA7MMINBASELINE_LENGTH, 15, false, tooltips.get(FID_ACA7MMINBASELINE_LENGTH)));
        jPanel2.add(this.makeTextField(FID_COMPACTMINBASELINE_LENGTH, 15, false, tooltips.get(FID_COMPACTMINBASELINE_LENGTH)));
        jPanel2.add(this.makeTextField(FID_MINBASELINE_LENGTH, 15, false, tooltips.get(FID_MINBASELINE_LENGTH)));
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.makeLabel("<html>Shortest baseline</html>"), (JComponent)jPanel2);
        jPanel2 = this.myCreateLineContainer();
        jPanel2.add(this.makeTextField(FID_ACA7MMINBASELINE_SCALE, 15, false, true, tooltips.get(FID_ACA7MMINBASELINE_SCALE)));
        jPanel2.add(this.makeTextField(FID_COMPACTMINBASELINE_SCALE, 15, false, true, tooltips.get(FID_COMPACTMINBASELINE_SCALE)));
        jPanel2.add(this.makeTextField(FID_MINBASELINE_SCALE, 15, false, true, tooltips.get(FID_MINBASELINE_SCALE)));
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.makeLabel("<html>Maximum recoverable scale</html>"), (JComponent)jPanel2);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    private JPanel createDesiredPerformanceInputPanel() {
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 11;
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        SfiControlParameterModel sfiControlParameterModel = this.getMyModel();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("fraction of antenna beamsize", "fraction of main beam");
        ValueUnitPairEditor valueUnitPairEditor = new UserUnitValueUnitPairEditor(sfiControlParameterModel.getAngularResolutionModel(), hashMap);
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(valueUnitPairEditor));
        valueUnitPairEditor.setToolTipText(tooltips.get(FID_ANGULARRESOLUTION_VUP));
        this.register(valueUnitPairEditor, FID_ANGULARRESOLUTION_VUP);
        this.registerSubView(valueUnitPairEditor);
        this.angularResolutionDelimiterEditor = new UserUnitValueUnitPairEditor(sfiControlParameterModel.getAcceptableAngularResolutionModel(), hashMap);
        this.angularResolutionDelimiterEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(this.angularResolutionDelimiterEditor));
        this.angularResolutionDelimiterEditor.setToolTipText(tooltips.get(FID_ANGULARRESOLUTIONDELIMITER_VUP));
        this.register(this.angularResolutionDelimiterEditor, FID_ANGULARRESOLUTIONDELIMITER_VUP);
        this.registerSubView(this.angularResolutionDelimiterEditor);
        this.angularResolutionDelimiterEditor.setUnitDropdownMenuEditable(false);
        JLabel jLabel = this.makeLabel(FID_DESIRED_ANGULAR_RESOLUTION_LABEL, "Desired Angular Resolution (Synthesized Beam)", "");
        this.angularResolutionModeButtonGroup = this.makeOTButtonGroup(FID_ANGULARRESOLUTIONMODE, AngularResolutionMode.values(), new String[]{"A single demanded angular resolution", "A range of demanded angular resolutions", "Any angular resolution", "An angular resolution that complies with the requirements for standalone ACA"});
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(jLabel, this.angularResolutionModeButtonGroup);
        gridBagConstraints.gridx = 0;
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.angularResolutionRangeSpecificationContainer = this.createLineContainer();
        this.angularResolutionRangeSpecificationContainer.add(valueUnitPairEditor);
        this.angularResolutionRangeDelimiterLabel = new JLabel(" to ");
        this.angularResolutionRangeSpecificationContainer.add(this.angularResolutionRangeDelimiterLabel);
        this.angularResolutionRangeSpecificationContainer.add(this.angularResolutionDelimiterEditor);
        componentCollection = new ComponentCollection();
        componentCollection.remember(new JLabel(""), this.angularResolutionRangeSpecificationContainer);
        gridBagConstraints.gridx = 0;
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection.remember(new JLabel(""));
        componentCollection = new ComponentCollection();
        valueUnitPairEditor = new ValueUnitPairEditor((AbstractValueUnitPairModel)sfiControlParameterModel.getLargestScaleModel(), Angle.units_sec_min_deg);
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new NonResettingNegativeVerifier(valueUnitPairEditor, true));
        valueUnitPairEditor.setToolTipText(tooltips.get(FID_LARGESTSCALE_VUP));
        this.register(valueUnitPairEditor, FID_LARGESTSCALE_VUP);
        this.registerSubView(valueUnitPairEditor);
        JLabel jLabel2 = this.makeLabel(FID_LARGEST_ANGULAR_STRUCTURE_LABEL, "Largest Angular Structure in source", "");
        componentCollection.remember(jLabel2, valueUnitPairEditor);
        gridBagConstraints.gridx = 0;
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        JPanel jPanel2 = new JPanel();
        Box box = Box.createHorizontalBox();
        jPanel2.add(box);
        this.register(jPanel2, FID_SENSITIVITY_CONTAINER);
        UserUnitValueUnitPairEditor userUnitValueUnitPairEditor = new UserUnitValueUnitPairEditor(sfiControlParameterModel.getSensitivityModel());
        userUnitValueUnitPairEditor.setRestrictedUnits(this.angularResolutionAnyRestrictedUnits);
        this.register(userUnitValueUnitPairEditor, FID_SENSITIVITY_VUP);
        this.registerSubView(userUnitValueUnitPairEditor);
        userUnitValueUnitPairEditor.setToolTipText(tooltips.get(FID_SENSITIVITY_VUP));
        userUnitValueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(userUnitValueUnitPairEditor));
        ValueUnitPairView.Builder builder = new ValueUnitPairView.Builder();
        builder.formatString("@ %.3g %s");
        builder.abstractValueUnitPairModel(sfiControlParameterModel.getCoarseARRangeModel()).fieldWidth(10);
        builder.unitsToDisplayManager((fieldID, valueUnitPair) -> new String[]{Angle.UNIT_ARCSEC});
        builder.principalIdentifier(FID_AR_FOR_SENS_EQUIV_FIELD_ONE_VUP);
        builder.isLabel(true);
        ValueUnitPairView valueUnitPairView = builder.build();
        valueUnitPairView.getInput().setName("SfiControlParameterEditor.arFieldOne");
        this.register(valueUnitPairView, FID_AR_FOR_SENS_EQUIV_FIELD_ONE_VUP);
        this.registerSubView(valueUnitPairView);
        valueUnitPairView.setToolTipText(tooltips.get(FID_AR_FOR_SENS_EQUIV_FIELD_ONE_VUP));
        ValueUnitPairView.Builder builder2 = new ValueUnitPairView.Builder();
        builder2.formatString("@ %.3g %s");
        builder2.unitsToDisplayManager((fieldID, valueUnitPair) -> new String[]{Angle.UNIT_ARCSEC});
        builder2.abstractValueUnitPairModel(sfiControlParameterModel.getFineARRangeModel()).fieldWidth(8);
        builder2.principalIdentifier(FID_AR_FOR_SENS_EQUIV_FIELD_TWO_VUP);
        builder2.isLabel(true);
        ValueUnitPairView valueUnitPairView2 = builder2.build();
        valueUnitPairView2.getInput().setName("SfiControlParameterEditor.arFieldTwo");
        this.register(valueUnitPairView2, FID_AR_FOR_SENS_EQUIV_FIELD_TWO_VUP);
        this.registerSubView(valueUnitPairView2);
        valueUnitPairView2.setToolTipText(tooltips.get(FID_AR_FOR_SENS_EQUIV_FIELD_TWO_VUP));
        ValueUnitPairView.Builder builder3 = new ValueUnitPairView.Builder();
        builder3.abstractValueUnitPairModel(sfiControlParameterModel.getFeedbackCoarseResolutionModel()).fieldWidth(10);
        builder3.unitsToDisplayManager(sfiControlParameterModel::getUnitCategoryForDisplay);
        builder3.principalIdentifier(FID_SENSITIVITY_FB_FIELD_ONE_RESOLUTION_VUP);
        ValueUnitPairView valueUnitPairView3 = builder3.build();
        valueUnitPairView3.getInput().setName("SfiControlParameterEditor.EquivalentToCoarseResolutionText");
        this.register(valueUnitPairView3, FID_SENSITIVITY_FB_FIELD_ONE_RESOLUTION_VUP);
        this.registerSubView(valueUnitPairView3);
        valueUnitPairView3.setToolTipText(tooltips.get(FID_SENSITIVITY_FB_FIELD_ONE_RESOLUTION_VUP));
        ValueUnitPairView.Builder builder4 = new ValueUnitPairView.Builder();
        builder4.abstractValueUnitPairModel(sfiControlParameterModel.getFeedbackFineResolutionModel()).fieldWidth(10);
        builder4.unitsToDisplayManager(sfiControlParameterModel::getUnitCategoryForDisplay);
        builder4.principalIdentifier(FID_SENSITIVITY_FB_FIELD_TWO_RESOLUTION_VUP);
        ValueUnitPairView valueUnitPairView4 = builder4.build();
        valueUnitPairView4.getInput().setName("SfiControlParameterEditor.EquivalentToFineResolutionText");
        this.register(valueUnitPairView4, FID_SENSITIVITY_FB_FIELD_TWO_RESOLUTION_VUP);
        this.registerSubView(valueUnitPairView4);
        valueUnitPairView4.setToolTipText(tooltips.get(FID_SENSITIVITY_FB_FIELD_TWO_RESOLUTION_VUP));
        gridBagConstraints.gridx = 0;
        this.sensitivityTypeLabel = this.makeLabel(LABEL_SENSITIVITY_SINGLEPOINT);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.sensitivityTypeLabel);
        box.add(userUnitValueUnitPairEditor);
        JLabel jLabel3 = this.makeLabel(FID_DESIRED_SENSITIVITY_EQUIVALENCE_LABEL, "equivalent to", "");
        box.add(jLabel3);
        box.add(valueUnitPairView3);
        box.add(valueUnitPairView);
        box.add(Box.createHorizontalGlue());
        this.addComponent(5, jPanel, gridBagLayout, gridBagConstraints, jPanel2);
        JPanel jPanel3 = new JPanel();
        this.register(jPanel3, FID_SENSITIVITY_FINE_CONTAINER);
        box = Box.createHorizontalBox();
        jPanel3.add(box);
        JLabel jLabel4 = this.makeLabel(FID_DESIRED_SENSITIVITY_EQUIVALENCE_SEPARATOR_LABEL, "will provide ", "");
        box.add(Box.createRigidArea(new Dimension(150, 5)));
        box.add(jLabel4);
        box.add(valueUnitPairView4);
        box.add(valueUnitPairView2);
        box.add(Box.createHorizontalGlue());
        gridBagConstraints.gridx = 0;
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, new JLabel(""));
        this.addComponent(5, jPanel, gridBagLayout, gridBagConstraints, jPanel3);
        JPanel jPanel4 = this.createLineContainer();
        this.register(jPanel4, FID_BW_FOR_SENSITIVITY_CONTAINER);
        JLabel jLabel5 = new JLabel("Bandwidth used for Sensitivity");
        this.initEvents(jLabel5, FID_BANDWIDTH_USED_FOR_SENSITIVITY_LABEL);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jLabel5);
        String[] stringArray = PerformanceParameters.getKnownDesiredSensitivityFrequencyMeasureList();
        String[] stringArray2 = new String[]{PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_AGGREGATEBANDWIDTH};
        String[] stringArray3 = new String[]{PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_AGGREGATEBANDWIDTH, PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_LARGESTWINDOWBANDWIDTH, PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_FINESTRESOLUTION, PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_USER};
        jPanel4.add(this.makeComboBox(FID_FREQUENCY_MEASURES_SPECLINE, stringArray, tooltips.get(FID_FREQUENCY_MEASURES_SPECLINE)));
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel4.add(this.makeComboBox(FID_FREQUENCY_MEASURES_CONT, stringArray2, tooltips.get(FID_FREQUENCY_MEASURES_SPECLINE)));
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel4.add(this.makeComboBox(FID_FREQUENCY_MEASURES_SPECSCAN, stringArray3, tooltips.get(FID_FREQUENCY_MEASURES_SPECLINE)));
        jPanel4.add(Box.createHorizontalStrut(5));
        JLabel jLabel6 = this.makeLabel("Frequency Width ");
        this.initEvents(jLabel6, FID_FREQUENCY_WIDTH_LABEL);
        jPanel4.add(jLabel6);
        userUnitValueUnitPairEditor = new UserUnitValueUnitPairEditor(sfiControlParameterModel.getFrequencyWidthModel());
        userUnitValueUnitPairEditor.setVisible(false);
        userUnitValueUnitPairEditor.setToolTipText(tooltips.get(FID_FREQUENCYWIDTH_VUP));
        this.register(userUnitValueUnitPairEditor, FID_FREQUENCYWIDTH_VUP);
        this.registerSubView(userUnitValueUnitPairEditor);
        jPanel4.add(userUnitValueUnitPairEditor);
        JTextField jTextField = this.makeTextField(FID_FREQUENCYWIDTH, false, tooltips.get(FID_FREQUENCYWIDTH));
        jPanel4.add(jTextField);
        this.addComponent(5, jPanel, gridBagLayout, gridBagConstraints, jPanel4);
        JPanel jPanel5 = this.createLineContainer();
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        componentCollection = new ComponentCollection();
        userUnitValueUnitPairEditor = new UserUnitValueUnitPairEditor(sfiControlParameterModel.getACASensitivityModel());
        userUnitValueUnitPairEditor.setEditable(false);
        this.register(userUnitValueUnitPairEditor, FID_ACA_SENSITIVITY_VUP);
        this.registerSubView(userUnitValueUnitPairEditor);
        userUnitValueUnitPairEditor.setToolTipText(tooltips.get(FID_ACA_SENSITIVITY_VUP));
        JLabel jLabel7 = this.makeLabel("Determined ACA Sensitivity");
        componentCollection.remember(jLabel7);
        componentCollection.remember(userUnitValueUnitPairEditor);
        this.desiredSensitivityComps.add(jLabel7);
        this.desiredSensitivityComps.add(userUnitValueUnitPairEditor);
        valueUnitPairEditor = new ValueUnitPairEditor(sfiControlParameterModel.getACAFeedbackModel());
        valueUnitPairEditor.setEditable(false);
        this.register(valueUnitPairEditor, FID_ACA_SENSITIVITY_FB_VUP);
        this.registerSubView(valueUnitPairEditor);
        valueUnitPairEditor.setToolTipText(tooltips.get(FID_ACA_SENSITIVITY_FB_VUP));
        jLabel7 = this.makeLabel("equivalent to");
        componentCollection.remember(jLabel7);
        componentCollection.remember(valueUnitPairEditor);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.desiredSensitivityComps.add(jLabel7);
        this.desiredSensitivityComps.add(valueUnitPairEditor);
        componentCollection = new ComponentCollection();
        userUnitValueUnitPairEditor = new UserUnitValueUnitPairEditor(sfiControlParameterModel.getTPSensitivityModel());
        userUnitValueUnitPairEditor.setEditable(false);
        this.register(userUnitValueUnitPairEditor, FID_TP_SENSITIVITY_VUP);
        this.registerSubView(userUnitValueUnitPairEditor);
        userUnitValueUnitPairEditor.setToolTipText(tooltips.get(FID_TP_SENSITIVITY_VUP));
        jLabel7 = this.makeLabel("Determined TP Sensitivity");
        componentCollection.remember(jLabel7);
        componentCollection.remember(userUnitValueUnitPairEditor);
        this.desiredSensitivityComps.add(jLabel7);
        this.desiredSensitivityComps.add(userUnitValueUnitPairEditor);
        valueUnitPairEditor = new ValueUnitPairEditor(sfiControlParameterModel.getTPFeedbackModel());
        valueUnitPairEditor.setEditable(false);
        this.register(valueUnitPairEditor, FID_TP_SENSITIVITY_FB_VUP);
        this.registerSubView(valueUnitPairEditor);
        valueUnitPairEditor.setToolTipText(tooltips.get(FID_TP_SENSITIVITY_FB_VUP));
        jLabel7 = this.makeLabel("equivalent to");
        componentCollection.remember(jLabel7);
        componentCollection.remember(valueUnitPairEditor);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.desiredSensitivityComps.add(jLabel7);
        this.desiredSensitivityComps.add(valueUnitPairEditor);
        jPanel5 = this.createLineContainer();
        OTButtonGroup oTButtonGroup = this.makeOTButtonGroup(FID_NEEDSMORETIME, this.needsMoreTimeOptions, tooltips.get(FID_NEEDSMORETIME));
        JLabel jLabel8 = this.makeLabel(ENTER_TOTAL_TIME_ESTIMATE);
        valueUnitPairEditor = new ValueUnitPairEditor((AbstractValueUnitPairModel)sfiControlParameterModel.getDesiredTimeModel(), Time.units_s_min_h);
        valueUnitPairEditor.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(valueUnitPairEditor));
        valueUnitPairEditor.setToolTipText(tooltips.get(FID_DESIREDTIME_VUP));
        this.register(jLabel8, FID_DESIREDTIME_LABEL);
        this.register(valueUnitPairEditor, FID_DESIREDTIME_VUP);
        this.registerSubView(valueUnitPairEditor);
        jPanel5.add(oTButtonGroup);
        jPanel5.add(Box.createHorizontalStrut(5));
        jPanel5.add(jLabel8);
        jPanel5.add(Box.createHorizontalStrut(5));
        oTButtonGroup.setPreferredSize(new Dimension((int)oTButtonGroup.getPreferredSize().getWidth(), (int)valueUnitPairEditor.getPreferredSize().getHeight()));
        jPanel5.add(valueUnitPairEditor);
        this.addLabeledComponent(jPanel, gridBagLayout, gridBagConstraints, OVERRIDE_LABEL_TEXT, jPanel5, FID_OVERRIDE_LABEL);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel(FID_TIMEESTIMATELABEL, "<html>Science Goal Breakdown:<br>time estimate, clustering, beam and configurations</html>", ""));
        componentCollection.remember(this.makeButton(FID_TIMEESTIMATEBUTTON, "Planning and Time Estimate", tooltips.get(FID_TIMEESTIMATEBUTTON)));
        gridBagConstraints.fill = 0;
        this.addComponentArray((JComponent)jPanel, gridBagLayout, gridBagConstraints, componentCollection, false);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        gridBagConstraints.fill = 2;
        String[] stringArray4 = new String[]{"1008", "480", "96"};
        OTComboBox oTComboBox = this.makeOTComboBox(FID_SOLARINTEGRATION_DURATION, stringArray4, "Select the solar duration correlator integration time in ms");
        JLabel jLabel9 = this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Solar integration duration (ms)", (JComponent)oTComboBox);
        this.initEvents(jLabel9, FID_SOLARINTEGRATION_DURATION_LABEL);
        this.isSimultaneous12AndACA = this.makeOTButtonGroup(FID_IS_SIMULTANEOUS_12_AND_7, this.isTimeConstrainedOptions, tooltips.get(FID_IS_SIMULTANEOUS_12_AND_7));
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Simultaneous 12-m and ACA observations", (JComponent)this.isSimultaneous12AndACA);
        OTButtonGroup oTButtonGroup2 = this.makeOTButtonGroup(FID_ISTIMECONST, this.isTimeConstrainedOptions, tooltips.get(FID_ISTIMECONST));
        JPanel jPanel6 = this.createLineContainer();
        JLabel jLabel10 = new JLabel("<html><b>Time Windows</b></html>");
        jPanel6.add(jLabel10);
        jLabel10.setVisible(false);
        this.typeOfTimeConstraintGroup = this.makeOTButtonGroup(FID_TYPE_OF_TIME_CONSTRAINT, typeOfTimeConstraintOptions, typeOfTimeConstraintTooltips);
        componentCollection = new ComponentCollection();
        JLabel jLabel11 = this.makeLabel(FID_TIME_CONSTRAINED_OBSERVING_LABEL, "<html>Are the observations time-constrained?</html>", "");
        jLabel11.setVerticalAlignment(1);
        componentCollection.remember(jLabel11);
        componentCollection.remember(oTButtonGroup2);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember(Box.createVerticalBox());
        Box box2 = Box.createVerticalBox();
        box2.add((Component)jPanel6, Float.valueOf(0.0f));
        box2.add((Component)this.typeOfTimeConstraintGroup, Float.valueOf(0.0f));
        componentCollection.remember(box2);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        TableModelListener tableModelListener = tableModelEvent -> {
            PerformanceParameters performanceParameters = ((SfiControlParameterModel)this.getModel()).getPerformanceParameters();
            if (null != performanceParameters) {
                this.typeOfTimeConstraintGroup.find(TIMECONST_TIME).setEnabled(performanceParameters.canAddTemporalParameters());
                this.typeOfTimeConstraintGroup.find(TIMECONST_VISIT).setEnabled(performanceParameters.canAddVisitConstraints());
            }
        };
        componentCollection = new ComponentCollection();
        TimingConstraintsListModel timingConstraintsListModel = sfiControlParameterModel.getTimingConstraintsModel();
        TimingConstraintsListEditor timingConstraintsListEditor = new TimingConstraintsListEditor(timingConstraintsListModel);
        JLabel jLabel12 = new JLabel("<html><p>Please specify one or more suitable time windows <br/> for your observation</p><br/><p>Your observation will be scheduled once during<br/> <b>ONE</b> of these intervals.</p> </html>");
        componentCollection.remember(jLabel12, timingConstraintsListEditor);
        jLabel12.setVerticalAlignment(1);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        timingConstraintsListModel.getTimingConstraintsTableModel().addTableModelListener(tableModelListener);
        VisitConstraintsListModel visitConstraintsListModel = sfiControlParameterModel.getVisitConstraintsModel();
        VisitConstraintListEditor visitConstraintListEditor = new VisitConstraintListEditor(visitConstraintsListModel);
        JLabel jLabel13 = new JLabel("<html><p>Please specify the arrangement of visits for your<br/> observation.</p><br/><p>Visits can either be for a specific date or relative <br/>to a previous visit.</p><br/><p>The first visit can be defined as having an arbitrary <br/>start date/time</p></html>");
        jLabel13.setVerticalAlignment(1);
        componentCollection = new ComponentCollection();
        componentCollection.remember(jLabel13, visitConstraintListEditor);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        visitConstraintsListModel.getVisitConstraintsTableModel().addTableModelListener(tableModelListener);
        MonitoringConstraintsListModel monitoringConstraintsListModel = sfiControlParameterModel.getMonitoringConstraintsModel();
        MonitoringConstraintListEditor monitoringConstraintListEditor = new MonitoringConstraintListEditor(monitoringConstraintsListModel);
        JLabel jLabel14 = new JLabel("<html><p>Please specify the arrangement of visits for your<br/>observation.</p><br/><p>Monitoring can either be for a specific date or at<br/>an arbitrary date.</p><br/><p>Double click on a visit to change the details. <br/>If you select that you want a specific date but then <br/>do not enter a date it will be assumed that this visit<br/>can be run at any time.</p></html>");
        componentCollection = new ComponentCollection();
        componentCollection.remember(jLabel14, monitoringConstraintListEditor);
        jLabel14.setVerticalAlignment(1);
        monitoringConstraintsListModel.getMonitoringConstraintsTableModel().addTableModelListener(tableModelListener);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.tempConstrainedComps = Set.of(jLabel12, timingConstraintsListEditor);
        this.visitConstrainedComps = Set.of(jLabel13, visitConstraintListEditor);
        this.monitoringConstrainedComps = Set.of(jLabel14, monitoringConstraintListEditor);
        this.anyTimeConstrainedComps.add(jLabel10);
        return jPanel;
    }

    @Override
    protected void addComponents(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        JPanel jPanel = this.createConfigurationInformationPanel();
        JComponent jComponent = this.addNonCollapsingGroup(jPanel, "Configuration Information");
        CSH.setHelpIDString((Component)jComponent, (String)"TOC-Phase 1 and Phase 2 Science Goals-Control and Performance-Configuration Information");
        JPanel jPanel2 = this.createDesiredPerformanceInputPanel();
        jComponent = this.addNonCollapsingGroup(jPanel2, "Desired Performance");
        CSH.setHelpIDString((Component)jComponent, (String)"TOC-Phase 1 and Phase 2 Science Goals-Control and Performance-Desired Performance");
        this.register(this, FID_SPECTRALTYPE);
    }

    @Override
    public void set(JComponent jComponent, Object object) {
        if (jComponent instanceof BooleanButtonWidget) {
            Boolean bl = (Boolean)object;
            String string = bl != false ? "Yes" : "No";
            super.set((OTButtonGroup)jComponent, string);
        } else {
            super.set(jComponent, object);
        }
    }

    private boolean displaysUseACAChoice() {
        PerformanceParameters performanceParameters;
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        SpectralSetupParameters spectralSetupParameters = null;
        SfiControlParameterModel sfiControlParameterModel = this.getMyModel();
        if (sfiControlParameterModel.getDocument() instanceof PerformanceParameters && (performanceParameters = (PerformanceParameters)sfiControlParameterModel.getDocument()).getScienceGoal() != null) {
            spectralSetupParameters = performanceParameters.getScienceGoal().getSpectralSetupParameters();
        }
        return almaCapabilities.getNumAntennas(Array.ARRAY_7M, spectralSetupParameters) > 0 || almaCapabilities.getNumAntennas(Array.ARRAY_TP, spectralSetupParameters) > 0;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(FID_FREQUENCYWIDTH)) {
            ValueUnitPair valueUnitPair = (ValueUnitPair)object;
            super.update(fieldID, TextUtils.format(valueUnitPair, 6));
            return;
        }
        if (fieldID.equals(FID_TIMEESTIMATEBUTTON)) {
            this.informEstimatedTime();
            return;
        }
        if (fieldID.equals(FID_BEAMSIZE_12M) || fieldID.equals(FID_BEAMSIZE_7M) || fieldID.equals(FID_ACA7MMAXBASELINE_BEAMSIZE) || fieldID.equals(FID_MOSTEXTENDEDBASELINE_BEAMSIZE) || fieldID.equals(FID_COMPACTMAXBASELINE_BEAMSIZE) || fieldID.equals(FID_ACA7MMINBASELINE_SCALE) || fieldID.equals(FID_MINBASELINE_SCALE) || fieldID.equals(FID_COMPACTMINBASELINE_SCALE)) {
            if (object instanceof Angle) {
                Angle angle = (Angle)((Object)object);
                super.update(fieldID, Antenna.formatBeamSize(angle));
                return;
            }
        } else {
            if (fieldID.equals(FID_MINBASELINE_LENGTH) || fieldID.equals(FID_MAXBASELINE_LENGTH) || fieldID.equals(FID_COMPACTMINBASELINE_LENGTH) || fieldID.equals(FID_COMPACTMAXBASELINE_LENGTH) || fieldID.equals(FID_ACA7MMINBASELINE_LENGTH) || fieldID.equals(FID_ACA7MMAXBASELINE_LENGTH)) {
                double d = ((Length)((Object)object)).getContentInUnits(Length.UNIT_KM);
                super.update(fieldID, String.format("%2.3f km", d));
                return;
            }
            if (fieldID.equals(FID_FREQUENCY_MEASURES_SPECLINE) || fieldID.equals(FID_FREQUENCY_MEASURES_CONT) || fieldID.equals(FID_FREQUENCY_MEASURES_SPECSCAN)) {
                String string = (String)object;
                boolean bl = PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_USER.equals(string);
                this.setUserSpecifiedBandwidthWidgetVisibility(bl);
                super.update(fieldID, string);
                return;
            }
            if (fieldID.equals(FID_DYNAMICRANGE)) {
                super.update(fieldID, object);
                return;
            }
            if (fieldID.equals(FID_ISTIMECONST)) {
                boolean bl = (Boolean)object;
                String string = bl ? "Yes" : "No";
                this.configureTimeConstraintComponents(bl);
                super.update(fieldID, string);
                return;
            }
            if (fieldID.equals(FID_TYPE_OF_TIME_CONSTRAINT)) {
                this.updateTimeConstraintType(fieldID, object);
                return;
            }
            if (fieldID.equals(FID_NEEDSMORETIME)) {
                boolean bl = (Boolean)object;
                String string = bl ? "Yes" : "No";
                super.update(fieldID, string);
                ((ValueUnitPairEditor)this.getComponent(FID_DESIREDTIME_VUP)).setVisible(bl);
                if (this.currentView.equals((Object)ScienceGoalEditorViewEnum.DEFAULTVIEW)) {
                    ((JLabel)this.getComponent(FID_DESIREDTIME_LABEL)).setVisible(bl);
                }
                return;
            }
            if (fieldID.equals(FID_SPECTRALTYPE)) {
                this.spectralTypeChoiceUpdated((SpectralSetupParameters.SpectralSetupTypeChoice)((Object)object), this.isSensitivityWidgetsVisible);
                return;
            }
            if (fieldID.equals(FID_ACA_SENSITIVITY_VUP) || fieldID.equals(FID_TP_SENSITIVITY_VUP)) {
                UserUnitValueUnitPair userUnitValueUnitPair = (UserUnitValueUnitPair)object;
                super.update(fieldID, TextUtils.format(userUnitValueUnitPair, 6));
                return;
            }
            if (fieldID.equals(FID_ACAOBSERVATION)) {
                Boolean bl = (Boolean)object;
                super.update(fieldID, object);
                this.setDesiredSensitivityCompsView();
                if (bl.booleanValue() && !isUseACA) {
                    this.getMyModel().updateSensitivityValues();
                }
                isUseACA = bl;
                return;
            }
            if (TargetParametersEditor.FID_TARGETTYPE.equals(fieldID)) {
                String string = FieldTypeInfo.getValueFromLabel((String)object);
                if (string.equals(TargetParameters.TYPE_F_SINGLERECTANGLE)) {
                    this.sensitivityTypeLabel.setText(LABEL_SENSITIVITY_MOSAIC);
                } else {
                    this.sensitivityTypeLabel.setText(LABEL_SENSITIVITY_SINGLEPOINT);
                }
                return;
            }
            if (SingleFieldScienceGoalModel.EDITOR_SUBVIEW_FID.equals(fieldID)) {
                SwingUtilities.invokeLater(() -> this.configureEditorForView((ScienceGoalEditorViewEnum)((Object)((Object)object))));
            } else if (FID_ANGULARRESOLUTIONMODE.equals(fieldID)) {
                String string = (String)object;
                this.updateAngularResolutionMode(string);
            } else if (SfiControlParameterModel.FID_ANGULAR_RESOLUTION_VALUES_EQUAL.equals(fieldID)) {
                this.isAngularResolutionSpecifiersEqual = (Boolean)object;
                PerformanceParameters performanceParameters = (PerformanceParameters)this.getMyModel().getDocument();
                this.displayFineAngularResolutionEquivalenceComponents(Optional.empty(), performanceParameters.getAngularResolutionMode());
            } else if (FID_IS_SIMULTANEOUS_12_AND_7_POSSIBLE.equals(fieldID)) {
                boolean bl = (Boolean)object;
                this.isSimultaneous12AndACA.setEnabled(bl);
                if (!bl) {
                    this.update(FID_IS_SIMULTANEOUS_12_AND_7, "No");
                    this.getMyModel().update(this, FID_IS_SIMULTANEOUS_12_AND_7, "No");
                }
            }
        }
        super.update(fieldID, object);
    }

    private void updateTimeConstraintType(FieldID fieldID, Object object) {
        PerformanceParameters.TimingConstraintType timingConstraintType = object instanceof PerformanceParameters.TimingConstraintType ? (PerformanceParameters.TimingConstraintType)((Object)object) : PerformanceParameters.TimingConstraintType.getTypeFromButtonLabel(object.toString());
        switch (timingConstraintType) {
            case TIMINGCONSTRAINTSTYPE_NONE: {
                this.showComponentsInThisGroup(this.tempConstrainedComps, false);
                this.showComponentsInThisGroup(this.visitConstrainedComps, false);
                this.showComponentsInThisGroup(this.monitoringConstrainedComps, false);
                SfiControlParameterModel sfiControlParameterModel = (SfiControlParameterModel)this.getModel();
                if (sfiControlParameterModel != null) {
                    PerformanceParameters performanceParameters = sfiControlParameterModel.getPerformanceParameters();
                    if (performanceParameters == null) {
                        return;
                    }
                    sfiControlParameterModel.clearAnyExistingTimeBasedConstraints();
                    this.showComponentsInThisGroup(this.anyTimeConstrainedComps, performanceParameters.getIsTimeConstrained());
                    super.update(fieldID, TIMECONST_NONE);
                    break;
                }
                this.showComponentsInThisGroup(this.anyTimeConstrainedComps, false);
                break;
            }
            case TIMINGCONSTRAINTSTYPE_SPECIFICDATES: {
                this.showComponentsInThisGroup(this.tempConstrainedComps, true);
                this.showComponentsInThisGroup(this.anyTimeConstrainedComps, true);
                this.showComponentsInThisGroup(this.visitConstrainedComps, false);
                this.showComponentsInThisGroup(this.monitoringConstrainedComps, false);
                super.update(fieldID, TIMECONST_TIME);
                break;
            }
            case TIMINGCONSTRAINTSTYPE_MULTIPLEVISITS: {
                this.showComponentsInThisGroup(this.visitConstrainedComps, true);
                this.showComponentsInThisGroup(this.anyTimeConstrainedComps, true);
                this.showComponentsInThisGroup(this.tempConstrainedComps, false);
                this.showComponentsInThisGroup(this.monitoringConstrainedComps, false);
                super.update(fieldID, TIMECONST_VISIT);
                break;
            }
            default: {
                this.showComponentsInThisGroup(this.tempConstrainedComps, true);
                this.showComponentsInThisGroup(this.anyTimeConstrainedComps, true);
                this.showComponentsInThisGroup(this.monitoringConstrainedComps, false);
                this.showComponentsInThisGroup(this.visitConstrainedComps, false);
                super.update(fieldID, TIMECONST_TIME);
            }
        }
    }

    private void updateAngularResolutionMode(String string) {
        boolean bl;
        boolean bl2;
        AngularResolutionMode angularResolutionMode = AngularResolutionMode.valueOfBOMapping(string);
        OTButtonGroup oTButtonGroup = (OTButtonGroup)this.getComponent(FID_ANGULARRESOLUTIONMODE);
        oTButtonGroup.findButtonWithBOMapping(string).setSelected(true);
        boolean bl3 = EnumSet.of(AngularResolutionMode.Range, AngularResolutionMode.Single).contains(angularResolutionMode);
        PerformanceParameters performanceParameters = (PerformanceParameters)this.getMyModel().getDocument();
        boolean bl4 = false;
        boolean bl5 = angularResolutionMode.equals(AngularResolutionMode.Range);
        if (performanceParameters != null) {
            try {
                ObsProposal obsProposal = performanceParameters.getScienceGoal().getObsProposal();
                if (obsProposal != null && !obsProposal.isVLBIorPhasedArray()) {
                    bl4 = obsProposal.isVLBIorPhasedArray();
                    this.angularResolutionRangeSpecificationContainer.setVisible(bl3);
                    JComponent jComponent = this.getComponent(FID_ANGULARRESOLUTION_VUP);
                    jComponent.setVisible(bl3);
                    jComponent.setEnabled(bl3);
                    boolean bl6 = bl5;
                    this.angularResolutionRangeDelimiterLabel.setVisible(bl6);
                    this.angularResolutionDelimiterEditor.setVisible(bl6);
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(SfiControlParameterEditor.class).info("Unable to determine if VLBI mode : " + unknownEntityException.getMessage());
            }
        }
        boolean bl7 = !(bl2 = angularResolutionMode.equals(AngularResolutionMode.Any)) && EnumSet.of(ScienceGoalEditorViewEnum.DEFAULTVIEW, ScienceGoalEditorViewEnum.ACASUPPLEMENTALCALL).contains((Object)this.currentView);
        this.getComponent(FID_LARGESTSCALE_VUP).setEnabled(bl7);
        this.getComponent(FID_LARGESTSCALE_VUP).setVisible(bl7);
        this.getComponent(FID_LARGEST_ANGULAR_STRUCTURE_LABEL).setVisible(bl7);
        UserUnitValueUnitPairEditor userUnitValueUnitPairEditor = (UserUnitValueUnitPairEditor)this.getComponent(FID_SENSITIVITY_VUP);
        UserUnitValueUnitPairModel userUnitValueUnitPairModel = userUnitValueUnitPairEditor.getModel();
        if (userUnitValueUnitPairModel.getVUP() == null) {
            return;
        }
        if (bl2) {
            userUnitValueUnitPairEditor.setRestrictedUnitsToBeDisplayed(bl2);
            bl = Arrays.stream(this.angularResolutionAnyRestrictedUnits).anyMatch(userUnitValueUnitPairModel.getVUP().getUnit()::contains);
            if (!bl) {
                userUnitValueUnitPairEditor.update(userUnitValueUnitPairEditor.getUnitFID(), UserSensitivityData.USERUNIT_JY);
            } else {
                userUnitValueUnitPairEditor.update(userUnitValueUnitPairEditor.getUnitFID(), userUnitValueUnitPairModel.getVUP().getUnit());
            }
        } else {
            userUnitValueUnitPairEditor.setRestrictedUnitsToBeDisplayed(bl2);
            UserUnitValueUnitPair userUnitValueUnitPair = (UserUnitValueUnitPair)userUnitValueUnitPairModel.getDocument();
            if (userUnitValueUnitPair != null) {
                userUnitValueUnitPairEditor.update(userUnitValueUnitPairEditor.getUnitFID(), userUnitValueUnitPair.getUnit());
            }
        }
        bl = EnumSet.of(AngularResolutionMode.Any, AngularResolutionMode.Range).contains(angularResolutionMode) && !bl4;
        this.displayFineAngularResolutionEquivalenceComponents(Optional.of(bl), angularResolutionMode);
        this.getComponent(FID_AR_FOR_SENS_EQUIV_FIELD_ONE_VUP).setVisible(bl5);
        String string2 = tooltips.get(bl5 ? FID_ANGULARRESOLUTIONDELIMITER_VUP : FID_ANGULARRESOLUTION_VUP);
        this.getComponent(FID_ANGULARRESOLUTION_VUP).setToolTipText(string2);
    }

    @Override
    public void configureEditorForView(@NonNull ScienceGoalEditorViewEnum scienceGoalEditorViewEnum) {
        if (scienceGoalEditorViewEnum == null) {
            throw new NullPointerException("viewToDisplay is marked non-null but is null");
        }
        this.currentView = scienceGoalEditorViewEnum;
        switch (scienceGoalEditorViewEnum) {
            case DEFAULTVIEW: 
            case ACASUPPLEMENTALCALL: {
                this.configureEditorForStandardView();
                break;
            }
            case SOLAR: {
                this.configureEditorForSolar();
                break;
            }
            case VLBI: {
                this.configureEditorForVLBI();
                break;
            }
            default: {
                throw new RuntimeException("Unknown view specified: " + scienceGoalEditorViewEnum);
            }
        }
    }

    private void configureEditorForStandardView() {
        Object object;
        Object object2;
        this.isSensitivityWidgetsVisible = true;
        this.setVisible(true, FID_CONFIGURATION_PANEL, FID_BW_FOR_SENSITIVITY_CONTAINER, FID_SENSITIVITY_CONTAINER, FID_SENSITIVITY_FINE_CONTAINER, FID_LARGEST_ANGULAR_STRUCTURE_LABEL, FID_LARGESTSCALE_VUP);
        this.getComponent(FID_SOLARINTEGRATION_DURATION).setVisible(false);
        this.getComponent(FID_SOLARINTEGRATION_DURATION_LABEL).setVisible(false);
        JComponent jComponent = this.getComponent(FID_DESIRED_ANGULAR_RESOLUTION_LABEL);
        JComponent jComponent2 = this.getComponent(FID_ANGULARRESOLUTION_VUP);
        assert (jComponent != null && jComponent2 != null);
        this.angularResolutionModeButtonGroup.find(AngularResolutionMode.SACA.getUILabel()).setEnabled(true);
        boolean bl = false;
        try {
            bl = ObservingToolController.getOTGui().getPrimaryProject().getObsProposal().isSupplementalCallProposal();
            boolean bl2 = !bl;
            this.angularResolutionModeButtonGroup.find(AngularResolutionMode.Range.getUILabel()).setEnabled(bl2);
            this.angularResolutionModeButtonGroup.find(AngularResolutionMode.Any.getUILabel()).setEnabled(bl2);
            this.angularResolutionModeButtonGroup.find(AngularResolutionMode.Single.getUILabel()).setEnabled(bl2);
            if (bl) {
                object2 = this.angularResolutionModeButtonGroup.find(AngularResolutionMode.SACA.getUILabel());
                ((AbstractButton)object2).doClick();
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SfiControlParameterEditor.class).warning("Unable to determine if this is a supplemental call " + unknownEntityException.getMessage());
        }
        jComponent.setVisible(true);
        jComponent.setEnabled(true);
        this.angularResolutionRangeSpecificationContainer.setVisible(true);
        this.angularResolutionModeButtonGroup.setVisible(true);
        PerformanceParameters performanceParameters = (PerformanceParameters)this.getMyModel().getDocument();
        if (performanceParameters != null) {
            object2 = performanceParameters.getAngularResolutionMode();
            boolean bl3 = EnumSet.of(AngularResolutionMode.Single, AngularResolutionMode.Range).contains(object2);
            jComponent2.setVisible(bl3);
            jComponent2.setEnabled(bl3);
            bl3 = AngularResolutionMode.Range.equals(object2);
            this.angularResolutionRangeDelimiterLabel.setVisible(bl3);
            this.angularResolutionDelimiterEditor.setVisible(bl3);
            boolean bl4 = EnumSet.of(AngularResolutionMode.Any, AngularResolutionMode.Range).contains(object2);
            this.displayFineAngularResolutionEquivalenceComponents(Optional.of(bl4), (AngularResolutionMode)object2);
            this.getComponent(FID_AR_FOR_SENS_EQUIV_FIELD_ONE_VUP).setVisible(((Enum)object2).equals(AngularResolutionMode.Range));
        }
        object2 = this.getComponent(FID_SENSITIVITY_VUP);
        JComponent jComponent3 = this.getComponent(FID_SENSITIVITY_FB_FIELD_ONE_RESOLUTION_VUP);
        JComponent jComponent4 = this.getComponent(FID_DESIRED_SENSITIVITY_EQUIVALENCE_LABEL);
        assert (object2 != null && jComponent3 != null && jComponent4 != null);
        ((JComponent)object2).setVisible(true);
        this.sensitivityTypeLabel.setVisible(true);
        jComponent3.setVisible(true);
        jComponent4.setVisible(true);
        this.getComponent(FID_BANDWIDTH_USED_FOR_SENSITIVITY_LABEL).setVisible(true);
        this.getComponent(FID_FREQUENCY_WIDTH_LABEL).setVisible(true);
        if (performanceParameters != null) {
            this.getComponent(FID_DESIREDTIME_LABEL).setVisible(performanceParameters.getNeedsMoreTime());
        }
        if (performanceParameters != null && performanceParameters.getParent() != null) {
            object = (ScienceGoal)performanceParameters.getParent();
            this.spectralTypeChoiceUpdated(object.getSpectralSetupParameters().getSpectralType(), true);
        }
        this.getComponent(FID_NEEDSMORETIME).setVisible(true);
        object = (JLabel)this.getComponent(FID_OVERRIDE_LABEL);
        ((JLabel)object).setText(OVERRIDE_LABEL_TEXT);
        ((JComponent)object).setToolTipText(tooltips.get(FID_DESIREDTIME_VUP));
        ValueUnitPairEditor valueUnitPairEditor = (ValueUnitPairEditor)this.getComponent(FID_DESIREDTIME_VUP);
        valueUnitPairEditor.setToolTipText(tooltips.get(FID_DESIREDTIME_VUP));
    }

    private void configureEditorForSolar() {
        Iterable<SummaryTableRow> iterable;
        Object object;
        this.isSensitivityWidgetsVisible = false;
        this.getComponent(FID_CONFIGURATION_PANEL).setVisible(true);
        ValueUnitPairEditor valueUnitPairEditor = (ValueUnitPairEditor)this.getComponent(FID_DESIREDTIME_VUP);
        valueUnitPairEditor.setVisible(true);
        this.setVisible(false, FID_BW_FOR_SENSITIVITY_CONTAINER, FID_SENSITIVITY_CONTAINER, FID_SENSITIVITY_FINE_CONTAINER);
        this.getComponent(FID_SOLARINTEGRATION_DURATION).setVisible(false);
        this.getComponent(FID_SOLARINTEGRATION_DURATION_LABEL).setVisible(false);
        this.getComponent(FID_LARGEST_ANGULAR_STRUCTURE_LABEL).setVisible(false);
        this.getComponent(FID_LARGESTSCALE_VUP).setVisible(false);
        SfiControlParameterModel sfiControlParameterModel = this.getMyModel();
        PerformanceParameters performanceParameters = (PerformanceParameters)sfiControlParameterModel.getDocument();
        if (performanceParameters.isAngularResolutionModeSACA()) {
            object = sfiControlParameterModel.getAngularResolutionModel();
            ((UserUnitValueUnitPairModel)object).update((Editor)this.getComponent(FID_ANGULARRESOLUTION_VUP), ((AbstractValueUnitPairModel)object).getValueFID(), "");
            SfiControlParameterModel sfiControlParameterModel2 = this.getMyModel();
            sfiControlParameterModel2.update(null, FID_ANGULARRESOLUTIONMODE, AngularResolutionMode.Single.getBOMapping());
        }
        this.angularResolutionModeButtonGroup.find(AngularResolutionMode.SACA.getUILabel()).setEnabled(false);
        this.angularResolutionModeButtonGroup.setVisible(true);
        this.getComponent(FID_DESIRED_ANGULAR_RESOLUTION_LABEL).setVisible(true);
        object = performanceParameters.getAngularResolutionMode();
        boolean bl = EnumSet.of(AngularResolutionMode.Single, AngularResolutionMode.Range).contains(object);
        JComponent jComponent = this.getComponent(FID_ANGULARRESOLUTION_VUP);
        jComponent.setVisible(bl);
        jComponent.setEnabled(bl);
        bl = AngularResolutionMode.Range.equals(object);
        this.angularResolutionRangeDelimiterLabel.setVisible(bl);
        this.angularResolutionDelimiterEditor.setVisible(bl);
        JComponent jComponent2 = this.getComponent(FID_SENSITIVITY_VUP);
        JComponent jComponent3 = this.getComponent(FID_SENSITIVITY_FB_FIELD_ONE_RESOLUTION_VUP);
        JComponent jComponent4 = this.getComponent(FID_DESIRED_SENSITIVITY_EQUIVALENCE_LABEL);
        assert (jComponent2 != null && jComponent3 != null && jComponent4 != null);
        jComponent2.setVisible(false);
        this.sensitivityTypeLabel.setVisible(false);
        jComponent3.setVisible(false);
        jComponent4.setVisible(false);
        JComponent jComponent5 = this.getComponent(FID_DESIRED_ANGULAR_RESOLUTION_LABEL);
        JComponent jComponent6 = this.getComponent(FID_ANGULARRESOLUTION_VUP);
        assert (jComponent5 != null && jComponent6 != null);
        jComponent5.setVisible(true);
        jComponent6.setVisible(true);
        jComponent6.setEnabled(true);
        jComponent5.setEnabled(true);
        this.setVisible(false, FID_BANDWIDTH_USED_FOR_SENSITIVITY_LABEL, FID_FREQUENCY_WIDTH_LABEL);
        JLabel jLabel = (JLabel)this.getComponent(FID_OVERRIDE_LABEL);
        jLabel.setText("Total on-source time estimate");
        jLabel.setToolTipText("Total on-source time required for solar observing");
        valueUnitPairEditor.setToolTipText("Total on-source time required for solar observing");
        this.getComponent(FID_DESIREDTIME_LABEL).setVisible(false);
        PerformanceParameters performanceParameters2 = (PerformanceParameters)sfiControlParameterModel.getDocument();
        if (performanceParameters2 == null) {
            return;
        }
        if (performanceParameters2.getParent() != null) {
            iterable = (ScienceGoal)performanceParameters2.getParent();
            this.spectralTypeChoiceUpdated(iterable.getSpectralSetupParameters().getSpectralType(), this.isSensitivityWidgetsVisible);
        }
        sfiControlParameterModel.update(this, FID_NEEDSMORETIME, "Yes");
        this.getComponent(FID_NEEDSMORETIME).setVisible(false);
        iterable = (ValueUnitPairModel)valueUnitPairEditor.getModel();
        ValueUnitPair valueUnitPair = ((ValueUnitPairModel)iterable).getVUP();
        if (valueUnitPair != null) {
            valueUnitPair.convertToUnit(Time.UNIT_H);
        }
        this.getComponent(FID_AR_FOR_SENS_EQUIV_FIELD_ONE_VUP).setVisible(performanceParameters2.isAngularResolutionModeRange());
    }

    private void configureTimeConstraintComponents(boolean bl) {
        if (bl) {
            this.typeOfTimeConstraintGroup.setVisible(true);
            this.typeOfTimeConstraintGroup.setEnabled(true);
            this.showComponentsInThisGroup(this.tempConstrainedComps, true);
            this.showComponentsInThisGroup(this.visitConstrainedComps, false);
            this.showComponentsInThisGroup(this.monitoringConstrainedComps, false);
            this.showComponentsInThisGroup(this.anyTimeConstrainedComps, true);
            SfiControlParameterModel sfiControlParameterModel = (SfiControlParameterModel)this.getModel();
            PerformanceParameters performanceParameters = sfiControlParameterModel.getPerformanceParameters();
            if (null != performanceParameters) {
                this.typeOfTimeConstraintGroup.find(TIMECONST_TIME).setEnabled(performanceParameters.canAddTemporalParameters());
                this.typeOfTimeConstraintGroup.find(TIMECONST_VISIT).setEnabled(performanceParameters.canAddVisitConstraints());
                PerformanceParameters.TimingConstraintType timingConstraintType = performanceParameters.getTypeOfTimingConstraint();
                if (performanceParameters.getMonitoringConstraintCount() > 0) {
                    timingConstraintType = PerformanceParameters.TimingConstraintType.TIMINGCONSTRAINTSTYPE_SPECIFICDATES;
                } else if (performanceParameters.getVisitConstraintCount() > 0) {
                    timingConstraintType = PerformanceParameters.TimingConstraintType.TIMINGCONSTRAINTSTYPE_MULTIPLEVISITS;
                }
                this.update(FID_TYPE_OF_TIME_CONSTRAINT, (Object)timingConstraintType);
            } else {
                this.update(FID_TYPE_OF_TIME_CONSTRAINT, (Object)PerformanceParameters.TimingConstraintType.TIMINGCONSTRAINTSTYPE_NONE);
            }
        } else {
            this.typeOfTimeConstraintGroup.setVisible(false);
            this.typeOfTimeConstraintGroup.setEnabled(false);
            this.showComponentsInThisGroup(this.tempConstrainedComps, false);
            this.showComponentsInThisGroup(this.visitConstrainedComps, false);
            this.showComponentsInThisGroup(this.monitoringConstrainedComps, false);
            this.showComponentsInThisGroup(this.anyTimeConstrainedComps, false);
        }
    }

    private void setUserSpecifiedBandwidthWidgetVisibility(boolean bl) {
        ValueUnitPairEditor valueUnitPairEditor = (ValueUnitPairEditor)this.getComponent(FID_FREQUENCYWIDTH_VUP);
        valueUnitPairEditor.setVisible(this.isSensitivityWidgetsVisible && bl);
        if (bl) {
            valueUnitPairEditor.getModel().publish();
        }
        this.getComponent(FID_FREQUENCYWIDTH).setVisible(this.isSensitivityWidgetsVisible && !bl);
    }

    private void configureEditorForVLBI() {
        Iterable<Model> iterable;
        this.isSensitivityWidgetsVisible = false;
        this.getComponent(FID_CONFIGURATION_PANEL).setVisible(false);
        this.getComponent(FID_SENSITIVITY_FINE_CONTAINER).setVisible(false);
        this.getComponent(FID_BW_FOR_SENSITIVITY_CONTAINER).setVisible(false);
        this.getComponent(FID_SENSITIVITY_CONTAINER).setVisible(false);
        this.getComponent(FID_SOLARINTEGRATION_DURATION).setVisible(false);
        this.getComponent(FID_SOLARINTEGRATION_DURATION_LABEL).setVisible(false);
        ValueUnitPairEditor valueUnitPairEditor = (ValueUnitPairEditor)this.getComponent(FID_DESIREDTIME_VUP);
        valueUnitPairEditor.setVisible(true);
        valueUnitPairEditor.setToolTipText(tooltips.get(FID_DESIREDTIME_VUP));
        this.angularResolutionModeButtonGroup.find(AngularResolutionMode.SACA.getUILabel()).setEnabled(false);
        JComponent jComponent = this.getComponent(FID_DESIRED_ANGULAR_RESOLUTION_LABEL);
        JComponent jComponent2 = this.getComponent(FID_ANGULARRESOLUTION_VUP);
        assert (jComponent != null && jComponent2 != null);
        jComponent.setVisible(false);
        jComponent2.setVisible(false);
        jComponent2.setEnabled(false);
        jComponent.setEnabled(false);
        this.angularResolutionModeButtonGroup.setVisible(false);
        this.angularResolutionRangeDelimiterLabel.setVisible(false);
        this.angularResolutionDelimiterEditor.setVisible(false);
        JComponent jComponent3 = this.getComponent(FID_LARGEST_ANGULAR_STRUCTURE_LABEL);
        JComponent jComponent4 = this.getComponent(FID_LARGESTSCALE_VUP);
        assert (jComponent3 != null && jComponent4 != null);
        jComponent3.setVisible(false);
        jComponent4.setVisible(false);
        JComponent jComponent5 = this.getComponent(FID_SENSITIVITY_VUP);
        JComponent jComponent6 = this.getComponent(FID_SENSITIVITY_FB_FIELD_ONE_RESOLUTION_VUP);
        JComponent jComponent7 = this.getComponent(FID_DESIRED_SENSITIVITY_EQUIVALENCE_LABEL);
        assert (jComponent5 != null && jComponent6 != null && jComponent7 != null);
        jComponent5.setVisible(false);
        this.sensitivityTypeLabel.setVisible(false);
        jComponent6.setVisible(false);
        jComponent7.setVisible(false);
        this.getComponent(FID_BANDWIDTH_USED_FOR_SENSITIVITY_LABEL).setVisible(false);
        this.getComponent(FID_FREQUENCY_WIDTH_LABEL).setVisible(false);
        JLabel jLabel = (JLabel)this.getComponent(FID_OVERRIDE_LABEL);
        jLabel.setText("VLBI total time");
        jLabel.setToolTipText("Enter total time, including calibration and overheads");
        this.getComponent(FID_DESIREDTIME_LABEL).setVisible(false);
        PerformanceParameters performanceParameters = (PerformanceParameters)this.getMyModel().getDocument();
        if (performanceParameters == null) {
            return;
        }
        if (performanceParameters.getParent() != null) {
            iterable = (ScienceGoal)performanceParameters.getParent();
            this.spectralTypeChoiceUpdated(iterable.getSpectralSetupParameters().getSpectralType(), false);
            this.displayFineAngularResolutionEquivalenceComponents(Optional.of(false), performanceParameters.getAngularResolutionMode());
        }
        if ((iterable = this.getMyModel()) != null) {
            ((SfiControlParameterModel)iterable).update(this, FID_NEEDSMORETIME, "Yes");
        }
        this.getComponent(FID_NEEDSMORETIME).setVisible(false);
        ValueUnitPairModel valueUnitPairModel = (ValueUnitPairModel)valueUnitPairEditor.getModel();
        ValueUnitPair valueUnitPair = valueUnitPairModel.getVUP();
        if (valueUnitPair != null) {
            valueUnitPair.convertToUnit(Time.UNIT_H);
        }
    }

    private void displayFineAngularResolutionEquivalenceComponents(Optional<Boolean> optional, AngularResolutionMode angularResolutionMode) {
        if (optional.isPresent()) {
            this.isMultipleEquivalanceFieldsDisplayed = optional.get();
        }
        boolean bl = this.isMultipleEquivalanceFieldsDisplayed != false && this.isAngularResolutionSpecifiersEqual == false;
        this.getComponent(FID_DESIRED_SENSITIVITY_EQUIVALENCE_SEPARATOR_LABEL).setVisible(bl);
        this.getComponent(FID_SENSITIVITY_FB_FIELD_TWO_RESOLUTION_VUP).setVisible(bl);
        this.getComponent(FID_AR_FOR_SENS_EQUIV_FIELD_TWO_VUP).setVisible(bl && angularResolutionMode.equals(AngularResolutionMode.Range));
    }

    private void showComponentsInThisGroup(Set<JComponent> set, boolean bl) {
        set.stream().forEach(jComponent -> jComponent.setVisible(bl));
    }

    private void setDesiredSensitivityCompsView() {
        this.desiredSensitivityComps.stream().forEach(jComponent -> jComponent.setVisible(false));
    }

    private void informEstimatedTime() {
        PerformanceParameters performanceParameters = ((SfiControlParameterModel)this.getModel()).getPerformanceParameters();
        EstimatedTimeInfoBuilder estimatedTimeInfoBuilder = new EstimatedTimeInfoBuilder(performanceParameters);
        try {
            EstimatedTimeInfoBuilder.TimeEstimateModel timeEstimateModel = estimatedTimeInfoBuilder.buildTimeEstimateModel();
            assert (timeEstimateModel != null);
            JDialog jDialog = estimatedTimeInfoBuilder.buildTimeEstimateDialogWindow(timeEstimateModel);
            jDialog.setVisible(true);
        }
        catch (TimeEstimateInterface.UnableToGenerateTimeEstimateException unableToGenerateTimeEstimateException) {
            GUIUtilities.warning(null, unableToGenerateTimeEstimateException.getMessage());
        }
    }

    private void spectralTypeChoiceUpdated(@NonNull SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice, boolean bl) {
        if (spectralSetupTypeChoice == null) {
            throw new NullPointerException("choice is marked non-null but is null");
        }
        if (!bl) {
            this.getComponent(FID_FREQUENCY_MEASURES_SPECLINE).setVisible(false);
            this.getComponent(FID_FREQUENCY_MEASURES_CONT).setVisible(false);
            this.getComponent(FID_FREQUENCY_MEASURES_SPECSCAN).setVisible(false);
            this.setUserSpecifiedBandwidthWidgetVisibility(false);
            return;
        }
        switch (spectralSetupTypeChoice) {
            case SINGLECONTINUUM: {
                this.getComponent(FID_FREQUENCY_MEASURES_SPECLINE).setVisible(false);
                this.getComponent(FID_FREQUENCY_MEASURES_CONT).setVisible(true);
                this.getComponent(FID_FREQUENCY_MEASURES_SPECSCAN).setVisible(false);
                break;
            }
            case SPECTRALLINE: {
                this.getComponent(FID_FREQUENCY_MEASURES_SPECLINE).setVisible(true);
                this.getComponent(FID_FREQUENCY_MEASURES_CONT).setVisible(false);
                this.getComponent(FID_FREQUENCY_MEASURES_SPECSCAN).setVisible(false);
                break;
            }
            case SPECTRALSCAN: {
                this.getComponent(FID_FREQUENCY_MEASURES_SPECLINE).setVisible(false);
                this.getComponent(FID_FREQUENCY_MEASURES_CONT).setVisible(false);
                this.getComponent(FID_FREQUENCY_MEASURES_SPECSCAN).setVisible(true);
                break;
            }
            default: {
                throw new RuntimeException("Unknown spectral type has been specified " + spectralSetupTypeChoice);
            }
        }
        PerformanceParameters performanceParameters = this.getMyModel().getPerformanceParameters();
        if (performanceParameters.getDesiredSensitivityFrequencyMeasure().equals(PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_USER)) {
            this.setUserSpecifiedBandwidthWidgetVisibility(true);
        }
    }

    static {
        tooltips.put(FID_NO_ANTENNA_12M, "Number of antennas in the 12m array");
        tooltips.put(FID_NO_ANTENNA_7M, "Number of antennas in the 7m array");
        tooltips.put(FID_NO_ANTENNA_TP, "Number of antennas in the total power array");
        tooltips.put(FID_ANGULARRESOLUTION_VUP, "Synthesized beam of final image");
        tooltips.put(FID_ANGULARRESOLUTIONDELIMITER_VUP, "Range of synthesized beam of final image");
        tooltips.put(FID_ISPOINTSOURCE, "Select if your source will be unresolved in any of the available configurations");
        tooltips.put(FID_EXTENDEDSOURCE, "Select if your source will be resolved by any of the configurations");
        tooltips.put(FID_LARGESTSCALE_VUP, "What is the angular extent of the largest source component that you want to map?");
        tooltips.put(FID_SENSITIVITY_VUP, "1-sigma sensitivity in flux or temperature units");
        tooltips.put(FID_SENSITIVITY_FB_FIELD_ONE_RESOLUTION_VUP, "Sensitivity in equivalent flux or temperature units for coarse resolution");
        tooltips.put(FID_SENSITIVITY_FB_FIELD_TWO_RESOLUTION_VUP, "Sensitivity in equivalent flux or temperature units for fine resolution");
        tooltips.put(FID_FREQUENCY_MEASURES_SPECLINE, "Bandwidth for sensitivity calculation");
        tooltips.put(FID_FREQUENCYWIDTH_VUP, "Specify the frequency width used in sensitivity calculation.");
        tooltips.put(FID_FREQUENCYWIDTH, "Bandwidth for sensitivity in frequency units");
        tooltips.put(FID_DYNAMICRANGE, "Ratio of the peak flux expected to the rms sensitivity level desired");
        tooltips.put(FID_TIMEESTIMATEBUTTON, "Display a detailed breakdown of this information");
        tooltips.put(FID_NEEDSMORETIME, "Select if more u,v coverage (i.e. time) is required than indicated by the time estimate");
        tooltips.put(FID_ISTIMECONST, "Specify fixed dates, multiple epochs or fixed-duration observing. Only allowed for a single array configuration");
        tooltips.put(FID_START_TIME, "Required starting time for the scheduling block. Valid format: YYYY-MM-DD hh:mm:ss.mmm");
        tooltips.put(FID_END_TIME, "Time by which the scheduling block must have been executed. Valid format: YYYY-MM-DD hh:mm:ss.mmm");
        tooltips.put(FID_ALLOWED_MARGIN_VALUE, "Amount of time by which it is acceptable to vary the start and end times from the requested values");
        tooltips.put(FID_DESIREDTIME_VUP, "Enter total time for the largest array configuration required, including calibration and overheads");
        tooltips.put(FID_BEAMSIZE_12M, "<html>Primary beam (field of view) of 12-m antenna</html>");
        tooltips.put(FID_BEAMSIZE_7M, "<html>Primary beam (field of view) of 7-m antenna</html>");
        tooltips.put(FID_COMPACTMAXBASELINE_LENGTH, "<html>The compact configuration maximum baseline length and the corresponding synthesized beam size (angular resolution)</html>");
        tooltips.put(FID_COMPACTMAXBASELINE_BEAMSIZE, "<html>The compact configuration maximum baseline length and the corresponding synthesized beam size (angular resolution)</html>");
        tooltips.put(FID_COMPACTMINBASELINE_LENGTH, "<html>The compact configuration minimum baseline length and the corresponding maximum recoverable scale (angular resolution)</html>");
        tooltips.put(FID_COMPACTMINBASELINE_SCALE, "<html>The compact configuration minimum baseline length and the corresponding maximum recoverable scale (angular resolution)</html>");
        tooltips.put(FID_ACA7MMAXBASELINE_LENGTH, "<html>The compact configuration maximum baseline length and the corresponding synthesized beam size (angular resolution)</html>");
        tooltips.put(FID_ACA7MMAXBASELINE_BEAMSIZE, "<html>The compact configuration maximum baseline length and the corresponding synthesized beam size (angular resolution)</html>");
        tooltips.put(FID_ACA7MMINBASELINE_LENGTH, "<html>The compact configuration minimum baseline length and the corresponding maximum recoverable scale (angular resolution)</html>");
        tooltips.put(FID_ACA7MMINBASELINE_SCALE, "<html>The compact configuration minimum baseline length and the corresponding maximum recoverable scale (angular resolution)</html>");
        tooltips.put(FID_MAXBASELINE_LENGTH, "<html>The extended configuration maximum baseline length and the corresponding synthesized beam size (angular resolution)</html>");
        tooltips.put(FID_MOSTEXTENDEDBASELINE_BEAMSIZE, "<html>The extended configuration maximum baseline length and the corresponding synthesized beam size (angular resolution)</html>");
        tooltips.put(FID_MINBASELINE_LENGTH, "<html>The extended configuration minimum baseline length and the corresponding maximum recoverable scale (angular resolution)</html>");
        tooltips.put(FID_MINBASELINE_SCALE, "<html>The extended configuration minimum baseline length and the corresponding maximum recoverable scale (angular resolution)</html>");
        tooltips.put(FID_ACA_SENSITIVITY_VUP, "ACA sensitivity determined from main array");
        tooltips.put(FID_ACA_SENSITIVITY_FB_VUP, "The corresponding sensitivity in flux or temperature units - non-editable.");
        tooltips.put(FID_TP_SENSITIVITY_VUP, "TP sensitivity determiined from main array");
        tooltips.put(FID_TP_SENSITIVITY_FB_VUP, "The corresponding sensitivity in flux or temperature units - non-editable.");
        tooltips.put(FID_IS_SIMULTANEOUS_12_AND_7, "Select if a single 12-m configuration plus 7-m is required, for all clusters.");
        TIMECONST_VISIT = PerformanceParameters.TimingConstraintType.TIMINGCONSTRAINTSTYPE_MULTIPLEVISITS.label;
        TIMECONST_TIME = PerformanceParameters.TimingConstraintType.TIMINGCONSTRAINTSTYPE_SPECIFICDATES.label;
        TIMECONST_NONE = PerformanceParameters.TimingConstraintType.TIMINGCONSTRAINTSTYPE_NONE.label;
        typeOfTimeConstraintOptions = new String[]{TIMECONST_NONE, TIMECONST_TIME, TIMECONST_VISIT};
        typeOfTimeConstraintTooltips = new String[]{"<html>Specify one or more time windows - the observations will be scheduled in <b>one</b> of these</html>", "The observations will be run on each date specified", "Specify the amount of time the observation should last for (including calibration and overheads)"};
        FID_DESIRED_SENSITIVITY_EQUIVALENCE_SEPARATOR_LABEL = new FieldID("SfiControl.desiredSensitivityEquivalanceSeparatorLabel");
        FID_SENSITIVITY_FINE_CONTAINER = new FieldID("SfiControl.sensitivityFBContainerLine2");
    }

    private class BooleanButtonWidget
    extends OTButtonGroup {
        private static final long serialVersionUID = -3348445849617933389L;
        private final String choiceYes;
        private final String choiceNo;

        public BooleanButtonWidget(FieldID fieldID, String string, String string2, String string3) {
            super(new String[]{string, string2});
            this.choiceYes = string;
            this.choiceNo = string2;
            SfiControlParameterEditor.this.initEvents(this, fieldID);
            this.setToolTipText(string3);
        }

        public BooleanButtonWidget(FieldID fieldID, String string, String string2, String[] stringArray) {
            super(new String[]{string, string2});
            this.choiceYes = string;
            this.choiceNo = string2;
            SfiControlParameterEditor.this.initEvents(this, fieldID);
            this.setToolTipText(stringArray);
        }

        @Override
        public void setSelectedItem(String string) {
            boolean bl;
            boolean bl2 = bl = string.equals(this.choiceYes) || string.equals("Yes");
            if (bl) {
                super.setSelectedItem(this.choiceYes);
            } else {
                super.setSelectedItem(this.choiceNo);
            }
        }
    }
}

