/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.ContextSwitchInterface;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.editors.obsproject.ObsProposalEditor;
import alma.obsprep.ot.editors.sciencegoals.MultiResolutionElementTable;
import alma.obsprep.ot.editors.sciencegoals.SfiSpectralSetupEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.EditorManager;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.sciencegoals.MultiResolutionElementTableModel;
import alma.obsprep.ot.models.sciencegoals.SpectralWindowGroupModel;
import alma.obsprep.services.experts.spectralline.DialogSpectralLineChooser;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.experts.spectralline.SpectralLineChooser;
import alma.obsprep.services.experts.spectralline.SpectralLinePublisher;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import lombok.NonNull;

public class SpectralWindowGroupEditor
extends Editor
implements SfiSpectralSetupEditor.ScienceSpectralWindowSelector {
    public static final FieldID FID_DISPLAY_IMAGE_TABLE_CHECKBOX_USER_CONTROLLABLE = new FieldID("SpectralWindowSetupSuperEditor.enableDisplayImageTableCheckBox");
    public static final FieldID FID_TABLE = new FieldID("SpectralWindowSetupSuperEditor.table");
    public static final FieldID FID_IMAGE_TABLE = new FieldID("SpectralWindowSetupSuperEditor.imageTable");
    public static final FieldID FID_SELECT_LINES = new FieldID("SpectralWindowSetupSuperEditor select lines");
    public static final FieldID FID_DISPLAY_IMAGE_TABLE_CHECKBOX = new FieldID("SpectralWindowSetupSuperEditor.displayImageTable");
    private final SpectralLineChooser lineChooser;
    private SpectralLineButtonBox buttonBox;
    private Table spwTable;
    private ListSelectionListener listSelectionListener = null;
    private TableColumn walshSwitchTableColumn;

    public SpectralWindowGroupEditor(SpectralWindowGroupModel spectralWindowGroupModel, SpectralLineChooser spectralLineChooser) {
        this.setModel(spectralWindowGroupModel);
        this.setName("SpectralWindowSetupSuperEditor/BB-" + spectralWindowGroupModel.getGroupIndex());
        this.lineChooser = spectralLineChooser;
        this.build();
        spectralWindowGroupModel.publish();
    }

    public SpectralWindowGroupModel getMyModel() {
        return (SpectralWindowGroupModel)this.getModel();
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.spwTable.getModel().addTableModelListener(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.spwTable.getModel().removeTableModelListener(tableModelListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listSelectionListener = listSelectionListener;
        this.spwTable.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.spwTable.getSelectionModel().removeListSelectionListener(listSelectionListener);
        this.listSelectionListener = null;
    }

    public ListSelectionListener getListSelectionListener() {
        return this.listSelectionListener;
    }

    public ScienceSpectralWindow getSelectedScienceSpectralWindow() {
        int n = this.spwTable.getSelectedRow();
        ScienceSpectralWindow[] scienceSpectralWindowArray = this.getMyModel().getSpectralWindows();
        if (n == -1 || n >= scienceSpectralWindowArray.length) {
            return null;
        }
        return scienceSpectralWindowArray[n];
    }

    public void clearSelection() {
        this.spwTable.clearSelection();
    }

    public int getSelectedScienceSpectralWindowIndex() {
        return this.spwTable.getSelectedRow();
    }

    @Override
    protected void build() {
        this.setLayout(new BoxLayout(this, 3));
        this.spwTable = new MultiResolutionElementTable(this.getMyModel().getTableModel());
        UserEditRestrictionController.getInstance().registerUserChangeRestrictionAffectedComponents(List.of(this.spwTable));
        this.spwTable.setSelectionMode(0);
        this.spwTable.setColumnSelectionAllowed(false);
        this.register(this.spwTable, FID_TABLE);
        this.addListSelectionListener(listSelectionEvent -> this.setButtons());
        Dimension dimension = new Dimension(550, this.spwTable.getRowHeight() * 4 + 20);
        this.spwTable.setPreferredScrollableViewportSize(dimension);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.spwTable);
        this.add((Component)scrollWhenFocusedPane, "Center");
        JPanel jPanel = this.createLineContainer();
        this.buttonBox = new SpectralLineButtonBox();
        jPanel.add(this.buttonBox);
        JCheckBox jCheckBox = this.makeCheckBox(FID_DISPLAY_IMAGE_TABLE_CHECKBOX, "Show image spectral windows", "When selected, displays the image sidebands in the event that 90-degrees Walsh switching is enabled");
        jPanel.add(jCheckBox);
        jCheckBox.setFocusPainted(false);
        jCheckBox.setSelected(false);
        jCheckBox.setEnabled(false);
        this.add((Component)jPanel, "South");
        int n = this.getMyModel().getGroupIndex() + 1;
        this.setBorder(BorderFactory.createTitledBorder("Baseband-" + n));
        this.setMaxRows(SpectralWindowGroupModel.MAX_WINDOWS_PER_BASEBAND);
    }

    public void removeTableHeader() {
        this.spwTable.setTableHeader(null);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(FID_TABLE)) {
            this.setButtons();
            if (this.spwTable != null && this.spwTable.getSelectedRowCount() == 0 && this.spwTable.getRowCount() > 0) {
                this.spwTable.getSelectionModel().setSelectionInterval(0, 0);
            }
            return;
        }
        if (fieldID.equals(FID_SELECT_LINES)) {
            this.buttonBox.setButtons();
        } else if (fieldID.equals(SfiSpectralSetupEditor.FID_WALSH_SWITCHING)) {
            boolean bl;
            TableColumnModel tableColumnModel = this.spwTable.getColumnModel();
            int n = MultiResolutionElementTableModel.ColumnDescriptor.WALSHSWITCH.getColumnIndex();
            try {
                bl = this.spwTable.getColumnName(n).equals(MultiResolutionElementTableModel.ColumnDescriptor.WALSHSWITCH.getColumnName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
            }
            boolean bl2 = (Boolean)object;
            boolean bl3 = this.getMyModel().getSpectralSetupParameters().isSpectralLine();
            if (bl2 && bl3) {
                if (!bl && this.walshSwitchTableColumn != null) {
                    this.spwTable.addColumn(this.walshSwitchTableColumn);
                    this.spwTable.moveColumn(tableColumnModel.getColumnCount() - 1, n);
                }
            } else if (bl) {
                this.walshSwitchTableColumn = tableColumnModel.getColumn(n);
                this.spwTable.removeColumn(this.walshSwitchTableColumn);
            }
        } else if (fieldID.equals(FID_DISPLAY_IMAGE_TABLE_CHECKBOX)) {
            TableCellEditor tableCellEditor;
            if (object == null) {
                return;
            }
            boolean bl = (Boolean)object;
            if (bl && (tableCellEditor = this.spwTable.getCellEditor()) != null && !tableCellEditor.stopCellEditing()) {
                this.getMyModel().update(null, FID_DISPLAY_IMAGE_TABLE_CHECKBOX, false);
                object = false;
            }
        } else if (fieldID.equals(FID_DISPLAY_IMAGE_TABLE_CHECKBOX_USER_CONTROLLABLE)) {
            boolean bl = (Boolean)object;
            this.retrieve(FID_DISPLAY_IMAGE_TABLE_CHECKBOX).setEnabled(bl);
        }
        super.update(fieldID, object);
    }

    protected boolean showsFraction() {
        return true;
    }

    public void setMaxRows(int n) {
        this.buttonBox.setMaxRows(n);
    }

    public JButton getSelectLineButton() {
        return this.buttonBox.selectLineButton;
    }

    private void setButtons() {
        if (!this.isEnabled() || this.buttonBox == null) {
            return;
        }
        this.buttonBox.setButtons();
    }

    public void setButtonBoxVisible(boolean bl) {
        this.buttonBox.setVisible(bl);
    }

    public int getTableColumnWidth(int n) throws IndexOutOfBoundsException {
        TableColumn tableColumn = this.spwTable.getColumnModel().getColumn(n);
        return tableColumn.getPreferredWidth();
    }

    public void setTableColumnWidth(int n, int n2) throws IndexOutOfBoundsException {
        TableColumn tableColumn = this.spwTable.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
    }

    public int getTableColumnCount() {
        return this.spwTable.getColumnCount();
    }

    public void addTableColumnListener(TableColumnModelListener tableColumnModelListener) {
        this.spwTable.getColumnModel().addColumnModelListener(tableColumnModelListener);
    }

    public void removeTableColumnListener(TableColumnModelListener tableColumnModelListener) {
        this.spwTable.getColumnModel().removeColumnModelListener(tableColumnModelListener);
    }

    public void setTablePreferredScrollableViewportSize(Dimension dimension) {
        this.spwTable.setPreferredScrollableViewportSize(dimension);
    }

    public void printElements() {
        ScienceSpectralWindow[] scienceSpectralWindowArray = this.getMyModel().getSpectralWindows();
        System.out.println(scienceSpectralWindowArray.length + " ScienceSpectralWindow");
        int n = 0;
        for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[" + n++ + "] bbc = " + scienceSpectralWindow.getGroupIndex());
            stringBuilder.append(", centerFrequency = " + scienceSpectralWindow.getCenterFrequency());
            stringBuilder.append(", mode = " + scienceSpectralWindow.getCorrConfigMode());
            System.out.println(stringBuilder.toString());
        }
    }

    protected void cancelCellEditing() {
        if (this.spwTable == null) {
            return;
        }
        Enumeration<TableColumn> enumeration = this.spwTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableCellEditor tableCellEditor;
            TableColumn tableColumn = enumeration.nextElement();
            if (tableColumn == null || (tableCellEditor = tableColumn.getCellEditor()) == null) continue;
            tableCellEditor.cancelCellEditing();
        }
    }

    @Override
    public void finalizeUserEdits() {
        if (this.spwTable == null) {
            return;
        }
        Enumeration<TableColumn> enumeration = this.spwTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableCellEditor tableCellEditor;
            TableColumn tableColumn = enumeration.nextElement();
            if (tableColumn == null || (tableCellEditor = tableColumn.getCellEditor()) == null || !ContextSwitchInterface.class.isAssignableFrom(tableCellEditor.getClass())) continue;
            ContextSwitchInterface contextSwitchInterface = (ContextSwitchInterface)((Object)tableCellEditor);
            try {
                contextSwitchInterface.finalizeUserEdits();
            }
            catch (Exception exception) {
                Log.logger(SpectralWindowGroupEditor.class).warning("Unable to finalise user edits : " + exception.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config/otData");
        InitServices.initModelSupportClasses();
        SpectralSetupParameters spectralSetupParameters = SpectralSetupParameters.createSpectralSetupParameters();
        SpectralWindowGroupModel spectralWindowGroupModel = new SpectralWindowGroupModel(spectralSetupParameters, 0);
        SpectralWindowGroupEditor spectralWindowGroupEditor = new SpectralWindowGroupEditor(spectralWindowGroupModel, DialogSpectralLineChooser.getInstance());
        spectralSetupParameters.setPolarisation(CorrPolarization.SINGLE_X.polarization);
        JFrame jFrame = new JFrame("SpectralElementSetupEditor Test");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(spectralWindowGroupEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private class SpectralLineButtonBox
    extends JPanel {
        private int maxRows = -1;
        private JButton selectLineButton;
        private JButton addSPWButton;
        private JButton deleteSPWButton;
        private boolean isVLBIMode = false;

        private SpectralLine convertToSpectralLine(ScienceSpectralWindow scienceSpectralWindow) {
            SpectralLine spectralLine = new SpectralLine();
            spectralLine.setFrequency(scienceSpectralWindow.getCenterFrequency());
            spectralLine.setLineId(scienceSpectralWindow.getSplatalogId());
            spectralLine.setTitle(scienceSpectralWindow.getTransitionName());
            spectralLine.setType(SpectralLine.Type.LINE);
            spectralLine.setScienceSpectralWindowUUID(scienceSpectralWindow.getUUID());
            return spectralLine;
        }

        public SpectralLineButtonBox() {
            EditorManager editorManager = ObservingToolController.getMyInstance().getGui().getEditorManager();
            editorManager.modelFor(ObsProposal.class).subscribe((model, fieldID, object) -> this.setVLBIPulsarMode(fieldID, object));
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
            this.selectLineButton = new JButton("Add spectral window centred on a spectral line");
            this.selectLineButton.setToolTipText("Use the spectral line picker to define a spectral window");
            this.selectLineButton.addActionListener(actionEvent -> {
                this.selectLineButton.setEnabled(false);
                ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
                for (ScienceSpectralWindow scienceSpectralWindow : SpectralWindowGroupEditor.this.getMyModel().getSpectralWindows()) {
                    arrayList.add(this.convertToSpectralLine(scienceSpectralWindow));
                }
                ArrayList arrayList2 = new ArrayList();
                for (ScienceSpectralWindow scienceSpectralWindow : SpectralWindowGroupEditor.this.getMyModel().getSpectralWindowsInOtherGroups()) {
                    arrayList2.add(this.convertToSpectralLine(scienceSpectralWindow));
                }
                Velocity velocity = SpectralWindowGroupEditor.this.getMyModel().getTableModel().getTargetVelocity();
                SpectralLinePublisher spectralLinePublisher = SpectralWindowGroupEditor.this.lineChooser.createPublisher(SpectralWindowGroupEditor.this, FID_SELECT_LINES, this.selectLineButton);
                SpectralWindowGroupEditor.this.lineChooser.chooseMultipleLines(spectralLinePublisher, velocity, arrayList, arrayList2, Optional.of(SpectralWindowGroupEditor.this.getMyModel().getSpectralSetupParameters()));
            });
            this.add(this.selectLineButton);
            this.add(Box.createHorizontalStrut(17));
            this.addSPWButton = new JButton("Add spectral window manually");
            this.addSPWButton.setToolTipText("Define a spectral window at any frequency");
            this.addSPWButton.addActionListener(actionEvent -> {
                int n = this.getSelectedIndex();
                SpectralLine spectralLine = new SpectralLine();
                spectralLine.setTitle("...Enter Name Here...");
                spectralLine.setFrequency(Frequency.createFrequencyGHZ(0.0));
                SpectralWindowGroupEditor.this.getMyModel().addSpectralLine(n + 1, spectralLine);
                this.setSelectedIndex(n + 1);
                this.setButtons();
            });
            this.add(this.addSPWButton);
            this.add(Box.createHorizontalStrut(5));
            this.deleteSPWButton = new JButton("Delete");
            this.deleteSPWButton.setToolTipText("Delete selected spectral window");
            this.deleteSPWButton.addActionListener(actionEvent -> {
                int n = this.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                this.deleteSpectralLine(n);
                int n2 = this.count();
                if (n == 0) {
                    if (n2 != 0) {
                        this.setSelectedIndex(n);
                    }
                } else if (n == n2) {
                    this.setSelectedIndex(n - 1);
                } else if (n != -1) {
                    this.setSelectedIndex(n);
                }
                this.setButtons();
            });
            this.add(this.deleteSPWButton);
            this.add(Box.createHorizontalGlue());
            this.selectLineButton.setName("BtnSelectSpectralLines");
            this.addSPWButton.setName("BtnAddSpectralWindow");
            this.deleteSPWButton.setName("BtnDeleteSpectralWindow");
        }

        private Object setVLBIPulsarMode(@NonNull FieldID fieldID, Object object) {
            if (fieldID == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            if (fieldID.equals(ObsProposalEditor.PROPOSALTYPE_FID) && object != null) {
                this.isVLBIMode = ObsProposal.isProjectTypeVLBIRelated((String)object);
                this.setButtons();
            }
            return object;
        }

        public void setButtons() {
            boolean bl;
            if (!this.isEnabled()) {
                return;
            }
            int n = this.count();
            boolean bl2 = bl = this.isVLBIMode && SpectralWindowGroupEditor.this.getMyModel().getGroupIndex() == 0;
            if (this.maxRows >= 0) {
                boolean bl3 = n < this.maxRows;
                this.addSPWButton.setEnabled(bl3 && !bl);
            }
            if (this.selectLineButton != null) {
                this.selectLineButton.setEnabled(!bl);
            }
            if (this.deleteSPWButton != null) {
                this.deleteSPWButton.setEnabled(!bl && n > 0 && this.getSelectedIndex() != -1);
            }
        }

        public int count() {
            return SpectralWindowGroupEditor.this.getMyModel().getWindowCount();
        }

        public void deleteSpectralLine(int n) {
            SpectralWindowGroupEditor.this.getMyModel().deleteWindow(n);
        }

        public int getSelectedIndex() {
            return SpectralWindowGroupEditor.this.spwTable.getSelectedRow();
        }

        public void setSelectedIndex(int n) {
            SpectralWindowGroupEditor.this.spwTable.getSelectionModel().setSelectionInterval(n, n);
        }

        @Override
        public String toString() {
            return "SpectralWindowGroupEditor.SpectralLineButtonBox(maxRows=" + this.maxRows + ", selectLineButton=" + this.selectLineButton + ", addSPWButton=" + this.addSPWButton + ", deleteSPWButton=" + this.deleteSPWButton + ", isVLBIMode=" + this.isVLBIMode + ")";
        }

        public void setMaxRows(int n) {
            this.maxRows = n;
        }
    }

    public static enum SpectralWindowTableEnum {
        IMAGETABLE,
        NONIMAGETABLE;

    }
}

