/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.entity.xmlbinding.obsproject.types.PerformanceParametersTTimingConstraintsTypeType;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.editors.sciencegoals.ProjectTimeEstimateSummary;
import alma.obsprep.ot.editors.sciencegoals.ProjectTimeEstimateSummaryInterface;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SchedBlockObservingTimeCalculator;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.ToBeSupportedException;
import alma.valuetypes.DataRate;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

public class StandardProjectTimeEstimateSummary
extends ProjectTimeEstimateSummary
implements ProjectTimeEstimateSummaryInterface {
    private final AbstractScienceGoal[] abstractScienceGoals;

    public StandardProjectTimeEstimateSummary(@NonNull AbstractScienceGoal[] abstractScienceGoalArray) {
        if (abstractScienceGoalArray == null) {
            throw new NullPointerException("abstractScienceGoals is marked non-null but is null");
        }
        if (abstractScienceGoalArray.length == 0) {
            throw new IllegalArgumentException("No science goals have been defined");
        }
        this.abstractScienceGoals = abstractScienceGoalArray;
        boolean bl = false;
        for (AbstractScienceGoal abstractScienceGoal : abstractScienceGoalArray) {
            if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("No science goals have been defined");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String info() throws ProjectTimeEstimateSummaryInterface.UnableToGenerateProjectTimeSummaryException, UnknownEntityException {
        boolean bl = ObsProposal.isVLBIRelated();
        this.resetProjectSummaryDataMaps();
        Set<String> set = this.getAllUniqueScienceGoalNames();
        assert (set != null && !set.isEmpty());
        for (AbstractScienceGoal abstractScienceGoal : this.abstractScienceGoals) {
            SchedBlockObservingTimeCalculator schedBlockObservingTimeCalculator;
            if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            SchedBlockObservingTimeCalculator.Builder builder = new SchedBlockObservingTimeCalculator.Builder();
            builder.scienceGoal(scienceGoal);
            try {
                schedBlockObservingTimeCalculator = new SchedBlockObservingTimeCalculator(builder);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new ProjectTimeEstimateSummaryInterface.UnableToGenerateProjectTimeSummaryException(invalidObsProgramParametersException.getMessage());
            }
            Collection<ScienceGoal> collection = schedBlockObservingTimeCalculator.getScienceGoalsWithClusters();
            for (ScienceGoal scienceGoal2 : collection) {
                EnumMap<ProjectTimeEstimateSummary.TimeTableColTypes, Object> enumMap;
                Object object;
                Object object2;
                boolean bl2 = scienceGoal2.isStandAloneACA();
                boolean bl3 = scienceGoal2.isSolarScienceGoal();
                boolean bl4 = scienceGoal2.getPerformanceParameters().isSimultaneous12and7Observation();
                String string = scienceGoal2.getName();
                this.scienceGoalNameMap.put(scienceGoal2, string);
                boolean bl5 = scienceGoal2.getPerformanceParameters().getUseACA();
                boolean bl6 = scienceGoal2.getPerformanceParameters().getUseACA() && scienceGoal2.getPerformanceParameters().getUseTP();
                try {
                    void enum_;
                    Object object3;
                    PerformanceParameters performanceParameters = scienceGoal2.getPerformanceParameters();
                    object2 = new ObservingTimeCalculator(scienceGoal2);
                    object = null;
                    if (performanceParameters.getNeedsMoreTime()) {
                        Object object4 = object = scienceGoal2.isFullPolarization() ? Time.max(AlmaPolicies.getInstance().getMinTimeForPolarisationSB().deepCopy(), performanceParameters.getDesiredTime().deepCopy()) : performanceParameters.getDesiredTime().deepCopy();
                        assert (object != null);
                    }
                    int n = 1;
                    if (performanceParameters.getIsTimeConstrained() && performanceParameters.getTimingConstraintsType() != null && performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.MULTIPLEVISITS.toString())) {
                        n = performanceParameters.getVisitConstraintCount();
                    }
                    enumMap = new EnumMap(ProjectTimeEstimateSummary.TimeTableColTypes.class);
                    for (Enum enum_2 : ProjectTimeEstimateSummary.TimeTableColTypes.values()) {
                        enumMap.put((ProjectTimeEstimateSummary.TimeTableColTypes)enum_2, Time.createTime());
                    }
                    if (bl) {
                        enumMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMEXT, (Time)object.multiply((double)n));
                        if (bl5) {
                            if (!bl3) {
                                if (bl4) {
                                    enumMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACA7M, (Time)object.multiply((double)n));
                                } else {
                                    enumMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACA7M, (Time)((Time)object.multiply((double)n)).multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACA7M, scienceGoal2)));
                                }
                            }
                            if (bl6) {
                                if (bl4) {
                                    enumMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACATP, (Time)object.multiply((double)n));
                                } else {
                                    enumMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACATP, (Time)((Time)object.multiply((double)n)).multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal2)));
                                }
                            }
                        }
                    } else {
                        if (!bl2) {
                            try {
                                enumMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMEXT, ((ObservingTimeCalculator)object2).getTotalRequestedTime(Array.ARRAY_12M, false, false, true));
                            }
                            catch (Exception exception) {
                                enumMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMEXT, Time.createTime());
                            }
                            if (!bl3) {
                                try {
                                    object3 = ((ObservingTimeCalculator)object2).getTotalRequestedTime(Array.ARRAY_12M, false, true, true);
                                    enumMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMCOMPACT, object3);
                                }
                                catch (Exception exception) {
                                    enumMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMCOMPACT, Time.createTime());
                                }
                            }
                        }
                        if (bl5) {
                            if (!bl3) {
                                object3 = ((ObservingTimeCalculator)object2).getTotalRequestedTime(bl4 ? Array.ARRAY_12M : Array.ARRAY_7M, false, false, true);
                                enumMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACA7M, object3);
                            }
                            if (bl6) {
                                object3 = ((ObservingTimeCalculator)object2).getTotalRequestedTime(bl4 ? Array.ARRAY_12M : Array.ARRAY_TP, false, false, true);
                                enumMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACATP, object3);
                            }
                        }
                    }
                    this.estimatedTotalTimeData.put(scienceGoal2, enumMap);
                    object3 = new EnumMap(ProjectTimeEstimateSummary.TimeTableColTypes.class);
                    ProjectTimeEstimateSummary.TimeTableColTypes[] timeTableColTypesArray = ProjectTimeEstimateSummary.TimeTableColTypes.values();
                    int n2 = timeTableColTypesArray.length;
                    boolean i = false;
                    while (enum_ < n2) {
                        ProjectTimeEstimateSummary.TimeTableColTypes timeTableColTypes = timeTableColTypesArray[enum_];
                        object3.put(timeTableColTypes, Time.createTime());
                        ++enum_;
                    }
                    if (object == null) {
                        this.determineCalibrationTimes(scienceGoal2, (Map<ProjectTimeEstimateSummary.TimeTableColTypes, Time>)object3);
                    }
                    this.estimatedCalibrationTimeData.put(scienceGoal2, object3);
                    this.determineDataRates(scienceGoal2, bl2, string, bl6, n);
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    object2 = new EnumMap(ProjectTimeEstimateSummary.DataTableColTypes.class);
                    object = new EnumMap(ProjectTimeEstimateSummary.DataTableColTypes.class);
                    EnumMap<ProjectTimeEstimateSummary.TimeTableColTypes, Time> enumMap2 = new EnumMap<ProjectTimeEstimateSummary.TimeTableColTypes, Time>(ProjectTimeEstimateSummary.TimeTableColTypes.class);
                    enumMap = new EnumMap<ProjectTimeEstimateSummary.TimeTableColTypes, Object>(ProjectTimeEstimateSummary.TimeTableColTypes.class);
                    for (Enum enum_ : ProjectTimeEstimateSummary.DataTableColTypes.values()) {
                        object.put(enum_, StorageVolume.createStorageVolume());
                        object2.put(enum_, DataRate.createDataRate());
                    }
                    for (Enum enum_ : ProjectTimeEstimateSummary.TimeTableColTypes.values()) {
                        enumMap2.put((ProjectTimeEstimateSummary.TimeTableColTypes)enum_, Time.createTime());
                        enumMap.put((ProjectTimeEstimateSummary.TimeTableColTypes)enum_, Time.createTime());
                    }
                    this.estimatedDataRates.put(scienceGoal2, object2);
                    this.estimatedDataVolume.put(scienceGoal2, object);
                    this.estimatedCalibrationTimeData.put(scienceGoal2, enumMap);
                    this.estimatedTotalTimeData.put(scienceGoal2, enumMap2);
                    this.badlyConfiguredScienceGoals.put(scienceGoal2, true);
                }
            }
        }
        return this.build();
    }

    private Set<String> getAllUniqueScienceGoalNames() throws ProjectTimeEstimateSummaryInterface.UnableToGenerateProjectTimeSummaryException {
        HashSet<String> hashSet = new HashSet<String>();
        for (AbstractScienceGoal abstractScienceGoal : this.abstractScienceGoals) {
            if (hashSet.contains(abstractScienceGoal.getName())) {
                throw new ProjectTimeEstimateSummaryInterface.UnableToGenerateProjectTimeSummaryException("All science goals must have unique names");
            }
            hashSet.add(abstractScienceGoal.getName());
        }
        return hashSet;
    }

    private void resetProjectSummaryDataMaps() {
        this.badlyConfiguredScienceGoals.clear();
        this.estimatedDataRates.clear();
        this.estimatedDataVolume.clear();
        this.estimatedCalibrationTimeData.clear();
        this.estimatedTotalTimeData.clear();
        this.scienceGoalNameMap.clear();
    }

    private void determineDataRates(@NonNull ScienceGoal scienceGoal, boolean bl, @NonNull String string, boolean bl2, int n) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoalForCluster is marked non-null but is null");
        }
        if (string == null) {
            throw new NullPointerException("scienceGoalName is marked non-null but is null");
        }
        EnumMap<ProjectTimeEstimateSummary.DataTableColTypes, DataRate> enumMap = new EnumMap<ProjectTimeEstimateSummary.DataTableColTypes, DataRate>(ProjectTimeEstimateSummary.DataTableColTypes.class);
        EnumMap<ProjectTimeEstimateSummary.DataTableColTypes, Object> enumMap2 = new EnumMap<ProjectTimeEstimateSummary.DataTableColTypes, Object>(ProjectTimeEstimateSummary.DataTableColTypes.class);
        DataRate dataRate = DataRate.createDataRate();
        for (Object toBeSupportedException : ProjectTimeEstimateSummary.DataTableColTypes.values()) {
            enumMap.put((ProjectTimeEstimateSummary.DataTableColTypes)((Object)toBeSupportedException), dataRate);
        }
        if (!bl) {
            enumMap.put(ProjectTimeEstimateSummary.DataTableColTypes.TWELVEM, scienceGoal.getAverageDataRate(Array.ARRAY_12M));
        } else {
            enumMap.put(ProjectTimeEstimateSummary.DataTableColTypes.TWELVEM, DataRate.createDataRate());
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        int n2 = performanceParameters.getUseACA() ? 1 : 0;
        if (n2 != 0) {
            enumMap.put(ProjectTimeEstimateSummary.DataTableColTypes.ACA7M, scienceGoal.getAverageDataRate(Array.ARRAY_7M));
            if (bl2) {
                enumMap.put(ProjectTimeEstimateSummary.DataTableColTypes.ACATP, scienceGoal.getAverageDataRate(Array.ARRAY_TP));
            } else {
                enumMap.put(ProjectTimeEstimateSummary.DataTableColTypes.ACATP, dataRate);
            }
        }
        if (!bl) {
            try {
                enumMap2.put(ProjectTimeEstimateSummary.DataTableColTypes.TWELVEM, (Object)((StorageVolume)scienceGoal.getDataVolume(Array.ARRAY_12M).multiply(n)));
            }
            catch (ToBeSupportedException toBeSupportedException) {
                Log.logger(StandardProjectTimeEstimateSummary.class).warning(String.format("Unable to determine data volume for science goal %s for the array %s", new Object[]{string, Array.ARRAY_12M}));
                enumMap2.put(ProjectTimeEstimateSummary.DataTableColTypes.TWELVEM, (Object)StorageVolume.createStorageVolume());
            }
        } else {
            enumMap2.put(ProjectTimeEstimateSummary.DataTableColTypes.TWELVEM, (Object)StorageVolume.createStorageVolume());
        }
        enumMap2.put(ProjectTimeEstimateSummary.DataTableColTypes.ACA7M, (Object)StorageVolume.createStorageVolume());
        enumMap2.put(ProjectTimeEstimateSummary.DataTableColTypes.ACATP, (Object)StorageVolume.createStorageVolume());
        if (n2 != 0) {
            try {
                enumMap2.put(ProjectTimeEstimateSummary.DataTableColTypes.ACA7M, (Object)((StorageVolume)scienceGoal.getDataVolume(Array.ARRAY_7M).multiply(n)));
            }
            catch (ToBeSupportedException toBeSupportedException) {
                Log.logger(StandardProjectTimeEstimateSummary.class).warning(String.format("Unable to determine data volume for science goal %s for the array %s", new Object[]{string, Array.ARRAY_7M}));
            }
            if (bl2) {
                try {
                    Object toBeSupportedException;
                    toBeSupportedException = (StorageVolume)scienceGoal.getDataVolume(Array.ARRAY_TP).multiply(n);
                    if (Double.isNaN(toBeSupportedException.getContent())) {
                        toBeSupportedException = StorageVolume.createStorageVolume();
                    }
                    enumMap2.put(ProjectTimeEstimateSummary.DataTableColTypes.ACATP, toBeSupportedException);
                }
                catch (ToBeSupportedException toBeSupportedException) {
                    Log.logger(StandardProjectTimeEstimateSummary.class).warning(String.format("Unable to determine data volume for science goal %s for the array %s", new Object[]{string, Array.ARRAY_TP}));
                }
            }
        }
        this.estimatedDataRates.put(scienceGoal, enumMap);
        this.estimatedDataVolume.put(scienceGoal, enumMap2);
    }

    private void determineCalibrationTimes(ScienceGoal scienceGoal, Map<ProjectTimeEstimateSummary.TimeTableColTypes, Time> map) throws InvalidObsProgramParametersException, UnknownEntityException {
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        boolean bl = scienceGoal.isStandAloneACA();
        boolean bl2 = scienceGoal.isSolarScienceGoal();
        EnumSet<ObservingTimeCalculator.CalibrationOverheads> enumSet = EnumSet.of(ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONEXECTIMES, ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONOVERHEADS, ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONSLEWTIME);
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        if (!bl) {
            map.put(ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMEXT, scienceGoal.getOverheadTimes(enumSet, Array.ARRAY_12M, targetParameters, false));
            if (!bl2) {
                map.put(ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMCOMPACT, (Time)map.get((Object)ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMEXT).multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, scienceGoal)));
            }
        } else {
            map.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACA7M, scienceGoal.getOverheadTimes(enumSet, Array.ARRAY_7M, targetParameters, false));
        }
        if (performanceParameters.getUseACA()) {
            boolean bl3 = scienceGoal.getPerformanceParameters().isSimultaneous12and7Observation();
            if (bl3) {
                map.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACA7M, Time.createTime());
                map.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACATP, Time.createTime());
            } else {
                if (!bl2) {
                    map.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACA7M, scienceGoal.getOverheadTimes(enumSet, Array.ARRAY_7M, targetParameters, false));
                }
                if (performanceParameters.getUseTP()) {
                    map.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACATP, scienceGoal.getOverheadTimes(enumSet, Array.ARRAY_TP, targetParameters, false));
                } else {
                    map.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACATP, Time.createTime());
                }
            }
        } else {
            map.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACATP, Time.createTime());
            map.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACA7M, Time.createTime());
        }
    }
}

