/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.annotations.SpatialPartOfSpatialDocument;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.ot.editors.spatialvisual.BaseSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualParameters;
import alma.obsprep.ot.editors.spatialvisual.subform.FovParameterEditor;
import alma.obsprep.ot.editors.spatialvisual.subform.ImageQueryEditor;
import alma.obsprep.ot.models.sciencegoals.FieldSetupModel;
import alma.valuetypes.Frequency;
import javax.swing.event.ChangeListener;

public class SpatialVisualParametersModel
extends Model {
    private TargetParameters targetParams = null;
    private BaseSpatialVisualModel spatialVisualModel = null;

    public void updateTargetParams() {
        if (this.getMyModel().getFormModel() instanceof FieldSetupModel) {
            FieldSetupModel fieldSetupModel = (FieldSetupModel)this.getMyModel().getFormModel();
            this.targetParams = fieldSetupModel.getTargetParametersModel().getTargetParameters();
        }
    }

    public Frequency getRepFreq() {
        try {
            ScienceGoal scienceGoal = this.targetParams.getScienceGoal();
            return scienceGoal.getSpectralSetupParameters().getRepresentativeFrequency();
        }
        catch (NullPointerException nullPointerException) {
            return Frequency.createFrequency();
        }
    }

    public Frequency getRepSkyFreq() {
        Object object;
        Object object2;
        Object object3 = this.getMyModel().getDocument();
        if (object3 instanceof BusinessObject && (object2 = (object = (BusinessObject)object3).getParent()) instanceof SchedBlock) {
            SchedBlock schedBlock = (SchedBlock)object2;
            return schedBlock.getSchedulingConstraints().getRepresentativeFrequency().deepCopy();
        }
        if (this.targetParams == null) {
            return Frequency.createFrequency();
        }
        object = this.targetParams.getScienceGoal();
        if (object == null) {
            return Frequency.createFrequency();
        }
        object2 = object.getSpectralSetupParameters();
        Frequency frequency = object2.getRepresentativeFrequency();
        if (((SpectralSetupParameters)((Object)object2)).isSingleContinuumSkyFrequency() || ((SpectralSetupParameters)((Object)object2)).isSpectralScan()) {
            return frequency;
        }
        return frequency.dopplerShifted(this.targetParams.getSourceVelocity());
    }

    public void updateRepSkyFreq() {
        double d = this.getRepSkyFreq().getContentInUnits(Frequency.UNIT_GHZ);
        this.publish(FovParameterEditor.FID_REP_FREQ, String.format("%.3f GHz", d));
    }

    public BaseSpatialVisualModel getMyModel() {
        return this.spatialVisualModel;
    }

    public SpatialVisualParametersModel(BaseSpatialVisualModel baseSpatialVisualModel) {
        super(null);
        this.spatialVisualModel = baseSpatialVisualModel;
        if (this.getMyModel().getFormModel() instanceof FieldSetupModel) {
            this.configureTargetParametersChangeListener();
        }
        this.subscribe(baseSpatialVisualModel.getPointingPatternModel().getFovParameterListener());
    }

    private void configureTargetParametersChangeListener() {
        FieldSetupModel fieldSetupModel = (FieldSetupModel)this.getMyModel().getFormModel();
        ChangeListener changeListener = changeEvent -> {
            this.updateTargetParams();
            this.updateRepSkyFreq();
        };
        fieldSetupModel.addTargetParametersSelectionChangeListener(changeListener);
    }

    @Override
    public void publish() {
        if (this.document != null) {
            SpatialVisualParameters spatialVisualParameters = this.getSpatialVisualParameters();
            this.publish(FovParameterEditor.FID_ARRAY_TYPE, (Object)spatialVisualParameters.getAntenna());
            this.publish(FovParameterEditor.FID_IS_PHASE_ONE, spatialVisualParameters.isPhaseOne());
            this.publish(FovParameterEditor.FID_FOV_SIZE, (Object)spatialVisualParameters.getFovSize());
            this.publish(FovParameterEditor.FID_SHOW_FOV, spatialVisualParameters.isShowsFov());
            this.publish(ImageQueryEditor.FID_IMAGE_SERVER, spatialVisualParameters.getImageServer());
            this.publish(ImageQueryEditor.FID_IMAGE_SIZE, spatialVisualParameters.getSize());
            this.updateTargetParams();
            this.updateRepSkyFreq();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        SpatialVisualParameters spatialVisualParameters = this.getSpatialVisualParameters();
        if (fieldID.equals(FovParameterEditor.FID_ARRAY_TYPE)) {
            Antenna antenna = Antenna.getValue((String)object);
            spatialVisualParameters.setAntenna(antenna);
            this.updateFOVSize();
            return antenna;
        }
        if (fieldID.equals(FovParameterEditor.FID_SHOW_FOV)) {
            Boolean bl = (Boolean)object;
            spatialVisualParameters.setShowsFov(bl);
            return bl;
        }
        if (fieldID.equals(ImageQueryEditor.FID_IMAGE_SERVER)) {
            String string = (String)object;
            if (spatialVisualParameters != null) {
                spatialVisualParameters.setImageServer(string);
            }
            return string;
        }
        if (fieldID.equals(ImageQueryEditor.FID_IMAGE_SIZE)) {
            double d = 0.0;
            try {
                d = DoubleVerifier.parseDouble(object);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            spatialVisualParameters.setSize(d);
            return d;
        }
        return null;
    }

    public SpatialPartOfSpatialDocument getSpatialPart() {
        return this.spatialVisualModel.getFormModel().getSpatialPart();
    }

    public SpatialVisualParameters getSpatialVisualParameters() {
        return (SpatialVisualParameters)this.document;
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }

    @Override
    public void setonlyDocument(Object object) {
        this.document = object;
    }

    protected void clearFovSource() {
        this.getSpatialVisualParameters().setSingleFrequencySource("");
    }

    protected void updateFOVSize() {
        this.publish(FovParameterEditor.FID_FOV_SIZE, (Object)this.getSpatialVisualParameters().getFovSize());
    }

    public TargetParameters getTargetParams() {
        return this.targetParams;
    }
}

