/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.MiscUtils;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AboutDialog
extends GuiFactory.Dialog {
    public static final DialogId browserErrorDialog = new DialogId("Editor.UnexpectedError");
    private static final String user_version_tag = "[USER_VERSION]";
    private static final String alma_version_tag = "[ALMA_VERSION]";
    private static final String patch_version_tag = "[PATCH_VERSION]";
    private static final String ot_logo_tag = "[OT_LOGO]";
    private static final String alma_logo_tag = "[ALMA_LOGO]";
    private static final URL ot_logo_url = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/ot_logo_135x100.jpg");
    private static final URL alma_logo_url = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/alma_logo.gif");
    private static final URL about_alma_html = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/about_alma.html");
    private static final URL about_ot_html = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/about_ot.html");
    private static final URL acknowledgments_html = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/about_acknowledgements.html");
    private static final URL credits_html = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/about_credits.html");
    private static final URL license_html = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/about_license.html");
    private static final URL version_html = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/about_version.html");
    private static final URL releasenotes_html = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/about_releasenotes.html");
    private static AboutDialog instance = null;
    private AboutPanel aboutPanel = null;

    public static AboutDialog getMyInstance() {
        return instance;
    }

    public AboutDialog(String string, String string2, String string3) {
        instance = this;
        this.setTitle("About the ALMA Observing Tool");
        this.aboutPanel = new AboutPanel(this, string, string2, string3);
        this.aboutPanel.setName("AboutDialog");
        this.add(this.aboutPanel);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(550, 450);
        super.setDefaultButton(this.aboutPanel.buttonClose);
    }

    private String getDocument(URL uRL) {
        String string = "";
        Object object = "";
        if (uRL == null) {
            return null;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                object = (String)object + string;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object;
    }

    public void showDialog() {
        if (this.getX() == 0 && this.getY() == 0) {
            this.setLocationRelativeTo(this.getOwner());
        }
        this.setVisible(true);
    }

    public void showReleaseNotes() {
        if (this.getX() == 0 && this.getY() == 0) {
            this.setLocationRelativeTo(this.getOwner());
        }
        this.aboutPanel.tabbedPanel.setSelectedIndex(2);
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        AboutDialog aboutDialog = new AboutDialog("Cycle 0", "R8.0.1", "p1");
        aboutDialog.setVisible(true);
    }

    public class AboutPanel
    extends JPanel
    implements HyperlinkListener {
        private JButton buttonClose;
        private JTextPane paneAboutAlma;
        private JTextPane paneAboutOT;
        private JTextPane paneAcknowledgements;
        private JTextPane paneReleaseNotes;
        private JTextPane paneCredits;
        private JTextPane paneLicense;
        private JTextPane paneVersion;
        private JPanel panelAboutAlma;
        private JPanel panelAboutOT;
        private JPanel panelAcknowledgements;
        private JPanel panelCredits;
        private JPanel panelReleaseNotes;
        private JPanel panelLicense;
        private JPanel panelVersion;
        private JScrollPane scrollAboutAlma;
        private JScrollPane scrollAboutOT;
        private JScrollPane scrollAcknowledgements;
        private JScrollPane scrollReleaseNotes;
        private JScrollPane scrollCredits;
        private JScrollPane scrollLicense;
        private JScrollPane scrollVersion;
        private JTabbedPane tabbedPanel;
        private GuiFactory.Dialog mainDialog = null;

        public AboutPanel(GuiFactory.Dialog dialog, String string, String string2, String string3) {
            this.mainDialog = dialog;
            this.initComponents(string, string2, string3);
        }

        private void initComponents(String string, String string2, String string3) {
            this.tabbedPanel = new JTabbedPane();
            this.tabbedPanel.setName("AboutDialog.tabbedPanel");
            this.panelAboutAlma = new JPanel();
            this.scrollAboutAlma = new JScrollPane();
            this.paneAboutAlma = new JTextPane();
            this.panelAboutOT = new JPanel();
            this.scrollAboutOT = new JScrollPane();
            this.paneAboutOT = new JTextPane();
            this.panelReleaseNotes = new JPanel();
            this.scrollReleaseNotes = new JScrollPane();
            this.paneReleaseNotes = new JTextPane();
            this.panelAcknowledgements = new JPanel();
            this.scrollAcknowledgements = new JScrollPane();
            this.paneAcknowledgements = new JTextPane();
            this.panelCredits = new JPanel();
            this.scrollCredits = new JScrollPane();
            this.paneCredits = new JTextPane();
            this.panelLicense = new JPanel();
            this.scrollLicense = new JScrollPane();
            this.paneLicense = new JTextPane();
            this.panelVersion = new JPanel();
            this.scrollVersion = new JScrollPane();
            this.paneVersion = new JTextPane();
            this.buttonClose = new JButton();
            this.buttonClose.setName("AboutDialog.CloseButton");
            this.paneAboutAlma.setEditable(false);
            this.paneAboutAlma.setContentType("text/html");
            this.paneAboutAlma.setOpaque(true);
            String string4 = AboutDialog.this.getDocument(about_alma_html);
            string4 = string4.replace(AboutDialog.alma_logo_tag, alma_logo_url.toString());
            this.paneAboutAlma.setText(string4);
            this.paneAboutAlma.setCaretPosition(0);
            this.paneAboutAlma.addHyperlinkListener(this);
            this.paneAboutOT.setEditable(false);
            this.paneAboutOT.setContentType("text/html");
            this.paneAboutOT.setOpaque(true);
            string4 = AboutDialog.this.getDocument(about_ot_html);
            string4 = string4.replace(AboutDialog.ot_logo_tag, ot_logo_url.toString());
            this.paneAboutOT.setText(string4);
            this.paneAboutOT.setCaretPosition(0);
            this.paneAboutOT.addHyperlinkListener(this);
            this.paneReleaseNotes.setEditable(false);
            this.paneReleaseNotes.setContentType("text/html");
            this.paneReleaseNotes.setOpaque(true);
            string4 = AboutDialog.this.getDocument(releasenotes_html);
            this.paneReleaseNotes.setText(string4);
            this.paneReleaseNotes.setCaretPosition(0);
            this.paneReleaseNotes.addHyperlinkListener(this);
            this.paneAcknowledgements.setEditable(false);
            this.paneAcknowledgements.setContentType("text/html");
            this.paneAcknowledgements.setOpaque(true);
            string4 = AboutDialog.this.getDocument(acknowledgments_html);
            this.paneAcknowledgements.setText(string4);
            this.paneAcknowledgements.setCaretPosition(0);
            this.paneAcknowledgements.addHyperlinkListener(this);
            this.paneCredits.setEditable(false);
            this.paneCredits.setContentType("text/html");
            this.paneCredits.setOpaque(true);
            string4 = AboutDialog.this.getDocument(credits_html);
            this.paneCredits.setText(string4);
            this.paneCredits.setCaretPosition(0);
            this.paneCredits.addHyperlinkListener(this);
            this.paneLicense.setEditable(false);
            this.paneLicense.setContentType("text/html");
            this.paneLicense.setOpaque(true);
            string4 = AboutDialog.this.getDocument(license_html);
            this.paneLicense.setText(string4);
            this.paneLicense.setCaretPosition(0);
            this.paneLicense.addHyperlinkListener(this);
            this.paneVersion.setEditable(false);
            this.paneVersion.setContentType("text/html");
            this.paneVersion.setOpaque(true);
            string4 = AboutDialog.this.getDocument(version_html);
            string4 = string4.replace(AboutDialog.ot_logo_tag, ot_logo_url.toString());
            string4 = string4.replace(AboutDialog.user_version_tag, string);
            string4 = string4.replace(AboutDialog.alma_version_tag, string2);
            string4 = string4.replace(AboutDialog.patch_version_tag, string3);
            this.paneVersion.setText(string4);
            this.paneVersion.setCaretPosition(0);
            this.paneVersion.addHyperlinkListener(this);
            this.tabbedPanel.setTabPlacement(3);
            this.tabbedPanel.setPreferredSize(new Dimension(450, 350));
            this.scrollAboutAlma.setViewportView(this.paneAboutAlma);
            GroupLayout groupLayout = new GroupLayout(this.panelAboutAlma);
            this.panelAboutAlma.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollAboutAlma, GroupLayout.Alignment.TRAILING, -1, 335, Short.MAX_VALUE));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollAboutAlma, -1, 213, Short.MAX_VALUE));
            this.tabbedPanel.addTab("About ALMA", this.panelAboutAlma);
            this.scrollAboutOT.setViewportView(this.paneAboutOT);
            GroupLayout groupLayout2 = new GroupLayout(this.panelAboutOT);
            this.panelAboutOT.setLayout(groupLayout2);
            groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollAboutOT, GroupLayout.Alignment.TRAILING, -1, 335, Short.MAX_VALUE));
            groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollAboutOT, GroupLayout.Alignment.TRAILING, -1, 213, Short.MAX_VALUE));
            this.tabbedPanel.addTab("About the OT", this.panelAboutOT);
            this.scrollReleaseNotes.setViewportView(this.paneReleaseNotes);
            GroupLayout groupLayout3 = new GroupLayout(this.panelReleaseNotes);
            this.panelReleaseNotes.setLayout(groupLayout3);
            groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollReleaseNotes, -2, 400, Short.MAX_VALUE));
            groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollReleaseNotes, -2, 300, Short.MAX_VALUE));
            this.tabbedPanel.addTab("Release Notes", this.panelReleaseNotes);
            this.scrollAcknowledgements.setViewportView(this.paneAcknowledgements);
            GroupLayout groupLayout4 = new GroupLayout(this.panelAcknowledgements);
            this.panelAcknowledgements.setLayout(groupLayout4);
            groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollAcknowledgements, -1, 335, Short.MAX_VALUE));
            groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollAcknowledgements, -1, 213, Short.MAX_VALUE));
            this.tabbedPanel.addTab("Acknowledgements", this.panelAcknowledgements);
            this.scrollCredits.setViewportView(this.paneCredits);
            GroupLayout groupLayout5 = new GroupLayout(this.panelCredits);
            this.panelCredits.setLayout(groupLayout5);
            groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollCredits, -1, 335, Short.MAX_VALUE));
            groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollCredits, -1, 213, Short.MAX_VALUE));
            this.tabbedPanel.addTab("Credits", this.panelCredits);
            this.scrollLicense.setViewportView(this.paneLicense);
            GroupLayout groupLayout6 = new GroupLayout(this.panelLicense);
            this.panelLicense.setLayout(groupLayout6);
            groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollLicense, GroupLayout.Alignment.TRAILING, -1, 335, Short.MAX_VALUE));
            groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollLicense, GroupLayout.Alignment.TRAILING, -1, 213, Short.MAX_VALUE));
            this.tabbedPanel.addTab("License", this.panelLicense);
            this.scrollVersion.setViewportView(this.paneVersion);
            GroupLayout groupLayout7 = new GroupLayout(this.panelVersion);
            this.panelVersion.setLayout(groupLayout7);
            groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollVersion, GroupLayout.Alignment.TRAILING, -1, 335, Short.MAX_VALUE));
            groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollVersion, GroupLayout.Alignment.TRAILING, -1, 213, Short.MAX_VALUE));
            this.tabbedPanel.addTab("Version", this.panelVersion);
            this.tabbedPanel.setSelectedIndex(1);
            this.buttonClose.setText("Close");
            this.buttonClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AboutPanel.this.buttonCloseActionPerformed(actionEvent);
                }
            });
            GroupLayout groupLayout8 = new GroupLayout(this);
            this.setLayout(groupLayout8);
            groupLayout8.setHorizontalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addContainerGap().addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.tabbedPanel, -1, 400, Short.MAX_VALUE).addComponent(this.buttonClose, -2, 80, -2)).addContainerGap()));
            groupLayout8.setVerticalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addContainerGap().addComponent(this.tabbedPanel, -1, 300, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonClose).addContainerGap()));
        }

        private void _launchBrowser(String string) {
            Desktop desktop = null;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                URI uRI = null;
                try {
                    uRI = new URI(string);
                    desktop.browse(uRI);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Log.logger((Object)this).warning("Got a bad URI " + string + "(" + uRISyntaxException.getMessage() + ")");
                    String string2 = "Unable to load URL " + string + " in desktop browser.\nPlease check your desktop browser configuration.";
                    GUIUtilities.warning(browserErrorDialog, string2);
                }
                catch (IOException iOException) {
                    Log.logger((Object)this).warning("Failed to launch desktop web browser for URI " + uRI.toString() + "(" + iOException.getMessage() + ")");
                    String string3 = "Unable to load URL " + string + " in desktop browser.\nPlease check your desktop browser configuration.";
                    GUIUtilities.warning(browserErrorDialog, string3);
                }
            }
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String string = hyperlinkEvent.getURL() != null ? hyperlinkEvent.getURL().toString() : hyperlinkEvent.getDescription();
                this._launchBrowser(string);
            }
        }

        private void buttonCloseActionPerformed(ActionEvent actionEvent) {
            this.mainDialog.dispose();
        }
    }

    public static enum AboutTabs {
        ABOUT_ALMA("About ALMA"),
        ABOUT_ALMA_OT("About the ALMA OT"),
        ACKNOWLEDGEMENTS("Acknowledgements"),
        CREDITS("Credits"),
        LICENSE("License"),
        VERSION("Version"),
        RELEASENOTES("Release Notes");

        private final String value;

        private AboutTabs(String string2) {
            this.value = string2;
        }

        String value() {
            return this.value;
        }
    }
}

