/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.entity.xmlbinding.obsproject.types.ControlBlockTArrayRequestedType;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.PointingPatternI;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.PointingPatternAdapter;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.editors.misc.IndividualPointingsTableLoader;
import alma.obsprep.ot.editors.schedblock.PointingPatternEditor;
import alma.obsprep.ot.editors.sciencegoals.SfiControlParameterEditor;
import alma.obsprep.ot.editors.sciencegoals.TargetParametersEditor;
import alma.obsprep.ot.editors.spatialvisual.subform.FovParameterEditor;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.models.schedblock.PointingPatternTableModel;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.services.generator.refactored.targetcreator.ACACustomMosaicPointingCalculator;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.astro.PointingCoordsConverter;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import lombok.NonNull;

public class PointingPatternModel
extends Model
implements TableModelListener {
    private static DialogId DIALOG_OUT_OF_RANGE = new DialogId("ExportTargets.OutOfRange", "Exporting to file. Coordinates out of range");
    private static DialogId DIALOG_INVALID_COORDS = new DialogId("ExportTargets.InvalidCoords", "Exporting to file. Invalid coordinates");
    private static DialogId DIALOG_FILE_IO_ERROR = new DialogId("ExportTargets.WriteFileProblem", "Exporting to file. Problem while writing file");
    private PointingPatternTableModel pointingPatternTableModel = null;
    private static final double DEFAULT_COORD = 0.0;
    private boolean isACAEnabled = false;
    private boolean isSACA = false;
    private final ModelChangeSubscriber acaStatusUpdater = (model, fieldID, object) -> {
        boolean bl = this.isACAEnabled;
        if (SfiControlParameterEditor.FID_ACAOBSERVATION.equals(fieldID) && object instanceof Boolean) {
            this.isACAEnabled = (Boolean)object;
            if (bl != this.isACAEnabled && this.isACAEnabled) {
                this.updateNoPointingsFeedback();
            }
            this.publish(PointingPatternEditor.ACA_SCHEDULED, this.isACAEnabled);
        } else if (SfiControlParameterModel.FID_STANDALONE_ACA.equals(fieldID)) {
            this.isSACA = (Boolean)object;
            if (!this.isSACA) {
                this.publish(PointingPatternEditor.POINTING_TYPE_SELECTION, Antenna.ANTENNA_12M.getLabel());
            }
            this.switchPointingsToSelectedArray(this.isSACA ? Antenna.ANTENNA_7M : Antenna.ANTENNA_12M);
            this.publish(PointingPatternEditor.SACA_SCHEDULED, object);
        }
    };
    private final ModelChangeSubscriber fovParameterListener = (model, fieldID, object) -> {
        if (object == null) {
            return;
        }
        if (fieldID.equals(FovParameterEditor.FID_ARRAY_TYPE) && object instanceof Antenna) {
            Antenna antenna = (Antenna)((Object)((Object)object));
            this.switchPointingsToSelectedArray(antenna);
            this.publish(PointingPatternEditor.POINTING_TYPE_SELECTION, ((Antenna)((Object)((Object)object))).getLabel());
        }
    };
    private Antenna arrayPointingsCurrentlySelected = Antenna.ANTENNA_12M;
    private PointingPatternAdapter primaryArrayPointingPattern = null;

    public PointingPatternModel(Object object2) {
        super(object2);
        this.pointingPatternTableModel = new PointingPatternTableModel(this);
        this.pointingPatternTableModel.addTableModelListener(this);
    }

    public PointingPatternI getPointingPattern() {
        return (PointingPatternI)this.document;
    }

    public void originCoordinatesSystemUpdated() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null) {
            return;
        }
        pointingPatternI.originCoordinatesSystemUpdated();
        this.resetSexagesimal();
        this.getPointingPatternTableModel().fireTableStructureChanged();
        this.publish(PointingPatternEditor.POINTING_PATTERN_TABLE_FID, this.getPointingPattern());
    }

    @Override
    public void publish() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI != null) {
            this.getPointingPatternTableModel().fireTableStructureChanged();
            this.publish(PointingPatternEditor.POINTING_PATTERN_TABLE_FID, pointingPatternI);
            this.publish(PointingPatternEditor.OFFSET_COORD_TYPE_SELECTOR, pointingPatternI.isOffsetPointingPattern());
            this.publish(PointingPatternEditor.OFFSET_UNIT_COMBO_FID, pointingPatternI.getOffsetAngleUnit());
            this.publish(PointingPatternEditor.CUSTOM_MOSAIC_CHECKBOX_FID, pointingPatternI.isMosaic());
            this.publish(PointingPatternEditor.IS_PHASE_2, pointingPatternI instanceof PointingPattern);
            this.updateNoPointingsFeedback();
        }
    }

    private void updateNoPointingsFeedback() {
        if (this.getPointingPattern() == null) {
            return;
        }
        int n = this.getPointingCount();
        if (this.isSACA) {
            this.publish(PointingPatternEditor.NPOINTINGS12M_FID, 0);
            this.publish(PointingPatternEditor.NPOINTINGS7M_FID, n);
            this.setIsMosaic(n > 1);
        } else if (!this.getPointingPattern().isPhase2PointingPattern()) {
            if (this.arrayPointingsCurrentlySelected.is12m()) {
                this.publish(PointingPatternEditor.NPOINTINGS12M_FID, n);
                this.publish(PointingPatternEditor.NPOINTINGS7M_FID, this.getACA7mPointingCount());
            } else if (this.arrayPointingsCurrentlySelected.is7m()) {
                int n2 = this.primaryArrayPointingPattern != null ? this.primaryArrayPointingPattern.getPhaseCenterCoordinatesCount() : 0;
                this.publish(PointingPatternEditor.NPOINTINGS12M_FID, n2);
                this.publish(PointingPatternEditor.NPOINTINGS7M_FID, n);
            }
        } else {
            PointingPattern pointingPattern = (PointingPattern)this.getDocument();
            SchedBlock schedBlock = (SchedBlock)pointingPattern.getParent().getParent();
            boolean bl = schedBlock.getObsUnitControl().getArrayRequested().equals(ControlBlockTArrayRequestedType.SEVEN_M.toString());
            if (bl) {
                this.publish(PointingPatternEditor.NPOINTINGS12M_FID, 0);
                this.publish(PointingPatternEditor.NPOINTINGS7M_FID, n);
            } else {
                this.publish(PointingPatternEditor.NPOINTINGS12M_FID, n);
                this.publish(PointingPatternEditor.NPOINTINGS7M_FID, 0);
            }
        }
    }

    private int getACA7mPointingCount() {
        if (!this.isACAEnabled && this.getPointingPattern().isPhase2PointingPattern()) {
            return 0;
        }
        PointingPatternAdapter pointingPatternAdapter = (PointingPatternAdapter)this.document;
        TargetParameters targetParameters = pointingPatternAdapter.getTargetParameters();
        int n = targetParameters.getPointingPattern().getPhaseCenterCoordinatesCount();
        if (n == 0) {
            return 0;
        }
        if (!targetParameters.isMosaic()) {
            return n;
        }
        ScienceGoal scienceGoal = targetParameters.getScienceGoal();
        PointingPattern pointingPattern = PointingPattern.createPointingPattern();
        try {
            ACACustomMosaicPointingCalculator.setupMinBoundingBoxACA7mPointingPattern(targetParameters, pointingPattern, scienceGoal.getSpectralSetupParameters());
        }
        catch (SpectralSetupParameters.CannotDetermineLowestFrequencyException cannotDetermineLowestFrequencyException) {
            Log.logger(PointingPatternModel.class).warning("Unable to determine the number of ACA 7-m pointings");
            return 0;
        }
        return pointingPattern.getNumberOfPointings();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        boolean bl;
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (fieldID.equals(PointingPatternEditor.CUSTOM_MOSAIC_CHECKBOX_FID)) {
            bl = (Boolean)object;
            this.setIsMosaic(bl);
        }
        if (fieldID.equals(PointingPatternEditor.OFFSET_COORD_TYPE_SELECTOR)) {
            bl = object instanceof String ? Boolean.valueOf((String)object).booleanValue() : Boolean.valueOf((Boolean)object).booleanValue();
            if (pointingPatternI != null) {
                pointingPatternI.setOffsetPointingPattern(bl);
            }
            this.resetPointingPatternTable();
        } else if (fieldID.equals(PointingPatternEditor.OFFSET_UNIT_COMBO_FID)) {
            if (pointingPatternI != null) {
                pointingPatternI.setOffsetAngleUnit((String)object);
            }
            this.setOffsetUnit((String)object);
            this.getPointingPatternTableModel().fireTableStructureChanged();
        } else if (fieldID.equals(TargetParametersEditor.FID_NONSIDEREALMOTION)) {
            if (pointingPatternI != null) {
                bl = (Boolean)object;
                if (bl) {
                    if (pointingPatternI.isAbsolutePointingPattern()) {
                        Arrays.asList(pointingPatternI.getPhaseCenterCoordinates()).stream().forEach(skyCoordinates -> skyCoordinates.setAbsoluteCoordinatesInJ2000Deg(0.0, 0.0));
                    }
                    pointingPatternI.setOffsetPointingPattern(true);
                }
                this.resetPointingPatternTable();
            }
            this.publish(fieldID, object);
        } else if (fieldID.equals(PointingPatternEditor.POINTING_TYPE_SELECTION) && object != null) {
            Antenna antenna = Antenna.getValue((String)object);
            this.switchPointingsToSelectedArray(antenna);
        }
        return object;
    }

    private void switchPointingsToSelectedArray(@NonNull Antenna antenna) {
        if (antenna == null) {
            throw new NullPointerException("desiredArray is marked non-null but is null");
        }
        if (this.getPointingPattern() == null || this.getPointingPattern().isPhase2PointingPattern()) {
            return;
        }
        if (antenna.is12m() || this.isSACA) {
            this.loadPrimaryArrayPointingsIntoModel();
        } else if (antenna.is7m() && this.arrayPointingsCurrentlySelected.is12m()) {
            try {
                this.loadSecondaryArrayPointingsIntoModel();
            }
            catch (SpectralSetupParameters.CannotDetermineLowestFrequencyException cannotDetermineLowestFrequencyException) {
                Log.logger(PointingPatternModel.class).warning("Unable to determine the number of ACA 7-m pointings");
                return;
            }
        }
        this.arrayPointingsCurrentlySelected = antenna;
        this.pointingPatternTableModel.fireTableStructureChanged();
    }

    private void loadPrimaryArrayPointingsIntoModel() {
        if (this.primaryArrayPointingPattern == null) {
            return;
        }
        TargetParameters targetParameters = this.primaryArrayPointingPattern.getTargetParameters();
        this.setDocument(this.primaryArrayPointingPattern);
        targetParameters.setSecondaryArrayPointingPattern(Optional.empty());
    }

    private void loadSecondaryArrayPointingsIntoModel() throws SpectralSetupParameters.CannotDetermineLowestFrequencyException {
        this.primaryArrayPointingPattern = (PointingPatternAdapter)this.getDocument();
        this.setDocument(this.create7MPointingPattern(this.primaryArrayPointingPattern));
    }

    PointingPatternAdapter create7MPointingPattern(@NonNull PointingPatternAdapter pointingPatternAdapter) throws SpectralSetupParameters.CannotDetermineLowestFrequencyException {
        if (pointingPatternAdapter == null) {
            throw new NullPointerException("pointingPattern is marked non-null but is null");
        }
        TargetParameters targetParameters = pointingPatternAdapter.getTargetParameters();
        TargetParameters targetParameters2 = targetParameters.deepCopy();
        ScienceGoal scienceGoal = targetParameters.getScienceGoal();
        targetParameters2.setParentScienceGoal(scienceGoal);
        PointingPatternAdapter pointingPatternAdapter2 = targetParameters2.getPointingPattern();
        Stream.of(pointingPatternAdapter2.getPhaseCenterCoordinates()).forEach(skyCoordinates -> pointingPatternAdapter2.removePhaseCenterCoordinates((SkyCoordinates)skyCoordinates));
        PointingPattern pointingPattern = PointingPattern.createPointingPattern();
        if (targetParameters.isMosaic()) {
            ACACustomMosaicPointingCalculator.setupMinBoundingBoxACA7mPointingPattern(targetParameters, pointingPattern, scienceGoal.getSpectralSetupParameters());
            Stream.of(pointingPattern.getPhaseCenterCoordinates()).forEach(skyCoordinates -> pointingPatternAdapter2.addPhaseCenterCoordinates((SkyCoordinates)skyCoordinates));
        } else {
            Stream.of(pointingPatternAdapter.getPhaseCenterCoordinates()).forEach(skyCoordinates -> pointingPatternAdapter2.addPhaseCenterCoordinates(skyCoordinates.deepCopy()));
        }
        targetParameters.setSecondaryArrayPointingPattern(Optional.of(pointingPatternAdapter2));
        return pointingPatternAdapter2;
    }

    public void performCoordinateResetOfAllPointings() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        boolean bl = pointingPatternI.isOffsetPointingPattern();
        SkyCoordinates skyCoordinates = pointingPatternI.getSourceCoordinates();
        int n = pointingPatternI.getPhaseCenterCoordinates().length;
        int n2 = 1;
        for (SkyCoordinates skyCoordinates2 : pointingPatternI.getPhaseCenterCoordinates()) {
            if (n2 == n) break;
            pointingPatternI.removePhaseCenterCoordinates(skyCoordinates2);
            ++n2;
        }
        for (SkyCoordinates skyCoordinates2 : pointingPatternI.getPhaseCenterCoordinates()) {
            if (bl) {
                skyCoordinates2.getLatitude().setContentInDeg(0.0);
                skyCoordinates2.getLongitude().setContentInDeg(0.0);
                continue;
            }
            skyCoordinates2.getLatitude().setContentInDeg(skyCoordinates.getLatitude().getContentInDeg());
            skyCoordinates2.getLongitude().setContentInDeg(skyCoordinates.getLongitude().getContentInDeg());
        }
        this.getPointingPatternTableModel().fireTableStructureChanged();
    }

    public void setOffsetUnit(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("offsetUnit is marked non-null but is null");
        }
        if (this.document != null) {
            PointingPatternI pointingPatternI = this.getPointingPattern();
            for (SkyCoordinates skyCoordinates : pointingPatternI.getPhaseCenterCoordinates()) {
                if (!skyCoordinates.isOffsetCoordinates()) continue;
                double d = skyCoordinates.getLatitude().getContentInUnits(string);
                skyCoordinates.getLatitude().setContent(d);
                skyCoordinates.getLatitude().setUnit(string);
                d = skyCoordinates.getLongitude().getContentInUnits(string);
                skyCoordinates.getLongitude().setContent(d);
                skyCoordinates.getLongitude().setUnit(string);
            }
        }
    }

    public String getDisplayedOffsetUnit() {
        String string = PointingPatternI.DEFAULT_OFFSETANGLE_UNIT;
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI != null) {
            string = pointingPatternI.getOffsetAngleUnit();
        }
        return string;
    }

    public void resetPointingPatternTable() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        boolean bl = pointingPatternI.isOffsetPointingPattern();
        PointingCoordsConverter pointingCoordsConverter = new PointingCoordsConverter();
        pointingCoordsConverter.setOrigin(pointingPatternI.getSourceCoordinates());
        for (SkyCoordinates skyCoordinates : pointingPatternI.getPhaseCenterCoordinates()) {
            pointingCoordsConverter.convert(skyCoordinates, bl);
        }
        this.resetSexagesimal();
        this.getPointingPatternTableModel().fireTableStructureChanged();
    }

    public void resetSexagesimal() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        boolean bl = !pointingPatternI.isOffsetPointingPattern() && SkyCoordinates.isEquatorial(pointingPatternI.getSourceCoordinates().getSystem());
        this.getPointingPatternTableModel().setSexagesimal(bl);
    }

    public SkyCoordinates addPointing(int n, boolean bl) {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null || !pointingPatternI.isPointingPattern()) {
            return null;
        }
        SkyCoordinates skyCoordinates = SkyCoordinates.createAbsoluteCoordinates();
        skyCoordinates.setCoordinatesContents(0.0, 0.0);
        SkyCoordinates skyCoordinates2 = pointingPatternI.getFieldCenterCoordinates();
        if (skyCoordinates2 == null) {
            SkyCoordinates[] skyCoordinatesArray = pointingPatternI.getPhaseCenterCoordinates();
            if (skyCoordinatesArray.length > 0) {
                skyCoordinates2 = skyCoordinatesArray[0];
                skyCoordinates.setSystem(skyCoordinates2.getSystem());
            }
        } else {
            skyCoordinates.setSystem(skyCoordinates2.getSystem());
        }
        if (bl) {
            skyCoordinates.setType(SkyCoordinates.TYPE_RELATIVE);
            skyCoordinates.setCoordinatesUnits(this.getDisplayedOffsetUnit(), this.getDisplayedOffsetUnit());
        }
        if (n == -1) {
            n = this.getPointingCount();
        }
        this.getPointingPattern().addPhaseCenterCoordinates(n, skyCoordinates);
        this.getPointingPatternTableModel().fireTableRowsInserted(n, n);
        this.updateNoPointingsFeedback();
        return skyCoordinates;
    }

    public void deletePointing(int n) {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null || !pointingPatternI.isPointingPattern()) {
            return;
        }
        if (n != -1) {
            SkyCoordinates skyCoordinates = pointingPatternI.getPhaseCenterCoordinates(n);
            this.getPointingPatternTableModel().fireTableRowsDeleted(n, n);
            pointingPatternI.removePhaseCenterCoordinates(skyCoordinates);
            this.updateNoPointingsFeedback();
        }
    }

    public void deleteAllPointings() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null || !pointingPatternI.isPointingPattern()) {
            return;
        }
        int n = this.getPointingCount();
        for (int i = 0; i < n; ++i) {
            pointingPatternI.removePhaseCenterCoordinates(pointingPatternI.getPhaseCenterCoordinates(0));
        }
        this.updateNoPointingsFeedback();
    }

    public SkyCoordinates[] getPointings() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null || !pointingPatternI.isPointingPattern()) {
            return new SkyCoordinates[0];
        }
        return pointingPatternI.getPhaseCenterCoordinates();
    }

    public int getPointingCount() {
        PointingPatternTableModel pointingPatternTableModel = this.getPointingPatternTableModel();
        return pointingPatternTableModel == null ? 0 : pointingPatternTableModel.getRowCount();
    }

    public void setOnlyDocumentAndResetPointingsDisplayedToPrimaryArray(Object object, @NonNull Optional<Antenna> optional) {
        if (optional == null) {
            throw new NullPointerException("primaryAntenna is marked non-null but is null");
        }
        this.primaryArrayPointingPattern = null;
        this.arrayPointingsCurrentlySelected = optional.orElse(Antenna.ANTENNA_12M);
        this.setonlyDocument(object);
    }

    @Override
    public void setonlyDocument(Object object) {
        if (object == null) {
            this.document = null;
            return;
        }
        if (object instanceof PointingPatternI) {
            this.document = object;
        } else if (object instanceof TargetParameters) {
            TargetParameters targetParameters = (TargetParameters)object;
            this.document = targetParameters.getPointingPattern();
        }
        this.refreshSexagesimal();
        this.pointingPatternTableModel.fireTableStructureChanged();
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }

    public void refreshSexagesimal() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null) {
            return;
        }
        String string = pointingPatternI.getSourceCoordinates().getSystem();
        this.refreshSexagesimal(string);
    }

    public void refreshSexagesimal(String string) {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null) {
            return;
        }
        boolean bl = pointingPatternI.isOffsetPointingPattern();
        this.pointingPatternTableModel.setSexagesimal(!bl && SkyCoordinates.isEquatorial(string));
    }

    public boolean isMosaic() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null) {
            return true;
        }
        return pointingPatternI.isMosaic();
    }

    public void setIsMosaic(boolean bl) {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI != null) {
            pointingPatternI.setIsMosaic(bl);
        }
    }

    public void exportAbsoluteCoordsToFile(@NonNull File file, @NonNull PointingPatternEditor.AbsoluteCoordsFormat absoluteCoordsFormat, Optional<Antenna> optional) {
        PointingPatternI pointingPatternI;
        if (file == null) {
            throw new NullPointerException("outputFile is marked non-null but is null");
        }
        if (absoluteCoordsFormat == null) {
            throw new NullPointerException("absCoordsType is marked non-null but is null");
        }
        if (!EnumSet.of(PointingPatternEditor.AbsoluteCoordsFormat.DEGREES, PointingPatternEditor.AbsoluteCoordsFormat.RADIANS, PointingPatternEditor.AbsoluteCoordsFormat.SEXAGESIMAL).contains((Object)absoluteCoordsFormat)) {
            throw new IllegalArgumentException("Unknown absCoordsType has been specified : " + absoluteCoordsFormat);
        }
        try {
            pointingPatternI = this.getPointingPatternToExportToFile(optional);
        }
        catch (ArrayNotScheduledException arrayNotScheduledException) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            assert (fileWriter != null);
            this.writeHeader(fileWriter);
            if (pointingPatternI.isAbsolutePointingPattern()) {
                for (SkyCoordinates skyCoordinates : pointingPatternI.getPhaseCenterCoordinates()) {
                    String string;
                    Object object = "";
                    try {
                        switch (absoluteCoordsFormat) {
                            case DEGREES: {
                                object = (String)object + Double.toString(skyCoordinates.getLongitude().getContentInDeg()) + ",";
                                object = (String)object + Double.toString(skyCoordinates.getLatitude().getContentInDeg()) + ",";
                                break;
                            }
                            case RADIANS: {
                                object = (String)object + Double.toString(skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_RAD)) + ",";
                                object = (String)object + Double.toString(skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_RAD)) + ",";
                                break;
                            }
                            case SEXAGESIMAL: {
                                object = (String)object + skyCoordinates.getLongitude().toHHMMSS() + ",";
                                object = (String)object + skyCoordinates.getLatitude().toDDMMSS() + ",";
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown absCoordsType type specified: " + absoluteCoordsFormat);
                            }
                        }
                    }
                    catch (OutOfRangeException outOfRangeException) {
                        string = "Pointing coordinates out of range for " + skyCoordinates.toString() + ".\nPlease check your system coordinates.";
                        GUIUtilities.error(DIALOG_OUT_OF_RANGE, string);
                    }
                    catch (InvalidCoordException invalidCoordException) {
                        string = "Invalid pointing coordinates for " + skyCoordinates.toString() + ".\nPlease check your system coordinates.";
                        GUIUtilities.error(DIALOG_INVALID_COORDS, string);
                    }
                    fileWriter.write((String)object);
                    fileWriter.write(PointingPatternEditor.PointingStorageFormat.ABSOLUTECOORDS.getLabel() + "," + absoluteCoordsFormat + "\n");
                }
            } else {
                SkyCoordinates skyCoordinates = pointingPatternI.getSourceCoordinates();
                assert (skyCoordinates != null);
                for (SkyCoordinates skyCoordinates2 : pointingPatternI.getPhaseCenterCoordinates()) {
                    String string;
                    Object object = "";
                    try {
                        switch (absoluteCoordsFormat) {
                            case DEGREES: {
                                object = (String)object + Double.toString(skyCoordinates2.getAbsoluteCoordinates(skyCoordinates).getLongitude().getContentInDeg()) + ",";
                                object = (String)object + Double.toString(skyCoordinates2.getAbsoluteCoordinates(skyCoordinates).getLatitude().getContentInDeg()) + ",";
                                break;
                            }
                            case RADIANS: {
                                object = (String)object + Double.toString(skyCoordinates2.getAbsoluteCoordinates(skyCoordinates).getLongitude().getContentInUnits(Longitude.UNIT_RAD)) + ",";
                                object = (String)object + Double.toString(skyCoordinates2.getAbsoluteCoordinates(skyCoordinates).getLatitude().getContentInUnits(Latitude.UNIT_RAD)) + ",";
                                break;
                            }
                            case SEXAGESIMAL: {
                                object = (String)object + skyCoordinates2.getAbsoluteCoordinates(skyCoordinates).getLongitude().toHHMMSS() + ",";
                                object = (String)object + skyCoordinates2.getAbsoluteCoordinates(skyCoordinates).getLatitude().toDDMMSS() + ",";
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown absCoordsType type specified: " + absoluteCoordsFormat);
                            }
                        }
                    }
                    catch (OutOfRangeException outOfRangeException) {
                        string = "Pointing coordinates out of range for " + skyCoordinates2.toString() + ".\nPlease check your system coordinates.";
                        GUIUtilities.error(DIALOG_OUT_OF_RANGE, string);
                    }
                    catch (InvalidCoordException invalidCoordException) {
                        string = "Invalid pointing coordinates for " + skyCoordinates2.toString() + ".\nPlease check your system coordinates.";
                        GUIUtilities.error(DIALOG_INVALID_COORDS, string);
                    }
                    fileWriter.write((String)object);
                    fileWriter.write(PointingPatternEditor.PointingStorageFormat.ABSOLUTECOORDS.getLabel() + "," + absoluteCoordsFormat + "\n");
                }
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            Log.logger(PointingPatternModel.class).warning("Unable to export pointings " + iOException.getMessage());
            String string = "";
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException2) {
                Log.logger(PointingPatternModel.class).warning("Unable to export pointings " + iOException2.getMessage());
            }
            GUIUtilities.error(DIALOG_FILE_IO_ERROR, "Problem occurred while writing pointing\ncoordinates to " + string);
        }
    }

    @NonNull
    PointingPatternI getPointingPatternToExportToFile(@NonNull Optional<Antenna> optional) throws ArrayNotScheduledException {
        PointingPatternAdapter pointingPatternAdapter;
        if (optional == null) {
            throw new NullPointerException("arrayToGeneratePointingsFor is marked non-null but is null");
        }
        if (this.getDocument() instanceof PointingPattern) {
            return (PointingPatternI)this.getDocument();
        }
        PointingPatternAdapter pointingPatternAdapter2 = pointingPatternAdapter = this.primaryArrayPointingPattern != null ? this.primaryArrayPointingPattern : (PointingPatternAdapter)this.getDocument();
        if (optional.isPresent()) {
            Antenna antenna = optional.get();
            if (this.isSACA && antenna.is12m() || !this.isACAEnabled && antenna.is7m()) {
                throw new ArrayNotScheduledException();
            }
            if (!this.isSACA && antenna.is7m() && this.isACAEnabled) {
                try {
                    pointingPatternAdapter = this.create7MPointingPattern(pointingPatternAdapter);
                }
                catch (SpectralSetupParameters.CannotDetermineLowestFrequencyException cannotDetermineLowestFrequencyException) {
                    Log.logger(PointingPatternModel.class).warning("Unable to create 7-m pointings");
                    throw new ArrayNotScheduledException();
                }
            }
        }
        return pointingPatternAdapter;
    }

    public void exportOffsetCoordsToFile(@NonNull File file, @NonNull PointingPatternEditor.OffsetCoordsFormat offsetCoordsFormat, Optional<Antenna> optional) {
        if (file == null) {
            throw new NullPointerException("outputFile is marked non-null but is null");
        }
        if (offsetCoordsFormat == null) {
            throw new NullPointerException("offsetCoordsType is marked non-null but is null");
        }
        PointingPatternI pointingPatternI = null;
        try {
            pointingPatternI = this.getPointingPatternToExportToFile(optional);
        }
        catch (ArrayNotScheduledException arrayNotScheduledException) {
            Log.logger(PointingPatternModel.class).warning("Array not scheduled");
        }
        if (!EnumSet.of(PointingPatternEditor.OffsetCoordsFormat.DEGREES, PointingPatternEditor.OffsetCoordsFormat.ARCMINS, PointingPatternEditor.OffsetCoordsFormat.ARCSECS).contains((Object)offsetCoordsFormat)) {
            throw new IllegalArgumentException("Unknown absCoordsType has been specified: " + offsetCoordsFormat);
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            this.writeHeader(fileWriter);
            assert (fileWriter != null);
            if (pointingPatternI.isAbsolutePointingPattern()) {
                SkyCoordinates skyCoordinates = pointingPatternI.getSourceCoordinates();
                assert (skyCoordinates != null);
                for (SkyCoordinates skyCoordinates2 : pointingPatternI.getPhaseCenterCoordinates()) {
                    Object object = "";
                    SkyCoordinates skyCoordinates3 = skyCoordinates2.getOffsetCoordinates(skyCoordinates);
                    switch (offsetCoordsFormat) {
                        case DEGREES: {
                            object = (String)object + Double.toString(skyCoordinates3.getLongitude().getContentInDeg()) + ",";
                            object = (String)object + Double.toString(skyCoordinates3.getLatitude().getContentInDeg()) + ",";
                            break;
                        }
                        case ARCMINS: {
                            object = (String)object + Double.toString(skyCoordinates3.getLongitude().getContentInUnits(Longitude.UNIT_ARCMIN)) + ",";
                            object = (String)object + Double.toString(skyCoordinates3.getLatitude().getContentInUnits(Latitude.UNIT_ARCMIN)) + ",";
                            break;
                        }
                        case ARCSECS: {
                            object = (String)object + Double.toString(skyCoordinates3.getLongitude().getContentInUnits(Longitude.UNIT_ARCSEC)) + ",";
                            object = (String)object + Double.toString(skyCoordinates3.getLatitude().getContentInUnits(Latitude.UNIT_ARCSEC)) + ",";
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown offsetCoordsType type specified: " + offsetCoordsFormat);
                        }
                    }
                    fileWriter.write((String)object);
                    fileWriter.write(PointingPatternEditor.PointingStorageFormat.OFFSETCOORDS.getLabel() + "," + offsetCoordsFormat + "\n");
                }
                fileWriter.close();
            } else {
                for (SkyCoordinates skyCoordinates : pointingPatternI.getPhaseCenterCoordinates()) {
                    Object object = "";
                    switch (offsetCoordsFormat) {
                        case DEGREES: {
                            object = (String)object + Double.toString(skyCoordinates.getLongitude().getContentInDeg()) + ",";
                            object = (String)object + Double.toString(skyCoordinates.getLatitude().getContentInDeg()) + ",";
                            break;
                        }
                        case ARCMINS: {
                            object = (String)object + Double.toString(skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_ARCMIN)) + ",";
                            object = (String)object + Double.toString(skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_ARCMIN)) + ",";
                            break;
                        }
                        case ARCSECS: {
                            object = (String)object + Double.toString(skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_ARCSEC)) + ",";
                            object = (String)object + Double.toString(skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_ARCSEC)) + ",";
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown offsetCoordsType type specified: " + offsetCoordsFormat);
                        }
                    }
                    fileWriter.write((String)object);
                    fileWriter.write(PointingPatternEditor.PointingStorageFormat.OFFSETCOORDS.getLabel() + "," + offsetCoordsFormat + "\n");
                }
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            Log.logger(PointingPatternModel.class).warning("Unable to export pointings " + iOException.getMessage());
            String string = "";
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            GUIUtilities.error(DIALOG_FILE_IO_ERROR, "Problem occurred while writing pointing\ncoordinates to " + string);
        }
    }

    private void writeHeader(FileWriter fileWriter) throws IOException {
        fileWriter.write("RA , Dec, Coordinate Type, Coordinate Units\n");
        fileWriter.write("--   This signals end of the header\n");
    }

    public void importPointingsFromFile(@NonNull File file, boolean bl) {
        boolean bl2;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        IndividualPointingsTableLoader individualPointingsTableLoader = new IndividualPointingsTableLoader();
        try {
            bl2 = individualPointingsTableLoader.loadList(file, ",");
        }
        catch (IOException iOException) {
            return;
        }
        if (!bl2) {
            return;
        }
        if (!bl) {
            this.deleteAllPointings();
        }
        if (!individualPointingsTableLoader.getList().isEmpty()) {
            this.addToParent(individualPointingsTableLoader.getList());
        }
    }

    private void addToParent(@NonNull List list) {
        if (list == null) {
            throw new NullPointerException("pointingList is marked non-null but is null");
        }
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null || !pointingPatternI.isPointingPattern()) {
            return;
        }
        String string = pointingPatternI.getSourceCoordinates().getSystem();
        Iterator iterator = list.iterator();
        Boolean bl = null;
        while (iterator.hasNext()) {
            try {
                SkyCoordinates skyCoordinates = (SkyCoordinates)iterator.next();
                skyCoordinates.setSystem(string);
                bl = skyCoordinates.isOffsetCoordinates();
                pointingPatternI.addPhaseCenterCoordinates(skyCoordinates);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("The list should contain only type SkyCoordinates");
            }
        }
        this.getPointingPatternTableModel().fireTableRowsInserted(0, list.size() - 1);
        this.updateNoPointingsFeedback();
        if (bl != null) {
            pointingPatternI.setOffsetPointingPattern(bl);
        }
        this.publish();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.updateNoPointingsFeedback();
    }

    public PointingPatternTableModel getPointingPatternTableModel() {
        return this.pointingPatternTableModel;
    }

    public boolean isACAEnabled() {
        return this.isACAEnabled;
    }

    public boolean isSACA() {
        return this.isSACA;
    }

    public ModelChangeSubscriber getAcaStatusUpdater() {
        return this.acaStatusUpdater;
    }

    public ModelChangeSubscriber getFovParameterListener() {
        return this.fovParameterListener;
    }

    public class ArrayNotScheduledException
    extends Exception {
    }
}

