/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.spectralvisual;

import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.hla.runtime.obsprep.interfaces.ModelStructureListener;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyListener;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class TargetParametersTableModel
extends AbstractTableModel {
    private ScienceGoal document = null;
    private final RepresentativeFrequencyListener reprFreqListener = representativeFrequencyChangeEvent -> this.fireTableDataChanged();
    private final PropertyChangeListener sourceVelocityListener = propertyChangeEvent -> {
        Object object = propertyChangeEvent.getSource();
        if (object instanceof TargetParameters && propertyChangeEvent.getPropertyName().endsWith(".sourceVelocity")) {
            TargetParameters targetParameters = (TargetParameters)object;
            int n = targetParameters.getIndex();
            this.fireTableRowsUpdated(n, n);
        }
    };
    private final ModelStructureListener structureListener = new ModelStructureListener(){

        public void businessObjectAddedTo(IBusinessObject iBusinessObject, IBusinessObject iBusinessObject2, Referring.By by, int n) {
            if (iBusinessObject2 == TargetParametersTableModel.this.document && iBusinessObject instanceof TargetParameters) {
                TargetParameters targetParameters = (TargetParameters)iBusinessObject;
                targetParameters.addPropertyChangeListener(TargetParametersTableModel.this.sourceVelocityListener);
                TargetParametersTableModel.this.fireTableRowsInserted(n, n);
            }
        }

        public void businessObjectRemovedFrom(IBusinessObject iBusinessObject, IBusinessObject iBusinessObject2, Referring.By by) {
            if (iBusinessObject2 == TargetParametersTableModel.this.document && iBusinessObject instanceof TargetParameters) {
                TargetParameters targetParameters = (TargetParameters)iBusinessObject;
                targetParameters.removePropertyChangeListener(TargetParametersTableModel.this.sourceVelocityListener);
                TargetParametersTableModel.this.fireTableDataChanged();
            }
        }
    };

    @Override
    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1, -1, 0));
    }

    public TargetParametersTableModel(ScienceGoal scienceGoal) {
        this.setDocument(scienceGoal);
    }

    public void setDocument(ScienceGoal scienceGoal) {
        ObsProject obsProject;
        if (this.document != null) {
            obsProject = scienceGoal.findProject();
            if (obsProject != null) {
                obsProject.removeModelStructureListener(this.structureListener);
            }
            for (TargetParameters targetParameters : this.document.getTargetParameters()) {
                targetParameters.removePropertyChangeListener(this.sourceVelocityListener);
            }
            this.document.removeRepresentativeFrequencyListener(this.reprFreqListener);
        }
        this.document = scienceGoal;
        if (this.document == null) {
            return;
        }
        this.document.addRepresentativeFrequencyListener(this.reprFreqListener);
        obsProject = this.document.findProject();
        if (obsProject != null) {
            obsProject.addModelStructureListener(this.structureListener);
            for (TargetParameters targetParameters : this.document.getTargetParameters()) {
                targetParameters.addPropertyChangeListener(this.sourceVelocityListener);
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return ColumnDescriptor.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return ColumnDescriptor.getColumnDescriptor(n).getColumnName();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return ColumnDescriptor.getColumnDescriptor(n).getColumnClass();
    }

    @Override
    public int getRowCount() {
        if (this.document == null) {
            return 0;
        }
        return this.document.getTargetParametersCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        TargetParameters targetParameters = this.document.getTargetParameters(n);
        SpectralSetupParameters spectralSetupParameters = this.document.getSpectralSetupParameters();
        Velocity velocity = targetParameters.getSourceVelocity();
        switch (ColumnDescriptor.getColumnDescriptor(n2)) {
            case SOURCE_NAME: {
                return targetParameters.getSourceName();
            }
            case VELOCITY_VALUE: {
                return velocity.getCenterVelocity();
            }
            case VELOCITY_SYSTEM: {
                return velocity.getReferenceSystem();
            }
            case REPFREQ_SKYOFFSET: {
                Frequency frequency = spectralSetupParameters.getRepresentativeFrequency();
                Frequency frequency2 = spectralSetupParameters.isSingleContinuumSkyFrequency() || spectralSetupParameters.isSpectralScan() ? frequency : frequency.dopplerShifted(targetParameters.getSourceVelocityInDefaultReferenceFrame(Optional.of(spectralSetupParameters.getScienceGoal())));
                return String.format("%.4f %s", frequency2.getContent(), frequency2.getUnit());
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    public Object[] getLongValues() {
        return new Object[]{ColumnDescriptor.SOURCE_NAME.columnName, ColumnDescriptor.VELOCITY_VALUE.columnName, ColumnDescriptor.VELOCITY_SYSTEM.columnName, ColumnDescriptor.REPFREQ_SKYOFFSET.columnName};
    }

    private static enum ColumnDescriptor {
        SOURCE_NAME("Source Name", String.class),
        VELOCITY_VALUE("Velocity", Double.class),
        VELOCITY_SYSTEM("Frame", String.class),
        REPFREQ_SKYOFFSET("Representative Frequency (Observed)", String.class);

        public final String columnName;
        public final Class<?> columnClass;

        protected static int getColumnCount() {
            return ColumnDescriptor.values().length;
        }

        protected static ColumnDescriptor getColumnDescriptor(int n) {
            return ColumnDescriptor.values()[n];
        }

        private ColumnDescriptor(String string2, Class<?> clazz) {
            this.columnName = string2;
            this.columnClass = clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }
}

