/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.persistence;

import alma.obsprep.util.ZipSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.dtm.ref.DTMNodeList;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PersonalDb {
    private DocumentBuilderFactory dfact = DocumentBuilderFactory.newInstance();
    private XPathFactory xfact = XPathFactory.newInstance();
    private XPathExpression xName;
    private XPathExpression xPI;
    private XPathExpression xCode;

    public PersonalDb() {
        try {
            this.xName = this.compile("/ObsProject/projectName/text()");
            this.xPI = this.compile("/ObsProject/pI/text()");
            this.xCode = this.compile("/ObsProject/code/text()");
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }

    Document parse(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        return this.dfact.newDocumentBuilder().parse(inputStream);
    }

    public XPathExpression compile(String ... stringArray) throws XPathExpressionException {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string);
        }
        String string = stringBuilder.toString();
        XPath xPath = this.xfact.newXPath();
        return xPath.compile(string);
    }

    public Cursor query(List<File> list, String string, XPathExpression xPathExpression) throws XPathExpressionException {
        return new Cursor(list, string, xPathExpression);
    }

    protected class FileScanner {
        protected File aotFile;
        protected String aotEntry;
        protected XPathExpression xPathExpression;
        protected FileResult result;

        protected FileScanner(File file, String string, XPathExpression xPathExpression) {
            this.aotFile = file;
            this.aotEntry = string;
            this.xPathExpression = xPathExpression;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void scan() {
            ArrayList<String> arrayList = new ArrayList<String>();
            byte[] byArray = null;
            FileInputStream fileInputStream = null;
            ZipSupport.ZipReader zipReader = null;
            try {
                Object object;
                fileInputStream = new FileInputStream(this.aotFile);
                zipReader = new ZipSupport.ZipReader(fileInputStream);
                while ((object = zipReader.getZipEntry()) != null) {
                    String string = ((ZipEntry)object).getName();
                    if (string.startsWith(this.aotEntry)) {
                        byte[] byArray2 = ((ZipSupport.ZipNtry)object).getData();
                        Document document = PersonalDb.this.parse(new ByteArrayInputStream(byArray2));
                        Object object2 = this.xPathExpression.evaluate(document, XPathConstants.NODESET);
                        DTMNodeList dTMNodeList = (DTMNodeList)object2;
                        for (int i = 0; i < dTMNodeList.getLength(); ++i) {
                            arrayList.add(dTMNodeList.item(i).getNodeValue());
                        }
                    }
                    if (!string.startsWith("ObsProject")) continue;
                    byArray = ((ZipSupport.ZipNtry)object).getData();
                }
                this.result = new FileResult(this.aotFile, arrayList);
                if (arrayList.size() > 0 && byArray != null && PersonalDb.this.xName != null && PersonalDb.this.xCode != null && PersonalDb.this.xPI != null) {
                    try {
                        object = PersonalDb.this.parse(new ByteArrayInputStream(byArray));
                        this.result.prjName = (String)PersonalDb.this.xName.evaluate(object, XPathConstants.STRING);
                        this.result.prjCode = (String)PersonalDb.this.xCode.evaluate(object, XPathConstants.STRING);
                        this.result.prjPI = (String)PersonalDb.this.xPI.evaluate(object, XPathConstants.STRING);
                    }
                    catch (XPathExpressionException xPathExpressionException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                this.result = new FileResult(this.aotFile, exception);
            }
            finally {
                if (zipReader != null) {
                    try {
                        zipReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public class Cursor
    implements Iterator<FileResult> {
        private List<File> files;
        private int index;
        private String aotEntry;
        private XPathExpression xPathExpression;
        private FileResult lookahead;

        protected Cursor(List<File> list, String string, XPathExpression xPathExpression) {
            this.files = list;
            this.index = 0;
            this.aotEntry = string;
            this.xPathExpression = xPathExpression;
            this.lookahead();
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != null;
        }

        @Override
        public FileResult next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            FileResult fileResult = this.lookahead;
            this.lookahead();
            return fileResult;
        }

        private void lookahead() {
            this.lookahead = null;
            while (this.lookahead == null && this.index < this.files.size()) {
                File file = this.files.get(this.index);
                FileScanner fileScanner = new FileScanner(file, this.aotEntry, this.xPathExpression);
                fileScanner.scan();
                if (fileScanner.result.matches.size() > 0 || fileScanner.result.error != null) {
                    this.lookahead = fileScanner.result;
                }
                ++this.index;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class FileResult {
        public File file;
        public List<String> matches = Collections.EMPTY_LIST;
        public Exception error;
        public String prjName;
        public String prjPI;
        public String prjCode;

        protected FileResult(File file, List<String> list) {
            this.file = file;
            this.matches = list;
        }

        protected FileResult(File file, Exception exception) {
            this.file = file;
            this.error = exception;
        }

        public boolean hasError() {
            return this.error != null;
        }

        public String toString() {
            String string = "File " + this.file.getName() + " - ";
            if (this.hasError()) {
                String string2 = this.error.getMessage() != null ? this.error.getMessage() : this.error.toString();
                return string + "error scanning file: " + string2;
            }
            return string + "found: " + this.matches.toString();
        }
    }
}

