/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ExpectedProperties;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsreview.ObsReview;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.obsproject.ObsProjectValidationUtils;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import lombok.NonNull;

public class ObsProjectValidator
extends AbstractValidator {
    private static final String INTERNAL_VALIDATION_ERROR = "Internal validation error: expecting UnknownEntityException in ObsProjectValidator";

    public ObsProjectValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    public void localValidate(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel) {
        Problem problem;
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        ObsProject obsProject = (ObsProject)businessObject;
        if (obsProject.getPI().equals("")) {
            problem = DefaultProblem.createError("No Principal Investigator specified", "Select the top level Project node in the tree and fill in the Principal Investigator field", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (obsProject.getProjectName().equals("")) {
            problem = DefaultProblem.createError("No Project Name specified", "Select the top level Project node in the tree and fill in the Project Name field", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (obsProject.getVersion().equals("")) {
            problem = DefaultProblem.createError("No Project Version specified", "Select the top level Project node in the tree and fill in the Project Version field", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        String string = obsProject.getStatus();
        try {
            this.checkSourcesHaveNonZeroVelocity(problemListModel, obsProject);
        }
        catch (UnknownEntityException unknownEntityException) {
            problemListModel.add(DefaultProblem.createError(INTERNAL_VALIDATION_ERROR, "Contact your support agent", (IBusinessObject)businessObject));
        }
        this.checkDGCNotEnabledWithLargePrograms(problemListModel, obsProject);
        if (string != ObsProject.STATUS_NEWPHASE1 && string != ObsProject.STATUS_PHASE1SUBMITTED && string != ObsProject.STATUS_REJECTED) {
            this.checkForDuplicateScienceGoalNames(businessObject, problemListModel, obsProject);
            try {
                this.checkSchedBlocksInObsPlan(businessObject, problemListModel, obsProject);
                this.checkAllNonDescopedScienceGoalsHaveSBs(businessObject, problemListModel, obsProject);
            }
            catch (UnknownEntityException unknownEntityException) {
                problemListModel.add(DefaultProblem.createError(INTERNAL_VALIDATION_ERROR, "Contact your support agent", (IBusinessObject)businessObject));
            }
        } else if (!string.equals(ObsProject.STATUS_REJECTED)) {
            this.checkSBsHaveUniqueName(businessObject, problemListModel, obsProject);
        }
    }

    private void checkSBsHaveUniqueName(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ObsProject obsProject) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        try {
            List<SchedBlock> list;
            ObsReview obsReview = obsProject.gettrueObsReview();
            if (obsReview != null && !(list = obsReview.getObsPlan().findSchedBlocks()).isEmpty()) {
                HashSet<String> hashSet = new HashSet<String>();
                for (SchedBlock schedBlock : list) {
                    String string = schedBlock.getName();
                    if (hashSet.contains(string)) {
                        Problem problem = DefaultProblem.createError("Scheduling block name " + string + " is used more than once", "Scheduling block names must be unique. Please edit the name of this scheduling block", schedBlock);
                        problemListModel.add(problem);
                        continue;
                    }
                    hashSet.add(string);
                }
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Problem problem = DefaultProblem.createWarning("Phase 1 SBs were expected but could not be retrieved", "Either regenerate the Phase 1 SBs through the OT or contact your support agent", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private void checkDGCNotEnabledWithLargePrograms(@NonNull ProblemListModel problemListModel, @NonNull ObsProject obsProject) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        ObsProposal obsProposal = null;
        try {
            obsProposal = obsProject.getObsProposal();
            if (obsProposal == null || !obsProposal.isLargeProgram()) {
                return;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            return;
        }
        ObsProgram obsProgram = obsProject.getObsProgram();
        if (obsProgram == null) {
            return;
        }
        for (AbstractScienceGoal abstractScienceGoal : obsProgram.getAbstractScienceGoal()) {
            if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
            ObsProjectValidationUtils.validateNoDGCInLargeProgram(problemListModel, (ScienceGoal)((Object)abstractScienceGoal));
        }
    }

    private void checkAllNonDescopedScienceGoalsHaveSBs(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ObsProject obsProject) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        List<ScienceGoal> list = Arrays.asList(obsProject.getObsProgram().getAbstractScienceGoalScienceGoal());
        list.stream().filter(scienceGoal -> !scienceGoal.getIsDescoped()).forEach(scienceGoal -> {
            ObsUnitSet obsUnitSet = scienceGoal.getObsUnitSet();
            try {
                boolean bl;
                boolean bl2 = bl = obsUnitSet == null || obsUnitSet.findSchedBlocks().isEmpty();
                if (RoleDirectoryServiceHelper.isUserP2G() && bl) {
                    problemListModel.add(DefaultProblem.createWarning(String.format("Science goal (%s) has no SBs attached to it", scienceGoal.getName()), "Please ensure that you generate SBs for this science goal.", (IBusinessObject)scienceGoal));
                }
            }
            catch (Exception exception) {
                problemListModel.add(DefaultProblem.createError(INTERNAL_VALIDATION_ERROR, "Contact your support agent", (IBusinessObject)businessObject));
            }
        });
    }

    private void checkSchedBlocksInObsPlan(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ObsProject obsProject) throws UnknownEntityException {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        List<SchedBlock> list = obsProject.getObsProgram().getObsPlan().findSchedBlocks();
        if (list.isEmpty()) {
            if (RoleDirectoryServiceHelper.isUserP2G()) {
                Problem problem = DefaultProblem.createWarning("The Project contains no SchedBlocks", "Without SBs the project cannot take data.", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            for (SchedBlock schedBlock : list) {
                String string = schedBlock.getName();
                if (hashSet.contains(string)) {
                    Problem problem = DefaultProblem.createError("Scheduling block name " + string + " is used more than once", "Scheduling block names must be unique. Please edit the name of this scheduling block", schedBlock);
                    problemListModel.add(problem);
                    continue;
                }
                hashSet.add(string);
            }
        }
    }

    private void checkForDuplicateScienceGoalNames(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ObsProject obsProject) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        ObsProgram obsProgram = obsProject.getObsProgram();
        if (obsProgram != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (AbstractScienceGoal abstractScienceGoal : obsProgram.getAbstractScienceGoal()) {
                if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
                try {
                    ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
                    String string = scienceGoal.getName().trim();
                    if (hashSet.contains(string)) {
                        problemListModel.add(DefaultProblem.createError("This program already contains a science goal labelled " + string, " Please change the name of the science goal.", (IBusinessObject)businessObject));
                        continue;
                    }
                    hashSet.add(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void checkSourcesHaveNonZeroVelocity(@NonNull ProblemListModel problemListModel, @NonNull ObsProject obsProject) throws UnknownEntityException {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        for (ScienceGoal scienceGoal : obsProject.getPhaseApplicableScienceGoals()) {
            for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                boolean bl;
                if (targetParameters.getNonSiderealMotion()) continue;
                boolean bl2 = targetParameters.getSourceVelocity().getCenterVelocity().isZero();
                ExpectedProperties expectedProperties = targetParameters.getExpectedProperties();
                boolean bl3 = bl = !expectedProperties.getExpectedLineWidth().isZero() || !expectedProperties.getExpectedPeakLineFluxDensity().isZero();
                if (!bl || !bl2) continue;
                problemListModel.add(DefaultProblem.createWarning("At least one of your sources has its velocity set to zero", "Please enter a velocity for all sources if known - this aids automatic line searches", (IBusinessObject)targetParameters));
                return;
            }
        }
    }
}

