/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.VisitConstraint;
import alma.obsprep.datastructures.GenericNaryTree;
import alma.obsprep.datastructures.Node;
import alma.obsprep.ot.valdef.obsproject.LoopingTimeConstraintsException;
import alma.obsprep.ot.valdef.obsproject.VisitTimings;
import alma.valuetypes.Time;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.DoubleRange;
import org.apache.commons.lang.math.Range;

public final class RelativeVisitTimingTreeUtils {
    private static GenericNaryTree<VisitTimings> buildVisitTree(@NonNull PerformanceParameters performanceParameters) {
        if (performanceParameters == null) {
            throw new NullPointerException("clusterPerformanceParameters is marked non-null but is null");
        }
        Node<VisitTimings> node2 = new Node<VisitTimings>(VisitTimings.builder().isRoot(true).build());
        GenericNaryTree<VisitTimings> genericNaryTree = new GenericNaryTree<VisitTimings>(node2);
        RelativeVisitTimingTreeUtils.buildRelativeTimingTree(performanceParameters, node2, performanceParameters.getVisitConstraint(0));
        if (Log.logger(RelativeVisitTimingTreeUtils.class).fine()) {
            StringBuilder stringBuilder = new StringBuilder();
            genericNaryTree.getPreOrderTraversal().stream().filter(node -> ((VisitTimings)node.getData()).getVisit() != null).forEach(node -> stringBuilder.append(((VisitTimings)node.getData()).getVisit().getVisitId() + "->"));
            Log.logger(RelativeVisitTimingTreeUtils.class).fine("Pre-order transit: " + StringUtils.removeEnd((String)stringBuilder.toString(), (String)"->"));
            for (ArrayList<Node<VisitTimings>> arrayList : genericNaryTree.getPathsFromRootToAnyLeaf()) {
                StringBuilder stringBuilder2 = new StringBuilder();
                arrayList.stream().filter(node -> ((VisitTimings)node.getData()).getVisit() != null).forEach(node -> stringBuilder.append(((VisitTimings)node.getData()).getVisit().getVisitId() + "->"));
                Log.logger(RelativeVisitTimingTreeUtils.class).fine("Tree path : " + StringUtils.removeEnd((String)stringBuilder2.toString(), (String)"->"));
            }
        }
        return genericNaryTree;
    }

    private static void buildRelativeTimingTree(@NonNull PerformanceParameters performanceParameters, @NonNull Node<VisitTimings> node, @NonNull VisitConstraint visitConstraint3) {
        if (performanceParameters == null) {
            throw new NullPointerException("clusterPerformanceParameters is marked non-null but is null");
        }
        if (node == null) {
            throw new NullPointerException("currentNode is marked non-null but is null");
        }
        if (visitConstraint3 == null) {
            throw new NullPointerException("currentVisit is marked non-null but is null");
        }
        Node<VisitTimings> node2 = new Node<VisitTimings>(VisitTimings.builder().visit(visitConstraint3).build());
        node.addChild(node2);
        Stream.of(performanceParameters.getVisitConstraint()).filter(visitConstraint2 -> visitConstraint2.getPreviousVisitId() == visitConstraint3.getVisitId()).forEach(visitConstraint -> RelativeVisitTimingTreeUtils.buildRelativeTimingTree(performanceParameters, node2, visitConstraint));
    }

    public static List<RelativeVisitOverlapResult> determineRelativeVisitOverlaps(@NonNull PerformanceParameters performanceParameters, double d) throws LoopingTimeConstraintsException, UnableToFindCommonParentException {
        if (performanceParameters == null) {
            throw new NullPointerException("performanceParameters is marked non-null but is null");
        }
        HashSet hashSet = new HashSet();
        ArrayList<RelativeVisitOverlapResult> arrayList = new ArrayList<RelativeVisitOverlapResult>();
        GenericNaryTree<VisitTimings> genericNaryTree = RelativeVisitTimingTreeUtils.buildVisitTree(performanceParameters);
        List<Node<VisitTimings>> list = genericNaryTree.getBreadthFirstPreOrderTraversal();
        for (Node<VisitTimings> node : list) {
            if (node.getData().isRoot()) continue;
            for (Node<VisitTimings> node2 : list) {
                if (node2.getData().isRoot() || hashSet.contains(Objects.hash(node, node2)) || node2.equals(node)) continue;
                RelativeVisitTimingTreeUtils.checkForRelativeVisitOverlap(node, node2, arrayList, performanceParameters, d);
            }
        }
        return arrayList;
    }

    private static boolean checkForRelativeVisitOverlap(@NonNull Node<VisitTimings> node, @NonNull Node<VisitTimings> node2, @NonNull ArrayList<RelativeVisitOverlapResult> arrayList, PerformanceParameters performanceParameters, double d) throws LoopingTimeConstraintsException, UnableToFindCommonParentException {
        Object object;
        Object object2;
        LinkedList<Node<VisitTimings>> linkedList;
        if (node == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (node2 == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        if (arrayList == null) {
            throw new NullPointerException("relativeVisitOverlaps is marked non-null but is null");
        }
        Time time = Time.createTimeSec(d);
        VisitConstraint visitConstraint = node.getData().getVisit();
        VisitConstraint visitConstraint2 = node2.getData().getVisit();
        if (visitConstraint.isFixedStart() || visitConstraint2.isFixedStart() || visitConstraint.isArbitraryStart() || visitConstraint2.isArbitraryStart()) {
            return false;
        }
        Time time2 = visitConstraint.getAllowedMargin();
        Time time3 = visitConstraint2.getAllowedMargin();
        boolean bl = false;
        LinkedList<Node<VisitTimings>> linkedList2 = RelativeVisitTimingTreeUtils.getPathFromRootToNode(node);
        if (RelativeVisitTimingTreeUtils.isBranchesDistinct(linkedList2, linkedList = RelativeVisitTimingTreeUtils.getPathFromRootToNode(node2))) {
            try {
                object2 = RelativeVisitTimingTreeUtils.getDivergenceNodes(linkedList2, linkedList);
                object = RelativeVisitTimingTreeUtils.getExecutionWindow(((DivergenceNodes)object2).getNodeA(), node);
                VisitTimeWindow visitTimeWindow = RelativeVisitTimingTreeUtils.getExecutionWindow(((DivergenceNodes)object2).getNodeB(), node2);
                DoubleRange doubleRange = new DoubleRange(((VisitTimeWindow)object).getStartWindow().getSecs() + 1.0, ((VisitTimeWindow)object).getEndWindow().getSecs() - 1.0);
                DoubleRange doubleRange2 = new DoubleRange(visitTimeWindow.getStartWindow().getSecs() + 1.0, visitTimeWindow.getEndWindow().getSecs() - 1.0);
                bl = doubleRange.overlapsRange((Range)doubleRange2);
            }
            catch (UnableToGetRelativeTimeWindowException unableToGetRelativeTimeWindowException) {
                throw new LoopingTimeConstraintsException(unableToGetRelativeTimeWindowException);
            }
        } else {
            object2 = RelativeVisitTimingTreeUtils.getRelativeStartTime(node);
            bl = object2.isGreaterThan((AbstractDoubleWithUnit)(object = RelativeVisitTimingTreeUtils.getRelativeStartTime(node2))) ? ((Time)object2.minus((AbstractDoubleWithUnit)time2)).isLessThanOrEqualTo((AbstractDoubleWithUnit)((Time)object.plus((AbstractDoubleWithUnit)time))) : ((Time)object.minus((AbstractDoubleWithUnit)time3)).isLessThanOrEqualTo((AbstractDoubleWithUnit)((Time)object2.plus((AbstractDoubleWithUnit)time)));
        }
        if (bl) {
            object2 = new RelativeVisitOverlapResult(node.getData(), node2.getData());
            int n = ((RelativeVisitOverlapResult)object2).getVisitA().getVisit().getVisitId();
            int n2 = ((RelativeVisitOverlapResult)object2).getVisitB().getVisit().getVisitId();
            boolean bl2 = arrayList.stream().anyMatch(relativeVisitOverlapResult -> {
                int n3 = relativeVisitOverlapResult.getVisitA().getVisit().getVisitId();
                int n4 = relativeVisitOverlapResult.getVisitB().getVisit().getVisitId();
                return n == n3 && n2 == n4 || n2 == n3 && n == n4;
            });
            if (!bl2) {
                arrayList.add((RelativeVisitOverlapResult)object2);
            }
        }
        return bl;
    }

    private static VisitTimeWindow getExecutionWindow(@NonNull Node<VisitTimings> node, @NonNull Node<VisitTimings> node2) throws UnableToGetRelativeTimeWindowException {
        if (node == null) {
            throw new NullPointerException("startNode is marked non-null but is null");
        }
        if (node2 == null) {
            throw new NullPointerException("nodeToEstablishTimings is marked non-null but is null");
        }
        Time time = Time.createTime();
        Time time2 = Time.createTime();
        Node<VisitTimings> node3 = node2;
        do {
            VisitConstraint visitConstraint = node3.getData().getVisit();
            time.aggregate((Time)visitConstraint.getRequiredDelay().minus((AbstractDoubleWithUnit)visitConstraint.getAllowedMargin()));
            time2.aggregate((Time)visitConstraint.getRequiredDelay().plus((AbstractDoubleWithUnit)visitConstraint.getAllowedMargin()));
            assert (node3 != null);
            if (!node.equals(node3)) continue;
            return new VisitTimeWindow(time, time2);
        } while ((node3 = node3.getParent()) != null);
        throw new UnableToGetRelativeTimeWindowException();
    }

    private static DivergenceNodes getDivergenceNodes(@NonNull LinkedList<Node<VisitTimings>> linkedList, @NonNull LinkedList<Node<VisitTimings>> linkedList2) throws UnableToFindCommonParentException {
        if (linkedList == null) {
            throw new NullPointerException("branchA is marked non-null but is null");
        }
        if (linkedList2 == null) {
            throw new NullPointerException("branchB is marked non-null but is null");
        }
        Iterator<Node<VisitTimings>> iterator = linkedList.descendingIterator();
        while (iterator.hasNext()) {
            Node<VisitTimings> node = iterator.next();
            Iterator<Node<VisitTimings>> iterator2 = linkedList2.descendingIterator();
            while (iterator2.hasNext()) {
                Node<VisitTimings> node2 = iterator2.next();
                if (!node.getParent().equals(node2.getParent())) continue;
                return new DivergenceNodes(node, node2);
            }
        }
        throw new UnableToFindCommonParentException();
    }

    private static Time getRelativeStartTime(@NonNull Node<VisitTimings> node) {
        if (node == null) {
            throw new NullPointerException("relativeVisit is marked non-null but is null");
        }
        VisitConstraint visitConstraint = node.getData().getVisit();
        if (visitConstraint.isFixedStart() || visitConstraint.isArbitraryStart()) {
            throw new IllegalArgumentException("relativeVisit is a fixed visit");
        }
        Time time = Time.createTime();
        Node<VisitTimings> node2 = node;
        do {
            time.aggregate(node2.getData().getVisit().getRequiredDelay());
        } while ((node2 = node2.getParent()).getParent() != null && !node2.getParent().getData().isRoot());
        return time;
    }

    private static boolean isBranchesDistinct(List<Node<VisitTimings>> list, List<Node<VisitTimings>> list2) {
        int n = list.size() - 1 < list2.size() - 1 ? list.size() - 1 : list2.size() - 1;
        Set set = list.stream().filter(node -> ((VisitTimings)node.getData()).getVisit() != null).map(node -> ((VisitTimings)node.getData()).getVisit().getVisitId()).collect(Collectors.toUnmodifiableSet());
        Set set2 = list2.stream().filter(node -> ((VisitTimings)node.getData()).getVisit() != null).map(node -> ((VisitTimings)node.getData()).getVisit().getVisitId()).collect(Collectors.toUnmodifiableSet());
        return Sets.intersection(set, set2).size() != n;
    }

    private static LinkedList<Node<VisitTimings>> getPathFromRootToNode(@NonNull Node<VisitTimings> node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        LinkedList<Node<VisitTimings>> linkedList = new LinkedList<Node<VisitTimings>>();
        linkedList.add(node);
        Node<VisitTimings> node2 = node;
        while (node2.getParent() != null) {
            node2 = node2.getParent();
            linkedList.addFirst(node2);
        }
        return linkedList;
    }

    static Instant getNominalStartTime(@NonNull PerformanceParameters performanceParameters, VisitConstraint visitConstraint) throws LoopingTimeConstraintsException {
        if (performanceParameters == null) {
            throw new NullPointerException("pp is marked non-null but is null");
        }
        if (visitConstraint == null) {
            return null;
        }
        if (visitConstraint.getIsFixedStart()) {
            return visitConstraint.getStartTimeInDate().toInstant();
        }
        if (visitConstraint.getPreviousVisitId() > 0) {
            Instant instant = RelativeVisitTimingTreeUtils.getNominalStartTime(performanceParameters, visitConstraint.getPreviousVisitId(), visitConstraint.getVisitId());
            instant = instant.plus(Math.round(visitConstraint.getRequiredDelay().getContentInUnits(Time.UNIT_MIN)), ChronoUnit.MINUTES);
            return instant;
        }
        return ZonedDateTime.now(ZoneOffset.UTC).withNano(0).toInstant();
    }

    private static Instant getNominalStartTime(@NonNull PerformanceParameters performanceParameters, int n, int n2) throws LoopingTimeConstraintsException {
        VisitConstraint visitConstraint;
        if (performanceParameters == null) {
            throw new NullPointerException("pp is marked non-null but is null");
        }
        if ((visitConstraint = performanceParameters.getVisitConstraint(--n)) == null) {
            return null;
        }
        if (visitConstraint.getIsFixedStart()) {
            return visitConstraint.getStartTimeInDate().toInstant();
        }
        if (visitConstraint.getPreviousVisitId() > 0) {
            if (visitConstraint.getPreviousVisitId() == n2) {
                throw new LoopingTimeConstraintsException();
            }
            Instant instant = RelativeVisitTimingTreeUtils.getNominalStartTime(performanceParameters, visitConstraint.getPreviousVisitId(), n2);
            instant = instant.plus(Math.round(visitConstraint.getRequiredDelay().getContentInUnits(Time.UNIT_MIN)), ChronoUnit.MINUTES);
            return instant;
        }
        return ZonedDateTime.now(ZoneOffset.UTC).withNano(0).toInstant();
    }

    private RelativeVisitTimingTreeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class VisitTimeWindow {
        @NonNull
        private Time startWindow;
        @NonNull
        private Time endWindow;

        @NonNull
        public Time getStartWindow() {
            return this.startWindow;
        }

        @NonNull
        public Time getEndWindow() {
            return this.endWindow;
        }

        public void setStartWindow(@NonNull Time time) {
            if (time == null) {
                throw new NullPointerException("startWindow is marked non-null but is null");
            }
            this.startWindow = time;
        }

        public void setEndWindow(@NonNull Time time) {
            if (time == null) {
                throw new NullPointerException("endWindow is marked non-null but is null");
            }
            this.endWindow = time;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof VisitTimeWindow)) {
                return false;
            }
            VisitTimeWindow visitTimeWindow = (VisitTimeWindow)object;
            if (!visitTimeWindow.canEqual(this)) {
                return false;
            }
            Time time = this.getStartWindow();
            Time time2 = visitTimeWindow.getStartWindow();
            if (time == null ? time2 != null : !time.equals(time2)) {
                return false;
            }
            Time time3 = this.getEndWindow();
            Time time4 = visitTimeWindow.getEndWindow();
            return !(time3 == null ? time4 != null : !time3.equals(time4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof VisitTimeWindow;
        }

        public int hashCode() {
            int n = 1;
            Time time = this.getStartWindow();
            n = n * 59 + (time == null ? 43 : time.hashCode());
            Time time2 = this.getEndWindow();
            n = n * 59 + (time2 == null ? 43 : time2.hashCode());
            return n;
        }

        public VisitTimeWindow(@NonNull Time time, @NonNull Time time2) {
            if (time == null) {
                throw new NullPointerException("startWindow is marked non-null but is null");
            }
            if (time2 == null) {
                throw new NullPointerException("endWindow is marked non-null but is null");
            }
            this.startWindow = time;
            this.endWindow = time2;
        }

        public String toString() {
            return "RelativeVisitTimingTreeUtils.VisitTimeWindow(startWindow=" + this.getStartWindow() + ", endWindow=" + this.getEndWindow() + ")";
        }
    }

    private static class DivergenceNodes {
        @NonNull
        private Node<VisitTimings> nodeA;
        @NonNull
        private Node<VisitTimings> nodeB;

        @NonNull
        public Node<VisitTimings> getNodeA() {
            return this.nodeA;
        }

        @NonNull
        public Node<VisitTimings> getNodeB() {
            return this.nodeB;
        }

        public void setNodeA(@NonNull Node<VisitTimings> node) {
            if (node == null) {
                throw new NullPointerException("nodeA is marked non-null but is null");
            }
            this.nodeA = node;
        }

        public void setNodeB(@NonNull Node<VisitTimings> node) {
            if (node == null) {
                throw new NullPointerException("nodeB is marked non-null but is null");
            }
            this.nodeB = node;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DivergenceNodes)) {
                return false;
            }
            DivergenceNodes divergenceNodes = (DivergenceNodes)object;
            if (!divergenceNodes.canEqual(this)) {
                return false;
            }
            Node<VisitTimings> node = this.getNodeA();
            Node<VisitTimings> node2 = divergenceNodes.getNodeA();
            if (node == null ? node2 != null : !((Object)node).equals(node2)) {
                return false;
            }
            Node<VisitTimings> node3 = this.getNodeB();
            Node<VisitTimings> node4 = divergenceNodes.getNodeB();
            return !(node3 == null ? node4 != null : !((Object)node3).equals(node4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof DivergenceNodes;
        }

        public int hashCode() {
            int n = 1;
            Node<VisitTimings> node = this.getNodeA();
            n = n * 59 + (node == null ? 43 : node.hashCode());
            Node<VisitTimings> node2 = this.getNodeB();
            n = n * 59 + (node2 == null ? 43 : node2.hashCode());
            return n;
        }

        public DivergenceNodes(@NonNull Node<VisitTimings> node, @NonNull Node<VisitTimings> node2) {
            if (node == null) {
                throw new NullPointerException("nodeA is marked non-null but is null");
            }
            if (node2 == null) {
                throw new NullPointerException("nodeB is marked non-null but is null");
            }
            this.nodeA = node;
            this.nodeB = node2;
        }

        public String toString() {
            return "RelativeVisitTimingTreeUtils.DivergenceNodes(nodeA=" + this.getNodeA() + ", nodeB=" + this.getNodeB() + ")";
        }
    }

    public static class RelativeVisitOverlapResult {
        @NonNull
        private VisitTimings visitA;
        @NonNull
        private VisitTimings visitB;

        @NonNull
        public VisitTimings getVisitA() {
            return this.visitA;
        }

        @NonNull
        public VisitTimings getVisitB() {
            return this.visitB;
        }

        public void setVisitA(@NonNull VisitTimings visitTimings) {
            if (visitTimings == null) {
                throw new NullPointerException("visitA is marked non-null but is null");
            }
            this.visitA = visitTimings;
        }

        public void setVisitB(@NonNull VisitTimings visitTimings) {
            if (visitTimings == null) {
                throw new NullPointerException("visitB is marked non-null but is null");
            }
            this.visitB = visitTimings;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof RelativeVisitOverlapResult)) {
                return false;
            }
            RelativeVisitOverlapResult relativeVisitOverlapResult = (RelativeVisitOverlapResult)object;
            if (!relativeVisitOverlapResult.canEqual(this)) {
                return false;
            }
            VisitTimings visitTimings = this.getVisitA();
            VisitTimings visitTimings2 = relativeVisitOverlapResult.getVisitA();
            if (visitTimings == null ? visitTimings2 != null : !((Object)visitTimings).equals(visitTimings2)) {
                return false;
            }
            VisitTimings visitTimings3 = this.getVisitB();
            VisitTimings visitTimings4 = relativeVisitOverlapResult.getVisitB();
            return !(visitTimings3 == null ? visitTimings4 != null : !((Object)visitTimings3).equals(visitTimings4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof RelativeVisitOverlapResult;
        }

        public int hashCode() {
            int n = 1;
            VisitTimings visitTimings = this.getVisitA();
            n = n * 59 + (visitTimings == null ? 43 : ((Object)visitTimings).hashCode());
            VisitTimings visitTimings2 = this.getVisitB();
            n = n * 59 + (visitTimings2 == null ? 43 : ((Object)visitTimings2).hashCode());
            return n;
        }

        public RelativeVisitOverlapResult(@NonNull VisitTimings visitTimings, @NonNull VisitTimings visitTimings2) {
            if (visitTimings == null) {
                throw new NullPointerException("visitA is marked non-null but is null");
            }
            if (visitTimings2 == null) {
                throw new NullPointerException("visitB is marked non-null but is null");
            }
            this.visitA = visitTimings;
            this.visitB = visitTimings2;
        }

        public String toString() {
            return "RelativeVisitTimingTreeUtils.RelativeVisitOverlapResult(visitA=" + this.getVisitA() + ", visitB=" + this.getVisitB() + ")";
        }
    }

    public static class UnableToFindCommonParentException
    extends Exception {
    }

    public static class UnableToGetRelativeTimeWindowException
    extends Exception {
    }
}

