/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

public class SBTimeEstimateHelper {
    private final Map<CalType, ArrayList<CalibrationStatistics>> calibrationTimeStats = new HashMap<CalType, ArrayList<CalibrationStatistics>>(60);
    private SchedBlock schedBlock = null;
    private final Map<String, ArrayList<CalObs>> observingGroups = new HashMap<String, ArrayList<CalObs>>(10);

    public SBTimeEstimateHelper(SchedBlock schedBlock) {
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            this.observingGroups.put(observingGroup.getName(), new ArrayList());
        }
        this.schedBlock = schedBlock;
    }

    public void addCalibrationExecutionStats(CalType calType, Time time, Time time2, Long l) {
        if (this.calibrationTimeStats.get((Object)calType) == null) {
            this.calibrationTimeStats.put(calType, new ArrayList());
        }
        ArrayList<CalibrationStatistics> arrayList = this.calibrationTimeStats.get((Object)calType);
        arrayList.add(new CalibrationStatistics(time, time2, l));
    }

    public void addCalibrationToGroup(@NonNull String string, @NonNull CalObs calObs) {
        if (string == null) {
            throw new NullPointerException("observingGroupName is marked non-null but is null");
        }
        if (calObs == null) {
            throw new NullPointerException("calibrationObservation is marked non-null but is null");
        }
        if (!this.observingGroups.containsKey(string)) {
            this.observingGroups.put(string, new ArrayList());
        }
        this.observingGroups.get(string).add(calObs);
    }

    public static GroupType getGroupType(String string) throws UnknownObservingGroupTypeException {
        for (String string2 : GroupType.CALIBRATORS.getObservingGroupLabelPrefixes()) {
            if (!string.startsWith(string2)) continue;
            return GroupType.CALIBRATORS;
        }
        for (String string2 : GroupType.SCIENCE.getObservingGroupLabelPrefixes()) {
            if (!string.startsWith(string2)) continue;
            return GroupType.SCIENCE;
        }
        throw new UnknownObservingGroupTypeException("Unable to deduce the observing group type for " + string);
    }

    public List<CalObs[]> getCalibrationsForGroup(@NonNull GroupType groupType) {
        String[] stringArray;
        if (groupType == null) {
            throw new NullPointerException("observingGroupType is marked non-null but is null");
        }
        ArrayList<CalObs[]> arrayList = new ArrayList<CalObs[]>();
        switch (groupType) {
            case CALIBRATORS: {
                stringArray = GroupType.CALIBRATORS.getObservingGroupLabelPrefixes();
                break;
            }
            case SCIENCE: {
                stringArray = GroupType.SCIENCE.getObservingGroupLabelPrefixes();
                break;
            }
            default: {
                throw new RuntimeException("Unknown observing group detected");
            }
        }
        for (String string : this.observingGroups.keySet()) {
            for (String string2 : stringArray) {
                if (!string.startsWith(string2)) continue;
                arrayList.add(this.observingGroups.get(string).toArray(new CalObs[this.observingGroups.get(string).size()]));
            }
        }
        return arrayList;
    }

    public CalObs[] getCalibrationsForGroup(String string) throws UnknownObservingGroupTypeException {
        if (!this.observingGroups.containsKey(string)) {
            throw new UnknownObservingGroupTypeException("Unknown observing group specified " + string);
        }
        return this.observingGroups.get(string).toArray(new CalObs[this.observingGroups.get(string).size()]);
    }

    public Integer getNumberOfExecutions() {
        return this.schedBlock.getSchedBlockControl().getExecutionCount();
    }

    public String toString() {
        ArrayList<Object> arrayList;
        StringBuffer stringBuffer = new StringBuffer();
        for (String object : this.observingGroups.keySet()) {
            stringBuffer.append(object + "\n");
            arrayList = this.observingGroups.get(object);
            for (Object object2 : arrayList) {
                try {
                    stringBuffer.append(object2.getClass().getName() + "  Cycle time " + ((CalObs)object2).cycleTime() + " Int. time " + ((CalObs)object2).calTime() + "\n");
                }
                catch (SourceNeverVisibleException | InvalidFrequencyException exception) {
                    exception.printStackTrace();
                }
            }
        }
        for (CalType calType : this.calibrationTimeStats.keySet()) {
            arrayList = this.calibrationTimeStats.get((Object)calType);
            if (arrayList == null) continue;
            for (Object object2 : arrayList) {
                stringBuffer.append("Execution stats for cal " + calType + " Cycle Time : " + ((CalibrationStatistics)object2).getCycleTime() + " Execution count " + ((CalibrationStatistics)object2).getExecutionCount() + " Execution Time " + ((CalibrationStatistics)object2).getExecutionTime() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public String[] getObservingGroupNames() {
        Set<String> set = this.observingGroups.keySet();
        return set.toArray(new String[set.size()]);
    }

    public SchedBlock getSchedBlock() {
        return this.schedBlock;
    }

    public static enum GroupType {
        CALIBRATORS(new String[]{"Calibrators", "One time calibrators"}),
        SCIENCE(new String[]{"Science", "Tuning Group"});

        @NonNull
        private String[] observingGroupLabelPrefixes;

        public static GroupType getGroupType(String string) throws UnknownObservingGroupTypeException {
            for (GroupType groupType : GroupType.values()) {
                for (String string2 : groupType.getObservingGroupLabelPrefixes()) {
                    if (!string.startsWith(string2)) continue;
                    return groupType;
                }
            }
            throw new UnknownObservingGroupTypeException("Unable to find group type " + string);
        }

        private GroupType(String[] stringArray) {
            if (stringArray == null) {
                throw new NullPointerException("observingGroupLabelPrefixes is marked non-null but is null");
            }
            this.observingGroupLabelPrefixes = stringArray;
        }

        @NonNull
        public String[] getObservingGroupLabelPrefixes() {
            return this.observingGroupLabelPrefixes;
        }
    }

    private static class CalibrationStatistics {
        @NonNull
        private Time executionTime;
        @NonNull
        private Time cycleTime;
        @NonNull
        private Long executionCount;

        public String toString() {
            return "Scan time " + this.executionTime + " cycle time " + this.cycleTime + " execution count " + this.executionCount;
        }

        public CalibrationStatistics(@NonNull Time time, @NonNull Time time2, @NonNull Long l) {
            if (time == null) {
                throw new NullPointerException("executionTime is marked non-null but is null");
            }
            if (time2 == null) {
                throw new NullPointerException("cycleTime is marked non-null but is null");
            }
            if (l == null) {
                throw new NullPointerException("executionCount is marked non-null but is null");
            }
            this.executionTime = time;
            this.cycleTime = time2;
            this.executionCount = l;
        }

        @NonNull
        public Time getExecutionTime() {
            return this.executionTime;
        }

        @NonNull
        public Time getCycleTime() {
            return this.cycleTime;
        }

        @NonNull
        public Long getExecutionCount() {
            return this.executionCount;
        }

        public void setExecutionTime(@NonNull Time time) {
            if (time == null) {
                throw new NullPointerException("executionTime is marked non-null but is null");
            }
            this.executionTime = time;
        }

        public void setCycleTime(@NonNull Time time) {
            if (time == null) {
                throw new NullPointerException("cycleTime is marked non-null but is null");
            }
            this.cycleTime = time;
        }

        public void setExecutionCount(@NonNull Long l) {
            if (l == null) {
                throw new NullPointerException("executionCount is marked non-null but is null");
            }
            this.executionCount = l;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CalibrationStatistics)) {
                return false;
            }
            CalibrationStatistics calibrationStatistics = (CalibrationStatistics)object;
            if (!calibrationStatistics.canEqual(this)) {
                return false;
            }
            Long l = this.getExecutionCount();
            Long l2 = calibrationStatistics.getExecutionCount();
            if (l == null ? l2 != null : !((Object)l).equals(l2)) {
                return false;
            }
            Time time = this.getExecutionTime();
            Time time2 = calibrationStatistics.getExecutionTime();
            if (time == null ? time2 != null : !time.equals(time2)) {
                return false;
            }
            Time time3 = this.getCycleTime();
            Time time4 = calibrationStatistics.getCycleTime();
            return !(time3 == null ? time4 != null : !time3.equals(time4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof CalibrationStatistics;
        }

        public int hashCode() {
            int n = 1;
            Long l = this.getExecutionCount();
            n = n * 59 + (l == null ? 43 : ((Object)l).hashCode());
            Time time = this.getExecutionTime();
            n = n * 59 + (time == null ? 43 : time.hashCode());
            Time time2 = this.getCycleTime();
            n = n * 59 + (time2 == null ? 43 : time2.hashCode());
            return n;
        }
    }

    public static class CalibrationTimeSummaryRecord {
        @NonNull
        private Time totalExecutionTime;
        @NonNull
        private Long totalNumberOfExecutions;
        @NonNull
        private Time cycleTime;

        public CalibrationTimeSummaryRecord(@NonNull Time time, @NonNull Long l, @NonNull Time time2) {
            if (time == null) {
                throw new NullPointerException("totalExecutionTime is marked non-null but is null");
            }
            if (l == null) {
                throw new NullPointerException("totalNumberOfExecutions is marked non-null but is null");
            }
            if (time2 == null) {
                throw new NullPointerException("cycleTime is marked non-null but is null");
            }
            this.totalExecutionTime = time;
            this.totalNumberOfExecutions = l;
            this.cycleTime = time2;
        }

        @NonNull
        public Time getTotalExecutionTime() {
            return this.totalExecutionTime;
        }

        @NonNull
        public Long getTotalNumberOfExecutions() {
            return this.totalNumberOfExecutions;
        }

        @NonNull
        public Time getCycleTime() {
            return this.cycleTime;
        }

        public void setTotalExecutionTime(@NonNull Time time) {
            if (time == null) {
                throw new NullPointerException("totalExecutionTime is marked non-null but is null");
            }
            this.totalExecutionTime = time;
        }

        public void setTotalNumberOfExecutions(@NonNull Long l) {
            if (l == null) {
                throw new NullPointerException("totalNumberOfExecutions is marked non-null but is null");
            }
            this.totalNumberOfExecutions = l;
        }

        public void setCycleTime(@NonNull Time time) {
            if (time == null) {
                throw new NullPointerException("cycleTime is marked non-null but is null");
            }
            this.cycleTime = time;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CalibrationTimeSummaryRecord)) {
                return false;
            }
            CalibrationTimeSummaryRecord calibrationTimeSummaryRecord = (CalibrationTimeSummaryRecord)object;
            if (!calibrationTimeSummaryRecord.canEqual(this)) {
                return false;
            }
            Long l = this.getTotalNumberOfExecutions();
            Long l2 = calibrationTimeSummaryRecord.getTotalNumberOfExecutions();
            if (l == null ? l2 != null : !((Object)l).equals(l2)) {
                return false;
            }
            Time time = this.getTotalExecutionTime();
            Time time2 = calibrationTimeSummaryRecord.getTotalExecutionTime();
            if (time == null ? time2 != null : !time.equals(time2)) {
                return false;
            }
            Time time3 = this.getCycleTime();
            Time time4 = calibrationTimeSummaryRecord.getCycleTime();
            return !(time3 == null ? time4 != null : !time3.equals(time4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof CalibrationTimeSummaryRecord;
        }

        public int hashCode() {
            int n = 1;
            Long l = this.getTotalNumberOfExecutions();
            n = n * 59 + (l == null ? 43 : ((Object)l).hashCode());
            Time time = this.getTotalExecutionTime();
            n = n * 59 + (time == null ? 43 : time.hashCode());
            Time time2 = this.getCycleTime();
            n = n * 59 + (time2 == null ? 43 : time2.hashCode());
            return n;
        }

        public String toString() {
            return "SBTimeEstimateHelper.CalibrationTimeSummaryRecord(totalExecutionTime=" + this.getTotalExecutionTime() + ", totalNumberOfExecutions=" + this.getTotalNumberOfExecutions() + ", cycleTime=" + this.getCycleTime() + ")";
        }
    }

    public static class UnknownObservingGroupTypeException
    extends Exception {
        public UnknownObservingGroupTypeException(String string) {
            super(string);
        }
    }
}

