/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationModel;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.MatchedConfiguration;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.util.AngleRange;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserAngle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;

public class ConfigurationHelper {
    private static final double AR_RANGE_TOLERANCE = 0.001;
    private static CacheAccess<Integer, MatchedConfiguration> bestMatchCache = JCS.getInstance((String)"bestMatchCache");

    public static UserAngle[] determineARRangeForARModeAny(ScienceGoal scienceGoal) {
        Set<Configuration> set = Configuration.getAnyConfigurations();
        OptionalDouble optionalDouble = set.stream().mapToDouble(configuration -> configuration.getMaxBaseline()).max();
        OptionalDouble optionalDouble2 = set.stream().mapToDouble(configuration -> configuration.getMaxBaseline()).min();
        Optional<Configuration> optional = set.stream().filter(configuration -> configuration.getMaxBaseline() == optionalDouble.getAsDouble()).findFirst();
        Optional<Configuration> optional2 = set.stream().filter(configuration -> configuration.getMaxBaseline() == optionalDouble.getAsDouble()).findFirst();
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        assert (optional.isPresent() && optional2.isPresent());
        Angle angle = null;
        Angle angle2 = null;
        ScienceGoal scienceGoal2 = scienceGoal.getParentScienceGoal();
        if (scienceGoal2 == null) {
            scienceGoal2 = scienceGoal;
        }
        try {
            angle = optional.get().getAchievableAngularResolutionForClusters(scienceGoal2, SfiControlParameterModel.RequestAngularResolutionEnum.FINEST, frequency, RequestedArray.TWELVE_M);
            angle2 = optional2.get().getAchievableAngularResolutionForClusters(scienceGoal2, SfiControlParameterModel.RequestAngularResolutionEnum.COARSEST, frequency, RequestedArray.TWELVE_M);
        }
        catch (InvalidConfigurationParametersException | InvalidObsProgramParametersException exception) {
            Log.logger(TechnicalJustificationModel.class).info("Unable to determine AR  : " + exception.getMessage());
        }
        UserAngle userAngle = UserAngle.createUserAngle(angle.getContent(), angle.getUnit(), frequency);
        UserAngle userAngle2 = UserAngle.createUserAngle(angle2.getContent(), angle2.getUnit(), frequency);
        return new UserAngle[]{userAngle2, userAngle};
    }

    public static MatchedConfiguration getBestMatchedConfiguration(double d, @NonNull RequestedArray requestedArray, @NonNull ScienceGoal scienceGoal, ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations, @NonNull Configuration.DesiredAngularResolution desiredAngularResolution, boolean bl) throws InvalidConfigurationParametersException {
        Collection<ScienceGoal> collection;
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedSG is marked non-null but is null");
        }
        if (desiredAngularResolution == null) {
            throw new NullPointerException("angularResolutionConstraint is marked non-null but is null");
        }
        if (!EnumSet.of(RequestedArray.SEVEN_M, RequestedArray.TWELVE_M).contains((Object)requestedArray)) {
            throw new IllegalArgumentException("Illegal argument: array must be 12-m or 7-m");
        }
        if (scienceGoalConfigurations.isEmpty()) {
            throw new IllegalArgumentException("Illegal argument: configurationsToBeScheduled.isEmpty() (" + scienceGoalConfigurations.isEmpty() + ") did not pass the test: configurationsToBeScheduled.isEmpty() test");
        }
        Integer n = Objects.hash(new Object[]{d, requestedArray, scienceGoal.toXml(), scienceGoalConfigurations, desiredAngularResolution, bl});
        MatchedConfiguration matchedConfiguration = (MatchedConfiguration)bestMatchCache.get((Object)n);
        if (matchedConfiguration != null) {
            return matchedConfiguration;
        }
        MatchedConfiguration matchedConfiguration2 = new MatchedConfiguration();
        Configuration configuration = null;
        double d2 = Double.POSITIVE_INFINITY;
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        try {
            collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        block2: for (ConfigurationSet configurationSet : scienceGoalConfigurations) {
            Optional<Configuration> optional;
            Optional<Configuration> optional2 = requestedArray.equals((Object)RequestedArray.TWELVE_M) ? (bl ? configurationSet.getTM2Configuration() : configurationSet.getTM1Configuration()) : (optional = configurationSet.getAca7mConfiguration());
            if (!optional.isPresent()) {
                throw new IllegalArgumentException("No configuration found");
            }
            for (ScienceGoal scienceGoal2 : collection) {
                Configuration configuration2 = optional.get();
                if (configuration == null) {
                    configuration = configuration2;
                    d2 = configuration2.getAchievableResolution(d, scienceGoal2, requestedArray);
                    continue block2;
                }
                double d3 = configuration2.getAchievableResolution(d, scienceGoal2, requestedArray);
                if (desiredAngularResolution.equals((Object)Configuration.DesiredAngularResolution.FINEST)) {
                    if (!(d3 < d2)) continue;
                    d2 = d3;
                    configuration = configuration2;
                    continue;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
                configuration = configuration2;
            }
        }
        assert (configuration != null);
        matchedConfiguration2.setConfiguration(Optional.of(configuration));
        matchedConfiguration2.setConfigurationAR(Angle.createAngle((double)d2, (String)Angle.UNIT_ARCSEC));
        bestMatchCache.put((Object)n, (Object)matchedConfiguration2);
        return matchedConfiguration2;
    }

    static ConfigurationsForResolutionRange getConfigurationsForResolutionRange(double d, RequestedArray requestedArray, ScienceGoal scienceGoal, Optional<ReceiverBand> optional, Angle angle, double d2, double d3) throws InvalidConfigurationParametersException {
        ConfigurationsForResolutionRange configurationsForResolutionRange = new ConfigurationsForResolutionRange();
        List<Configuration> list = configurationsForResolutionRange.getConfigurations();
        boolean bl = false;
        for (Configuration configuration2 : Configuration.getKnownConfigurations(requestedArray)) {
            try {
                double d4;
                if (!configuration2.isReceiverSupported(optional.orElseGet(() -> ReceiverBand.getReceiverBand(d))) || !(d3 + 0.001 >= (d4 = configuration2.getAchievableResolution(d, scienceGoal, requestedArray))) || !(d2 - 0.001 <= d4)) continue;
                if (!Configuration.isLongBaselineConfiguration(configuration2)) {
                    bl = true;
                }
                list.add(configuration2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidConfigurationParametersException(d);
            }
        }
        if (bl) {
            configurationsForResolutionRange.setConfigurations(list.stream().filter(configuration -> !Configuration.isLongBaselineConfiguration(configuration)).collect(Collectors.toList()));
            if (configurationsForResolutionRange.getConfigurations().size() != list.size()) {
                configurationsForResolutionRange.setLongbaselineConfigurationsTruncated(true);
            }
        }
        return configurationsForResolutionRange;
    }

    public static Angle getAchievableAngularResolutionForAllClusters(@NonNull ScienceGoal scienceGoal, @NonNull SfiControlParameterModel.RequestAngularResolutionEnum requestAngularResolutionEnum, @NonNull Configuration.ConfigurationExtent configurationExtent, @NonNull Frequency frequency, @NonNull RequestedArray requestedArray) throws InvalidObsProgramParametersException, InvalidConfigurationParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (requestAngularResolutionEnum == null) {
            throw new NullPointerException("angularResolutionPerformance is marked non-null but is null");
        }
        if (configurationExtent == null) {
            throw new NullPointerException("configurationExtent is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("repFreq is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        Double d = null;
        block10: for (ScienceGoal scienceGoal2 : sourceClusterDetector.splitScienceGoalIntoSourceClusters()) {
            Configuration configuration = null;
            switch (configurationExtent) {
                case COMPACT: {
                    try {
                        configuration = Configuration.getMostCompactConfiguration(requestedArray);
                        break;
                    }
                    catch (Configuration.UnableToDetermineConfigurationException unableToDetermineConfigurationException) {
                        throw new IllegalArgumentException("Unknown array type " + requestedArray);
                    }
                }
                case EXTENDED: {
                    configuration = Configuration.getMostExtendedCompatibleConfiguration(requestedArray, scienceGoal);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown configurationExtent specified : " + configurationExtent);
                }
            }
            assert (configuration != null) : "Configuration should not be null when determining the angular resolution";
            double d2 = configuration.getAchievableResolution(frequency.getContentInGHz(), scienceGoal2, requestedArray);
            if (d == null) {
                d = d2;
                continue;
            }
            switch (requestAngularResolutionEnum) {
                case FINEST: {
                    if (!(d2 < d)) continue block10;
                    d = d2;
                    continue block10;
                }
                case COARSEST: {
                    if (!(d2 > d)) continue block10;
                    d = d2;
                    continue block10;
                }
            }
            throw new RuntimeException("Unable to determine the performance required " + requestAngularResolutionEnum);
        }
        return Angle.createAngle((double)d, (String)Angle.UNIT_ARCSEC);
    }

    public static Angle getAchievableAngularResolutionForAllClusters(@NonNull ScienceGoal scienceGoal, @NonNull SfiControlParameterModel.RequestAngularResolutionEnum requestAngularResolutionEnum, @NonNull Frequency frequency, Configuration configuration, RequestedArray requestedArray) throws InvalidObsProgramParametersException, InvalidConfigurationParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (requestAngularResolutionEnum == null) {
            throw new NullPointerException("angularResolutionPerformance is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("repFreq is marked non-null but is null");
        }
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        Double d = null;
        block4: for (ScienceGoal scienceGoal2 : sourceClusterDetector.splitScienceGoalIntoSourceClusters()) {
            double d2 = configuration.getAchievableResolution(frequency.getContentInGHz(), scienceGoal2, requestedArray);
            if (d == null) {
                d = d2;
                continue;
            }
            switch (requestAngularResolutionEnum) {
                case FINEST: {
                    if (!(d2 < d)) continue block4;
                    d = d2;
                    continue block4;
                }
                case COARSEST: {
                    if (!(d2 > d)) continue block4;
                    d = d2;
                    continue block4;
                }
            }
            throw new RuntimeException("Unable to determine the performance required " + requestAngularResolutionEnum);
        }
        return Angle.createAngle((double)d, (String)Angle.UNIT_ARCSEC);
    }

    public static AngleRange getARsForConfigsInARRange(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, InvalidConfigurationParametersException {
        MatchedConfiguration matchedConfiguration = null;
        Frequency frequency = scienceGoal.getPerformanceParameters().getRepresentativeFrequencyWithSkyOffset();
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal, RequestedArray.TWELVE_M);
        MatchedConfiguration matchedConfiguration2 = ConfigurationHelper.getBestMatchedConfiguration(frequency.getContentInGHz(), RequestedArray.TWELVE_M, scienceGoal, scienceGoalConfigurations, Configuration.DesiredAngularResolution.COARSEST, false);
        matchedConfiguration = ConfigurationHelper.getBestMatchedConfiguration(frequency.getContentInGHz(), RequestedArray.TWELVE_M, scienceGoal, scienceGoalConfigurations, Configuration.DesiredAngularResolution.FINEST, false);
        assert (matchedConfiguration2 != null && matchedConfiguration != null);
        return new AngleRange(matchedConfiguration.getConfigurationAR(), matchedConfiguration2.getConfigurationAR());
    }

    public static boolean isConfigurationInSet(@NonNull Configuration configuration, int ... nArray) {
        if (configuration == null) {
            throw new NullPointerException("configurationToFind is marked non-null but is null");
        }
        if (nArray.length == 0) {
            return false;
        }
        for (int n : nArray) {
            if (configuration.getNumber() != n) continue;
            return true;
        }
        return false;
    }

    public static class ConfigurationsForResolutionRange {
        private List<Configuration> configurations = new ArrayList<Configuration>();
        private boolean isLongbaselineConfigurationsTruncated = false;

        public List<Configuration> getConfigurations() {
            return this.configurations;
        }

        public boolean isLongbaselineConfigurationsTruncated() {
            return this.isLongbaselineConfigurationsTruncated;
        }

        public void setConfigurations(List<Configuration> list) {
            this.configurations = list;
        }

        public void setLongbaselineConfigurationsTruncated(boolean bl) {
            this.isLongbaselineConfigurationsTruncated = bl;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ConfigurationsForResolutionRange)) {
                return false;
            }
            ConfigurationsForResolutionRange configurationsForResolutionRange = (ConfigurationsForResolutionRange)object;
            if (!configurationsForResolutionRange.canEqual(this)) {
                return false;
            }
            if (this.isLongbaselineConfigurationsTruncated() != configurationsForResolutionRange.isLongbaselineConfigurationsTruncated()) {
                return false;
            }
            List<Configuration> list = this.getConfigurations();
            List<Configuration> list2 = configurationsForResolutionRange.getConfigurations();
            return !(list == null ? list2 != null : !((Object)list).equals(list2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof ConfigurationsForResolutionRange;
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + (this.isLongbaselineConfigurationsTruncated() ? 79 : 97);
            List<Configuration> list = this.getConfigurations();
            n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
            return n;
        }

        public String toString() {
            return "ConfigurationHelper.ConfigurationsForResolutionRange(configurations=" + this.getConfigurations() + ", isLongbaselineConfigurationsTruncated=" + this.isLongbaselineConfigurationsTruncated() + ")";
        }
    }
}

