/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.Line;
import alma.obsprep.services.experts.RequiredConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.util.MinimumBoundingRectangle;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.UserSensitivity;
import com.google.common.collect.Sets;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

public class SchedBlockExpert {
    private final ScienceGoal scienceGoal;
    private final ObservingTimeCalculator timeCalculator;
    public static final double LOW_ELEVATION = 35.0;
    public static final double HIGH_RESOLUTION = 0.1;
    public static final double HOUR_ANGLE_STEP = 12.0;
    public static final Time NOMINAL_SB_LENGTH = AlmaPolicies.getInstance().getNominalSbLength();
    public static final double NOMINAL_TOTAL_TO_SCIENCE_RATIO = AlmaPolicies.getInstance().getNominalTotalToScienceRatio();
    public static final double NOMINAL_TOTAL_TO_WALSH_RATIO = AlmaPolicies.getInstance().getNominalTotalToWalshScienceRatio();
    public static final double NOMINAL_TOTAL_TO_SCIENCE_MULTIPLE_TUNINGS_RATIO = AlmaPolicies.getInstance().getNominalTotalToScienceMultipleTuningsRatio();
    public static final double NOMINAL_TOTAL_TO_SCIENCE_ACA_7M_RATIO = AlmaPolicies.getInstance().getNominalTotalToScienceACA7MRatio();
    public static final double NOMINAL_TOTAL_TO_POLARIZATION_RATIO = AlmaPolicies.getInstance().getNominalTotalToSciencePolarizationRatio();
    public static final Time TP_NOMINAL_SB_LENGTH = AlmaPolicies.getInstance().getTPNominalSbLength();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SchedBlockExpert getInstance(ScienceGoal scienceGoal) {
        SchedBlockExpert schedBlockExpert = (SchedBlockExpert)scienceGoal.getSchedBlockExpert();
        if (schedBlockExpert != null) return schedBlockExpert;
        Class<SchedBlockExpert> clazz = SchedBlockExpert.class;
        synchronized (SchedBlockExpert.class) {
            if (schedBlockExpert != null) return schedBlockExpert;
            schedBlockExpert = new SchedBlockExpert(scienceGoal);
            scienceGoal.setSchedBlockExpert(schedBlockExpert);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return schedBlockExpert;
        }
    }

    private SchedBlockExpert(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        this.scienceGoal = scienceGoal;
        this.timeCalculator = new ObservingTimeCalculator(scienceGoal);
    }

    public List<Range> calcHourAngleRange() {
        return Arrays.asList(new Range(-12.0, 12.0));
    }

    @Deprecated(forRemoval=true)
    public ArrayList<Range> calcBLResolutionRange() throws InvalidObsProgramParametersException {
        if (!Telescope.getTelescopeSelection().equals((Object)Telescope.ALMA)) {
            ArrayList<Range> arrayList = new ArrayList<Range>();
            arrayList.add(new Range(0.0, 0.0));
            return arrayList;
        }
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        double d = performanceParameters.getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC);
        double d2 = performanceParameters.getDesiredLargestScale().getContentInUnits(Angle.UNIT_ARCSEC);
        ArrayList<Range> arrayList = new ArrayList<Range>();
        arrayList.add(new Range(d * 0.5, d * 1.5));
        while (d * 50.0 < d2) {
            double d3 = d * 50.0 * 0.9;
            if (d >= d3) {
                throw new InvalidObsProgramParametersException("Invalid AngularResolution");
            }
            d = d3;
            arrayList.add(new Range(d * 0.5, d * 1.5));
        }
        return arrayList;
    }

    public List<Range> calcACAResolutionRange() {
        ArrayList<Range> arrayList = new ArrayList<Range>();
        arrayList.add(new Range(0.0, 0.0));
        return arrayList;
    }

    public static int calcExecutionCount(@NonNull Time time, @NonNull Set<SBGeneratorTemplate.SBGenerationSchema> set) {
        if (time == null) {
            throw new NullPointerException("totalOnSourceTime is marked non-null but is null");
        }
        if (set == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        Time time2 = (Time)time.multiply(SchedBlockExpert.getNominalExecutionTimeToTOSRatio(set));
        return (int)Math.ceil(time2.getContentInUnits(Time.UNIT_MIN) / NOMINAL_SB_LENGTH.getContentInUnits(Time.UNIT_MIN));
    }

    public int calcExecutionCountForAllSources(boolean bl, Set<SBGeneratorTemplate.SBGenerationSchema> set) throws InvalidFrequencyException, SourceNeverVisibleException, UnableToFindSolutionException {
        Time time = this.calcExecutionTimeForAllSources(bl, set);
        Time time2 = this.getNominalObsLengthPolicy();
        return (int)Math.ceil(time.getContentInDefaultUnits() / time2.getContentInDefaultUnits());
    }

    public Time calcExecutionTime(boolean bl, @NonNull Set<SBGeneratorTemplate.SBGenerationSchema> set) throws InvalidFrequencyException, SourceNeverVisibleException {
        if (set == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        Array array = this.scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M;
        int n = this.scienceGoal.getSoleTargetParameters().getNumberOfPointings(array);
        if (bl) {
            return this.timeCalculateACA();
        }
        return (Time)((Time)this.timeCalculate().multiply(n)).multiply(SchedBlockExpert.getNominalExecutionTimeToTOSRatio(set));
    }

    public Time calcExecutionTimeForAllSources(boolean bl, @NonNull Set<SBGeneratorTemplate.SBGenerationSchema> set) throws InvalidFrequencyException, SourceNeverVisibleException, UnableToFindSolutionException {
        if (set == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        Time time = Time.createTime((double)0.0, (String)Time.UNIT_S);
        if (bl) {
            return this.timeCalculateACA();
        }
        RequestedArray requestedArray = this.scienceGoal.isStandAloneACA() ? RequestedArray.SEVEN_M : RequestedArray.TWELVE_M;
        for (TargetParameters targetParameters : this.scienceGoal.getTargetParameters()) {
            int n = targetParameters.getNumberOfPointings(requestedArray.getArray());
            Time time2 = (Time)this.timeCalculate(targetParameters, requestedArray).multiply(n);
            time.aggregate(time2);
        }
        return (Time)time.multiply(SchedBlockExpert.getNominalExecutionTimeToTOSRatio(set));
    }

    public Sensitivity calcAllocatedSensitivity() {
        UserSensitivity userSensitivity;
        try {
            userSensitivity = this.scienceGoal.getPerformanceParameters().getSensitivityForFinestAR();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            Log.logger(SchedBlockExpert.class).warning("Unable to calculate allocated sensitivity " + invalidObsProgramParametersException.getMessage());
            return Sensitivity.createSensitivity();
        }
        int n = this.calcHourAngleRange().size();
        double d = Math.sqrt(n) * userSensitivity.getContentInUnits(Sensitivity.UNIT_MJY);
        return Sensitivity.createSensitivity((double)d, (String)Sensitivity.UNIT_MJY);
    }

    public Time timeCalculate() throws InvalidFrequencyException, SourceNeverVisibleException {
        Sensitivity sensitivity = this.calcAllocatedSensitivity();
        TargetParameters targetParameters = this.scienceGoal.getSoleTargetParameters();
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        Array array = this.scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M;
        return this.timeCalculator.singlePointOnSourceTime(array, sensitivity, targetParameters, performanceParameters.getSensitivityFrequencyWidth(), true);
    }

    public Time timeCalculate(@NonNull TargetParameters targetParameters, @NonNull RequestedArray requestedArray) throws InvalidFrequencyException, SourceNeverVisibleException {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        Sensitivity sensitivity = this.calcAllocatedSensitivity();
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        return this.timeCalculator.singlePointOnSourceTime(requestedArray.getArray(), sensitivity, targetParameters, performanceParameters.getSensitivityFrequencyWidth(), false);
    }

    public Time timeCalculateACA() throws InvalidFrequencyException, SourceNeverVisibleException {
        Sensitivity sensitivity = this.calcAllocatedSensitivity();
        TargetParameters targetParameters = this.scienceGoal.getSoleTargetParameters();
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        Time time = this.timeCalculator.singlePointOnSourceTime(Array.ARRAY_TP, sensitivity, targetParameters, performanceParameters.getSensitivityFrequencyWidth(), true);
        Time time2 = this.timeCalculator.singlePointOnSourceTime(Array.ARRAY_7M, sensitivity, targetParameters, performanceParameters.getSensitivityFrequencyWidth(), true);
        return time.getContentInDefaultUnits() > time2.getContentInDefaultUnits() ? time : time2;
    }

    @Deprecated(forRemoval=true)
    public Time getNominalSBLengthPolicy() {
        return NOMINAL_SB_LENGTH;
    }

    public Time getNominalSBLengthPolicy(@NonNull RequestedArray requestedArray) {
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return RequestedArray.TP.equals((Object)requestedArray) ? TP_NOMINAL_SB_LENGTH : NOMINAL_SB_LENGTH;
    }

    public Time getNominalObsLengthPolicy() {
        double d = this.getNominalSBLengthPolicy().getContentInUnits(Time.UNIT_MIN);
        double d2 = Math.max(d * 0.0, 0.0);
        return Time.createTime((double)(d - d2), (String)Time.UNIT_MIN);
    }

    public boolean getUseTPArray() {
        return SchedBlockExpert.determineIfTPArrayIsToBeUsed(this.scienceGoal.getPerformanceParameters().getUseACA(), this.scienceGoal);
    }

    public static List<SchedBlock> getAllSBsInObsProgram() throws UnknownEntityException, SchedBlock.UnableToFindParentScienceGoalException {
        ObsProject obsProject = ObservingToolController.getOTGui().getPrimaryProject();
        if (obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsUnitSet");
        }
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        ObsProgram obsProgram = obsProject.getObsProgram();
        if (obsProgram == null) {
            return arrayList;
        }
        for (AbstractScienceGoal abstractScienceGoal : obsProgram.getAbstractScienceGoal()) {
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            arrayList.addAll(SchedBlockWorker.findSBsInSG((AbstractScienceGoal)((Object)scienceGoal)));
        }
        return arrayList;
    }

    public static boolean determineIfTPArrayIsToBeUsed(boolean bl, @NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        if (scienceGoal.isSpectralScan()) {
            return false;
        }
        try {
            if (scienceGoal.isSolarScienceGoal()) {
                return true;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new IllegalArgumentException("Cannot determine if science goal is solar");
        }
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        if (almaCapabilities.getNumAntennas(Array.ARRAY_TP, spectralSetupParameters) > 0 && spectralSetupParameters.isSpectralLine()) {
            bl2 = true;
            PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
            if (!performanceParameters.getDesiredLargestScale().isZero()) {
                Angle angle = performanceParameters.getDesiredLargestScale();
                assert (angle != null);
                double d = scienceGoal.getRepresentativeFrequencyInSky().getContentInGHz();
                TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
                List<Configuration> list = null;
                Double d2 = null;
                try {
                    list = Configuration.getKnownConfigurations(RequestedArray.SEVEN_M);
                    d2 = list.get(0).getRecoverableScale(d, targetParametersArray, RequestedArray.SEVEN_M);
                }
                catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                    Log.logger(SchedBlockExpert.class).warning("Unable to determine ACA 7m configuration: " + invalidConfigurationParametersException.getMessage());
                    return true;
                }
                assert (d2 != null && d2 > 0.0);
                Log.logger(SchedBlockExpert.class).finer(String.format("ACA 7m recoverable scale : %.5g (arcsec) Desired angular scale : %.5g (arcsec)", d2, angle.getContentInUnits(Angle.UNIT_ARCSEC)));
                if (angle.getContentInUnits(Angle.UNIT_ARCSEC) < d2) {
                    Log.logger(SchedBlockExpert.class).finer("LAS requested can be recovered with the ACA 7m alone: TP omitted");
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
            if (spectralSetupParameters.getScienceSpectralWindowCount() > 0) {
                try {
                    if (ReceiverBand.getReceiverBand(spectralSetupParameters).getType().equals("DSB")) {
                        Log.logger(SchedBlockExpert.class).fine("DSB receiver being used: TP not scheduled");
                        bl2 = false;
                    }
                }
                catch (ReceiverBand.ReceiverNotFoundException | IllegalArgumentException exception) {
                    Log.logger(SchedBlockExpert.class).warning("Unable to determine whether we should use TP: " + exception.getMessage());
                    bl2 = false;
                }
            }
        }
        return bl2;
    }

    public static IntTimeSource getTotalExecutionTimeForSB(SchedBlock schedBlock, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        return (IntTimeSource)SchedBlockExpert.getTotalTOSForSB(schedBlock).multiply(SchedBlockExpert.getNominalExecutionTimeToTOSRatio(enumSet));
    }

    public static double getNominalExecutionTimeToTOSRatio(@NonNull Set<SBGeneratorTemplate.SBGenerationSchema> set) {
        if (set == null) {
            throw new NullPointerException("sbGenerationSchemas is marked non-null but is null");
        }
        double d = NOMINAL_TOTAL_TO_SCIENCE_RATIO;
        if (set.contains((Object)SBGeneratorTemplate.SBGenerationSchema.ACA_7M)) {
            d = NOMINAL_TOTAL_TO_SCIENCE_ACA_7M_RATIO;
        } else if (set.contains((Object)SBGeneratorTemplate.SBGenerationSchema.HIGHBAND_WALSH_LONGBASELINE)) {
            d = NOMINAL_TOTAL_TO_WALSH_RATIO;
        } else if (!Sets.intersection(EnumSet.of(SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING, SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN_MULTIPLE_SB, SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN), set).isEmpty()) {
            d = NOMINAL_TOTAL_TO_SCIENCE_MULTIPLE_TUNINGS_RATIO;
        } else if (set.contains((Object)SBGeneratorTemplate.SBGenerationSchema.POLARISATION)) {
            d = NOMINAL_TOTAL_TO_POLARIZATION_RATIO;
        }
        return d;
    }

    public static IntTimeSource getTotalTOSForSB(SchedBlock schedBlock) {
        IntTimeSource intTimeSource = IntTimeSource.createIntTimeSource((double)0.0, (String)IntTimeSource.UNIT_S);
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                intTimeSource = (IntTimeSource)intTimeSource.plus((AbstractDoubleWithUnit)scienceParameters.getIntegrationTime());
            }
        }
        return intTimeSource;
    }

    public static RequiredConfigurations getRecommended12mConfigurations(ScienceGoal scienceGoal, Frequency frequency) throws InvalidConfigurationParametersException {
        boolean bl;
        Object object;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Angle angle = performanceParameters.getDesiredLargestScale();
        RequiredConfigurations requiredConfigurations = new RequiredConfigurations();
        requiredConfigurations.setTMCompactConfigurationRecommended(false);
        try {
            object = scienceGoal.getObsProposal();
            if (object != null && object.isVLBIorPhasedArray()) {
                requiredConfigurations.setBest12mExtConfig(Configuration.getMostCompactConfiguration(RequestedArray.TWELVE_M));
                return requiredConfigurations;
            }
            if (angle.isLessThan((AbstractDoubleWithUnit)Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCMIN))) {
                throw new InvalidConfigurationParametersException("Desired LAS has not been defined");
            }
        }
        catch (UnknownEntityException | Configuration.UnableToDetermineConfigurationException throwable) {
            throw new InvalidConfigurationParametersException("Unable to determine ObsProposal" + (Exception)throwable);
        }
        Configuration configuration = Configuration.getBestConfiguration(frequency.getContentInGHz(), RequestedArray.TWELVE_M, scienceGoal);
        requiredConfigurations.setBest12mExtConfig(configuration);
        object = null;
        try {
            bl = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidConfigurationParametersException();
        }
        if (bl && !configuration.isConfigurationSolarCompatible(scienceGoal)) {
            String string = "Cannot determine a 12-m configuration for the desired angular resolution of " + performanceParameters.getDesiredAngularResolution() + " with a rep. freq of " + frequency + " when configured for solar";
            Log.logger(Configuration.class).finer(string);
            throw new InvalidConfigurationParametersException(string);
        }
        if (!bl && angle.isGreaterThan((AbstractDoubleWithUnit)Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC)) && Configuration.getIsSecondConfigurationRequired(configuration, angle.getContentInUnits(Angle.UNIT_ARCSEC), frequency.getContentInGHz(), scienceGoal, RequestedArray.TWELVE_M, false)) {
            requiredConfigurations.setTMCompactConfigurationRecommended(true);
            try {
                object = Configuration.getSecondCompactConfiguration(configuration);
                requiredConfigurations.setTwelveMetreCompactConfig((Configuration)object);
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                Log.logger(SchedBlockExpert.class).finer("Unable to determine the 12m compact configuration when one is required: " + invalidConfigurationParametersException.getMessage());
                requiredConfigurations.setTwelveMetreCompactConfig(null);
            }
        }
        return requiredConfigurations;
    }

    public static Rectangle getBoundingRectangle(SkyCoordinates skyCoordinates, SkyCoordinates[] skyCoordinatesArray) throws IllegalArgumentException {
        ArrayList<SkyCoordinates> arrayList = new ArrayList<SkyCoordinates>();
        Rectangle rectangle = Rectangle.createRectangle();
        try {
            Log.logger(SchedBlockExpert.class).fine(String.format("Rectangle origin: RA %s Dec %s ", skyCoordinates.getLongitude().toHHMMSS(), skyCoordinates.getLatitude().toDDMMSS()));
        }
        catch (InvalidCoordException | OutOfRangeException exception) {
            // empty catch block
        }
        for (SkyCoordinates object : skyCoordinatesArray) {
            SkyCoordinates skyCoordinates2 = object.isOffsetCoordinates() ? object.deepCopy() : object.getOffsetCoordinates(skyCoordinates);
            boolean bl = false;
            for (SkyCoordinates skyCoordinates3 : arrayList) {
                if (!skyCoordinates3.getLongitude().isEqual((AbstractDoubleWithUnit)skyCoordinates2.getLongitude()) || !skyCoordinates3.getLatitude().isEqual((AbstractDoubleWithUnit)skyCoordinates2.getLatitude())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(skyCoordinates2);
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("Illegal argument: offsetSkyCoords.size() (" + arrayList.size() + ") did not pass the test: offsetSkyCoords.size() == 0");
        }
        Line line = SchedBlockExpert.determineMaximumSeparationBetweenPointings(arrayList);
        assert (line != null);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            MinimumBoundingRectangle minimumBoundingRectangle = new MinimumBoundingRectangle();
            MinimumBoundingRectangle.BoundedRectangle boundedRectangle = minimumBoundingRectangle.determineMinimumBoundRectangleForCoordinates(arrayList);
            assert (boundedRectangle != null);
            Log.logger(SchedBlockExpert.class).fine("boundedRectangle (without 7m beam width included) : " + boundedRectangle);
            rectangle.setLong(Angle.createAngle((double)boundedRectangle.getSide(MinimumBoundingRectangle.BoundedRectangle.SideType.LONGEST).getSideLength(), (String)Angle.UNIT_ARCSEC));
            rectangle.setShort(Angle.createAngle((double)boundedRectangle.getSide(MinimumBoundingRectangle.BoundedRectangle.SideType.SHORTEST).getSideLength(), (String)Angle.UNIT_ARCSEC));
            double d = boundedRectangle.getRotationAngle();
            Log.logger(SchedBlockExpert.class).fine("Adjusted rotation angle (degs) : " + d);
            rectangle.setRotationAngle(Angle.createAngle((double)d, (String)Angle.UNIT_DEG));
            rectangle.clearTPVertices();
            stringBuilder.setLength(0);
            for (Point2D.Double double_ : boundedRectangle.getRectangle()) {
                Angle angle = Angle.createAngle((double)double_.getX(), (String)Angle.UNIT_ARCSEC);
                Angle angle2 = Angle.createAngle((double)double_.getY(), (String)Angle.UNIT_ARCSEC);
                rectangle.addTPVertex(angle, angle2);
                stringBuilder.append(angle.getContentInUnits(Angle.UNIT_ARCSEC) + "," + angle2.getContentInUnits(Angle.UNIT_ARCSEC) + ",");
            }
            try {
                rectangle.setCentre(rectangle.getTPRectangleCentralCoordinate().getAbsoluteCoordinates(skyCoordinates));
            }
            catch (Rectangle.UnableToDetermineCentralCoordinateException unableToDetermineCentralCoordinateException) {
                throw new IllegalArgumentException("Unable to determine TP rectangle central coordinate");
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            double_.setRect(rectangle.getLongitudeLength().getContentInUnits(Angle.UNIT_ARCSEC), rectangle.getLatitudeLength().getContentInUnits(Angle.UNIT_ARCSEC), boundedRectangle.getSide(MinimumBoundingRectangle.BoundedRectangle.SideType.LONGEST).getSideLength(), boundedRectangle.getSide(MinimumBoundingRectangle.BoundedRectangle.SideType.SHORTEST).getSideLength());
        }
        catch (MinimumBoundingRectangle.PointsAreAllCollinearException | MinimumBoundingRectangle.UnableToDetermineMinimumBoundingBoxException exception) {
            Log.logger(SchedBlockExpert.class).fine("Points are collinear or there are less than 3 pointings");
            if (arrayList.size() < 2) {
                rectangle.setRotationAngle(Angle.createAngle((double)0.0, (String)Angle.UNIT_DEG));
            } else {
                rectangle.setRotationAngle(Angle.createAngle((double)line.getAngleOfLine(), (String)Angle.UNIT_DEG));
            }
            if (arrayList.size() == 1) {
                rectangle.setCentre(arrayList.get(0).getAbsoluteCoordinates(skyCoordinates));
            } else {
                rectangle.setCentre(line.getRectangleCentre().getAbsoluteCoordinates(skyCoordinates));
            }
            rectangle.setLong(Angle.createAngle((double)line.getLength(), (String)Angle.UNIT_ARCSEC));
            rectangle.setShort(Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC));
        }
        if (Log.logger(SchedBlockExpert.class).fine()) {
            stringBuilder.setLength(0);
            for (SkyCoordinates skyCoordinates4 : arrayList) {
                stringBuilder.append(skyCoordinates4.getLongitude().getContentInUnits(Angle.UNIT_ARCSEC) + "," + skyCoordinates4.getLatitude().getContentInUnits(Angle.UNIT_ARCSEC) + ",");
            }
        }
        Log.logger(SchedBlockExpert.class).fine(String.format("Sky offset pointing coords (arcsec) : %s", stringBuilder.toString()));
        Log.logger(SchedBlockExpert.class).fine("Rectangle dimensions (arcsec) : Long " + rectangle.getLong().getContentInUnits(Angle.UNIT_ARCSEC) + " short " + rectangle.getShort().getContentInUnits(Angle.UNIT_ARCSEC));
        assert (rectangle != null);
        return rectangle;
    }

    private static Line determineMaximumSeparationBetweenPointings(@NonNull List<SkyCoordinates> list) throws IllegalArgumentException {
        if (list == null) {
            throw new NullPointerException("offsetSkyCoords is marked non-null but is null");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Illegal argument: offsetCoords.size (" + list.size() + ")  did not pass the test: offsetCoords.size < 1");
        }
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        if (list.size() == 1) {
            return new Line(0.0, double_, double_2);
        }
        double d = 0.0;
        boolean bl = false;
        for (SkyCoordinates skyCoordinates : list) {
            for (SkyCoordinates skyCoordinates2 : list) {
                if (skyCoordinates2 == skyCoordinates) continue;
                double d2 = skyCoordinates.getLongitude().getContentInUnits(Angle.UNIT_ARCSEC);
                double d3 = skyCoordinates.getLatitude().getContentInUnits(Angle.UNIT_ARCSEC);
                double d4 = skyCoordinates2.getLongitude().getContentInUnits(Angle.UNIT_ARCSEC);
                double d5 = skyCoordinates2.getLatitude().getContentInUnits(Angle.UNIT_ARCSEC);
                double d6 = d2 - d4;
                double d7 = d3 - d5;
                double d8 = Math.abs(Math.sqrt(d6 * d6 + d7 * d7));
                if (!bl) {
                    bl = true;
                    d = d8;
                    double_.setLocation(d2, d3);
                    double_2.setLocation(d4, d5);
                    continue;
                }
                if (!(d8 > d)) continue;
                double_.setLocation(d2, d3);
                double_2.setLocation(d4, d5);
                d = d8;
            }
        }
        Log.logger(SchedBlockExpert.class).fine("maxDistance: " + d);
        return new Line(d, double_, double_2);
    }

    public static Rectangle getBoundingRectangle(@NonNull TargetParameters targetParameters) {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        TargetParameters targetParameters2 = TargetParameters.getPointingSourceInICRS(targetParameters);
        Rectangle rectangle = SchedBlockExpert.getBoundingRectangle(targetParameters2.getFieldCenterCoordinates(), targetParameters2.getPointingPattern().getPhaseCenterCoordinates());
        rectangle.setTargetParameters(targetParameters2);
        return rectangle;
    }

    public static class UnableToDetermine12mCompactConfiguration
    extends Exception {
    }
}

