/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline;

import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.services.experts.spectralline.SpectralLineComparators;
import alma.valuetypes.Frequency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.lang3.StringUtils;

public final class SpectralLine
implements Comparable<SpectralLine>,
Cloneable {
    private static CacheAccess<String, String> transitionCache = JCS.getInstance((String)"transitionCache");
    private static List<SpectralLineStringReplacement> spectralLineStringReplacement = new ArrayList<SpectralLineStringReplacement>();
    public static final String DEFAULT_NAME = "...Enter Name Here...";
    private static Collection<String> badSpecies;
    private static Collection<String> badTransition;
    private Type type = Type.UNKNOWN;
    private Integer lineId = null;
    private String species = "";
    private Frequency frequency;
    private String transition = "";
    private String description = "";
    private String title = "";
    private Double smu = null;
    private String provenance = "";
    private Double upperStateEnergy = null;
    private Double observedIntensity = null;
    private UUID uuid = null;
    private CorrConfigMode corrConfigMode = null;
    private final EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
    private boolean isLineOutsideOfSPWRange = false;

    public void addFlag(Flag flag) {
        this.flags.add(flag);
    }

    public void removeFlag(Flag flag) {
        this.flags.remove((Object)flag);
    }

    public void setFlags(Collection<Flag> collection) {
        this.flags.clear();
        this.flags.addAll(collection);
    }

    public SpectralLine() {
    }

    public SpectralLine(SpectralLine spectralLine) {
        this.setLineId(spectralLine.lineId);
        this.setSpecies(spectralLine.species);
        this.setFrequency(spectralLine.frequency.deepCopy());
        this.setTransition(spectralLine.transition);
        this.setDescription(spectralLine.description);
        this.setSmu(spectralLine.smu);
        this.setUpperStateEnergy(spectralLine.upperStateEnergy);
        this.setObservedIntensity(spectralLine.observedIntensity);
        this.setType(spectralLine.type);
        this.setFlags(spectralLine.flags);
        this.setTitle(spectralLine.title);
        this.setProvenance(spectralLine.provenance);
        this.setScienceSpectralWindowUUID(spectralLine.uuid);
        this.setCorrConfigMode(spectralLine.corrConfigMode);
    }

    private void resetTitle() {
        for (String string : badSpecies) {
            if (!this.species.contains(string)) continue;
            this.title = this.transition;
            return;
        }
        this.title = StringUtils.trim((String)(this.getSpecies().trim() + " " + this.getTransition()));
    }

    public UUID getScienceSpectralWindowUUID() {
        return this.uuid;
    }

    public void setScienceSpectralWindowUUID(UUID uUID) {
        this.uuid = uUID;
    }

    public double getFrequencyInGHz() {
        if (this.frequency == null) {
            return Double.NaN;
        }
        return this.frequency.getContentInGHz();
    }

    public void setFrequency(Frequency frequency) {
        if (frequency != null) {
            this.frequency = frequency.deepCopy();
        }
    }

    public void setFrequency(double d) {
        if (d != 0.0) {
            this.frequency = Frequency.createFrequency((double)d, (String)Frequency.UNIT_HZ);
        }
    }

    public double getWavelength() {
        return 2.99792458E8 / this.getFrequency().getContentInUnits(Frequency.UNIT_HZ);
    }

    public void setWavelength(double d) {
        if (d == 0.0) {
            this.frequency = null;
        } else {
            this.setFrequency(2.99792458E8 / d);
        }
    }

    public void setTransition(String string) {
        String string2 = (String)transitionCache.get((Object)string);
        String string3 = string;
        if (string2 == null) {
            string = string.trim();
            for (SpectralLineStringReplacement spectralLineStringReplacement : SpectralLine.spectralLineStringReplacement) {
                string = spectralLineStringReplacement.getRegularExpression().matcher(string).replaceAll(spectralLineStringReplacement.getReplacementText());
            }
            this.transition = string;
            transitionCache.put((Object)string3, (Object)string);
        } else {
            this.transition = string2;
        }
        this.resetTitle();
    }

    public void setDescription(String string) {
        string = string.trim();
        this.description = string = string.replaceAll("\\s+", " ");
    }

    public void setSpecies(String string) {
        string = string.trim();
        string = string.replaceAll("\\s+", " ");
        string = string.replaceAll("&(Sigma|Omega);", "$1");
        string = string.replaceAll("Sigma", "\u03a3");
        string = string.replaceAll("Omega", "\u03a9");
        string = string.replaceAll("(\\D{1}=\\d+)", " $1");
        this.species = string = string.replaceAll("\\s+", " ");
        this.resetTitle();
    }

    public String toString() {
        return "<SpectralLine(" + this.title + ", " + this.frequency + ")>";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SpectralLine)) {
            return false;
        }
        SpectralLine spectralLine = (SpectralLine)object;
        boolean bl = false;
        if (this.frequency != null && spectralLine.frequency != null) {
            bl = spectralLine.frequency.equals((Object)this.frequency);
        }
        boolean bl2 = false;
        if (this.smu == null && spectralLine.smu == null) {
            bl2 = true;
        } else if (this.smu != null && spectralLine.smu != null) {
            bl2 = spectralLine.smu.equals(this.smu);
        }
        boolean bl3 = false;
        if (this.upperStateEnergy == null && spectralLine.upperStateEnergy == null) {
            bl3 = true;
        } else if (this.upperStateEnergy != null && spectralLine.upperStateEnergy != null) {
            bl3 = spectralLine.upperStateEnergy.equals(this.upperStateEnergy);
        }
        boolean bl4 = false;
        if (this.observedIntensity == null && spectralLine.observedIntensity == null) {
            bl4 = true;
        } else if (this.observedIntensity != null && spectralLine.observedIntensity != null) {
            bl4 = spectralLine.observedIntensity.equals(this.observedIntensity);
        }
        return bl && bl2 && bl3 && bl4 && spectralLine.description.equals(this.description) && spectralLine.species.equals(this.species) && spectralLine.title.equals(this.title) && spectralLine.transition.equals(this.transition) && spectralLine.type.equals((Object)this.type) && spectralLine.flags.equals(this.flags) && spectralLine.provenance.equals(this.provenance);
    }

    public int hashCode() {
        int n = 17;
        for (Object object : new Object[]{this.frequency, this.smu, this.upperStateEnergy, this.observedIntensity}) {
            if (object == null) continue;
            n = 31 * n + object.hashCode();
        }
        n = 31 * n + this.species.hashCode();
        n = 31 * n + this.title.hashCode();
        n = 31 * n + this.transition.hashCode();
        n = 31 * n + this.description.hashCode();
        n = 31 * n + this.flags.hashCode();
        n = 31 * n + this.type.hashCode();
        n = 31 * n + this.provenance.hashCode();
        return n;
    }

    @Override
    public int compareTo(SpectralLine spectralLine) {
        if (this.equals(spectralLine)) {
            return 0;
        }
        return SpectralLineComparators.TITLE_COMPARATOR.compare(this, spectralLine);
    }

    public void setLineOutsideOfSPWRange(boolean bl) {
        this.isLineOutsideOfSPWRange = bl;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public Integer getLineId() {
        return this.lineId;
    }

    public void setLineId(Integer n) {
        this.lineId = n;
    }

    public String getSpecies() {
        return this.species;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public String getTransition() {
        return this.transition;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setSmu(Double d) {
        this.smu = d;
    }

    public Double getSmu() {
        return this.smu;
    }

    public void setProvenance(String string) {
        this.provenance = string;
    }

    public String getProvenance() {
        return this.provenance;
    }

    public void setUpperStateEnergy(Double d) {
        this.upperStateEnergy = d;
    }

    public Double getUpperStateEnergy() {
        return this.upperStateEnergy;
    }

    public void setObservedIntensity(Double d) {
        this.observedIntensity = d;
    }

    public Double getObservedIntensity() {
        return this.observedIntensity;
    }

    public CorrConfigMode getCorrConfigMode() {
        return this.corrConfigMode;
    }

    public void setCorrConfigMode(CorrConfigMode corrConfigMode) {
        this.corrConfigMode = corrConfigMode;
    }

    public EnumSet<Flag> getFlags() {
        return this.flags;
    }

    public boolean isLineOutsideOfSPWRange() {
        return this.isLineOutsideOfSPWRange;
    }

    static {
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("\\s+"), " "));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("</?(sub|sup|i)>"), ""));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("&(Sigma|Omega);*"), "$1"));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("Sigma"), "\u03a3"));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("Omega"), "\u03a9"));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("alpha"), "\u03b1"));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("beta"), "\u03b2"));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("delta"), "\u03b4"));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("epsilon"), "\u03b5"));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("gamma"), "\u03b3"));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("zeta"), "\u03b6"));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("\\(\\s+"), "\\("));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("\\s+(,|\\))"), "$1"));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("(?<=[\\d\\)=])\\s+?-\\s+?(?=\\d)"), "-"));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("(?<=[=-])\\s+(?=\\d)"), ""));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("(?<=\\d),\\s+(\\d)"), ",$1"));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile(",(?![\\d*\\s])"), ", "));
        spectralLineStringReplacement.add(new SpectralLineStringReplacement(Pattern.compile("(?<=[+-])\\s+(?=[+-])"), ""));
        badSpecies = new ArrayList<String>();
        badTransition = new ArrayList<String>();
        badSpecies.add("alpha");
        badSpecies.add("beta");
        badSpecies.add("delta");
        badSpecies.add("epsilon");
        badSpecies.add("gamma");
        badSpecies.add("zeta");
        badSpecies.add("UnidentifiedTransition");
        badSpecies.add("u-line");
        badTransition.add("alpha");
    }

    public static enum Type {
        UNKNOWN,
        OFFLINE,
        ONLINE,
        CONTINUUM,
        LINE;

        public static final EnumSet<Type> ALL_TYPES;
        public static final EnumSet<Type> OBSERVED_TYPES;

        static {
            ALL_TYPES = EnumSet.allOf(Type.class);
            OBSERVED_TYPES = EnumSet.of(CONTINUUM, LINE);
        }
    }

    public static enum Flag {
        PLANET,
        ISM_HOTCORE,
        ISM_DIFFUSECLOUD,
        COMET,
        ISM_DARK_CLOUD,
        EXTRAGALACTIC,
        AGB_PPN_PN,
        COMMON;

        public static final EnumSet<Flag> ALL_FLAGS;

        static {
            ALL_FLAGS = EnumSet.allOf(Flag.class);
        }
    }

    private static class SpectralLineStringReplacement {
        @NonNull
        private Pattern regularExpression;
        @NonNull
        private String replacementText;

        public SpectralLineStringReplacement(@NonNull Pattern pattern, @NonNull String string) {
            if (pattern == null) {
                throw new NullPointerException("regularExpression is marked non-null but is null");
            }
            if (string == null) {
                throw new NullPointerException("replacementText is marked non-null but is null");
            }
            this.regularExpression = pattern;
            this.replacementText = string;
        }

        @NonNull
        public Pattern getRegularExpression() {
            return this.regularExpression;
        }

        @NonNull
        public String getReplacementText() {
            return this.replacementText;
        }

        public void setRegularExpression(@NonNull Pattern pattern) {
            if (pattern == null) {
                throw new NullPointerException("regularExpression is marked non-null but is null");
            }
            this.regularExpression = pattern;
        }

        public void setReplacementText(@NonNull String string) {
            if (string == null) {
                throw new NullPointerException("replacementText is marked non-null but is null");
            }
            this.replacementText = string;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SpectralLineStringReplacement)) {
                return false;
            }
            SpectralLineStringReplacement spectralLineStringReplacement = (SpectralLineStringReplacement)object;
            if (!spectralLineStringReplacement.canEqual(this)) {
                return false;
            }
            Pattern pattern = this.getRegularExpression();
            Pattern pattern2 = spectralLineStringReplacement.getRegularExpression();
            if (pattern == null ? pattern2 != null : !pattern.equals(pattern2)) {
                return false;
            }
            String string = this.getReplacementText();
            String string2 = spectralLineStringReplacement.getReplacementText();
            return !(string == null ? string2 != null : !string.equals(string2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof SpectralLineStringReplacement;
        }

        public int hashCode() {
            int n = 1;
            Pattern pattern = this.getRegularExpression();
            n = n * 59 + (pattern == null ? 43 : pattern.hashCode());
            String string = this.getReplacementText();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            return n;
        }

        public String toString() {
            return "SpectralLine.SpectralLineStringReplacement(regularExpression=" + this.getRegularExpression() + ", replacementText=" + this.getReplacementText() + ")";
        }
    }
}

